/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.aspect;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.TransactionAttributeType;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.container.factory.aspect.AbstractAspectDefBuilder;
import org.seasar.framework.ejb.EJB3BusinessMethodDesc;
import org.seasar.framework.ejb.EJB3Desc;
import org.seasar.framework.ejb.EJB3DescFactory;
import org.seasar.framework.ejb.EJB3InterceptorDesc;
import org.seasar.framework.ejb.impl.AroundInvokeSupportInterceptor;
import org.seasar.framework.ejb.impl.EJB3InterceptorSupportInterceptor;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class EJB3AnnotationAspectDefBuilder
extends AbstractAspectDefBuilder {
    private static final Map<TransactionAttributeType, String> txInterceptors = CollectionsUtil.newHashMap();

    public void appendAspectDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        EJB3Desc ejb3desc = EJB3DescFactory.getEJB3Desc(componentClass);
        if (ejb3desc == null) {
            return;
        }
        this.appendEJB3TxAspect(componentDef, ejb3desc);
        this.appendEJB3InterceptorsAspect(componentDef, ejb3desc);
        this.appendEJB3AroundInvokeAspect(componentDef, ejb3desc);
    }

    protected void appendEJB3TxAspect(ComponentDef componentDef, EJB3Desc ejb3desc) {
        if (!ejb3desc.isCMT()) {
            return;
        }
        for (EJB3BusinessMethodDesc methodDesc : ejb3desc.getBusinessMethods()) {
            String txInterceptor = txInterceptors.get(methodDesc.getTransactionAttributeType());
            if (txInterceptor == null) continue;
            this.appendAspect(componentDef, txInterceptor, methodDesc.getMethod());
        }
    }

    protected void appendEJB3InterceptorsAspect(ComponentDef componentDef, EJB3Desc ejb3desc) {
        for (EJB3BusinessMethodDesc methodDesc : ejb3desc.getBusinessMethods()) {
            for (EJB3InterceptorDesc interceptorDesc : methodDesc.getInterceptors()) {
                for (Method interceptorMethod : interceptorDesc.getInterceptorMethods()) {
                    EJB3InterceptorSupportInterceptor interceptor = new EJB3InterceptorSupportInterceptor(interceptorDesc.getInterceptorClass(), interceptorMethod);
                    AspectDef aspectDef = AspectDefFactory.createAspectDef((MethodInterceptor)interceptor, (Pointcut)new PointcutImpl(methodDesc.getMethod()));
                    componentDef.addAspectDef(aspectDef);
                }
            }
        }
    }

    protected void appendEJB3AroundInvokeAspect(ComponentDef componentDef, EJB3Desc ejb3desc) {
        for (Method aroundInvokeMethod : ejb3desc.getAroundInvokeMethods()) {
            AroundInvokeSupportInterceptor interceptor = new AroundInvokeSupportInterceptor(aroundInvokeMethod);
            for (EJB3BusinessMethodDesc methodDesc : ejb3desc.getBusinessMethods()) {
                AspectDef aspectDef = AspectDefFactory.createAspectDef((MethodInterceptor)interceptor, (Pointcut)new PointcutImpl(methodDesc.getMethod()));
                componentDef.addAspectDef(aspectDef);
            }
        }
    }

    static {
        txInterceptors.put(TransactionAttributeType.MANDATORY, "ejb3tx.mandatoryTx");
        txInterceptors.put(TransactionAttributeType.REQUIRED, "ejb3tx.requiredTx");
        txInterceptors.put(TransactionAttributeType.REQUIRES_NEW, "ejb3tx.requiresNewTx");
        txInterceptors.put(TransactionAttributeType.NOT_SUPPORTED, "ejb3tx.notSupportedTx");
        txInterceptors.put(TransactionAttributeType.NEVER, "ejb3tx.neverTx");
    }
}

