/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import java.util.Collection;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.where.ComposableWhere;
import org.seasar.extension.jdbc.where.ComposableWhereContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeWhere
extends ComposableWhere {
    protected String operator;

    public CompositeWhere(String operator, Where ... children) {
        super(children);
        this.operator = operator;
    }

    public CompositeWhere(String operator, Collection<Where> children) {
        super(children);
        this.operator = operator;
    }

    @Override
    protected void visit(ComposableWhereContext context) {
        if (this.children.isEmpty()) {
            return;
        }
        context.append('(');
        int len = context.getCriteriaLength();
        int cutBack = 1;
        for (Where child : this.children) {
            int newLen = context.append(child).getCriteriaLength();
            if (len == newLen) continue;
            len = context.append(") ").append(this.operator).append(" (").getCriteriaLength();
            cutBack = this.operator.length() + 3;
        }
        context.cutBack(cutBack);
    }
}

