/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOrdinalType
extends AbstractValueType {
    private final Class<? extends Enum> enumClass;

    public EnumOrdinalType(Class<? extends Enum> enumClass) {
        super(4);
        this.enumClass = enumClass;
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        int ordinal = resultSet.getInt(index);
        if (ordinal == 0 && resultSet.wasNull()) {
            return null;
        }
        return this.toEnum(ordinal);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        int ordinal = resultSet.getInt(columnName);
        if (ordinal == 0 && resultSet.wasNull()) {
            return null;
        }
        return this.toEnum(ordinal);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        int ordinal = cs.getInt(index);
        if (ordinal == 0 && cs.wasNull()) {
            return null;
        }
        return this.toEnum(ordinal);
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        int ordinal = cs.getInt(parameterName);
        if (ordinal == 0 && cs.wasNull()) {
            return null;
        }
        return this.toEnum(ordinal);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setInt(index, ((Enum)Enum.class.cast(value)).ordinal());
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setInt(parameterName, ((Enum)Enum.class.cast(value)).ordinal());
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        return BindVariableUtil.toText((Number)((Enum)Enum.class.cast(value)).ordinal());
    }

    protected Enum toEnum(int ordinal) {
        return this.enumClass.getEnumConstants()[ordinal];
    }
}

