/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.mapper;

import java.lang.reflect.Field;
import java.util.Collection;
import org.seasar.extension.jdbc.MappingContext;
import org.seasar.extension.jdbc.PropertyMapper;
import org.seasar.extension.jdbc.RelationshipEntityMapper;
import org.seasar.extension.jdbc.mapper.AbstractEntityMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRelationshipEntityMapper
extends AbstractEntityMapper
implements RelationshipEntityMapper {
    protected Field field;
    protected Field inverseField;

    public AbstractRelationshipEntityMapper(Class<?> entityClass, PropertyMapper[] propertyMappers, int[] idIndices, Field field, Field inverseField) {
        super(entityClass, propertyMappers, idIndices);
        this.field = field;
        field.setAccessible(true);
        if (inverseField != null) {
            this.inverseField = inverseField;
            inverseField.setAccessible(true);
        }
    }

    @Override
    public void map(Object target, Object[] values, MappingContext mappingContext) {
        Object key = this.getKey(values);
        Object entity = this.getEntity(values, mappingContext, key);
        if (!mappingContext.checkDone(this, target, entity)) {
            this.mapRelationship(target, entity);
        }
        this.mapRelationships(entity, values, mappingContext);
    }

    protected abstract void mapRelationship(Object var1, Object var2);

    public Field getField() {
        return this.field;
    }

    public Field getInverseField() {
        return this.inverseField;
    }

    protected boolean contains(Collection<?> relationship, Object target) {
        for (Object e : relationship) {
            if (e != target) continue;
            return true;
        }
        return false;
    }
}

