/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.id;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SqlLogger;
import org.seasar.extension.jdbc.exception.IdGenerationFailedRuntimeException;
import org.seasar.extension.jdbc.id.AbstractIdGenerator;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StringUtil;

public class IdentityIdGenerator
extends AbstractIdGenerator {
    public IdentityIdGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        super(entityMeta, propertyMeta);
    }

    public boolean supportBatch(JdbcManagerImplementor jdbcManager) {
        return false;
    }

    public boolean useGetGeneratedKeys(JdbcManagerImplementor jdbcManager) {
        return jdbcManager.getDialect().supportsGetGeneratedKeys();
    }

    public boolean isInsertInto(JdbcManagerImplementor jdbcManager) {
        return jdbcManager.getDialect().isInsertIdentityColumn();
    }

    public Object preInsert(JdbcManagerImplementor jdbcManager, Object entity, SqlLogger sqlLogger) {
        return null;
    }

    public void postInsert(JdbcManagerImplementor jdbcManager, Object entity, Statement statement, SqlLogger sqlLogger) {
        long id = jdbcManager.getDialect().supportsGetGeneratedKeys() ? this.getGeneratedId(statement) : this.getGeneratedId(jdbcManager, sqlLogger);
        this.setId(entity, id);
    }

    protected long getGeneratedId(Statement statement) {
        try {
            ResultSet rs = statement.getGeneratedKeys();
            return this.getGeneratedId(rs);
        }
        catch (SQLException e) {
            throw new IdGenerationFailedRuntimeException(this.entityMeta.getName(), this.propertyMeta.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getGeneratedId(JdbcManagerImplementor jdbcManager, SqlLogger sqlLogger) {
        String sql = jdbcManager.getDialect().getIdentitySelectString(this.toQualifiedName(this.entityMeta.getTableMeta().getSchema(), this.entityMeta.getTableMeta().getName()), this.propertyMeta.getColumnMeta().getName());
        sqlLogger.logSql(sql, new Object[0]);
        JdbcContext jdbcContext = jdbcManager.getJdbcContext();
        try {
            PreparedStatement ps = jdbcContext.getPreparedStatement(sql);
            ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
            long l = this.getGeneratedId(rs);
            return l;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected String toQualifiedName(String schema, String tableName) {
        if (StringUtil.isEmpty((String)schema)) {
            return tableName;
        }
        return schema + "." + tableName;
    }
}

