/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.task;

import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.seasar.extension.jdbc.gen.command.Command;
import org.seasar.extension.jdbc.gen.command.CommandAdapter;
import org.seasar.extension.jdbc.gen.internal.arg.ArgumentsBuilder;
import org.seasar.extension.jdbc.gen.internal.command.CommandInvokerImpl;

public abstract class AbstractTask
extends Task {
    protected static String RESULT_PROPERTY_NAME_SUFFIX = "_result";
    protected static String ERROR_PROPERTY_NAME_SUFFIX = "_error";
    protected Java java = new Java();
    protected Commandline jvmCommandline = new Commandline();
    protected String commandInvokerClassName = CommandInvokerImpl.class.getName();
    protected Path classpath;

    public Commandline.Argument createJvmarg() {
        return this.jvmCommandline.createArgument();
    }

    public String getCommandInvokerClassName() {
        return this.commandInvokerClassName;
    }

    public void setCommandInvokerClassName(String commandInvokerClassName) {
        this.commandInvokerClassName = commandInvokerClassName;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("classpath is not specified for '" + this.getTaskName() + "' task");
        }
        if (this.classpath.list().length == 0) {
            throw new BuildException("classpath is empty for '" + this.getTaskName() + "' task");
        }
        this.executeCommand();
    }

    protected void executeCommand() {
        Command command = this.getCommand();
        String commandName = command.getClass().getName();
        ArgumentsBuilder builder = new ArgumentsBuilder(command);
        List<String> args = builder.build();
        Environment.Variable commandProperty = new Environment.Variable();
        commandProperty.setKey(CommandAdapter.COMMAND_KEY);
        commandProperty.setValue(commandName);
        Environment.Variable commandInvokerProperty = new Environment.Variable();
        commandInvokerProperty.setKey(CommandAdapter.COMMAND_INVOKER_KEY);
        commandInvokerProperty.setValue(this.commandInvokerClassName);
        long time = System.currentTimeMillis();
        String resultPropertyName = commandName + time + RESULT_PROPERTY_NAME_SUFFIX;
        String errorPropertyName = commandName + time + ERROR_PROPERTY_NAME_SUFFIX;
        this.java.bindToOwner((Task)this);
        this.java.addSysproperty(commandProperty);
        this.java.addSysproperty(commandInvokerProperty);
        for (String arg : args) {
            this.java.createArg().setValue(arg);
        }
        for (String arg : this.jvmCommandline.getArguments()) {
            this.java.createJvmarg().setValue(arg);
        }
        this.java.setClasspath(this.classpath);
        this.java.setClassname(CommandAdapter.class.getName());
        this.java.setResultProperty(resultPropertyName);
        this.java.setErrorProperty(errorPropertyName);
        this.java.setFork(true);
        this.java.execute();
        String result = this.getProject().getProperty(resultPropertyName);
        if (!"0".equals(result)) {
            throw new BuildException(this.getProject().getProperty(errorPropertyName));
        }
    }

    protected abstract Command getCommand();
}

