/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class TimestampType
extends AbstractSqlType {
    public TimestampType() {
        this("timestamp");
    }

    public TimestampType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 93);
        } else {
            ps.setTimestamp(index, this.toTimestamp(value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Timestamp value = resultSet.getTimestamp(index);
        if (value == null) {
            return null;
        }
        return value.toString().replace('-', '/');
    }

    protected Timestamp toTimestamp(String value) {
        String pattern = null;
        pattern = value.contains("-") ? "yyyy-MM-dd hh:mm:ss" : "yyyy/MM/dd hh:mm:ss";
        Timestamp timestamp = TimestampConversionUtil.toTimestamp((Object)value, (String)pattern);
        int pos = value.indexOf(46);
        if (pos > -1) {
            int n;
            int nanos = IntegerConversionUtil.toPrimitiveInt((Object)value.substring(pos + 1));
            if (nanos > 0 && (n = (int)Math.log10(nanos)) < 8) {
                nanos *= (int)Math.pow(10.0, 8 - n);
            }
            timestamp.setNanos(nanos);
        }
        return timestamp;
    }
}

