/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.annotation.ReferentialActionType;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDesc;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDesc;
import org.seasar.extension.jdbc.gen.desc.SequenceDesc;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDesc;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.desc.SequenceDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.exception.SequenceNextValFailedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.ColumnModel;
import org.seasar.extension.jdbc.gen.model.ForeignKeyModel;
import org.seasar.extension.jdbc.gen.model.PrimaryKeyModel;
import org.seasar.extension.jdbc.gen.model.SequenceModel;
import org.seasar.extension.jdbc.gen.model.SqlIdentifierCaseType;
import org.seasar.extension.jdbc.gen.model.SqlKeywordCaseType;
import org.seasar.extension.jdbc.gen.model.TableModel;
import org.seasar.extension.jdbc.gen.model.TableModelFactory;
import org.seasar.extension.jdbc.gen.model.UniqueKeyModel;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class TableModelFactoryImpl
implements TableModelFactory {
    protected static Logger logger = Logger.getLogger(SequenceDescFactoryImpl.class);
    protected GenDialect dialect;
    protected DataSource dataSource;
    protected char delimiter;
    protected String tableOption;
    protected SqlIdentifierCaseType sqlIdentifierCaseType;
    protected SqlKeywordCaseType sqlKeywordCaseType;
    protected boolean useComment;
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public TableModelFactoryImpl(GenDialect dialect, DataSource dataSource, SqlIdentifierCaseType sqlIdentifierCaseType, SqlKeywordCaseType sqlKeywordCaseType, char delimiter, String tableOption, boolean useComment) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (sqlIdentifierCaseType == null) {
            throw new NullPointerException("sqlIdentifierCaseType");
        }
        if (sqlKeywordCaseType == null) {
            throw new NullPointerException("sqlKeywordCaseType");
        }
        this.dialect = dialect;
        this.dataSource = dataSource;
        this.sqlIdentifierCaseType = sqlIdentifierCaseType;
        this.sqlKeywordCaseType = sqlKeywordCaseType;
        this.delimiter = delimiter;
        this.tableOption = tableOption;
        this.useComment = useComment;
    }

    public TableModel getTableModel(TableDesc tableDesc) {
        TableModel tableModel = new TableModel();
        tableModel.setCanonicalTableName(tableDesc.getCanonicalName());
        tableModel.setName(this.identifier(tableDesc.getFullName()));
        tableModel.setDialect(this.dialect);
        tableModel.setDelimiter(this.delimiter);
        tableModel.setTableOption(this.keyword(this.tableOption));
        tableModel.setSqlIdentifierCaseType(this.sqlIdentifierCaseType);
        tableModel.setSqlKeywordCaseType(this.sqlKeywordCaseType);
        tableModel.setComment(this.normalizeComment(tableDesc.getComment()));
        tableModel.setUseComment(this.useComment);
        this.doPrimaryKeyModel(tableModel, tableDesc);
        this.doUniqueKeyModel(tableModel, tableDesc);
        this.doForeignKeyModel(tableModel, tableDesc);
        this.doSequenceModel(tableModel, tableDesc);
        this.doColumnModel(tableModel, tableDesc);
        this.doGeneratedInfo(tableModel, tableDesc);
        return tableModel;
    }

    protected void doPrimaryKeyModel(TableModel tableModel, TableDesc tableDesc) {
        PrimaryKeyDesc pkDesc = tableDesc.getPrimaryKeyDesc();
        if (pkDesc == null) {
            return;
        }
        PrimaryKeyModel pkModel = new PrimaryKeyModel();
        pkModel.setName(this.identifier(tableDesc.getName() + "_PK"));
        for (String columnName : pkDesc.getColumnNameList()) {
            pkModel.addColumnName(this.identifier(columnName));
        }
        tableModel.setPrimaryKeyModel(pkModel);
    }

    protected void doUniqueKeyModel(TableModel tableModel, TableDesc tableDesc) {
        int index = 1;
        for (UniqueKeyDesc ukDesc : tableDesc.getUniqueKeyDescList()) {
            UniqueKeyModel ukModel = new UniqueKeyModel();
            ukModel.setName(this.identifier(tableDesc.getName() + "_UK" + index));
            ukModel.setDropUniqueKeySyntax(this.keyword(this.dialect.getDropUniqueKeySyntax()));
            for (String columnName : ukDesc.getColumnNameList()) {
                ukModel.addColumnName(this.identifier(columnName));
            }
            tableModel.addUniqueKeyModel(ukModel);
            ++index;
        }
    }

    protected void doForeignKeyModel(TableModel tableModel, TableDesc tableDesc) {
        int index = 1;
        for (ForeignKeyDesc fkDesc : tableDesc.getForeignKeyDescList()) {
            ForeignKeyModel fkModel = new ForeignKeyModel();
            fkModel.setName(this.identifier(tableDesc.getName() + "_FK" + index));
            fkModel.setReferencedTableName(fkDesc.getReferencedFullTableName());
            fkModel.setDropForeignKeySyntax(this.keyword(this.dialect.getDropForeignKeySyntax()));
            for (String columnName : fkDesc.getColumnNameList()) {
                fkModel.addColumnName(this.identifier(columnName));
            }
            for (String referencedColumnName : fkDesc.getReferencedColumnNameList()) {
                fkModel.addReferencedColumnName(referencedColumnName);
            }
            fkModel.setOnDelete(this.toActionName(fkDesc.getOnDelete()));
            fkModel.setOnUpdate(this.toActionName(fkDesc.getOnUpdate()));
            tableModel.addForeignKeyModel(fkModel);
            ++index;
        }
    }

    protected String toActionName(ReferentialActionType actionType) {
        if (actionType == null || actionType == ReferentialActionType.NO_ACTION) {
            return null;
        }
        String actionName = actionType.name().replace('_', ' ').toLowerCase();
        return this.keyword(actionName);
    }

    protected void doSequenceModel(TableModel tableModel, TableDesc tableDesc) {
        for (SequenceDesc sequenceDesc : tableDesc.getSequenceDescList()) {
            SequenceModel sequenceModel = new SequenceModel();
            sequenceModel.setName(this.identifier(sequenceDesc.getSequenceName()));
            Long nextValue = this.getNextValue(sequenceDesc.getSequenceName(), sequenceDesc.getAllocationSize());
            long initialValue = nextValue != null ? Math.max(nextValue, sequenceDesc.getInitialValue()) : sequenceDesc.getInitialValue();
            String definition = this.dialect.getSequenceDefinitionFragment(sequenceDesc.getDataType(), initialValue, sequenceDesc.getAllocationSize());
            sequenceModel.setDefinition(this.keyword(definition));
            tableModel.addSequenceModel(sequenceModel);
        }
    }

    protected void doColumnModel(TableModel tableModel, TableDesc tableDesc) {
        for (ColumnDesc columnDesc : tableDesc.getColumnDescList()) {
            ColumnModel columnModel = new ColumnModel();
            columnModel.setName(this.identifier(columnDesc.getName()));
            String definition = columnDesc.getDefinition();
            if (columnDesc.isIdentity()) {
                definition = definition + " " + this.dialect.getIdentityColumnDefinition();
            } else if (!columnDesc.isNullable()) {
                definition = definition + " not null";
            }
            columnModel.setDefinition(this.keyword(definition));
            columnModel.setComment(this.normalizeComment(columnDesc.getComment()));
            tableModel.addColumnModel(columnModel);
        }
    }

    /*
     * Loose catch block
     */
    protected Long getNextValue(String sequenceName, int allocationSize) {
        String sql = this.dialect.getSequenceNextValString(sequenceName, allocationSize);
        logger.debug((Object)sql);
        Connection connection = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            ResultSet rs;
            PreparedStatement ps;
            block15: {
                ps = ConnectionUtil.prepareStatement((Connection)connection, (String)sql);
                rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                if (!rs.next()) break block15;
                Long l = rs.getLong(1);
                ResultSetUtil.close((ResultSet)rs);
                StatementUtil.close((Statement)ps);
                return l;
            }
            try {
                try {
                    throw new SequenceNextValFailedRuntimeException(sequenceName);
                    {
                        catch (Throwable throwable) {
                            ResultSetUtil.close((ResultSet)rs);
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    StatementUtil.close((Statement)ps);
                    throw throwable;
                }
            }
            catch (SequenceNextValFailedRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.dialect.isSequenceNotFound(e)) {
                    logger.log("DS2JDBCGen0017", new Object[]{sequenceName});
                    Long l = null;
                    return l;
                }
                throw new SequenceNextValFailedRuntimeException(sequenceName, e);
            }
        }
        finally {
            ConnectionUtil.close((Connection)connection);
        }
    }

    protected String keyword(String keyword) {
        return this.sqlKeywordCaseType.convert(keyword);
    }

    protected String identifier(String identifier) {
        return this.sqlIdentifierCaseType.convert(identifier);
    }

    protected String normalizeComment(String comment) {
        if (comment == null) {
            return "";
        }
        return comment.replace("'", "''");
    }

    protected void doGeneratedInfo(TableModel tableModel, TableDesc tableDesc) {
        this.generatedModelSupport.fillGeneratedInfo(this, tableModel);
    }
}

