/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Resource;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.NamesModel;
import org.seasar.extension.jdbc.gen.model.NamesModelFactory;
import org.seasar.extension.jdbc.gen.model.ServiceModel;
import org.seasar.extension.jdbc.gen.model.ServiceModelFactory;
import org.seasar.extension.jdbc.operation.Operations;
import org.seasar.framework.util.ClassUtil;

public class ServiceModelFactoryImpl
implements ServiceModelFactory {
    protected static String DEFAULT_JDBC_MANAGER_NAME = "jdbcManager";
    protected String packageName;
    protected String jdbcManagerName;
    protected String serviceClassNameSuffix;
    protected NamesModelFactory namesModelFactory;
    protected boolean useNamesClass;
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public ServiceModelFactoryImpl(String packageName, String serviceClassNameSuffix, NamesModelFactory namesModelFactory, boolean useNamesClass, String jdbcManagerName) {
        if (jdbcManagerName == null) {
            throw new NullPointerException("jdbcManagerName");
        }
        if (serviceClassNameSuffix == null) {
            throw new NullPointerException("serviceClassNameSuffix");
        }
        if (namesModelFactory == null) {
            throw new NullPointerException("namesModelFactory");
        }
        this.packageName = packageName;
        this.serviceClassNameSuffix = serviceClassNameSuffix;
        this.namesModelFactory = namesModelFactory;
        this.useNamesClass = useNamesClass;
        this.jdbcManagerName = jdbcManagerName;
    }

    public ServiceModel getServiceModel(EntityMeta entityMeta) {
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setPackageName(this.packageName);
        serviceModel.setShortClassName(entityMeta.getName() + this.serviceClassNameSuffix);
        serviceModel.setShortEntityClassName(entityMeta.getEntityClass().getSimpleName());
        serviceModel.setShortSuperclassName("Abstract" + this.serviceClassNameSuffix);
        serviceModel.setJdbcManagerName(this.jdbcManagerName);
        serviceModel.setJdbcManagerSetterNecessary(!DEFAULT_JDBC_MANAGER_NAME.equals(this.jdbcManagerName));
        for (PropertyMeta idPropertyMeta : entityMeta.getIdPropertyMetaList()) {
            serviceModel.addIdPropertyMeta(idPropertyMeta);
        }
        if (entityMeta.hasVersionPropertyMeta()) {
            serviceModel.setVersionPropertyMeta(entityMeta.getVersionPropertyMeta());
        }
        this.doNamesModel(serviceModel, entityMeta);
        this.doImportName(serviceModel, entityMeta);
        this.doGeneratedInfo(serviceModel, entityMeta);
        return serviceModel;
    }

    protected void doNamesModel(ServiceModel serviceModel, EntityMeta entityMeta) {
        if (entityMeta.getIdPropertyMetaList().size() > 0 && this.useNamesClass) {
            NamesModel namesModel = this.namesModelFactory.getNamesModel(entityMeta);
            serviceModel.setNamesModel(namesModel);
        }
    }

    protected void doImportName(ServiceModel serviceModel, EntityMeta entityMeta) {
        NamesModel namesModel;
        this.classModelSupport.addImportName((ClassModel)serviceModel, entityMeta.getEntityClass());
        this.classModelSupport.addImportName((ClassModel)serviceModel, Generated.class);
        for (PropertyMeta propertyMeta : serviceModel.getIdPropertyMetaList()) {
            this.classModelSupport.addImportName((ClassModel)serviceModel, propertyMeta.getPropertyClass());
        }
        PropertyMeta propertyMeta = serviceModel.getVersionPropertyMeta();
        if (propertyMeta != null) {
            this.classModelSupport.addImportName((ClassModel)serviceModel, propertyMeta.getPropertyClass());
        }
        if ((namesModel = serviceModel.getNamesModel()) != null) {
            String namesClassName = ClassUtil.concatName((String)namesModel.getPackageName(), (String)namesModel.getShortClassName());
            this.classModelSupport.addStaticImportName((ClassModel)serviceModel, namesClassName);
            this.classModelSupport.addStaticImportName((ClassModel)serviceModel, Operations.class);
            this.classModelSupport.addImportName((ClassModel)serviceModel, List.class);
        }
        if (serviceModel.isJdbcManagerSetterNecessary()) {
            this.classModelSupport.addImportName((ClassModel)serviceModel, Resource.class);
            this.classModelSupport.addImportName((ClassModel)serviceModel, TransactionAttribute.class);
            this.classModelSupport.addImportName((ClassModel)serviceModel, TransactionAttributeType.class);
            this.classModelSupport.addImportName((ClassModel)serviceModel, JdbcManager.class);
        }
    }

    protected void doGeneratedInfo(ServiceModel serviceModel, EntityMeta entityMeta) {
        this.generatedModelSupport.fillGeneratedInfo(this, serviceModel);
    }
}

