/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.data;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.data.Loader;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.exception.LoadFailedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.data.DumpFileReader;
import org.seasar.extension.jdbc.gen.internal.data.DumpFileTokenizer;
import org.seasar.extension.jdbc.gen.internal.exception.DumpFileEmptyRuntimeException;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderImpl
implements Loader {
    protected static Logger logger = Logger.getLogger(LoaderImpl.class);
    protected GenDialect dialect;
    protected String dumpFileEncoding;
    protected char delimiter = (char)44;
    protected String extension = ".csv";
    protected int batchSize;
    protected boolean delete;

    public LoaderImpl(GenDialect dialect, String dumpFileEncoding, int batchSize, boolean delete) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (dumpFileEncoding == null) {
            throw new NullPointerException("dumpFileEncoding");
        }
        if (batchSize < 0) {
            throw new IllegalArgumentException("batchSize");
        }
        this.dialect = dialect;
        this.dumpFileEncoding = dumpFileEncoding;
        this.batchSize = batchSize;
        this.delete = delete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SqlExecutionContext sqlExecutionContext, DatabaseDesc databaseDesc, File dumpFile) {
        Object[] objectArray;
        block15: {
            TableDesc tableDesc = this.getTableDesc(databaseDesc, dumpFile);
            if (tableDesc == null) {
                return;
            }
            logger.log("DS2JDBCGen0013", new Object[]{dumpFile.getPath(), tableDesc.getFullName()});
            DumpFileReader reader = this.createDumpFileReader(dumpFile);
            List<String> columnNameList = reader.readLine();
            if (columnNameList == null) {
                throw new DumpFileEmptyRuntimeException(dumpFile.getPath());
            }
            List<SqlType> sqlTypeList = this.getSqlTypeList(tableDesc, columnNameList);
            String sql = this.buildSql(tableDesc, columnNameList);
            sqlExecutionContext.begin();
            try {
                if (this.delete) {
                    this.deleteData(sqlExecutionContext, tableDesc);
                }
                this.preLoadData(sqlExecutionContext, tableDesc);
                this.loadData(sqlExecutionContext, reader, sqlTypeList, sql);
                this.postLoadData(sqlExecutionContext, tableDesc);
            }
            catch (Exception e) {
                logger.log("DS2JDBCGen0021", new Object[]{dumpFile.getPath()});
                if (this.dialect.isTableNotFound(e)) {
                    logger.log("DS2JDBCGen0012", new Object[]{tableDesc.getFullName()});
                    sqlExecutionContext.notifyException();
                } else {
                    LoadFailedRuntimeException ex = new LoadFailedRuntimeException(e, dumpFile.getPath(), reader.getLineNumber());
                    sqlExecutionContext.addException((RuntimeException)((Object)ex));
                }
                reader.close();
                return;
            }
            finally {
                sqlExecutionContext.end();
            }
            objectArray = new Object[]{dumpFile.getPath(), tableDesc.getFullName(), reader.getLineNumber() - 1};
            break block15;
            finally {
                reader.close();
            }
        }
        logger.log("DS2JDBCGen0014", objectArray);
    }

    @Override
    public boolean isTarget(DatabaseDesc databaseDesc, File file) {
        if (databaseDesc == null || file == null) {
            return false;
        }
        if (!file.getName().endsWith(this.extension)) {
            return false;
        }
        return this.getTableDesc(databaseDesc, file) != null;
    }

    protected void deleteData(SqlExecutionContext sqlExecutionContext, TableDesc tableDesc) throws SQLException {
        Statement statement = sqlExecutionContext.getStatement();
        String sql = "delete from " + tableDesc.getFullName();
        logger.debug((Object)sql);
        statement.execute(sql);
    }

    protected void preLoadData(SqlExecutionContext sqlExecutionContext, TableDesc tableDesc) throws SQLException {
        if (tableDesc.hasIdentityColumn() && this.dialect.supportsIdentityInsertControlStatement()) {
            Statement statement = sqlExecutionContext.getStatement();
            String sql = this.dialect.getIdentityInsertEnableStatement(tableDesc.getFullName());
            logger.debug((Object)sql);
            statement.execute(sql);
        }
    }

    protected void loadData(SqlExecutionContext sqlExecutionContext, DumpFileReader reader, List<SqlType> sqlTypeList, String sql) throws SQLException {
        PreparedStatement ps = sqlExecutionContext.getPreparedStatement(sql);
        List<String> valueList = null;
        boolean remaining = false;
        int i = 0;
        while ((valueList = reader.readLine()) != null) {
            this.bindArgs(ps, sqlTypeList, valueList);
            ps.addBatch();
            if (this.batchSize > 0 && (i + 1) % this.batchSize == 0) {
                ps.executeBatch();
                sqlExecutionContext.commitLocalTx();
                remaining = false;
            } else {
                remaining = true;
            }
            ++i;
        }
        if (remaining) {
            ps.executeBatch();
        }
    }

    protected void postLoadData(SqlExecutionContext sqlExecutionContext, TableDesc tableDesc) throws SQLException {
        if (tableDesc.hasIdentityColumn() && this.dialect.supportsIdentityInsertControlStatement()) {
            Statement statement = sqlExecutionContext.getStatement();
            String sql = this.dialect.getIdentityInsertDisableStatement(tableDesc.getFullName());
            logger.debug((Object)sql);
            statement.execute(sql);
        }
    }

    protected void bindArgs(PreparedStatement ps, List<SqlType> sqlTypeList, List<String> valueList) throws SQLException {
        for (int i = 0; i < sqlTypeList.size(); ++i) {
            SqlType sqlType = sqlTypeList.get(i);
            String value = valueList.get(i);
            sqlType.bindValue(ps, i + 1, value);
        }
    }

    protected String buildSql(TableDesc tableDesc, List<String> columnNameList) {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into ");
        buf.append(tableDesc.getFullName());
        buf.append(" (");
        for (String columnName : columnNameList) {
            buf.append(columnName);
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append(") values (");
        for (int i = 0; i < columnNameList.size(); ++i) {
            buf.append("?, ");
        }
        buf.setLength(buf.length() - 2);
        buf.append(")");
        return buf.toString();
    }

    protected List<SqlType> getSqlTypeList(TableDesc tableDesc, List<String> columnNameList) {
        ArrayList<SqlType> sqlTypeList = new ArrayList<SqlType>();
        for (int i = 0; i < columnNameList.size(); ++i) {
            String columnName = columnNameList.get(i);
            ColumnDesc columnDesc = tableDesc.getColumnDesc(columnName);
            sqlTypeList.add(columnDesc.getSqlType());
        }
        return sqlTypeList;
    }

    protected DumpFileTokenizer createDumpFileTokenizer() {
        return new DumpFileTokenizer(this.delimiter);
    }

    protected DumpFileReader createDumpFileReader(File dumpFile) {
        return new DumpFileReader(dumpFile, this.dumpFileEncoding, this.createDumpFileTokenizer());
    }

    protected TableDesc getTableDesc(DatabaseDesc databaseDesc, File dumpFile) {
        String name = StringUtil.trimSuffix((String)dumpFile.getName(), (String)this.extension);
        return databaseDesc.getTableDesc(name);
    }
}

