/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.data;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.seasar.extension.jdbc.gen.data.Dumper;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.data.DumpFileWriter;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ResultSetUtil;

public class DumperImpl
implements Dumper {
    protected static Logger logger = Logger.getLogger(DumperImpl.class);
    protected String dumpFileEncoding;
    protected GenDialect dialect;
    protected String extension = ".csv";
    protected char delimiter = (char)44;

    public DumperImpl(GenDialect dialect, String dumpFileEncoding) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (dumpFileEncoding == null) {
            throw new NullPointerException("dumpFileEncoding");
        }
        this.dialect = dialect;
        this.dumpFileEncoding = dumpFileEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(SqlExecutionContext sqlExecutionContext, DatabaseDesc databaseDesc, File dumpDir) {
        for (TableDesc tableDesc : databaseDesc.getTableDescList()) {
            String fileName = tableDesc.getCanonicalName() + this.extension;
            File dumpFile = new File(dumpDir, fileName);
            logger.log("DS2JDBCGen0015", new Object[]{tableDesc.getFullName(), dumpFile.getPath()});
            DumpFileWriter writer = this.createDumpFileWriter(dumpFile, tableDesc);
            try {
                boolean fail = this.dumpTableWithSort(sqlExecutionContext, tableDesc, writer);
                if (fail) {
                    this.dumpTable(sqlExecutionContext, tableDesc, writer);
                }
                logger.log("DS2JDBCGen0016", new Object[]{tableDesc.getFullName(), dumpFile.getPath(), writer.getLineNumber() - 1});
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpTableWithSort(SqlExecutionContext sqlExecutionContext, TableDesc tableDesc, DumpFileWriter writer) {
        String sql = this.buildSqlWithSort(tableDesc);
        sqlExecutionContext.begin();
        try {
            Statement statement = sqlExecutionContext.getStatement();
            this.dumpRows(statement, writer, sql);
        }
        catch (Exception e) {
            if (this.dialect.isTableNotFound(e)) {
                logger.log("DS2JDBCGen0012", new Object[]{tableDesc.getFullName()});
                sqlExecutionContext.notifyException();
                writer.writeHeaderOnly();
            } else {
                if (this.dialect.isColumnNotFound(e)) {
                    logger.log("DS2JDBCGen0018", new Object[]{sql});
                    sqlExecutionContext.notifyException();
                    boolean bl = true;
                    return bl;
                }
                sqlExecutionContext.addException((RuntimeException)new SRuntimeException("ES2JDBCGen0021", new Object[]{e}, (Throwable)e));
            }
        }
        finally {
            sqlExecutionContext.end();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpTable(SqlExecutionContext sqlExecutionContext, TableDesc tableDesc, DumpFileWriter writer) {
        String sql = this.buildSql(tableDesc);
        sqlExecutionContext.begin();
        try {
            Statement statement = sqlExecutionContext.getStatement();
            this.dumpRows(statement, writer, sql);
        }
        catch (Exception e) {
            if (this.dialect.isTableNotFound(e)) {
                logger.log("DS2JDBCGen0012", new Object[]{tableDesc.getFullName()});
                sqlExecutionContext.notifyException();
                writer.writeHeaderOnly();
            } else {
                sqlExecutionContext.addException((RuntimeException)new SRuntimeException("ES2JDBCGen0021", new Object[]{e}, (Throwable)e));
            }
        }
        finally {
            sqlExecutionContext.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpRows(Statement statement, DumpFileWriter writer, String sql) throws SQLException {
        logger.debug((Object)sql);
        ResultSet rs = statement.executeQuery(sql);
        try {
            writer.writeRows(rs);
        }
        finally {
            ResultSetUtil.close((ResultSet)rs);
        }
    }

    protected String buildSqlWithSort(TableDesc tableDesc) {
        List<String> pkColumnNameList;
        StringBuilder buf = new StringBuilder();
        buf.append("select * from ");
        buf.append(tableDesc.getFullName());
        if (tableDesc.getPrimaryKeyDesc() != null && (pkColumnNameList = tableDesc.getPrimaryKeyDesc().getColumnNameList()).size() > 0) {
            buf.append(" order by ");
            for (String columnName : pkColumnNameList) {
                buf.append(columnName);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    protected String buildSql(TableDesc tableDesc) {
        return "select * from " + tableDesc.getFullName();
    }

    protected DumpFileWriter createDumpFileWriter(File dumpFile, TableDesc tableDesc) {
        return new DumpFileWriter(dumpFile, tableDesc, this.dialect, this.dumpFileEncoding, this.delimiter);
    }
}

