/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.util.BindingUtil;
import org.seasar.framework.log.Logger;

public abstract class AbstractAssembler {
    private static Logger logger = Logger.getLogger(AbstractAssembler.class);
    private ComponentDef componentDef;

    public AbstractAssembler(ComponentDef componentDef) {
        this.componentDef = componentDef;
    }

    protected final ComponentDef getComponentDef() {
        return this.componentDef;
    }

    protected BeanDesc getBeanDesc(Object component) {
        return BindingUtil.getBeanDesc(this.getComponentDef(), component);
    }

    protected Class getComponentClass(Object component) {
        return BindingUtil.getComponentClass(this.getComponentDef(), component);
    }

    protected Object[] getArgs(Class[] argTypes) {
        Object[] args = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            try {
                args[i] = this.getComponentDef().getContainer().getComponent(argTypes[i]);
                continue;
            }
            catch (ComponentNotFoundRuntimeException ex) {
                logger.log("WSSR0007", new Object[]{this.getComponentDef().getComponentClass().getName(), ex.getComponentKey()});
                args[i] = null;
            }
        }
        return args;
    }
}

