// Mbro.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "windowsx.h"
#include "Mbro.h"
#include "LogManager.h"
#include "DIBData.h"

#define MAX_LOADSTRING 100

// O[oϐ:
HINSTANCE hInst;                                // ݂̃C^[tFCX
WCHAR szTitle[MAX_LOADSTRING];                  // ^Cg o[̃eLXg
WCHAR szWindowClass[MAX_LOADSTRING];            // C EBhE NX
int nMbroWidth = 640;							// 摜TCY
int nMbroHeight = 480;							// 摜cTCY
//int nMbroWidth = 960;							// 摜TCY
//int nMbroHeight = 960;							// 摜cTCY
double dCenterX = -0.5;							// lw
double dCenterY = 0.0;							// lx
double dVPP = 0.005;							// PsNZ̒l
const double VPP_MIN = 1.0e-10;
const double VPP_MAX = 1.0;
CDIBData dibMbro;								// }fu摜chaf[^
double dMaxValue = 128.0;						// U臒lifΒl̂Qj
int nColorBitsB = 3;							// FʊKrbg P`W
int nColorBitsG = 3;							// FʊKrbg P`W
int nColorBitsR = 3;							// FʊKrbg P`W
bool bDispInfo = false;							// \
TCHAR sText[160];

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	Input(HWND, UINT, WPARAM, LPARAM);
void DrawMbro();

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPWSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: ɃR[h}ĂB
	LOGF_DEBUG(_T("***** Application starting."));

    // O[oĂ܂B
    LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    LoadStringW(hInstance, IDC_MBRO, szWindowClass, MAX_LOADSTRING);
    MyRegisterClass(hInstance);

    // AvP[V̏s܂:
    if (!InitInstance (hInstance, nCmdShow))
    {
        return FALSE;
    }

    HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_MBRO));

    MSG msg;

    // C bZ[W [v:
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
	LOGF_DEBUG(_T("***** Application end."));

    return (int) msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style          = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
    wcex.lpfnWndProc    = WndProc;
    wcex.cbClsExtra     = 0;
    wcex.cbWndExtra     = 0;
    wcex.hInstance      = hInstance;
    wcex.hIcon          = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MBRO));
    //wcex.hCursor        = LoadCursor(nullptr, IDC_ARROW);
	wcex.hCursor = NULL;
	wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName   = MAKEINTRESOURCEW(IDC_MBRO);
    wcex.lpszClassName  = szWindowClass;
    wcex.hIconSm        = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
//
//   Rg:
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   HWND hWnd = CreateWindowW(szWindowClass, szTitle,
	   WS_CAPTION | WS_SYSMENU | WS_DLGFRAME | WS_MINIMIZEBOX,
	   CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:    C EBhẼbZ[W܂B
//
//  WM_COMMAND  - AvP[V j[̏
//  WM_PAINT    - C EBhE̕`
//  WM_DESTROY  - ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static bool bDrag = false;
	static POINT ptDrag = { 0, 0 };

    switch (message)
    {
	case WM_CREATE:
		{
			LOG_DEBUG(_T("WM_CREATE"));
			dibMbro.Create(nMbroWidth, nMbroHeight);
			RECT rectw, rectc;
			::GetWindowRect(hWnd, &rectw);
			::GetClientRect(hWnd, &rectc);
			::MoveWindow(hWnd, rectw.left, rectw.top,
				rectw.right - rectw.left - rectc.right + rectc.left + nMbroWidth,
				rectw.bottom - rectw.top - rectc.bottom + rectc.top + nMbroHeight,
				FALSE);
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
			DrawMbro();
		}
		break;
	case WM_INITMENU:
		{
			HMENU hmenu = ::GetMenu(hWnd);
			MENUITEMINFO minfo;
			memset(&minfo, 0, sizeof(MENUITEMINFO));
			minfo.cbSize = sizeof(MENUITEMINFO);
			minfo.fMask = MIIM_STATE;
			if (bDispInfo)
			{
				minfo.fState = MFS_CHECKED;
			}
			else
			{
				minfo.fState = MFS_UNCHECKED;
			}
			::SetMenuItemInfo(hmenu, IDM_DISP, FALSE, &minfo);
		}
		break;
	case WM_COMMAND:
        {
            int wmId = LOWORD(wParam);
            // Iꂽj[̉:
            switch (wmId)
            {
			case IDM_COPY:
				LOG_DEBUG(_T("IDM_COPY"));
				dibMbro.Copy(hWnd);
				break;
			case IDM_INPUT:
				LOG_DEBUG(_T("IDM_INPUT"));
				if (DialogBox(hInst, MAKEINTRESOURCE(IDD_INPUT), hWnd, Input) == IDOK)
				{
					DrawMbro();
					::InvalidateRect(hWnd, NULL, FALSE);
					::UpdateWindow(hWnd);
				}
				break;
			case IDM_DISP:
				LOG_DEBUG(_T("IDM_DISP"));
				bDispInfo = !bDispInfo;
				::InvalidateRect(hWnd, NULL, FALSE);
				::UpdateWindow(hWnd);
				break;
            case IDM_ABOUT:
				LOG_DEBUG(_T("IDM_ABOUT"));
				DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
                break;
            case IDM_EXIT:
				LOG_DEBUG(_T("IDM_EXIT"));
				DestroyWindow(hWnd);
                break;
            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
            }
        }
        break;
    case WM_PAINT:
        {
			LOG_DEBUG(_T("WM_PAINT"));
			PAINTSTRUCT ps;
            HDC hdc = BeginPaint(hWnd, &ps);
            // TODO: HDC gp`R[hɒǉĂ...
			HDC hdcWork = ::CreateCompatibleDC(hdc);
			HBITMAP hbmpWork = ::CreateCompatibleBitmap(hdc, nMbroWidth, nMbroHeight);
			dibMbro.SetDIBits(hdcWork, hbmpWork);
			HBITMAP hbmpOld = (HBITMAP)::SelectObject(hdcWork, hbmpWork);
			if (bDispInfo)
			{
				_stprintf_s(sText, sizeof(sText) / sizeof(TCHAR), _T("l %1.8e, %1.8e   [g %1.8e"), dCenterX, dCenterY, dVPP);
				::SetTextColor(hdcWork, RGB(255, 255, 255));
				::SetBkColor(hdcWork, RGB(0, 0, 0));
				RECT rect;
				ZeroMemory(&rect, sizeof(rect));
				::DrawText(hdcWork, sText, _tcslen(sText), &rect, DT_CALCRECT);
				::DrawText(hdcWork, sText, _tcslen(sText), &rect, DT_LEFT);
			}
			::BitBlt(hdc, 0, 0, nMbroWidth, nMbroHeight, hdcWork, 0, 0, SRCCOPY);
			::SelectObject(hdcWork, hbmpOld);
			::DeleteObject(hbmpWork);
			::DeleteDC(hdcWork);
			EndPaint(hWnd, &ps);
        }
        break;
    case WM_DESTROY:
		LOG_DEBUG(_T("WM_DESTROY"));
		PostQuitMessage(0);
        break;
	case WM_LBUTTONDOWN:
		{
			POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
			LOGF_DEBUG(_T("WM_LBUTTONDOWN  x=%d y=%d"), pt.x, pt.y);
			if (::DragDetect(hWnd, pt))
			{
				TRACKMOUSEEVENT tme;
				ZeroMemory(&tme, sizeof(tme));
				tme.cbSize = sizeof(tme);
				tme.dwFlags = TME_LEAVE;
				tme.hwndTrack = hWnd;
				::TrackMouseEvent(&tme);
				bDrag = true;
				HCURSOR hcsr = ::LoadCursor(NULL, IDC_HAND);
				::SetCursor(hcsr);
				ptDrag = pt;
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
			LOGF_DEBUG(_T("WM_LBUTTONUP  x=%d y=%d"), pt.x, pt.y);
			bDrag = false;
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
		}
		break;
	case WM_MOUSEMOVE:
		{
			POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
			//LOGF_DEBUG(_T("WM_MOUSEMOVE  x=%d y=%d"), pt.x, pt.y);
			if (bDrag && ((pt.x != ptDrag.x) || (pt.y != ptDrag.y)))
			{
				dCenterX -= (pt.x - ptDrag.x) * dVPP;
				dCenterY += (pt.y - ptDrag.y) * dVPP;
				DrawMbro();
				ptDrag = pt;
				::InvalidateRect(hWnd, NULL, FALSE);
				::UpdateWindow(hWnd);
			}
		}
		break;
	case WM_LBUTTONDBLCLK:
		{
			POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
			LOGF_DEBUG(_T("WM_LBUTTONDBLCLK  x=%d y=%d"), pt.x, pt.y);
			bDrag = false;
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
			double _dVPP = dVPP / 2.0;
			if (_dVPP >= VPP_MIN)
			{
				dCenterX += (pt.x - nMbroWidth / 2) * dVPP;
				dCenterY -= (pt.y - nMbroHeight / 2) * dVPP;
				dVPP = _dVPP;
				DrawMbro();
				::InvalidateRect(hWnd, NULL, FALSE);
			}
		}
		break;
	case WM_RBUTTONDBLCLK:
		{
			POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
			LOGF_DEBUG(_T("WM_RBUTTONDBLCLK  x=%d y=%d"), pt.x, pt.y);
			bDrag = false;
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
			double _dVPP = dVPP * 2.0;
			if (_dVPP <= VPP_MAX)
			{
				dCenterX += (pt.x - nMbroWidth / 2) * dVPP;
				dCenterY -= (pt.y - nMbroHeight / 2) * dVPP;
				dVPP = _dVPP;
				DrawMbro();
				::InvalidateRect(hWnd, NULL, FALSE);
			}
		}
		break;
	case WM_MOUSELEAVE:
		{
			bDrag = false;
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
		}
		break;
	default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

// o[W{bNX̃bZ[W nh[łB
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
        {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}

// ̓_CAO{bNX̃bZ[W nh[łB
INT_PTR CALLBACK Input(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	int len;
	double dx, dy;
	switch (message)
	{
	case WM_INITDIALOG:
		_stprintf_s(sText, sizeof(sText)/sizeof(*sText), _T("%1.8e"), dCenterX);
		::SetDlgItemText(hDlg, IDC_EDIT_X, sText);
		_stprintf_s(sText, sizeof(sText)/sizeof(*sText), _T("%1.8e"), dCenterY);
		::SetDlgItemText(hDlg, IDC_EDIT_Y, sText);
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
			len = ::GetDlgItemText(hDlg, IDC_EDIT_X, sText, sizeof(sText) / sizeof(TCHAR));
			if (len == 0)
			{
				::MessageBox(hDlg, _T("l X ͌"), _T(""), MB_OK);
				return (INT_PTR)FALSE;
			}
			sText[len] = 0;
			_stscanf_s(sText, _T("%le"), &dx);
			len = ::GetDlgItemText(hDlg, IDC_EDIT_Y, sText, sizeof(sText) / sizeof(TCHAR));
			if (len == 0)
			{
				::MessageBox(hDlg, _T("l Y ͌"), _T(""), MB_OK);
				return (INT_PTR)FALSE;
			}
			sText[len] = 0;
			_stscanf_s(sText, _T("%le"), &dy);
			dCenterX = dx;
			dCenterY = dy;
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		default:
			break;
		}
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}


// }fuQvZic = a + bij
//   Zn+1 = (Zn)^2 + c
// x,yWɂvZɕϊia  c ̎Ab  c ̋j
//   Xn+1 = (Xn)^2 - (Yn)^2 + a
//   Yn+1 = 2 * Xn * Yn + b
// return _(x,y)̌_̋̂Q悪臒l𒴂܂ł̌vZ
DWORD CalcMbro(double a, double b)
{
	DWORD cnt_max = 1 << (nColorBitsB + nColorBitsG + nColorBitsR);
	DWORD cnt;
	double xn = 0.0;
	double yn = 0.0;
	for (cnt = 0; cnt < cnt_max; ++cnt)
	{
		double v = xn * xn + yn * yn;
		if (v > dMaxValue)
		{
			return cnt;
		}
		double _xn = xn * xn - yn * yn + a;
		double _yn = 2.0 * xn * yn + b;
		xn = _xn;
		yn = _yn;
	}
	
	return cnt-1;
}


// }fuWOtBbN`
void DrawMbro()
{
	LOGF_DEBUG(_T("DrawMbro() : Center x=%g y=%g  VPP=%g"), dCenterX, dCenterY, dVPP);
	HCURSOR hcsr = ::LoadCursor(NULL, IDC_WAIT);
	hcsr = ::SetCursor(hcsr);
	DWORD maskb = (1 << nColorBitsB) - 1;
	DWORD maskg = (1 << nColorBitsG) - 1;
	DWORD maskr = (1 << nColorBitsR) - 1;
	DWORD fillb = (1 << (8 - nColorBitsB)) - 1;
	DWORD fillg = (1 << (8 - nColorBitsG)) - 1;
	DWORD fillr = (1 << (8 - nColorBitsR)) - 1;
	for (int x = 0; x < nMbroWidth; ++x)
	{
		double dx = (x - nMbroWidth / 2) * dVPP;
		for (int y = 0; y < nMbroHeight; ++y)
		{
			double dy = (nMbroHeight / 2 - y) * dVPP;
			DWORD cnt = CalcMbro(dx + dCenterX, dy + dCenterY);
			DWORD r = (((cnt >> (nColorBitsB + nColorBitsG)) & maskr) << (8 - nColorBitsR)) | fillr;
			DWORD g = (((cnt >> nColorBitsB) & maskg) << (8 - nColorBitsG)) | fillg;
			DWORD b = ((cnt & maskb) << (8 - nColorBitsB)) | fillb;
			dibMbro.SetPixcel(x, y, CDIBData::_RGB(r, g, b));
		}
	}
	::SetCursor(hcsr);
}