// Oo̓NX
// Compiler : Visual Studio/C++ 2008
//
#include "stdafx.h"
#include "common.h"
#include "LogManager.h"
#include <locale.h>

CLogManager::CLogManager()
{
	InitializeCriticalSection(&m_cs);

	m_sLogPath[0] = 0;
	m_hLogFile = INVALID_HANDLE_VALUE;
}

CLogManager::~CLogManager()
{
	if (m_hLogFile != INVALID_HANDLE_VALUE)
	{
		FlushFileBuffers(m_hLogFile);
		CloseHandle(m_hLogFile);
	}
	DeleteCriticalSection(&m_cs);
}

DWORD CLogManager::MakeLogFile()
{
	if (m_hLogFile != INVALID_HANDLE_VALUE)
	{
		FlushFileBuffers(m_hLogFile);
		CloseHandle(m_hLogFile);
	}
	GetModuleDir(m_sLogPath, MAX_PATH);
	_tcscat_s(m_sLogPath, sizeof(m_sLogPath) / sizeof(TCHAR), LOG_FILENAME);
	m_hLogFile = CreateFile(m_sLogPath, GENERIC_WRITE, FILE_SHARE_READ,
							NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (m_hLogFile == INVALID_HANDLE_VALUE)
	{
		return GetLastError();
	}
#ifdef _UNICODE
	if (GetLastError() != ERROR_ALREADY_EXISTS)
	{
		char BOM[2] = { (char)0xff, (char)0xfe };
		DWORD dwLen;
		if (!WriteFile(m_hLogFile, BOM, 2, &dwLen, NULL))
		{
			return GetLastError();
		}
	}
#endif // _UNICODE

	SetFilePointer(m_hLogFile, 0, 0, FILE_END);
	return GetLastError();
}

DWORD CLogManager::PrintLog(LPCTSTR sText)
{
	return PrintLogF(sText);
}

DWORD CLogManager::PrintLogF(LPCTSTR sFormat, ...)
{
	EnterCriticalSection(&m_cs);
	if (m_hLogFile == INVALID_HANDLE_VALUE)
	{
		if (MakeLogFile() != NO_ERROR)
		{
			LeaveCriticalSection(&m_cs);
			return 0;
		}
	}

	LPTSTR *pParam = ((LPTSTR*)&sFormat) + 1;
	DWORD nLen = 0L;

	SYSTEMTIME stime;
	GetLocalTime(&stime);

	LPTSTR sFormatLineBuff = new TCHAR[LOG_BUFSIZE];
	LPTSTR sLineBuff = new TCHAR[LOG_BUFSIZE];

	_vstprintf_s(sFormatLineBuff, LOG_BUFSIZE, sFormat, (va_list)pParam);
	_stprintf_s(sLineBuff, LOG_BUFSIZE, _T("%04d/%02d/%02d %02d:%02d:%02d.%03d %s\r\n")
		, stime.wYear, stime.wMonth, stime.wDay
		, stime.wHour, stime.wMinute, stime.wSecond, stime.wMilliseconds
		, sFormatLineBuff);

	WriteFile(m_hLogFile, sLineBuff, _tcslen(sLineBuff)*sizeof(TCHAR), &nLen, NULL);

	delete[] sFormatLineBuff;
	delete[] sLineBuff;

	LeaveCriticalSection(&m_cs);
	return nLen;
}

DWORD CLogManager::PrintTraceLog(LPCTSTR sFile, int nLine, LPCTSTR sText)
{
	LPCTSTR pos;
	if ((pos = _tcsrchr(sFile, _T('\\'))) != NULL)
	{
		pos++;
	}
	else if ((pos = _tcsrchr(sFile, _T(':'))) != NULL)
	{
		pos++;
	}
	else
	{
		pos = sFile;
	}

	return PrintLogF(_T("[%s:%d] %s"), pos, nLine, sText);
}

DWORD CLogManager::PrintTraceLogF(LPCTSTR sFile, int nLine, LPCTSTR sFormat, ...)
{
	LPCTSTR pos;
	if ((pos = _tcsrchr(sFile, _T('\\'))) != NULL)
	{
		pos++;
	}
	else if ((pos = _tcsrchr(sFile, _T(':'))) != NULL)
	{
		pos++;
	}
	else
	{
		pos = sFile;
	}

	LPTSTR sLog = new TCHAR[LOG_BUFSIZE];
	va_list argptr;
	va_start(argptr, sFormat);
	_vstprintf_s(sLog, LOG_BUFSIZE, sFormat, argptr);
	DWORD dwRes = PrintLogF(_T("[%s:%d] %s"), pos, nLine, sLog);
	delete[] sLog;

	return dwRes;
}

DWORD CLogManager::PrintWinError(LPCTSTR sText, DWORD code)
{
	HMODULE HNTDLL = LoadLibrary(_T("NTDLL.DLL"));
	setlocale(LC_ALL, "japanese");

	LPVOID pmsg = NULL;
	DWORD dw = ::FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_HMODULE,
		HNTDLL,
		code,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR)&pmsg,
		0,
		NULL
		);
	DWORD dwRes;
	if (dw == 0)
	{
		dwRes = PrintLogF(_T("%s : (%08x)"), sText, code);
	}
	else
	{
		dwRes = PrintLogF(_T("%s : %s"), sText, (LPTSTR)pmsg);
		::LocalFree(pmsg);
	}

	FreeLibrary(HNTDLL);
	return dwRes;
}

CLogManager LogMng;
