#include "stdafx.h"
#include "IGraph.h"


template class CIPoint<int>;
template class CIPoint<double>;
template class CISize<int>;
template class CISize<double>;
template bool cross_point<int> (CIPoint<int> a1, CIPoint<int> a2, CIPoint<int> b1, CIPoint<int> b2, CIPoint<int>& c);
template bool cross_point<double>(CIPoint<double> a1, CIPoint<double> a2, CIPoint<double> b1, CIPoint<double> b2, CIPoint<double>& c);
template bool cripping<int>(CIPoint<int> c1, CIPoint<int> c2, CIPoint<int>& q1, CIPoint<int>& q2);
template bool cripping<double>(CIPoint<double> c1, CIPoint<double> c2, CIPoint<double>& q1, CIPoint<double>& q2);
template bool is_in<int>(CIPoint<int> a, CIPoint<int> b, CIPoint<int> c, CIPoint<int> d);
template bool is_in<double>(CIPoint<double> a, CIPoint<double> b, CIPoint<double> c, CIPoint<double> d);

/* WNXev[g */

// RXgN^
template <typename Type> CIPoint<Type>::CIPoint()
	: x(0), y(0)
{
}
template <typename Type> CIPoint<Type>::CIPoint(Type dx, Type dy)
	: x(dx), y(dy)
{
}
template <typename Type> CIPoint<Type>::CIPoint(const CIPoint& dp)
	: x(dp.x), y(dp.y)
{
}

// 
template <typename Type> bool CIPoint<Type>::operator==(CIPoint<Type> dp) const
{
	if ((dp.x == x) && (dp.y == y))
	{
		return true;
	}
	else
	{
		return false;
	}
};
template <typename Type> bool CIPoint<Type>::operator!=(CIPoint<Type> dp) const
{
	if ((dp.x == x) && (dp.y == y))
	{
		return false;
	}
	else
	{
		return true;
	}
};
template <typename Type> CIPoint<Type> CIPoint<Type>::operator+=(CISize<Type> ds)
{
	x += ds.cx;
	y += ds.cy;
	return *this;
};
template <typename Type> CIPoint<Type> CIPoint<Type>::operator-=(CISize<Type> ds)
{
	x -= ds.cx;
	y -= ds.cy;
	return *this;
};
template <typename Type> CIPoint<Type> CIPoint<Type>::operator+(CISize<Type> ds)
{
	return (CIPoint<Type>(x + ds.cx, y + ds.cy));
};
template <typename Type> CIPoint<Type> CIPoint<Type>::operator-(CISize<Type> ds)
{
	return (CIPoint<Type>(x - ds.cx, y - ds.cy));
};
template <typename Type> CIPoint<Type> CIPoint<Type>::operator-()
{
	return (CIPoint<Type>(-x, -y));
};
template <typename Type> CISize<Type> CIPoint<Type>::operator-(CIPoint<Type> dp)
{
	return (CISize<Type>(x - dp.x, y - dp.y));
};


/* TCYNXev[g */

// RXgN^
template <typename Type> CISize<Type>::CISize()
	: cx(0), cy(0)
{
}
template <typename Type> CISize<Type>::CISize(Type dcx, Type dcy)
	: cx(dcx), cy(dcy)
{
}
template <typename Type> CISize<Type>::CISize(const CISize& ds)
	: cx(ds.cx), cy(ds.cy)
{
}

// 
template <typename Type> bool CISize<Type>::operator==(CISize ds) const
{
	if ((ds.cx == cx) && (ds.cy == cy)) {
		return true;
	}
	else {
		return false;
	}
};
template <typename Type> bool CISize<Type>::operator!=(CISize ds) const
{
	if ((ds.cx == cx) && (ds.cy == cy)) {
		return false;
	}
	else {
		return true;
	}
};
template <typename Type> CISize<Type> CISize<Type>::operator+=(CISize ds)
{
	cx += ds.cx;
	cy += ds.cy;
	return *this;
};
template <typename Type> CISize<Type> CISize<Type>::operator-=(CISize ds) {
	cx -= ds.cx;
	cy -= ds.cy;
	return *this;
};
template <typename Type> CISize<Type> CISize<Type>::operator+(CISize ds)
{
	return (CISize<Type>(cx + ds.cx, cy + ds.cy));
};
template <typename Type> CISize<Type> CISize<Type>::operator-(CISize ds)
{
	return (CISize<Type>(cx - ds.cx, cy - ds.cy));
};
template <typename Type> CISize<Type> CISize<Type>::operator-()
{
	return (CISize<Type>(-cx, -cy));
};


/* NbsO֐ev[g */
/*
̌_߂֐
`(a1`a2)
a(b1`b2)
`̕(r)
a̕(s)

_p@(a2 - a1) * r + a1 == (b2 - b1) * s + b1
CœWJ
(a2x - a1x) * r + a1x == (b2x - b1x) * s + b1x
(a2y - a1y) * r + a1y == (b2y - b1y) * s + b1y
A
     (b2y - b1y) * (a1x - b1x) + (b2x - b1x) * (b1y - a1y)
r == -----------------------------------------------------
     (a2y - a1y) * (b2x - b1x) - (b2y - b1y) * (a2x - a1x)
     (a2y - a1y) * (b1x - a1x) + (a2x - a1x) * (a1y - b1y)
s == -----------------------------------------------------
     (b2y - b1y) * (a2x - a1x) - (a2y - a1y) * (b2x - b1x)

wax = a2x - a1x
way = a2y - a1y
wbx = b2x - b1x
wby = b2y - b1y
    wby * (a1x - b1x) + wbx * (b1y - a1y)
r = -------------------------------------    (0 <= r <= 1)
            way * wbx - wby * wax
    way * (a1x - b1x) + wax * (b1y - a1y)
s = -------------------------------------    (0 <= s <= 1)
            way * wbx - wby * wax

qx = (a2x - a1x) * r + a1x
qy = (a2y - a1y) * r + a1y
*/
template <typename Type>
bool cross_point(CIPoint<Type> a1, CIPoint<Type> a2, CIPoint<Type> b1, CIPoint<Type> b2, CIPoint<Type>& q)
{
	CISize<Type> wa = a2 - a1;
	CISize<Type> wb = b2 - b1;
	Type den = wa.cy * wb.cx - wb.cy * wa.cx;
	if (den == (Type)0)
	{
		return false;
	}
	double r = (double)(wb.cy * (a1.x - b1.x) + wb.cx * (b1.y - a1.y)) / den;
	if ((r < (Type)0) || (r >(Type)1))
	{
		return false;
	}
	double s = (double)(wa.cy * (a1.x - b1.x) + wa.cx * (b1.y - a1.y)) / den;
	if ((s < 0.0) || (s > 1.0))
	{
		return false;
	}
	q.x = (Type)((a2.x - a1.x) * r + a1.x);
	q.y = (Type)((a2.y - a1.y) * r + a1.y);
	return true;
}

/*
 c1 - c2 ΊpƂiX̖j`̈Ő q1 - q2 ؂
*/
template <typename Type>
bool cripping(CIPoint<Type> c1, CIPoint<Type> c2, CIPoint<Type>& q1, CIPoint<Type>& q2)
{
	if ((c1.x == c2.x) || (c1.y == c2.y))
	{
		return false;
	}

	CIPoint<Type> lt;
	CIPoint<Type> rb;
	if (c1.x <= c2.x){
		lt.x = c1.x;
		rb.x = c2.x;
	}
	else {
		lt.x = c2.x;
		rb.x = c1.x;
	}
	if (c1.y <= c2.y){
		lt.y = c1.y;
		rb.y = c2.y;
	}
	else {
		lt.y = c2.y;
		rb.y = c1.y;
	}

	CIPoint<Type> qo;
	bool cross = false;
	if (cross_point<Type>({ lt.x, lt.y }, { lt.x, rb.y }, q1, q2, qo))
	{
		cross = true;
		if (q1.x < lt.x)	q1 = qo;
		else				q2 = qo;
	}
	if (cross_point<Type>({ rb.x, lt.y }, { rb.x, rb.y }, q1, q2, qo))
	{
		cross = true;
		if (q1.x > rb.x)	q1 = qo;
		else				q2 = qo;
	}
	if (cross_point<Type>({ lt.x, lt.y }, { rb.x, lt.y }, q1, q2, qo))
	{
		cross = true;
		if (q1.y < lt.y)	q1 = qo;
		else				q2 = qo;
	}
	if (cross_point<Type>({ lt.x, rb.y }, { rb.x, rb.y }, q1, q2, qo))
	{
		cross = true;
		if (q1.y > rb.y)	q1 = qo;
		else				q2 = qo;
	}

	return cross;
}

/*
a, b, c 𒸓_Ɏ`̈Ő q1 - q2 ؂
*/
template <typename Type>
bool cripping(CIPoint<Type> a, CIPoint<Type> b, CIPoint<Type> c, CIPoint<Type>& q1, CIPoint<Type>& q2)
{
	CIPoint<Type> lt;
	CIPoint<Type> rb;
	if (c1.x <= c2.x) {
		lt.x = c1.x;
		rb.x = c2.x;
	}
	else {
		lt.x = c2.x;
		rb.x = c1.x;
	}
	if (c1.y <= c2.y) {
		lt.y = c1.y;
		rb.y = c2.y;
	}
	else {
		lt.y = c2.y;
		rb.y = c1.y;
	}
	return true;
}

/*
Op` a-b-c ɓ_ d ݂邩ׂ
*/
template <typename Type>
bool is_in(CIPoint<Type> a, CIPoint<Type> b, CIPoint<Type> c, CIPoint<Type> d)
{
	/* a-b  a-d ̊Oς߂ */
	Type ab_ad = (b.x - a.x) * (d.y - a.y) - (b.y - a.y) * (d.x - a.x);
	/* b-c  b-d ̊Oς߂ */
	Type bc_bd = (c.x - b.x) * (d.y - b.y) - (c.y - b.y) * (d.x - b.x);
	/* c-a  c-d ̊Oς߂ */
	Type ca_cd = (a.x - c.x) * (d.y - c.y) - (a.y - c.y) * (d.x - c.x);
	/* ʂSēیi^jȂOp`ɑ݂ */
	if ((ab_ad >= 0) && (bc_bd >= 0) && (ca_cd >= 0))
	{
		return true;
	}
	if ((ab_ad <= 0) && (bc_bd <= 0) && (ca_cd <= 0))
	{
		return true;
	}

	return false;
}
