/**********************************************************/
/* error process wrapper functions                        */
/*  from UNIX NETWORK PROGRAMMING,Vol.1,Second Edition,   */
/*      By W. Richard Stevens, Published By Prentice Hall */
/*       ftp://ftp.kohala.com/pub/rstevens/unpv12e.tar.gz */
/**********************************************************/
#include "opengatesrv.h"

int
Open(const char *pathname, int oflag, mode_t mode)
{
	int		fd;

	if ( (fd = open(pathname, oflag, mode)) == -1)
		err_msg("open error for %s", pathname);
	return(fd);
}

int
Close(int fd)
{
  int ret;

  /*if( (ret=close(fd)) == -1)
   *  err_msg("close error");
   */

  ret=close(fd);

  return ret;
}

pid_t
Fork(void)
{
	pid_t	pid;

	if ( (pid = fork()) == -1)
		err_msg("fork error");
	return(pid);
}

int
Pipe(int *fds)
{
  int ret;
	if ((ret=pipe(fds)) < 0)
		err_msg("pipe error");

	return ret;
}

int
Getpeername(int fd, struct sockaddr *sa, socklen_t *salenptr)
{
  int ret;
	if ((ret=getpeername(fd, sa, salenptr)) < 0)
		err_msg("getpeername error");

	return ret;
}

int
Socket(int family, int type, int protocol)
{
	int		n;

	if ( (n = socket(family, type, protocol)) < 0)
		err_msg("socket error");
	return(n);
}

int
Listen(int fd, int backlog)
{
  int ret;
	char	*ptr;

		/*4can override 2nd argument with environment variable */
	if ( (ptr = getenv("LISTENQ")) != NULL)
		backlog = atoi(ptr);

	if ((ret=listen(fd, backlog)) < 0)
		err_msg("listen error");

	return ret;
}

void *
Malloc(size_t size)
{
	void	*ptr;

	if ( (ptr = malloc(size)) == NULL)
		err_msg("malloc error");
	return(ptr);
}
