/*
 * service.h
 *
 *  Created on: 2012/06/08
 *      Author: yasuoki
 */

#ifndef SERVICE_H_
#define SERVICE_H_

namespace SST {

class Service {
public:
	Service();
	~Service();

	bool			configure(Sentinel *sentinel, const char *id);
	bool			run();
	void			stop();
	const char *	getServiceId() const;

	ServiceInfo *	getServiceInfo() const;
	const char *	getParticipationGroupId(size_t index) const;
	bool			getResource(size_t nFrom, RecList *pList) const;
	ServiceStatus	getServiceStatus() const;
	bool			isServiceParticipation(const char *userId) const;

protected:
	Sentinel *		sentinel;
	char			serviceId[8];
	char *			serviceName;
	char *			ownerId;

	size_t			bGroup;
	size_t			nGroup;
	char **			pGroup;

	size_t			bResources;
	size_t			nResources;
	Resource **		pResources;
};


class Services
{
public:
	Services();
	~Services();
	bool	configure(Sentinel *sentinel, Conf *conf);
	bool	run();
	void	stop();

	size_t	getServiceCount() const { return nNodes; }
	Service *getService(size_t index) { return pNodes[index]; }

protected:
	void	clear();

	Sentinel *	sentinel;
	size_t		nNodes;
	size_t		bNodes;
	Service **	pNodes;
};
}

#endif /* SERVICE_H_ */
