/*
 * sentinel.h
 *
 *  Created on: 2012/06/05
 *      Author: Yasuoki
 */

#ifndef SENTINEL_H_
#define SENTINEL_H_

#include "../include/sst_types.h"
#include "device_slot.h"
#include "session.h"
#include "queue.h"
#include "listener.h"
#include "requester.h"
#include "processor.h"
#include "service.h"
#include <csignal>
#include <syslog.h>
#include <event2/event.h>
#include <event2/thread.h>

namespace SST {

class Sentinel {
public:
	Sentinel();
	~Sentinel();
private:
	Sentinel(const Sentinel &c);
	Sentinel &operator=(const Sentinel &c);
public:
	void	log(int logLevel, const char *fmt, ...);
	bool 	loadConfig(const char *file);
	Conf *	getConf();
	bool	run();
	bool	process();
	bool	waitDataArive(Session *c);
	SessionPool &getSessionPool();
	Queue &	getQueue() { return queue; }
	ListenerPool & getListener();
	Database *getDatabase() { return pDatabase; }
	Services &getServices() { return services; }
	Requester &getRequester() { return requester; }
	int		getLoad() const;

protected:
	Conf *	allocConf(const char *confFileName);
	void	freeConf(Conf *conf);
	bool	configure();
	bool	startThreads();
	void	waitThreads();
	static void	sigtermProc(int fd, short event, void *args);
	static void	sighupProc(int fd, short event, void *args);
	static void	sigintProc(int fd, short event, void *args);

	Conf *conf;
	Database 			*pDatabase;
	DeviceSlotList *	pDevices;
	Queue				queue;
	ListenerPool		listener;
	ProcessorPool		processor;
	SessionPool			conList;
	Services			services;
	Requester			requester;

	struct event_base *eventBase;
    struct event *sigterm;
    struct event *sighup;
    struct event *sigint;
};

}

#endif /* SENTINEL_H_ */
