/*
 * requester.cpp
 *
 *  Created on: 2012/07/31
 *      Author: tanaka
 */

#include "../include/sst_types.h"
#include "message.h"
#include "sentinel.h"
#include "requester.h"
#include <syslog.h>
#include <curl/curl.h>

namespace SST {

Requester::RequestProcessor::RequestProcessor(Requester * rs)
{
	requester	= rs;

	request		= NULL;
	response	= NULL;

	threadHandlePtr	= NULL;
	doCancel	= false;
	doStop		= false;
}

Requester::RequestProcessor::~RequestProcessor()
{
}

bool Requester::RequestProcessor::run()
{
	if( threadHandlePtr ) return true;
	if( pthread_create( &threadHandle, NULL, threadEntry, this) != 0 ) {
		requester->sentinel->log(LOG_ERR, "RequestProcessor: start thread is failed");
		return false;
	}
	threadHandlePtr	= &threadHandle;
	return true;
}

void Requester::RequestProcessor::stop()
{
	doStop	= true;
	if( threadHandlePtr ) {
		requester->queue.put(new QnEnd());
	}
}

void Requester::RequestProcessor::wait()
{
	if( threadHandlePtr ) {
		void *ret = NULL;
		pthread_join(*threadHandlePtr, &ret);
		threadHandlePtr	= NULL;
		doStop	= false;
	}
}

void * Requester::RequestProcessor::threadEntry(void *ptr)
{
	void *ret = ((Requester::RequestProcessor*)ptr)->mainLoop();
	((Requester::RequestProcessor*)ptr)->threadHandlePtr = NULL;
	return ret;
}

void * Requester::RequestProcessor::mainLoop()
{
	requester->sentinel->log(LOG_INFO, "RequestProcessor: thread %x is start", threadHandle);

	while( !doStop ) {
		requester->sentinel->log(LOG_DEBUG, "RequestProcessor: %x wait in", threadHandle);
		QueueNode *q = requester->queue.get();
		requester->sentinel->log(LOG_DEBUG, "RequestProcessor: %x wait out", threadHandle);
		if( q == NULL ) {
			requester->sentinel->log(LOG_ERR, "RequestProcessor: queue error");
			break;
		}
		if( q->getType() != QueueRequest ) {
			requester->sentinel->log(LOG_ERR, "RequestProcessor: queue type error");
			break;
		}
		QnRequest *rq = (QnRequest*)q;
		process(rq);
		delete q;
	}
	requester->sentinel->log(LOG_ERR, "RequestProcessor: thread %x is exit", threadHandle);
	return NULL;
}

bool Requester::RequestProcessor::process(QnRequest *q)
{
	requester->sentinel->log(LOG_DEBUG, "RequestProcessor::process 1" );
	curNode = q;

	requester->sentinel->log(LOG_DEBUG, "RequestProcessor::process 2 url=%s", q->msg->getURL() );
	CURL *curl;
	CURLcode res;
	curl = curl_easy_init();
	if( !curl) {
		requester->sentinel->log(LOG_ERR, "RequestProcessor::process curl init failed");
		return false;
	}
	curl_easy_setopt(curl, CURLOPT_URL, q->msg->getURL());
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, pxWriteCB);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, this);
	res = curl_easy_perform(curl);
	curl_easy_cleanup(curl);
	if (res != CURLE_OK) {
		requester->sentinel->log(LOG_ERR, "RequestProcessor::process curl failed");
		return false;
	}
	requester->sentinel->log(LOG_DEBUG, "RequestProcessor::process end" );
	return true;
}

bool Requester::RequestProcessor::cancelProcess()
{
	doCancel	= true;
	return true;
}

size_t Requester::RequestProcessor::writeCB(char* ptr, size_t size, size_t nmemb)
{
	requester->sentinel->log(LOG_DEBUG, "RequestProcessor::writeCB ptr=%x size=%u, nmemb=%u", ptr, size, nmemb);
	if( response == NULL ) {
		response = new Message();
	}
	response->addContent(ptr, size*nmemb);
	QnResponse *n = new QnResponse(curNode->con, response, curNode->data);
	requester->sentinel->getQueue().put(n);
    return size * nmemb;
}

size_t Requester::RequestProcessor::pxWriteCB(char* ptr, size_t size, size_t nmemb, void* data)
{
	Requester::RequestProcessor *inst = (Requester::RequestProcessor*)data;
	return inst->writeCB(ptr, size, nmemb);
}

///////////////////////////
Requester::Requester()
{
	sentinel	= NULL;
	pProcessor	= NULL;
	nProcessor	= 0;
}

Requester::~Requester()
{
	clear();
}

void Requester::clear()
{
	if( pProcessor ) {
		size_t i;
		for( i = 0; i < nProcessor; i++) {
			delete pProcessor[i];
		}
		free(pProcessor);
	}
	queue.clear();
}

bool Requester::configure(Sentinel *obj, Conf *conf)
{
	sentinel	= obj;
	sentinel->log(LOG_DEBUG, "Requester::configure begin");
	size_t nProcs=8;
	RequestProcessor **ptr = (RequestProcessor**)malloc(sizeof(RequestProcessor*)*nProcs);
	size_t i;
	for( i = 0; i < nProcs; i++ ) {
		RequestProcessor *proc = new RequestProcessor(this);
		ptr[i] = proc;
	}
	nProcessor	= nProcs;
	pProcessor	= ptr;
	sentinel->log(LOG_DEBUG, "Requester::configure end");
	return true;
}

bool Requester::run(Sentinel *obj)
{
	sentinel->log(LOG_DEBUG, "Requester::run start");
	size_t i;
	for( i = 0; i < nProcessor; i++ ) {
		if( !pProcessor[i]->run() ) return false;
	}
	sentinel->log(LOG_DEBUG, "Requester::run end");
	return true;
}

void Requester::stop()
{
	size_t i;
	for( i = 0; i < nProcessor; i++ ) {
		pProcessor[i]->stop();
	}
	for( i = 0; i < nProcessor; i++ ) {
		pProcessor[i]->wait();
	}
}

bool Requester::putRequest(QnRequest *r)
{
	return queue.put(r);
}

}


