/*
 * queue.h
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#ifndef QUEUE_H_
#define QUEUE_H_

#include "../include/sst_types.h"
#include "lock.h"
#include <semaphore.h>

namespace SST {

class QueueNode
{
public:
	QueueNode(int type) {
		this->type	= type;
		this->next	= NULL;
	}
	virtual ~QueueNode() {

	}
	int	getType() {
		return type;
	}
	int	type;
	QueueNode *next;
};

class Queue
{
public:
	Queue();
	~Queue();

	void		clear();
	bool		put(QueueNode *node);
	QueueNode *	get();

protected:
	sem_t		qevent;
	LockObject	lock;
	QueueNode	*top;
	QueueNode	*bottom;
};

}


#endif /* QUEUE_H_ */
