/*
 * queue.cpp
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#include "queue.h"

namespace SST {

Queue::Queue()
{
	sem_init(&qevent, 0, 0);
	top		= NULL;
	bottom	= NULL;
}

Queue::~Queue()
{
	clear();
}

void Queue::clear()
{
	WriteLock lc(lock);
	QueueNode *p = top;
	while(p) {
		QueueNode *n = p->next;
		delete p;
		p = n;
	}
}

bool Queue::put(QueueNode *node)
{
	WriteLock lc(lock);
	if( bottom )
		bottom->next = node;
	else
		top			 = node;
	bottom		= node;
	sem_post(&qevent);
	return true;
}

QueueNode * Queue::get()
{
	if( sem_wait(&qevent) == -1 ) {
		return NULL;
	}
	QueueNode *r;
	{
		WriteLock lc(lock);
		r = top;
		if( r ) {
			top	= r->next;
			if( bottom == r ) bottom = NULL;
			r->next = NULL;
		}
	}
	return r;
}


}



