/*
 * listener.cpp
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#include "sentinel.h"
#include "listener.h"
#include "commands.h"
#include <memory.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <netdb.h>

namespace SST {

void ListenerPool::Listener::connectProc(int fd, short event, void *arg)
{
	ListenerPool *pool = (ListenerPool*)arg;
	Sentinel *sentinel = pool->sentinel;
	sentinel->log(LOG_DEBUG, "Listener::connectProc %d begin", fd);

	sockaddr_in caddr;
	socklen_t addrLen=sizeof(caddr);
	int cfd = accept(fd, (sockaddr *)&caddr, &addrLen);
	int val = 1;
	ioctl(cfd, FIONBIO, &val);

	event_add(pool->listenEvent, NULL);

	sentinel->getQueue().put(new QnAccept(cfd, &caddr));
	sentinel->log(LOG_DEBUG, "Listener::connectProc %d end", fd);
	return;
}

void ListenerPool::Listener::recvProc(int fd, short event, void *args)
{
	Session *con	= (Session*)args;
	Sentinel *sentinel = con->getSentinel();

	sentinel->log(LOG_DEBUG, "Listener::recvProc %d begin", fd);
	sentinel->getQueue().put(new QnSessionData(con));
	sentinel->log(LOG_DEBUG, "Listener::recvProc %d end", fd);
	return;
}

ListenerPool::Listener::Listener()
{
	doStop			= false;
	pool			= NULL;
	threadHandlePtr	= NULL;
}

ListenerPool::Listener::~Listener()
{
}

bool ListenerPool::Listener::run(ListenerPool *obj)
{
	pool		= obj;
	if( pthread_create( &threadHandle, NULL, threadEntry, this) != 0 ) {
		pool->sentinel->log(LOG_ERR, "start listen thread is failed");
		return false;
	}
	threadHandlePtr	= &threadHandle;
	return true;
}

void ListenerPool::Listener::stop()
{
	doStop	= true;
	if( threadHandlePtr ) {
		if( pool->listenBase )
			event_base_loopbreak(pool->listenBase);
		void *ret = NULL;
		pthread_join(threadHandle, &ret);
		threadHandlePtr = NULL;
	}
	doStop	= false;
}

void *ListenerPool::Listener::threadEntry(void *ptr)
{
	void *ret = ((Listener*)ptr)->mainLoop();
	((Listener*)ptr)->threadHandlePtr	= NULL;
	return ret;
}

void *ListenerPool::Listener::mainLoop()
{
	pool->sentinel->log(LOG_INFO, "listen thread %x is start", threadHandle);

	if( !doStop )
		event_base_dispatch(pool->listenBase);

	pool->sentinel->log(LOG_ERR, "listen thread %x is exit", threadHandle);
	return NULL;
}

/////////////////////////////////////////////////////

ListenerPool::ListenerPool()
{
	fd	= 0;
	sentinel	= NULL;
	listenBase	= NULL;
	listenEvent	= NULL;
	pListener	= NULL;
	nListener	= 0;
}

ListenerPool::~ListenerPool()
{
	clear();
}

void ListenerPool::clear()
{
	int i;

	for( i = 0; i < nListener; i++ )
		pListener[i].stop();

	if( pListener ) {
		delete [] pListener;
	}
	pListener	= NULL;
	nListener	= 0;

	if( listenEvent ) {
		event_del(listenEvent);
		event_free(listenEvent);
		listenEvent	= NULL;
	}
	if( listenBase ) {
		event_base_free(listenBase);
		listenBase	= NULL;
	}
	if( fd ) {
		::close(fd);
	}
}

bool ListenerPool::run(Sentinel *obj)
{
	sentinel	= obj;
	Conf *conf = obj->getConf();

	struct sockaddr_in srcAddr;
	memset(&srcAddr, 0, sizeof(srcAddr));
	srcAddr.sin_port = htons(conf->port);
	srcAddr.sin_family = AF_INET;
	srcAddr.sin_addr.s_addr = htonl(INADDR_ANY);

	int s = socket(AF_INET, SOCK_STREAM, 0);
	if( s == -1 ) {
		sentinel->log(LOG_ERR, "tcp socket can't open");
		return false;
	}
	char optval = 1/*1*/;
	::setsockopt( s, SOL_SOCKET, SO_REUSEADDR, (char*)&optval, sizeof(char) );
	if( bind(s, (struct sockaddr *) &srcAddr, sizeof(srcAddr)) == -1 ) {
		sentinel->log(LOG_ERR, "tcp socket can't bind");
		return false;
	}

	if( listen(s, 1) == -1 ) {
		sentinel->log(LOG_ERR, "tcp socket can't listen");
		return false;
	}

	fd = s;
	listenBase	= event_base_new();
    listenEvent = event_new(listenBase, fd, EV_READ, Listener::connectProc, this);
    event_add(listenEvent, NULL);

	int defListener	= conf->numListener;
	if( defListener <= 0 ) defListener = 1;
	pListener	= new Listener[defListener];
	if( pListener == NULL ) {
		sentinel->log(LOG_ERR, "Out of memory for listener thread.");
		return false;
	}
	nListener	= defListener;
	int i;
	for( i = 0; i < nListener; i++ ) {
		if( !pListener[i].run(this) ) {
			return false;
		}
	}
	return true;
}

void ListenerPool::stop()
{
	int i;
	for( i = 0; i < nListener; i++ ) {
		pListener[i].stop();
	}
	::close(fd);
}

bool ListenerPool::waitData(Session *con)
{
	struct event *ev = con->assignEvent(listenBase, Listener::recvProc);
    event_add(ev, NULL);
    return true;
}

}




