/*
 * device_slot.h
 *
 *  Created on: 2012/06/13
 *      Author: yasuoki
 */

#ifndef DEVICE_SLOT_H_
#define DEVICE_SLOT_H_

#include "../include/sst_types.h"

namespace SST {

class DeviceSlot
{
public:
	DeviceSlot();
	~DeviceSlot();

	DeviceSlotStatus	getStatus();
	bool		setStatus(DeviceSlotStatus st);
	bool		setDevice(Device *dev);
	Device *	getDevice();
	void		closeDevice();

protected:
	DeviceSlotStatus	status;
	Device *			device;
};

class DeviceSlotList
{
public:
	DeviceSlotList(Sentinel *sst);
	~DeviceSlotList();

	bool	allocSlot(size_t size);
	void	clear();
	size_t	getSlotCount();

protected:
	Sentinel *	sstptr;
	size_t		nSlots;
	size_t		nAllocs;
	DeviceSlot **pSlot;
};

}

#endif /* DEVICE_SLOT_H_ */
