/*
 * device_slot.cpp
 *
 *  Created on: 2012/06/15
 *      Author: yasuoki
 */

#include "sentinel.h"
#include "device_slot.h"
#include <malloc.h>
#include <memory.h>

namespace SST {

DeviceSlotList::DeviceSlotList(Sentinel *sst)
{
	sstptr	= sst;
	nSlots	= 0;
	nAllocs	= 0;
	pSlot	= NULL;
}

DeviceSlotList::~DeviceSlotList()
{
	clear();
}

bool DeviceSlotList::allocSlot(size_t size)
{
	if( size > nAllocs ) {
		DeviceSlot **list = (DeviceSlot**)realloc(pSlot, sizeof(DeviceSlot*));
		if( list == NULL ) {
			sstptr->log(LOG_ERR, "Out of memory at device slot allocate");
			return false;
		}
		memset(list, 0, sizeof(DeviceSlot*));
		pSlot	= list;
		nAllocs	= size;
	}
	return true;
}

void DeviceSlotList::clear()
{
	if( nAllocs ) {
		free((void*)pSlot);
	}
	nAllocs	= 0;
	nSlots	= 0;
	pSlot	= NULL;
}

size_t DeviceSlotList::getSlotCount()
{
	return nSlots;
}

}


