/*
 * sst_types.h
 *
 *  Created on: 2012/06/05
 *      Author: yasuoki
 */

#ifndef SST_TYPES_H_
#define SST_TYPES_H_

#include <stdlib.h>

#define SST_SYSLOGIDENT	"sentinel"
#define SST_STDERRIDENT	"stderr"
#define SST_CONFFOLDER	"/etc/sentinel"
#define SST_CONFFILE	"sentinel.conf"
#define SST_PIDFILE		"/var/run/sentinel.pid"
#define SST_PORT		1119
#define SST_TIMEOUT		30
#define SST_MAXWAITTIME	600
#define SST_CONNTHREADS 4
#define SST_DBTHREADS	4
#define SST_USERIDLEN	8
#define SST_SERVICEIDLEN	8
#define SST_RESOURCEIDLEN	8

#define SST_IOBUFFER_BLOCKSIZE	64
#define SST_ERR_NOMORECONNECTION 500

#define SST_ACCOUNID_LEN	8

namespace SST {

class LockObject;
class LockBase;
class ReadLock;
class WriteLock;
class Link;
class Database;
class Session;
class SessionPool;
class DeviceSlot;
class DeviceSlotList;
class Group;
class GroupList;
class Service;
class Schedule;
class Resource;
class Queue;
class QueueNode;
class Processor;
class Listener;
class CyclicBuffer;
class Message;
class RequestNode;
class Requester;
class Sentinel;

enum LogLevel {
	LogLevelDebug = 0,
	LogLevelVerbose = 1,
	LogLevelNotice = 2,
	LogLevelWarning = 3,
	LogLevelError = 4,
};

enum DeviceSlotStatus {
	DeviceSlotFree		= 0,
	DeviceSlotAssign	= 1,
	DeviceSlotAuth		= 3,
	DeviceSlotLinked	= 4,
	DeviceSlotWait		= 5,
	DeviceSlotClose		= 6,
};

enum LinkSpeed {
	LinkNone 		= 0,
	LinkHighSpeed	= 1,
	LinkLowSpeed	= 2,
};

enum ScheduleType {
	ScheduleNone		= 0,
	ScheduleEveryTime	= 1,
	ScheduleEveryDay	= 2,
	ScheduleEveryWeek	= 3,
	ScheduleEveryMonth	= 4,
	ScheduleSpecifyTime	= 5,
};

enum QueueType {
	QueueEnd			= 0,
	QueueAccept			= 1,
	QueueSessionData	= 2,
	QueueSessionCommand	= 3,
	QueueRequest		= 4,
	QueueResponse		= 5,
};

enum SessionStatus {
	SessionStatusWait		= 0,
	SessionStatusAccept		= 1,
	SessionStatusConnect	= 2,
	SessionStatusLogin		= 3,
};

enum ServiceStatus {
	ServiceStop = 0,
	ServiceOpen = 1,
	ServiceClose = 2,
	ServiceError = 3,
};

enum ResourceStatus {
	ResourceStop = 0,
	ResourceOpen = 1,
	ResourceClose = 2,
	ResourceError = 3,
};

enum DBError {
	DBErrorOk			= 0,
	DBErrorSystem		= 500,
	DBErrorLocked		= 501,
	DBErrorNotFound		= 502,
	DBErrorParmission	= 503,
	DBErrorAuth			= 504,
	DBErrorUserName		= 505,
	DBErrorDuplication	= 506,
	DBErrorNoSpace		= 507,
};

enum CMDStatus {
	CMDOk				= 0,
	CMDErrMemory		= 1,
	CMDErrRuntime		= 2,
	CMDErrDatabase		= 3,
	CMDErrComm			= 4,
	CMDErrMessage		= 5,
	CMDErrCommand		= 6,
	CMDErrNotLogin		= 7,
	CMDErrPermission	= 8,
	CMDErrNotFound		= 9,
	CMDErrDataFull		= 10,
	CMDErrDataLost		= 11,
	CMDErrDataConflict	= 12,
	CMDErrParameter		= 13,
	CMDErrHierarchy		= 14,
};
enum AccountField {
	AccountName		= 0x01,
	AccountAuth		= 0x02,
	AccountMail		= 0x04,
	AccountAddr		= 0x08,
	AccountPhone	= 0x10,
	AccountStat		= 0x20,
	AccountAll		= 0xff,
};

typedef struct _NamedValue {
	char *name;
	char *value;
} NamedValue;

typedef struct _RecList {
	size_t	nSize;
	size_t	nCount;
	size_t	nValues;
	char *	pValue[1];
} RecList;

typedef struct _Account {
	size_t	nSize;
	char *	id;
	char *	userName;
	char *	auth;
	char *	firstName;
	char *	secondName;
	char *	lastName;
	char *	email;
	char *	addr1;
	char *	addr2;
	char *	addr3;
	char *	phone;
	int		level;
	int		maxStorage;
	int		useStorage;
	time_t	createDate;
	time_t	lastDate;
} Account;

typedef struct _AccountGropu {
	char *	id;
	char *	groupName;
	char *	adminId;
	char *	description;
} AccountGroup;

typedef struct _Device {
	char *	id;
	int		langId;
	int		locale;
	char *	OS;
	char *	carrier;
	char *	ownerId;
	char *	sessionNode;
	char *	sessionId;
	time_t	lastConnectTime;
	time_t	connectTime;
	time_t	lastSyncTime;
} Device;

typedef struct _ServiceInfo {
	char *	serviceId;
	char *	serviceName;
	char *	ownerId;
	ServiceStatus status;
	size_t	participationGroupCount;
	size_t	resourceCount;
} ServiceInfo;

typedef struct _ResourceInfo {
	char *	serviceId;
	char *	resourceId;
	char *	resourceName;
	ResourceStatus status;
	char *	URL;
	char *	method;
	char *	paramPattern;
	char *	headerPattern;
} ResourceInfo;

typedef struct _Conf {
	char *	confFile;
	char *	pidFile;
	bool	daemonaize;
	int		initProcesses;
	int		numListener;
	int		numProcessor;
	int		maxConnections;
	int		maxDevices;
	int		maxUsers;
	int		maxGroups;
	int		maxServices;
	int		maxResources;
	char *	serverName;
	int		port;
	char *	bind;
	char *	authPasswd;
	char *	authMethod;
	int		timeout;
	int		maxWaitTime;
	int		connThreads;
	LogLevel	logLevel;
	char *	logIdent;
	char *	dbServer;
	int		dbPort;
	char *	dbAuth;
	int		dbThreads;
	char *	masterServer;
	int		masterPort;
	char *	masterAuth;
	bool	cloneMaster;
} Conf;

typedef unsigned int revision_t;

}

#endif /* SST_TYPES_H_ */
