/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.atusbhid.demo;

import com.atmel.atusbhid.demo.PanelButton;
import com.atmel.atusbhid.demo.PanelLed;
import com.atmel.atusbhidjni.AtUsbHidJni;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class Gui
implements Runnable {
    private AtUsbHidJni usbDevice = null;
    private JFrame jFrame = null;
    private PanelButton jPanelButton = null;
    private JPanel jContentPane = null;
    private JPanel jPanelText = null;
    private PanelLed jPanelLed = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JPanel jPanelStatus = null;
    private JLabel jLabelStatus = null;
    private boolean deviceConnected = false;
    private boolean autoConnect = false;
    private JLabel jLabelBufferInfo = null;
    private String VERSION = "AtmelHidGenericDemo V1.1";

    public Gui() {
        String libraryPath = String.valueOf(System.getProperty("user.dir")) + "\\Jni";
        try {
            this.usbDevice = new AtUsbHidJni();
        }
        catch (UnsatisfiedLinkError ex) {
            System.err.println(".():UnsatisfiedLinkError");
            JOptionPane.showMessageDialog(null, ".():UnsatisfiedLinkError\nCan't find " + libraryPath + ".dll", "Jni.java error", 0);
            System.exit(0);
        }
        catch (SecurityException ex) {
            JOptionPane.showMessageDialog(null, ".():SecurityException", "Jni.java error", 0);
            System.exit(0);
        }
        catch (NullPointerException ex) {
            JOptionPane.showMessageDialog(null, ".():NullPointerException", "Jni.java error", 0);
            System.err.println(".():NullPointerException");
            System.exit(0);
        }
        if (!this.usbDevice.loadLibraryUsbHid()) {
            JOptionPane.showMessageDialog(null, "Demo.main():LoadLibrary", "Gui.java error", 0);
            System.exit(0);
        }
    }

    @Override
    public void run() {
        this.getJFrame().pack();
        this.getJFrame().setVisible(true);
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setSize(new Dimension(510, 280));
            this.jFrame.setResizable(false);
            this.jFrame.setTitle(this.VERSION);
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (Gui.this.deviceConnected) {
                        Gui.this.setDeviceConnected(false);
                    }
                    Gui.this.usbDevice.UnloadloadLibraryUsbHid();
                    System.exit(0);
                }
            });
            this.centerJFrame();
        }
        return this.jFrame;
    }

    private void centerJFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getJFrame().getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.getJFrame().setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jPanelButton = new PanelButton(this);
            this.jContentPane.add((Component)this.jPanelButton.getJPanelButton(), null);
            this.jContentPane.add((Component)this.getJPanelText(), null);
            this.jPanelLed = new PanelLed(this);
            this.jContentPane.add((Component)this.jPanelLed.getJPanelLed(), null);
            this.jContentPane.add((Component)this.getJPanelStatus(), null);
            this.setControlEnable(false);
            this.TaskReadText();
        }
        return this.jContentPane;
    }

    private JPanel getJPanelText() {
        if (this.jPanelText == null) {
            this.jPanelText = new JPanel();
            this.jPanelText.setLayout(new FlowLayout());
            this.jPanelText.add((Component)this.getJScrollPane(), null);
        }
        return this.jPanelText;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
        }
        return this.jTextArea;
    }

    private JPanel getJPanelStatus() {
        if (this.jPanelStatus == null) {
            this.jLabelBufferInfo = new JLabel("");
            this.jLabelStatus = new JLabel("Not Connected");
            this.jLabelStatus.setFont(new Font("Courier New", 1, 14));
            this.jLabelStatus.setForeground(Color.blue);
            this.jPanelStatus = new JPanel();
            this.jPanelStatus.setLayout(new BorderLayout());
            this.jPanelStatus.setBorder(BorderFactory.createTitledBorder(null, "Status", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPanelStatus.add((Component)this.jLabelStatus, "West");
            this.jPanelStatus.add((Component)this.jLabelBufferInfo, "East");
        }
        return this.jPanelStatus;
    }

    private void setControlEnable(boolean b) {
        this.jPanelLed.setCommunicationEnable(b);
        this.jPanelButton.setCommunicationEnable(b);
    }

    public void setLed(int ledNum, boolean ledState) {
        byte[] byteArray = new byte[this.usbDevice.getOutputReportLength()];
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = 0;
            ++i;
        }
        byteArray[1] = (byte)(ledNum + 48);
        if (ledState) {
            byteArray[0] = 49;
            this.jLabelStatus.setText("Led " + ledNum + " is on");
        } else {
            byteArray[0] = 48;
            this.jLabelStatus.setText("Led " + ledNum + " is off");
        }
        if (!this.usbDevice.writeData(byteArray)) {
            this.setDeviceConnected(false);
            this.jLabelStatus.setText("Connection to device lost during led setting");
        }
    }

    private void TaskReadText() {
        Timer timer = this.createTimer();
        timer.start();
    }

    private Timer createTimer() {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int state;
                if (Gui.this.deviceConnected) {
                    byte[] data = Gui.this.usbDevice.readData();
                    if (data.length > 0) {
                        if (data[0] == 1) {
                            Gui.this.getJTextArea().append("Button as been pressed\n");
                        } else {
                            Gui.this.getJTextArea().append("Button as been released\n");
                        }
                        Gui.this.jLabelStatus.setText("New action on target");
                    }
                    byte[] buffer = new byte[Gui.this.usbDevice.getOutputReportLength()];
                    int i = 0;
                    while (i < buffer.length) {
                        buffer[i] = 0;
                        ++i;
                    }
                    if (buffer.length >= 4) {
                        buffer[0] = 85;
                        buffer[1] = -86;
                        buffer[2] = 85;
                        buffer[3] = 85;
                    }
                    if (!Gui.this.usbDevice.setFeature(buffer)) {
                        Gui.this.setDeviceConnected(false);
                        Gui.this.jLabelStatus.setText("Connection to device lost");
                    }
                } else if (Gui.this.autoConnect && (state = Gui.this.usbDevice.findHidDevice(Gui.this.jPanelButton.getVid(), Gui.this.jPanelButton.getPid())) == 1) {
                    Gui.this.setDeviceConnected(true);
                }
            }
        };
        return new Timer(100, action);
    }

    public void setDeviceConnected(boolean b) {
        this.jLabelBufferInfo.setText("");
        if (b) {
            int state = this.usbDevice.findHidDevice(this.jPanelButton.getVid(), this.jPanelButton.getPid());
            switch (state) {
                case 1: {
                    this.jPanelButton.setCommunicationEnable(false);
                    this.setControlEnable(true);
                    this.setLed(1, false);
                    this.setLed(2, false);
                    this.setLed(3, false);
                    this.setLed(4, false);
                    if (!this.autoConnect) {
                        this.jLabelStatus.setText("Connected to the device");
                    } else {
                        this.jLabelStatus.setText("Auto-connected to the device");
                    }
                    this.jLabelBufferInfo.setText("Buffer Size, In:" + this.usbDevice.getInputReportLength() + "Byte, Out=" + this.usbDevice.getOutputReportLength() + "Byte, Feature" + this.usbDevice.getFeatureReportLength() + "Byte");
                    this.deviceConnected = true;
                    break;
                }
                case -1: {
                    if (!this.autoConnect) {
                        JOptionPane.showMessageDialog(this.getJFrame(), "Usb Device Not Found", "Gui.java error", 0);
                    }
                    this.jLabelStatus.setText("Usb Device Not Found");
                    this.deviceConnected = false;
                    break;
                }
                case -2: {
                    if (!this.autoConnect) {
                        JOptionPane.showMessageDialog(this.getJFrame(), "Usb no capabilities", "Gui.java error", 0);
                    }
                    this.jLabelStatus.setText("Usb no capabilities");
                    this.deviceConnected = false;
                    break;
                }
                default: {
                    if (!this.autoConnect) {
                        JOptionPane.showMessageDialog(this.getJFrame(), "Usb Unknown Error", "Gui.java error", 0);
                    }
                    this.jLabelStatus.setText("Usb Unknown Error");
                    this.deviceConnected = false;
                    break;
                }
            }
        } else {
            this.usbDevice.closeDevice();
            this.setControlEnable(false);
            this.jLabelStatus.setText("Disconneted from the device");
            this.deviceConnected = false;
        }
    }

    public void setAutoConnect(boolean b) {
        this.autoConnect = b;
    }

    public void startIsp() {
        byte[] buffer = new byte[this.usbDevice.getOutputReportLength()];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = 0;
            ++i;
        }
        if (buffer.length >= 4) {
            buffer[0] = 85;
            buffer[1] = -86;
            buffer[2] = 85;
            buffer[3] = -86;
        }
        if (this.usbDevice.setFeature(buffer)) {
            this.setDeviceConnected(false);
            this.jLabelStatus.setText("Isp mode enable, you can run flip");
        } else {
            JOptionPane.showMessageDialog(this.getJFrame(), "Not able to start ISP mode", "Gui.java error", 0);
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(this.getJTextArea());
            this.jScrollPane.setPreferredSize(new Dimension(490, 120));
        }
        return this.jScrollPane;
    }

    public static void main(String[] args) {
        Gui gui = new Gui();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(gui);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

