//
// PORT MAP
//
#ifndef PORTCONF_H_
#define PORTCONF_H_

// PUSH SWITCH
#define PS_PORT		PORTD		// PUSH SWITCH
#define PS_BIT0		PORTDbits.RD0	// IN PUSH SW BIT 0
#define PS_BIT2		PORTDbits.RD1	// IN PUSH SW BIT 1
#define PS_BIT3		PORTDbits.RD2	// IN PUSH SW BIT 2
#define PS_SEL		1	// 001 = SELECTOR
#define PS_VUP		2	// 010 = VOLUME UP
#define PS_VDN		3	// 011 = VOLUME DOWN
#define PS_STOP		4	// 100 = STOP PLAY
#define PS_PLAY		5	// 101 = START PLAY
#define PS_EXIT		6	// 110 = EXIT MENU
#define PS_ENT		7	// 111 = ENTER
//
// ROTALY ENCODER
#define RE_PORT		PORTD		// ROTALY ENCODER
#define RE_A			PORTDbits.RD4	// IN INROTALY ENCODER A LINE
#define RE_B			PORTDbits.RD5	// IN INROTALY ENCODER B LINE
//
// DISPLAY
#define DP_PORT		PORTB		// DD-25664BE-4A(SSD1322)
#define DP_CS			PORTBbits.RB0	// OUT CS#
#define DP_CLK		PORTBbits.RB1	// OUT SCLK
#define DP_DIN		PORTBbits.RB2	// OUT SDIN
//
// ELECTORIC VOLUME
#define EV_PORT		PORTB		// LM1972
#define EV_LS0		PORTBbits.RB3	// OUT DEVICE 0 LOAD/SHIFT
#define EV_LS1		PORTBbits.RB4	// OUT DEVICE 1 LOAD/SHIFT
#define EV_LS2		PORTBbits.RB5	// OUT DEVICE 2 LOAD/SHIFT
#define EV_CLK		PORTBbits.RB6	// OUT CLOCK
#define EV_DIN		PORTBbits.RB7	// OUT DATA IN
//
// TUNNER
#define TU_PORT		PORTA		// TAE5767
#define TU_RW			PORTAbits.RA0	// OUT READ/WRITE
#define TU_CLK		PORTAbits.RA1	// OUT CLOCK
#define TU_DATA		PORTAbits.RA2	// IN/OUT DATA
// HOST Connector
// RC4 USB-
// RC5 USB+
// SELECTOR RELAY
#define SR_PORT		PORTD		// SELECTOR RELAY 
#define SR_SEL		PORTDbits.RD7	// OUT SELECTOR

#define PORTA_INPUT	0b00000000
#define PORTB_INPUT	0b00000000
#define PORTC_INPUT	0b00110000
#define PORTD_INPUT	0b10110111
#define PORTE_INPUT	0b00000000

#endif // PORTCONF_H_
