#!/usr/local/bin/ruby
#-*- coding: utf-8 -*-

## If opts["daemon"] is true, then it'll be forked. And also the current-working-dir will be moved to '/'.
## In above case, you must expand the relative path using File::expand_path method.
basedir = File::expand_path(File.dirname($0))
$:.unshift File.join(basedir,"..")
require 'yadaemon'

opts = {}
opts[:debug] = true
opts[:daemon] = true  ## If it's commented out, then this script never be forked.
appname = File::basename($0,".rb")  ## appname == "first_step"
daemon = YaDaemon.new(appname,"test.pid","/tmp", opts)  ## the "/tmp/#{appname}/test.pid" file will be created.
outfile = "/tmp/#{appname}/test.log" ## Check this file each five seconds later.
daemon.run do |pid|
  i = 0
  while daemon.running
    open(outfile,"w") do |f|
      f.flock(File::LOCK_EX)
      f.write(format("updated: %d\n", i))
      f.flush
      f.truncate(f.pos)
    end
    i += 1
    sleep 5
  end
end
