package gdsearch;

import gdsearch.vo.GameData;

import java.io.IOException;
import java.util.List;

import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Query;

@SuppressWarnings("serial")
public class GameDataDeleteServlet extends HttpServlet {

	public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        deleteGameData();
        resp.sendRedirect("/index.html");
    }

    // GameDataを500件削除
    public void deleteGameData() {
        // クエリ生成
        Query qry   = new Query(GameData.class.getSimpleName());
        // データストアサービスの取得
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        // データベースから500件単位でデータを取得
        List<Entity> lstGameData = service.prepare(qry).asList(FetchOptions.Builder.withOffset(0).limit(500));

        for (Entity ety : lstGameData) {
            PersistenceManager pm = PMF.get().getPersistenceManager();
            GameData gdti = pm.getObjectById(GameData.class, ety.getKey().getId());
            try {
                pm.deletePersistent(gdti);
            } finally {
                pm.close();
            }
        }
    }
}

