package gdsearch;

import javax.servlet.http.*;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

import gdsearch.vo.GameData;

/**
 * データのインポートを行うサーブレット
 * @author kanazawa
 */
public class GameDataImportServlet extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd");

        // テキストボックスに入力されたデータを取得
        String data = req.getParameter("importdata");
        // 一行ごとに分割する
        data = data.replaceAll("\r\n|\r", "\n");
        String[] lines = data.split("\n");

        GameDataDAO dao = new GameDataDAO();
        for(int i = 0; i < lines.length; i++){
            // カンマ区切りの文字列をトークン(単語)に分割する
            StringTokenizer st = new StringTokenizer(lines[i], ",");

            // データオブジェクトにセット
            GameData gd = new GameData();
            gd.setHard    (st.nextToken().replaceAll("\"", ""));                   // ハード名
            try {
                gd.setSaleDate(df.parse(st.nextToken().replaceAll("\"", "")));     // 発売日
            } catch (Exception e) {}
            gd.setTitle2  (st.nextToken().replaceAll("\"", ""));                   // タイトル（上段）
            gd.setTitle   (st.nextToken().replaceAll("\"", ""));                   // タイトル（下段）
            gd.setMaker2  (st.nextToken().replaceAll("\"", ""));                   // 販売, 発売/開発/著作（上段）
            gd.setMaker   (st.nextToken().replaceAll("\"", ""));                   // 販売, 発売/開発/著作（下段）
            gd.setGenre   (st.nextToken().replaceAll("\"", ""));                   // 内容
            gd.setMedia   (st.nextToken().replaceAll("\"", ""));                   // 媒体
            gd.setCode    (st.nextToken().replaceAll("\"", ""));                   // 型番
            gd.setPrice   (Integer.parseInt(st.nextToken().replaceAll("\"", ""))); // 価格
            gd.setRestrict(st.nextToken().replaceAll("\"", ""));                   // R
            gd.setComment (st.nextToken().replaceAll("\"", ""));                   // 備考

            // 既に登録されているデータかどうか型番で検索して確認
            // ※ただし、一部の型番がないデータについてはチェックしない
            // （だから目視確認してね）
            if(gd.getCode().equals("") || dao.chkDuplicateGameData(gd.getCode())) {
                // データベースに格納
                dao.insertGameData(gd);
            }
        }
        resp.sendRedirect("/index.html");
    }
}
