package gdsearch;

import javax.servlet.http.*;
import java.io.IOException;
import gdsearch.vo.GameDataUrl;

/**
 * ハード名、発売日に対応するURLデータのインポートを行うサーブレット
 */
public class GameDataUrlImportServlet extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        // テキストボックスに入力されたデータを取得
        String data = req.getParameter("importdata");
        // 一行ごとに分割する
        data = data.replaceAll("\r\n|\r", "\n");
        String[] lines = data.split("\n");

        GameDataDAO dao = new GameDataDAO();
        for(int i = 0; i < lines.length; i++){
            String regex = "\"(.*)\",\"(.*)\"";

            // データオブジェクトにセット
            GameDataUrl gdurl = new GameDataUrl();
            gdurl.setKeystr(lines[i].replaceFirst(regex, "$1")); // ハード名 + 発売日
            gdurl.setUrl   (lines[i].replaceFirst(regex, "$2")); // URL

            // 既に登録されているデータかどうか確認
            if(dao.chkDuplicateGameDataUrl(gdurl)) {
                // データベースに格納
                dao.insertGameDataUrl(gdurl);
            }
        }

        resp.sendRedirect("/index.html");
    }
}
