package jp.unsf.ics.soft.jig;

import static java.lang.Math.abs;
import static java.lang.Math.acos;
import static java.lang.Math.cos;
import static java.lang.Math.sin;

import java.util.Locale;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

public class CalcSpeedService extends Service implements LocationListener {
	
	static final private int NOTIFICATION1 = 0;

	MainApplication app;

	int calcInterval = 1;
	int measureInterval = 1;
	volatile Location nowLoc = null;
	int ave[] = { 30, 45, 60, 90, 120 };
	SizedConcurrentLinkedQueue<Location> listLoc = new SizedConcurrentLinkedQueue<Location>(ave[ave.length - 1] / measureInterval + 5);
	private LocationManager gpsLocationManager;
	private LocationManager netLocationManager;
	
	
	Intent intent = null;
	PendingIntent contentIntent = null;
	Bitmap largeIcon = null;
	NotificationCompat.Builder builder = null;
	NotificationManager mNotificationManager = null;

	boolean goFlag = false;
	
	@Override
	public void onCreate(){
		Log.d("CalcSpeedService.onCreate", "");
		app = (MainApplication) this.getApplication();
		mNotificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
		contentIntent = PendingIntent.getActivity(this, 0, intent = new Intent(this, LocationTestActivity.class), PendingIntent.FLAG_UPDATE_CURRENT);
		largeIcon = BitmapFactory.decodeResource(getResources(), R.drawable.ic_launcher);
		builder = new NotificationCompat.Builder(getApplicationContext());
		goFlag = false;
		gpsLocationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
		netLocationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
	}

	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		synchronized(app.sync_){
			if(!goFlag){
				Log.i("CalcSpeedService", "Received start id " + startId + ": " + intent);
				goFlag = true;
		
				// GPSNETWORK̈ʒuvoC_֒I擾˗
				if (gpsLocationManager != null) {
					gpsLocationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, measureInterval * 1000 * 0, 1, this);
				}else{
					Log.e("CalcSpeedService.onStartCommand", "gpsLocationManager is NULL.");
				}
				if (netLocationManager != null) {
					netLocationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, measureInterval * 1000 * 0, 1, this);
				}else{
					Log.e("CalcSpeedService.onStartCommand", "netLocationManager is NULL.");
				}
				
				if(gpsLocationManager == null && netLocationManager == null){
					stopSelf();
				}
		
				// ʃXbhs
				new Handler().postDelayed(calcFunc, 1);
				new Handler().postDelayed(measureFunc, 1);
			}
		}
		return START_STICKY;
	}

	@Override
	public IBinder onBind(Intent arg0) {
		return null;
	}

	
    @Override    public void onDestroy() {
		synchronized(app.sync_){
			goFlag = false;
			// ʒuvoC_ɒI擾x~̂m点𑗂
			if (gpsLocationManager != null) {
				gpsLocationManager.removeUpdates(this);
			}
			if (netLocationManager != null) {
				netLocationManager.removeUpdates(this);
			}
			Log.d("CalcSpeedService.onDestroy","destroy");
			
			mNotificationManager.cancel(NOTIFICATION1);
			listLoc.clear();
		}
    	super.onDestroy();
    }

	protected void setIntent(String ticker, String title, String text) {
		builder.setContentIntent(contentIntent);
		builder.setTicker(ticker);
		builder.setSmallIcon(R.drawable.ic_launcher);
		builder.setContentTitle(title);
		builder.setContentText(text);
		builder.setLargeIcon(largeIcon);
		builder.setWhen(0); // tƍXV, 0ŕ\\
		builder.setOngoing(true); // FG
		builder.setAutoCancel(false);// ^bvĂȂ
		mNotificationManager.notify(NOTIFICATION1, builder.build());
	}
    

	// IɌvZAʒm̈ɕ\XbhB[sƎ~܂ȂB
	private final Runnable calcFunc = new Runnable() {
		@Override
		public void run() {
			//Log.d("calcFunc", "run");
			synchronized(app.sync_){
				String text = "";
				String text2 = "";
				boolean existAvedata = false;
				for (int i : ave) { // ϑx擾ԊuŁAߋ̑ʌʂ𓾂
					text += "/" + i;
					Location loc = listLoc.get(i / measureInterval);
					if (loc != null) {
						existAvedata = true;
						text2 += "/" + String.format(Locale.getDefault(), "%03.1f", getKmph(nowLoc, loc, i));
					} else {
						text2 += "/" + "-.-";
					}
				}
				if(existAvedata){
					text = text.substring(1) + "sec:" + text2.substring(1) + " km/h";
				} else if (nowLoc != null) { // ܂ʌʂ\ɂ܂ĂȂA݂̑ʌʂ͂
					int size = listLoc.size();
					if(size >= 2){
						Location loc = listLoc.get(size - 1);
						text = "Average Speed: " + String.format(Locale.getDefault(), "%03.1f km/h (%dsec)", getKmph(nowLoc, loc, size/measureInterval), size/measureInterval);
					}else{
						text = "Speed: " + String.format(Locale.getDefault(), "%03.1f km/h", nowLoc.getSpeed()*3.6);
					}
					
				} else {
					text = "vc"; // 1onChangeȂꍇB
				}
				String nowProvider = nowLoc == null ? "---" : nowLoc.getProvider();
				if(goFlag){
					setIntent("ϑx", "Average speed (" + nowProvider.toUpperCase(Locale.US) + ")", text);// ʒm̈\
					new Handler().postDelayed(calcFunc, calcInterval * 1000); // ēxo^
				}
			}
		}
	};

	// IɈʒui[XbhB[sƎ~܂ȂB
	// calcFuncƕs邽ߔr͐TdɁB
	private final Runnable measureFunc = new Runnable() {
		@Override
		public void run() {
			//Log.d("measureFunc", "run");
			synchronized(app.sync_){
				if (nowLoc != null) { // measureInterval̍ŐVɂ炸AŐVf[^𗘗p
					listLoc.add(nowLoc);
				}
			}
			if(goFlag){
				new Handler().postDelayed(measureFunc, measureInterval * 1000); // ēxo^
			}
		}
	};

	@Override
	public void onLocationChanged(Location location) {
		//if(nowLoc!=null) Log.d("LocationTestActivity.onLocationChanged:nowLoc", nowLoc.toString());
		//Log.d("LocationTestActivity.onLocationChanged:location", location.toString());
		synchronized (app.sync_) { // location.getTime()ÂłAonchangȅ񂪍ŐVƑ
			// Ԃ񂱂AGPSNETWORKǂǂM邩̊́B
			if (nowLoc == null
					|| (location.getAccuracy() < getDistance(location, nowLoc) 
							|| ((-0.5 < (location.getTime() - nowLoc.getTime())) && (location.getAccuracy() <= nowLoc.getAccuracy())) 
							|| ((0.0 <= (location.getTime() - nowLoc.getTime())) && location.getProvider().equals(nowLoc.getProvider())))) {
				nowLoc = location;
				Log.d("LocationTestActivity.onLocationChanged", "kakikae!");
			}
		}
		//Log.d("LocationTestActivity.onLocationChanged:nowLoc", nowLoc.toString());
	}

	@Override
	public void onProviderDisabled(String provider) {
		//superȂ
	}

	@Override
	public void onProviderEnabled(String provider) {
		//superȂ
	}

	@Override
	public void onStatusChanged(String provider, int status, Bundle extras) { 
		switch (status) {
			case LocationProvider.AVAILABLE:
				break;
			case LocationProvider.OUT_OF_SERVICE:
				break;
			case LocationProvider.TEMPORARILY_UNAVAILABLE:
				break;
		}
	}
	

	// Q_Ԃ̑xijvZBvZ̎ԊԊuLocation𗘗pB
	protected double getKmph(Location l1, Location l2) {
		return  getKmph(l1, l2, abs(l1.getTime() - l2.getTime()) / 1000.0);
	}

	// Q_Ԃ̑xijvZBvZ̎ԊԊu͕bŎw肷B
	protected double getKmph(Location l1, Location l2, double interval) {
		if (interval == 0.0) {
			return 0.0;
		} else {
			return getDistance(l1, l2) * 60.0 * 60.0 / interval / 1000.0;
		}
	}
	
	// Q_Ԃ̋nkɉČvZBn͊ŚBPʂm
	private static double getDistance(Location l1, Location l2) {
		double theta = l1.getLongitude() - l2.getLongitude();
		double dist = rad2deg(acos(sin(deg2rad(l1.getLatitude())) * sin(deg2rad(l2.getLatitude())) + cos(deg2rad(l1.getLatitude())) * cos(deg2rad(l2.getLatitude())) * cos(deg2rad(theta)))) * 60 * 1.1515 * 1.609344;
		return dist * 1000.0;
	}

	// WAxɁB
	private static double rad2deg(double radian) {
		return radian * (180f / Math.PI);
	}

	// xWAɁB
	private static double deg2rad(double degrees) {
		return degrees * (Math.PI / 180f);
	}

}
