/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ eLXgXN[ ]
 */

#include "header.h"
#include "winmain.h"
#include "screen.h"

/*
 * 萔
 */

/* EBhENX*/
#define SCREEN_CLASS_NAME               L"ScreenWindow"

/*
 * static֐
 */

/* XN[̍XV */
static void screen_update_object(SCREEN_OBJECT *object);

/*
 * staticϐ
 */

/* ŏ̃XN[IuWFNg */
static SCREEN_OBJECT *g_screen_object_head;

/*
 * XN[
 * LN^̔r
 */
static BOOL screen_chr_is_equal(const SCREEN_CHR *chr1, const SCREEN_CHR *chr2)
{
    assert(NULL != chr1);
    assert(NULL != chr2);

    /* LN^{ */
    if (chr1->chr != chr2->chr)
    {
        return FALSE;
    }

    /* EtO */
    if (chr1->right != chr2->right)
    {
        return FALSE;
    }

    /* tHAOEhJ[ */
    if (chr1->fore != chr2->fore)
    {
        return FALSE;
    }

    /* obNOEhJ[ */
    if (chr1->back != chr2->back)
    {
        return FALSE;
    }

    /* ׂĈv */
    return TRUE;
}

/*
 * XN[
 * \LN^`
 */
static BOOL screen_realchr_draw(HDC hDC, SCREEN_REAL_CHR *chr, SCREEN_OBJECT *object)
{
    COLORREF fore_prev;
    COLORREF back_prev;
    RECT *rect;

    assert(NULL != hDC);
    assert(chr != NULL);
    assert(object != NULL);

    /* ݂̃LN^ƕ`悵LN^v΁AȂ̂FALSEԂ */
    if (TRUE == screen_chr_is_equal(&chr->current, &chr->draw))
    {
        return FALSE;
    }
 
    /* tHAOEhJ[̍XVKv */
    if (chr->current.fore != object->fore_draw)
    {
        /* tHAOEhJ[XV */
        fore_prev = SetTextColor(hDC, chr->current.fore);
        assert(CLR_INVALID != fore_prev);
        if (CLR_INVALID == fore_prev)
        {
            return FALSE;
        }

        /* XV */
        object->fore_draw = chr->current.fore;
    }

    /* obNOEhJ[̍XVKv */
    if (chr->current.back != object->back_draw)
    {
        /* obNOEhJ[XV */
        back_prev = SetBkColor(hDC, chr->current.back);
        assert(CLR_INVALID != back_prev);
        if (CLR_INVALID == back_prev)
        {
            return FALSE;
        }

        /* XV */
        object->back_draw = chr->current.back;
    }

    /* Eł΁Ah~̂ߔpXy[XɋύX */
    if (TRUE == chr->current.right)
    {
        /* current𔼊pXy[XɋύX */
        chr->current.chr = L' ';

        /* čɂ */
        chr->current.right = FALSE;
    }

    /* p܂͑SpŁA`𕪂 */
    if (0x0100 > chr->current.chr)
    {
        /* p */
        rect = &chr->rect_ank;
    }
    else
    {
        /* Sp */
        rect = &chr->rect_kanji;
    }

    /* ` */
    ExtTextOut(hDC, rect->left, rect->top, ETO_OPAQUE, rect, (LPWSTR)&chr->current.chr, 1, NULL);

    /* `LN^݂̃LN^ɍXV */
    chr->draw = chr->current;

#ifdef _DEBUG
    /* `搔++ */
    object->chrs_draw++;
#endif /* _DEBUG */

    /* TRUEԂA`悵Ƃ */
    return TRUE;
}

/*
 * XN[
 * \C̔r
 */
static BOOL screen_realline_is_equal(SCREEN_REAL_LINE *line, SCREEN_OBJECT *object)
{
    UINT loop;
    BOOL result;

    assert(NULL != line);
    assert(NULL != object);

    /* LN^0łΏTRUE(v) */
    if (0 == line->chrs)
    {
        return TRUE;
    }

    assert(NULL != line->buf);

    /* ㉺`͈͂𒴂ĂΏTRUE(v) */
    if (0 > line->buf[0].rect_ank.bottom)
    {
        /* `͈͂シ */
        return TRUE;
    }
    if (object->height < line->buf[0].rect_ank.top)
    {
        /* `͈͂ */
        return TRUE;
    }

    /* LN^PʂŃ[v */
    for (loop = 0; loop < line->chrs; loop++)
    {
        /* E`͈͂𒴂ĂΑł؂ */
        if (object->width < line->buf[loop].rect_ank.left)
        {
            break;
        }

        /* rʂ𓾂 */
        result = screen_chr_is_equal(&line->buf[loop].current, &line->buf[loop].draw);
        if (result == FALSE)
        {
            /* svLN^o */
            return FALSE;
        }
    }

    /* SĂ̕`͈͓LN^v */
    return TRUE;
}

/*
 * XN[
 * \C̕`
 */
static BOOL screen_realline_draw(HDC hDC, SCREEN_REAL_LINE *line, SCREEN_OBJECT *object)
{
    UINT loop;
    BOOL result;

    assert(NULL != hDC);
    assert(NULL != line);
    assert(NULL != object);

    /* LN^0łΉȂ */
    if (0 == line->chrs)
    {
        return FALSE;
    }

    /* LN^1ȏ */
    assert(NULL != line->buf);

    /* ㉺`͈͂𒴂ĂFALSEԂ */
    if (0 > line->buf[0].rect_ank.bottom)
    {
        /* `͈͂シ */
        return FALSE;
    }
    if (object->height < line->buf[0].rect_ank.top)
    {
        /* `͈͂ */
        return FALSE;
    }

    /* LN^PʂŃ[v */
    for (loop = 0; loop < line->chrs; loop++)
    {
        /* E`͈͂𒴂ĂΑł؂ */
        if (object->width < line->buf[loop].rect_ank.left)
        {
            break;
        }

        /* 1LN^` */
        result = screen_realchr_draw(hDC, &line->buf[loop], object);

        /* ۂɕ`悵Ă */
        if (result == TRUE)
        {
            /* ȊO */
            if (loop < (line->chrs - 1))
            {
                /* Sp */
                if (0x0100 <= line->buf[loop].current.chr)
                {
                    /*  */
                    if (FALSE == line->buf[loop].current.right)
                    {
                        /* `悵Ă̂ŁAEv */
                        line->buf[loop + 1].draw = line->buf[loop].draw;

                        /* EƂ */
                        line->buf[loop + 1].draw.right = TRUE;
                    }
                }
            }
        }
    }

    /* ̍sɌp̂ŁATRUEԂ */
    return TRUE;
}

/*
 * XN[
 * \C`̍Đݒ
 */
static void screen_realline_setrect(LONG top, SCREEN_REAL_LINE *line)
{
    UINT loop;
    LONG bottom;

    assert(NULL != line);

    /* topbottomZo */
    bottom = top + g_tmAllHeight;

    /* SẴLN^[v */
    for (loop = 0; loop < line->chrs; loop++)
    {
        /* `(p) */
        line->buf[loop].rect_ank.top = top;
        line->buf[loop].rect_ank.bottom = bottom;

        /* `(Sp) */
        line->buf[loop].rect_kanji.top = top;
        line->buf[loop].rect_kanji.bottom = bottom;
    }
}

/*
 * XN[
 * \C̃TCY
 */
static void screen_realline_resize(LONG top, SCREEN_REAL_LINE *line, SCREEN_OBJECT *object)
{
    UINT loop;
    SCREEN_REAL_CHR *array;
    RECT rect_ank;
    RECT rect_kanji;

    assert(line != NULL);
    assert(object != NULL);

    /* ݂̃LN^ƈvĂ邩A傫 */
    if (object->real.width_chr <= line->chrs)
    {
        /* `Đݒ肷̂ */
        screen_realline_setrect(top, line);
        return;
    }

    /* vLN^0Ȃ牽Ȃ */
    if (0 == object->real.width_chr)
    {
        return;
    }

    /* Vȕ\LN^zmۂA[NA */
    array = (SCREEN_REAL_CHR*)malloc(sizeof(SCREEN_REAL_CHR) * object->real.width_chr);
    assert(NULL != array);
    if (NULL == array)
    {
        return;
    }
    memset(array, 0, sizeof(SCREEN_REAL_CHR) * object->real.width_chr);

    /* SĂ̍ŐVLN^𔼊pXy[Xŏ */
    for (loop = 0; loop < object->real.width_chr; loop++)
    {
        array[loop].current.chr = L' ';
        array[loop].current.right = FALSE;
        array[loop].current.fore = object->fore_def;
        array[loop].current.back = object->back_def;
    }

    /* ݂̃LN^1ȏȂRs[ */
    if (0 < line->chrs)
    {
        assert(NULL != line->buf);

        /* Rs[ */
        memcpy(array, line->buf, sizeof(SCREEN_REAL_CHR) * line->chrs);

        /* Âz */
        free(line->buf);
        line->buf = NULL;
        line->chrs = 0;
    }

    /* |C^Zbg */
    line->buf = array;

    /* VLN^Zbg */
    line->chrs = object->real.width_chr;

    /* p` */
    rect_ank.left = 0;
    rect_ank.top = top;
    rect_ank.right = g_tm.tmAveCharWidth;
    rect_ank.bottom = top + g_tmAllHeight;

    /* Sp` */
    rect_kanji.left = 0;
    rect_kanji.top = top;
    rect_kanji.right = g_tm.tmAveCharWidth * 2;
    rect_kanji.bottom = top + g_tmAllHeight;

    /* SẴLN^̋`XV */
    for (loop = 0; loop < line->chrs; loop++)
    {
        /* `XV */
        line->buf[loop].rect_ank = rect_ank;
        line->buf[loop].rect_kanji = rect_kanji;

        /* Rs[`AEֈړ */
        rect_ank.left += g_tm.tmAveCharWidth;
        rect_ank.right += g_tm.tmAveCharWidth;
        rect_kanji.left += g_tm.tmAveCharWidth;
        rect_kanji.right += g_tm.tmAveCharWidth;
    }
}

/*
 * XN[
 * \C̔j
 */
static void screen_realline_destroy(SCREEN_REAL_LINE *line)
{
    assert(NULL != line);

    /* ݂̃LN^0𒴂Ă */
    if (0 < line->chrs)
    {
        /* LN^z */
        assert(NULL != line->buf);
        free(line->buf);
        line->buf = NULL;
        line->chrs = 0;
    }
}

/*
 * XN[
 * \C̖
 */
static void screen_realline_invalidate(SCREEN_REAL_LINE *line)
{
    UINT loop;

    assert(NULL != line);

    /* LN^[v */
    for (loop = 0; loop < line->chrs; loop++)
    {
        /* `ς݃LN^kɕύX */
        assert(NULL != line->buf);
        line->buf[loop].draw.chr = L'\0';
    }
}

/*
 * XN[
 * \CɕZbg
 */
static void screen_realline_setchr(SCREEN_REAL_LINE *line, SCREEN_OBJECT *object, wchar_t chr)
{
    UINT x;

    assert(NULL != line);
    assert(NULL != object);
    assert(0x0020 <= chr);

    /* xʒu擾 */
    x = object->real.x;

    /* xʒu͈͂𒴂ĂΉȂ */
    if (line->chrs <= x)
    {
        return;
    }

    /* ނŕ */
    if (0x0100 <= chr)
    {
        /* xʒuI[ */
        if (x == (line->chrs - 1))
        {
            /* pXy[XZbg */
            line->buf[x].current.chr = L' ';
            line->buf[x].current.right = FALSE;
            line->buf[x].current.fore = object->real.fore;
            line->buf[x].current.back = object->real.back;

            object->real.x++;
        }
        else
        {
            /* SpZbg */
            line->buf[x + 0].current.chr = chr;
            line->buf[x + 0].current.right = FALSE;
            line->buf[x + 0].current.fore = object->real.fore;
            line->buf[x + 0].current.back = object->real.back;
            line->buf[x + 1].current.chr = chr;
            line->buf[x + 1].current.right = TRUE;
            line->buf[x + 1].current.fore = object->real.fore;
            line->buf[x + 1].current.back = object->real.back;

            object->real.x += 2;
        }
    }
    else
    {
        /* pZbg */
        line->buf[x].current.chr = chr;
        line->buf[x].current.right = FALSE;
        line->buf[x].current.fore = object->real.fore;
        line->buf[x].current.back = object->real.back;

        object->real.x++;
    }
}

/*
 * XN[
 * \XN[̃TCY
 */
static void screen_real_resize(SCREEN_OBJECT *object)
{
    UINT add;
    UINT loop;
    LONG top;
    SCREEN_REAL_LINE *line;

    assert(NULL != object);

    /* NCAg̈̕ALN^߂(]肪+1) */
    object->real.width_chr = object->width / g_tm.tmAveCharWidth;
    if (0 < object->width % g_tm.tmAveCharWidth)
    {
        object->real.width_chr++;
    }

    /* NCAg̈̍ALN^߂(]肪+1) */
    object->real.height_chr = object->height / g_tmAllHeight;
    if (0 < object->height % g_tmAllHeight)
    {
        object->real.height_chr++;
    }

    /* ݂̍s < Zos̏ꍇ */
    if (object->real.lines < object->real.height_chr)
    {
        /* ݑ݂slāAǉׂsZo */
        add = object->real.height_chr - object->real.lines;

        /* sǉ */
        for (loop = 0; loop < add; loop++)
        {
            /* VȍsIuWFNg쐬 */
            line = (SCREEN_REAL_LINE*)malloc(sizeof(SCREEN_REAL_LINE));
            assert(NULL != line);
            if (NULL == line)
            {
                return;
            }
            memset(line, 0, sizeof(SCREEN_REAL_LINE));
            bdlist_init((BDLIST_ENTRY*)line);

            /* ŏ̍s*/
            if (NULL == object->real.head)
            {
                /* ŏ̍sȂ̂ŁÂ܂܃Zbg */
                object->real.head = line;
            }
            else
            {
                /* I[ɒǉ */
                bdlist_insert_tail((BDLIST_ENTRY*)object->real.head, (BDLIST_ENTRY*)line);
            }
        }

        /* s̐XV */
        object->real.lines = object->real.height_chr;
    }

    /* dir_uplāAtop߂ */
    if (TRUE == object->real.dir_up)
    {
        /* ɉт*/
        top = object->height - g_tmAllHeight;
    }
    else
    {
        /* 牺ɉт*/
        top = 0;
    }

    /* SĂ̍sTCY */
    line = object->real.head;
    for (loop = 0; loop < object->real.lines; loop++)
    {
        assert(NULL != line);

        /* C̃TCY */
        screen_realline_resize(top, line, object);

        /* topXV */
        if (FALSE == object->real.dir_up)
        {
            /* ォ牺 */
            top += g_tmAllHeight;
        }
        else
        {
            /*  */
            top -= g_tmAllHeight;
        }

        /* ̃C*/
        line = (SCREEN_REAL_LINE*)line->bdlist.bdlist_next;
    }
}

/*
* XN[
* \XN[̔r
*/
static BOOL screen_real_is_equal(SCREEN_OBJECT *object)
{
    SCREEN_REAL_LINE *line;
    BOOL result;

    assert(NULL != object);

    /* ŏ̃C擾A߂lTRUEɏ */
    line = object->real.head;
    result = TRUE;

    /* C݂胋[v */
    while (NULL != line)
    {
        /* ̃Cr */
        result = screen_realline_is_equal(line, object);

        /* ʂFALSEłΒɔ */
        if (FALSE == result)
        {
            break;
        }

        /* ̃C𓾂 */
        line = (SCREEN_REAL_LINE*)line->bdlist.bdlist_next;
    }

    /* ʂԂ */
    return result;
}

/*
* XN[
* \XN[̕`
*/
static void screen_real_draw(HDC hDC, SCREEN_OBJECT *object)
{
    HFONT hDefFont;
    SCREEN_REAL_LINE *line;
    BOOL result;
    COLORREF fore_prev;
    COLORREF back_prev;

    assert(hDC != NULL);
    assert(object != NULL);

    /* ŏ̃C𓾂 */
    line = object->real.head;

    /* tHAOEhJ[ftHgFɃZbg */
    fore_prev = SetTextColor(hDC, object->fore_def);
    assert(CLR_INVALID != fore_prev);
    if (CLR_INVALID == fore_prev)
    {
        return;
    }
    object->fore_draw = object->fore_def;

    /* obNOEhJ[ftHgFɃZbg */
    back_prev = SetBkColor(hDC, object->back_def);
    assert(CLR_INVALID != back_prev);
    if (CLR_INVALID == back_prev)
    {
        return;
    }
    object->back_draw = object->back_def;

    /* tHgI */
    hDefFont = (HFONT)SelectObject(hDC, g_hFont);
    assert(NULL != hDefFont);
    if (NULL == hDefFont)
    {
        return;
    }

#ifdef _DEBUG
    /* \LN^NA */
    object->chrs_draw = 0;
#endif /* _DEBUG */

    /* C݂胋[v */
    while (NULL != line)
    {
        /* ̃C` */
        result = screen_realline_draw(hDC, line, object);

        /* `͈͂𒴂ĂFALSEԂ */
        if (FALSE == result)
        {
            break;
        }

        /* ̃C𓾂 */
        line = (SCREEN_REAL_LINE*)line->bdlist.bdlist_next;
    }

    /* tHg𕜌 */
    SelectObject(hDC, hDefFont);
}

/*
 * XN[
 * \XN[̔j
 */
static void screen_real_destroy(SCREEN_OBJECT *object)
{
    SCREEN_REAL_LINE *line;

    assert(NULL != object);

    /* ŏ̃CLł胋[v */
    while (NULL != object->real.head)
    {
        /* CLĂ */
        line = object->real.head;

        /* XgO */
        object->real.head = (SCREEN_REAL_LINE*)bdlist_remove((BDLIST_ENTRY*)line);

        /* ̃C폜 */
        screen_realline_destroy(line);

        /* sIuWFNg */
        free(line);
    }
}

/*
 * XN[
 * \XN[̖
 */
static void screen_real_invalidate(SCREEN_OBJECT *object)
{
    SCREEN_REAL_LINE *line;

    assert(NULL != object);

    /* ŏ̃C𓾂 */
    line = object->real.head;

    /* C݂胋[v */
    while (NULL != line)
    {
        /* ̃C𖳌 */
        screen_realline_invalidate(line);

        /* ̃C𓾂 */
        line = (SCREEN_REAL_LINE*)line->bdlist.bdlist_next;
    }
}

/*
 * XN[
 * \XN[烉C𓾂
 */
static SCREEN_REAL_LINE* screen_real_getline(SCREEN_OBJECT *object)
{
    UINT loop;
    SCREEN_REAL_LINE *line;

    assert(NULL != object);

    /* sĂNULLԂ */
    if (object->real.y >= object->real.lines)
    {
        return NULL;
    }

    /* ŏ̃C𓾂 */
    line = object->real.head;

    /* [v */
    for (loop = 0; loop < object->real.y; loop++)
    {
        /* ̃C𓾂 */
        line = (SCREEN_REAL_LINE*)line->bdlist.bdlist_next;
        assert(NULL != line);
    }

    return line;
}

/*
* XN[
* zC̃TCY
*/
static void screen_virtline_resize(SCREEN_VIRT_LINE *line, SCREEN_OBJECT *object)
{
    UINT loop;
    SCREEN_CHR *array;

    assert(line != NULL);
    assert(object != NULL);

    /* ݂̃LN^ƈvĂ邩A傫 */
    if (object->real.width_chr <= line->chrs)
    {
        /* Ȃ */
        return;
    }

    /* vLN^0Ȃ牽Ȃ */
    if (0 == object->real.width_chr)
    {
        return;
    }

    /* Vȕ\LN^zmۂA[NA */
    array = (SCREEN_CHR*)malloc(sizeof(SCREEN_CHR) * object->real.width_chr);
    assert(NULL != array);
    if (NULL == array)
    {
        return;
    }
    memset(array, 0, sizeof(SCREEN_CHR) * object->real.width_chr);

    /* SĂ̍ŐVLN^𔼊pXy[Xŏ */
    for (loop = 0; loop < object->real.width_chr; loop++)
    {
        array[loop].chr = L' ';
        array[loop].right = FALSE;
        array[loop].fore = object->fore_def;
        array[loop].back = object->back_def;
    }

    /* ݂̃LN^1ȏȂRs[ */
    if (0 < line->chrs)
    {
        assert(NULL != line->buf);

        /* Rs[ */
        memcpy(array, line->buf, sizeof(SCREEN_CHR) * line->chrs);

        /* Âz */
        free(line->buf);
        line->buf = NULL;
        line->chrs = 0;
    }

    /* |C^Zbg */
    line->buf = array;

    /* VLN^Zbg */
    line->chrs = object->real.width_chr;
}

/*
 * XN[
 * zC̔j
 */
static void screen_virtline_destroy(SCREEN_VIRT_LINE *line)
{
    assert(NULL != line);

    /* ݂̃LN^0𒴂Ă */
    if (0 < line->chrs)
    {
        /* LN^z */
        assert(NULL != line->buf);
        free(line->buf);
        line->buf = NULL;
        line->chrs = 0;
    }
}

/*
 * XN[
 * zCɕZbg
 */
static void screen_virtline_setchr(SCREEN_VIRT_LINE *line, SCREEN_OBJECT *object, wchar_t chr)
{
    UINT x;

    assert(NULL != line);
    assert(NULL != object);
    assert(0x0020 <= chr);

    /* xʒu擾 */
    x = object->virt.x;

    /* xʒu͈͂𒴂ĂΉȂ */
    if (line->chrs <= x)
    {
        return;
    }

    /* ނŕ */
    if (0x0100 <= chr)
    {
        /* xʒuI[ */
        if (x == (line->chrs - 1))
        {
            /* pXy[XZbg */
            line->buf[x].chr = L' ';
            line->buf[x].right = FALSE;
            line->buf[x].fore = object->real.fore;
            line->buf[x].back = object->real.back;

            object->virt.x++;
        }
        else
        {
            /* SpZbg */
            line->buf[x + 0].chr = chr;
            line->buf[x + 0].right = FALSE;
            line->buf[x + 0].fore = object->real.fore;
            line->buf[x + 0].back = object->real.back;
            line->buf[x + 1].chr = chr;
            line->buf[x + 1].right = TRUE;
            line->buf[x + 1].fore = object->real.fore;
            line->buf[x + 1].back = object->real.back;

            object->virt.x += 2;
        }
    }
    else
    {
        /* pZbg */
        line->buf[x].chr = chr;
        line->buf[x].right = FALSE;
        line->buf[x].fore = object->real.fore;
        line->buf[x].back = object->real.back;

        object->virt.x++;
    }
}

/*
 * XN[
 * zC\CփRs[(zCNULLł悢)
 */
static void screen_virtline_copy(SCREEN_VIRT_LINE *virt_line, SCREEN_REAL_LINE *real_line, SCREEN_OBJECT *object)
{
    UINT loop;

    assert(NULL != real_line);
    assert(NULL != object);

    /* zCNULL̏ꍇ */
    if (NULL == virt_line)
    {
        /* \LN^Xy[XŖ߂ */
        assert(object->real.width_chr <= real_line->chrs);
        for (loop = 0; loop < object->real.width_chr; loop++)
        {
            real_line->buf[loop].current.chr = L' ';
            real_line->buf[loop].current.right = FALSE;
            real_line->buf[loop].current.fore = object->fore_def;
            real_line->buf[loop].current.back = object->back_def;
        }
    }
    else
    {
        /* \LN^Rs[ */
        assert(object->real.width_chr <= real_line->chrs);
        assert(object->real.width_chr <= virt_line->chrs);
        for (loop = 0; loop < object->real.width_chr; loop++)
        {
            real_line->buf[loop].current = virt_line->buf[loop];
        }
    }
}

/*
 * XN[
 * zXN[֍sǉ
 */
static SCREEN_VIRT_LINE* screen_virt_addline(SCREEN_OBJECT *object)
{
    SCREEN_VIRT_LINE *line;

    assert(NULL != object);

    /* zCm */
    line = (SCREEN_VIRT_LINE*)malloc(sizeof(SCREEN_VIRT_LINE));
    assert(NULL != line);
    if (NULL == line)
    {
        return NULL;
    }

    /*  */
    memset(line, 0, sizeof(SCREEN_VIRT_LINE));
    bdlist_init((BDLIST_ENTRY*)line);

    /* TCY */
    screen_virtline_resize(line, object);

    /* 擪̍s邩 */
    if (NULL == object->virt.head)
    {
        /* ꂪ擪̍s */
        object->virt.head = line;
    }
    else
    {
        /* Xg̍ł擪ɒǉ */
        bdlist_insert_head((BDLIST_ENTRY*)object->virt.head, (BDLIST_ENTRY*)line);
        object->virt.head = line;
    }

    /* s𑝂₷ */
    object->virt.lines++;

    /* xʒu */
    object->virt.x = 0;

    return line;
}

/*
 * XN[
 * zXN[̃TCY
 */
static void screen_virt_resize(SCREEN_OBJECT *object)
{
    SCREEN_VIRT_LINE *line;

    assert(NULL != object);

    /* ŏ̃C擾 */
    line = object->virt.head;

    /* CLł胋[v */
    while (NULL != line)
    {
        /* C̃TCY */
        screen_virtline_resize(line, object);

        /* ̃C */
        line = (SCREEN_VIRT_LINE*)line->bdlist.bdlist_next;
    }
}

/*
 * XN[
 * zXN[̔j
 */
static void screen_virt_destroy(SCREEN_OBJECT *object)
{
    SCREEN_VIRT_LINE *line;

    assert(NULL != object);

    /* ŏ̃CLł胋[v */
    while (NULL != object->virt.head)
    {
        /* CLĂ */
        line = object->virt.head;

        /* XgO */
        object->virt.head = (SCREEN_VIRT_LINE*)bdlist_remove((BDLIST_ENTRY*)line);

        /* ̃C폜 */
        screen_virtline_destroy(line);

        /* sIuWFNg */
        free(line);
    }
}

/*
 * XN[
 * zXN[XN[͈͂̐ݒ
 */
static void screen_virt_scrollrange(SCREEN_OBJECT *object)
{
    SCROLLINFO prev;
    SCROLLINFO info;

    assert(NULL != object);

    /* XN[o[ȂΉȂ */
    if (FALSE == object->vscroll)
    {
        return;
    }

    /* \̂ */
    memset(&prev, 0, sizeof(prev));
    prev.cbSize = sizeof(prev);
    memset(&info, 0, sizeof(info));
    info.cbSize = sizeof(info);

    /* ݂̃XN[o[𓾂 */
    prev.fMask = SIF_DISABLENOSCROLL | SIF_PAGE | SIF_POS | SIF_RANGE;
    GetScrollInfo(object->hwnd, SB_VERT, &prev);

    /* zs <= \sł΃XN[o[͕sv */
    if (object->virt.lines <= object->real.height_chr)
    {
        info.fMask = SIF_DISABLENOSCROLL | SIF_PAGE | SIF_POS | SIF_RANGE;
        info.nMin = 0;
        info.nMax = 0;
        info.nPage = 1;
        info.nPos = 0;
        SetScrollInfo(object->hwnd, SB_VERT, &info, FALSE);
        return;
    }

    /* XN[o[̍ő吔́Azs - \s */
    info.fMask = SIF_DISABLENOSCROLL | SIF_RANGE | SIF_PAGE;
    info.nMin = 0;
    info.nMax = object->virt.lines - 1;
    info.nPage = object->real.height_chr;

    /* OnPos=nMaxł΁AnPosnMaxɐݒ */
    if (prev.nPos == (int)(prev.nMax - (prev.nPage - 1)))
    {
        /* XN[ */
        info.fMask |= SIF_POS;
        info.nPos = info.nMax - (info.nPage - 1);
    }

    SetScrollInfo(object->hwnd, SB_VERT, &info, TRUE);
}

/*
 * XN[
 * zXN[\XN[փRs[
 */
static void screen_virt_copy(SCREEN_OBJECT *object)
{
    UINT pos;
    SCREEN_VIRT_LINE *virt_line;
    SCREEN_REAL_LINE *real_line;
    UINT loop;

    assert(NULL != object);

    /* XN[ʒu̓[ŒƂ */
    pos = 0;
    virt_line = object->virt.head;
    real_line = object->real.head;

    /* real̍s[v */
    for (loop = 0; loop < object->real.lines; loop++)
    {
        assert(NULL != real_line);

        /* zC\CփRs[(zCNULLł悢) */
        screen_virtline_copy(virt_line, real_line, object);

        /* virt_lineNULLłȂ΁A擾 */
        if (NULL != virt_line)
        {
            virt_line = (SCREEN_VIRT_LINE*)virt_line->bdlist.bdlist_next;
        }

        /* real_line͕K݂ */
        real_line = (SCREEN_REAL_LINE*)real_line->bdlist.bdlist_next;
    }

    /* \XN[̍XVv */
    screen_update_object(object);
}

/*
 * XN[
 * EBhEnhXN[IuWFNgt
 */
static SCREEN_OBJECT* screen_get_object(HWND hwnd)
{
    SCREEN_OBJECT *object;

    assert(NULL != hwnd);

    /* ŏ̃XN[IuWFNg𓾂 */
    object = g_screen_object_head;

    /* ΃G[ */
    assert(NULL != object);
    if (NULL == object)
    {
        return NULL;
    }

    /* v邩 */
    while(object->hwnd != hwnd)
    {
        /* ȂΑ݂Ȃ */
        assert(NULL != object->bdlist.bdlist_next);
        if (NULL == object->bdlist.bdlist_next)
        {
            return NULL;
        }

        /* ֈړ */
        object = (SCREEN_OBJECT*)object->bdlist.bdlist_next;
    }

    /*  */
    return object;
}

/*
 * XN[
 * XN[IuWFNg̕`֎~
 * WM_DESTROYnhŌĂяo
 */
static void screen_disable_object(SCREEN_OBJECT *object)
{
    assert(NULL != object);

    /* jtOTRUEZbg邱ƂŁA`𖳌 */
    object->destroy = TRUE;
}

/*
 * XN[
 * IuWFNg폜
 * WM_NCDESTROYnhŌĂяo
 */
static void screen_destroy_object(SCREEN_OBJECT *object)
{
    assert(NULL != object);
    assert(TRUE == object->destroy);

    /* \XN[j */
    screen_real_destroy(object);

    /* zXN[j */
    screen_virt_destroy(object);

    /* 擪ǂ */
    if (g_screen_object_head == object)
    {
        /* 擪Ȃ̂ŁAheadXV */
        g_screen_object_head = (SCREEN_OBJECT*)bdlist_remove((BDLIST_ENTRY*)object);
    }
    else
    {
        /* PɃXgO΂悢 */
        bdlist_remove((BDLIST_ENTRY*)object);
    }

    /* EBhEnh𖳌 */
    object->hwnd = NULL;

    /* object{̂́AĂяoEBhEŐÓIɎƂOƂĂ̂ŁAȂ */
}

/*
* XN[
* XV
*/
static void screen_update_object(SCREEN_OBJECT *object)
{
    BOOL result;

    assert(NULL != object);

    /* zXN[r */
    result = screen_real_is_equal(object);
    if (FALSE == result)
    {
        /* `vZbg */
        object->update = TRUE;
    }
    else
    {
        /* ׂĈvĂ̂ŁA`v͕KvȂ */
        object->update = FALSE;
    }
}

/*
 * XN[
 * `
 */
static void screen_draw_object(SCREEN_OBJECT *object)
{
    HDC hDC;

    assert(NULL != object);

    /* jtOZbgĂ΁AȂ */
    if (TRUE == object->destroy)
    {
        return;
    }

    /* XVtOZbgĂȂ΁AȂ */
    if (FALSE == object->update)
    {
        return;
    }

    /* foCXReLXg擾 */
    assert(NULL != object->hwnd);
    hDC = GetDC(object->hwnd);
    assert(NULL != hDC);
    if (NULL == hDC)
    {
        return;
    }

    /* \XN[` */
    screen_real_draw(hDC, object);

    /* foCXReLXg */
    ReleaseDC(object->hwnd, hDC);
    hDC = NULL;

    /* XVtO~낷 */
    object->update = FALSE;
}

/*
 * XN[
 * WM_CREATEnh
 */
static BOOL screen_on_create(HWND hWnd, const LPCREATESTRUCT lpcs)
{
    SCREEN_OBJECT *object;
    BOOL result;
    RECT rect;

    assert(NULL != hWnd);
    assert(NULL != lpcs);

    /* XN[IuWFNg擾 */
    object = (SCREEN_OBJECT*)lpcs->lpCreateParams;
    assert(NULL != object);

    /* EBhEnhL */
    object->hwnd = hWnd;

    /* NCAg̈擾 */
    result = GetClientRect(hWnd, &rect);
    assert(FALSE != result);
    if (FALSE == result)
    {
        return FALSE;
    }

    /* NCAg̈̕ƍL */
    object->width = rect.right - rect.left;
    assert(0 <= object->width);
    if (0 > object->width)
    {
        return FALSE;
    }
    object->height = rect.bottom - rect.top;
    assert(0 <= object->height);
    if (0 > object->height)
    {
        return FALSE;
    }

    /* XN[o[̗Lŕݒ */
    object->real.dir_up = object->vscroll;

    /* TCYɂĉzC쐬 */
    screen_real_resize(object);

    /* XN[̐擪ɂĕ */
    if (NULL == g_screen_object_head)
    {
        /* ŏ̃IuWFNg */
        g_screen_object_head = object;
    }
    else
    {
        /* ̃IuWFNg̖ɒǉ */
        bdlist_insert_tail((BDLIST_ENTRY*)g_screen_object_head, (BDLIST_ENTRY*)object);
    }

    /*  */
    return TRUE;
}

/*
 * XN[
 * WM_DESTROYnh
 */
static void screen_on_destroy(HWND hWnd)
{
    SCREEN_OBJECT *object;

    assert(NULL != hWnd);

    /* EBhEnhIuWFNgt */
    object = screen_get_object(hWnd);
    assert(NULL != object);
    if (NULL == object)
    {
        return;
    }

    /* XN[IuWFNg̕`֎~ */
    screen_disable_object(object);
}

/*
 * XN[
 * WM_NCDESTROYnh
 */
static void screen_on_ncdestroy(HWND hWnd)
{
    SCREEN_OBJECT *object;

    assert(NULL != hWnd);

    /* EBhEnhIuWFNgt */
    object = screen_get_object(hWnd);
    assert(NULL != object);
    if (NULL == object)
    {
        return;
    }

    /* XN[IuWFNgj */
    screen_destroy_object(object);
}

/*
 * XN[
 * WM_SIZEnh
 */
static void screen_on_size(HWND hWnd, int width, int height)
{
    SCREEN_OBJECT *object;

    assert(NULL != hWnd);
    assert(0 <= width);
    assert(0 <= height);

    /* EBhEnhIuWFNgt */
    object = screen_get_object(hWnd);
    assert(NULL != object);
    if (NULL == object)
    {
        return;
    }

    /* ƍXV */
    object->width = width;
    object->height = height;

    /* \XN[̃TCY */
    screen_real_resize(object);

    /* zXN[̃TCY */
    screen_virt_resize(object);

    /* XN[͈͂XV */
    screen_virt_scrollrange(object);
}

/*
 * XN[
 * WM_PAINTnh
 */
static void screen_on_paint(HWND hWnd)
{
    SCREEN_OBJECT *object;
    HDC hDC;
    PAINTSTRUCT ps;

    assert(NULL != hWnd);

    /* EBhEnhIuWFNgt */
    object = screen_get_object(hWnd);
    assert(NULL != object);
    if (NULL == object)
    {
        return;
    }

    /* SẴC𖳌 */
    screen_real_invalidate(object);

    /* `Jn(WM_ERASEBKGNDM) */
    hDC = BeginPaint(hWnd, &ps);
    assert(NULL != hDC);
    if (NULL == hDC)
    {
        return;
    }

    /* SẴC` */
    screen_real_draw(hDC, object);

    /* `I */
    EndPaint(hWnd, &ps);
}

/*
 * XN[
 * EBhEvV[W
 */
static LRESULT CALLBACK screen_proc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    LPCREATESTRUCT lpcs;
    BOOL result;
    int width;
    int height;

    switch (uMsg)
    {
    /* EBhE쐬ꂽ */
    case WM_CREATE:
        lpcs = (LPCREATESTRUCT)lParam;
        result = screen_on_create(hWnd, lpcs);

        /* nȟʂɂāACreateWindows */
        if (FALSE == result)
        {
            /* s */
            return -1;
        }
        /*  */
        return 0;

    /* EBhEjꂽ(qEBhEjO) */
    case WM_DESTROY:
        screen_on_destroy(hWnd);
        return 0;

    /* EBhEjꂽ(qEBhEjꂽ) */
    case WM_NCDESTROY:
        screen_on_ncdestroy(hWnd);
        return 0;

    /* EBhETCYꂽ*/
    case WM_SIZE:
        width = (int)LOWORD(lParam);
        height = (int)HIWORD(lParam);
        screen_on_size(hWnd, width, height);
        return 0;

    /* wiĕ`悷 */
    case WM_ERASEBKGND:
        /* ͂łwi`悵ꍇ͔[ԂKv */
        return 1;

    /* EBhEĕ`悷 */
    case WM_PAINT:
        screen_on_paint(hWnd);
        return 0;

    /* ̑ */
    default:
        break;
    }

    /* ftHg̃EBhEvV[W */
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

/*
 * XN[
 * EBhENX̓o^
 */
static BOOL screen_register_class(void)
{
    WNDCLASSEX wcex;

    /* [NA */
    memset(&wcex, 0, sizeof(wcex));

    /* \̃TCY */
    wcex.cbSize = sizeof(wcex);

    /* EBhEX^C */
    wcex.style = CS_HREDRAW | CS_VREDRAW;

    /* EBhEvV[W */
    wcex.lpfnWndProc = screen_proc;

    /* CX^X */
    wcex.hInstance = g_hAppInstance;

    /* ACR() */
    wcex.hIcon = NULL;

    /* J[\ */
    wcex.hCursor = (HCURSOR)LoadImage(NULL, IDC_ARROW, IMAGE_CURSOR, 0, 0, LR_SHARED);

    /* wiuV */
    wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);

    /* NX */
    wcex.lpszClassName = SCREEN_CLASS_NAME;

    /* ACR() */
    wcex.hIconSm = NULL;

    /* EBhENX̓o^ */
    if (0 == (RegisterClassEx(&wcex)))
    {
        /* EBhENX̓o^Ɏs */
        return FALSE;
    }

    /*  */
    return TRUE;
}

/*
 * XN[
 * 
 */
BOOL screen_init(void)
{
    BOOL result;

    /* EBhENXo^ */
    result = screen_register_class();
    assert(FALSE != result);
    if (FALSE == result)
    {
        return FALSE;
    }

    /* XN[o^Xg */
    g_screen_object_head = NULL;

    /*  */
    return TRUE;
}

/*
 * XN[
 * 쐬
 */
BOOL screen_create(SCREEN_OBJECT *screen)
{
    DWORD dwStyle;

    assert(NULL != screen);

    /* ĂяoZbg̈ */
    assert(NULL != screen->name);
    assert(NULL != screen->parent);
    assert(0 <= screen->x);
    assert(0 <= screen->y);
    assert(0 <= screen->width);
    assert(0 <= screen->height);

    /* XN[Ǘ̈ */
    bdlist_init((BDLIST_ENTRY*)screen);
    memset(&screen->real, 0, sizeof(SCREEN_REAL_SCREEN));
    screen->real.fore = screen->fore_def;
    screen->real.back = screen->back_def;
    memset(&screen->virt, 0, sizeof(SCREEN_VIRT_SCREEN));
    screen->update = FALSE;
    screen->destroy = FALSE;
    screen->hwnd = NULL;

    /* EBhEX^Č */
    dwStyle = WS_CHILD | WS_VISIBLE;
    if (FALSE != screen->vscroll)
    {
        /* XN[o[ǉ */
        dwStyle |= WS_VSCROLL;
    }

    /* EBhE̍쐬 */
    screen->hwnd = CreateWindow(
        SCREEN_CLASS_NAME,
        screen->name,
        dwStyle,
        screen->x,
        screen->y,
        screen->width,
        screen->height,
        screen->parent,
        NULL,
        g_hAppInstance,
        (LPVOID)screen);

    /* EBhE쐬ł`FbN */
    assert(NULL != screen->hwnd);
    if (NULL == screen->hwnd)
    {
        return FALSE;
    }

    /* 쐬 */
    return TRUE;
}

/*
 * XN[
 * TCY
 */
void screen_resize(SCREEN_OBJECT *screen)
{
    assert(NULL != screen);

    /* ĂяoZbg̈ */
    assert(0 <= screen->x);
    assert(0 <= screen->y);
    assert(0 <= screen->width);
    assert(0 <= screen->height);

    if (NULL != screen->hwnd)
    {
        MoveWindow(screen->hwnd, screen->x, screen->y, screen->width, screen->height, TRUE);
    }
}

/*
 * XN[
 * ACh
 */
void screen_idle(void)
{
    SCREEN_OBJECT *object;

    /* ŏ̃IuWFNg擾 */
    object = g_screen_object_head;

    /* IuWFNgLł胋[v */
    while (NULL != object)
    {
        /* ` */
        screen_draw_object(object);

        /* ̃IuWFNg */
        object = (SCREEN_OBJECT*)object->bdlist.bdlist_next;
    }
}

/*
 * XN[
 * \XN[̈ʒuw
 */
void screen_locate(SCREEN_OBJECT *screen, UINT x, UINT y)
{
    assert(NULL != screen);

    /* L̂ */
    screen->real.x = x;
    screen->real.y = y;
}

/*
 * XN[
 * \XN[̕]
 */
void screen_reverse(SCREEN_OBJECT *screen, BOOL reverse)
{
    assert(NULL != screen);

    /* ] */
    if (FALSE == reverse)
    {
        /* ] */
        screen->real.fore = screen->fore_def;
        screen->real.back = screen->back_def;
    }
    else
    {
        /* ]L */
        screen->real.fore = screen->back_def;
        screen->real.back = screen->fore_def;
    }
}

/*
 * XN[
 * \XN[͈̔͂NA
 */
void screen_clear(SCREEN_OBJECT *screen, UINT width, UINT height)
{
    UINT x_real;
    UINT y_real;
    UINT x_loop;
    UINT y_loop;
    SCREEN_REAL_LINE *line;

    assert(NULL != screen);

    /* ݂̈ʒuL */
    x_real = screen->real.x;
    y_real = screen->real.y;

    /* y[v */
    for (y_loop = 0; y_loop < height; y_loop++)
    {
        /* x,yZbg */
        screen->real.x = x_real;
        screen->real.y = y_loop;

        /* line𓾂 */
        line = screen_real_getline(screen);
        if (NULL == line)
        {
            break;
        }

        /* x[v */
        for (x_loop = 0; x_loop < width; x_loop++)
        {
            /* Zbg */
            screen_realline_setchr(line, screen, L' ');
        }
    }

    /* ݂̈ʒu𕜌 */
    screen->real.x = x_real;
    screen->real.y = y_real;
}

/*
 * XN[
 * \XN[֏o
 */
void screen_print(SCREEN_OBJECT *screen, const wchar_t *buf)
{
    size_t len;
    UINT loop;
    UINT x;
    SCREEN_REAL_LINE *line;

    assert(NULL != screen);
    assert(NULL != buf);

    /* line𓾂 */
    line = screen_real_getline(screen);
    if (NULL == line)
    {
        return;
    }

    /* ŏxʒuL */
    x = screen->real.x;

    /* [v */
    len = wcslen(buf);
    for (loop = 0; loop < len; loop++)
    {
        /* s */
        if (buf[loop] == L'\n')
        {
            /* s */
            screen->real.x = x;
            screen->real.y++;
        }
        else
        {
            /* Zbg */
            screen_realline_setchr(line, screen, buf[loop]);
        }
    }

    /* XN[̍XVv */
    screen_update_object(screen);
}

/*
 * XN[
 * zXN[֏o
 */
void screen_add(SCREEN_OBJECT *screen, const wchar_t *buf)
{
    size_t len;
    UINT loop;
    SCREEN_VIRT_LINE *line;

    assert(NULL != screen);
    assert(NULL != buf);

    /* line𓾂 */
    line = screen_virt_addline(screen);
    assert(NULL != line);
    if (NULL == line)
    {
        return;
    }

    /* [v */
    len = wcslen(buf);
    for (loop = 0; loop < len; loop++)
    {
        /* s */
        if (buf[loop] == L'\n')
        {
            /* s͖AȂ */
            continue;
        }
        else
        {
            /* Zbg */
            screen_virtline_setchr(line, screen, buf[loop]);
        }
    }

    /* zXN[XN[o[ݒ */
    screen_virt_scrollrange(screen);

    /* zXN[\XN[փRs[ */
    screen_virt_copy(screen);
}
