/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ WindowsO ]
 */

#include "header.h"
#include "screen.h"
#include "logwin.h"

/*
 * 萔
 */

/* EBhELvV */
#define LOGWIN_WINDOW_NAME              L"WindowsO"

/*
 * staticϐ
 */

/* XN[IuWFNg */
static SCREEN_OBJECT g_logwin_screen;

/* t@Cnh */
static FILE *g_logwin_file;

/* Oԍ */
static UINT g_logwin_num;

/*
 * WindowsO
 * I
 */
static void logwin_on_ncdestroy(void)
{
    /* t@Cnh */
    if (NULL != g_logwin_file)
    {
        fclose(g_logwin_file);
        g_logwin_file = NULL;
    }
}

/*
 * WindowsO
 * t@CI[v
 */
BOOL logwin_file_open(void)
{
    wchar_t buf[0x8000];
    wchar_t dir[0x8000];
    DWORD len;
    DWORD attr;
    BOOL result;
    SYSTEMTIME st;
    errno_t err;

    /* bufɂ͏\傫ȃobt@pӂ邱(250LN^𒴂钷t@Cl[ɑΉ) */
    len = GetModuleFileName(NULL, buf, _countof(buf));
    assert((0 != len) && (ERROR_INSUFFICIENT_BUFFER != len));
    if ((0 == len) || (ERROR_INSUFFICIENT_BUFFER == len))
    {
        return FALSE;
    }

    /* len-1瑖āAŏɋ؂蕶oĂƂ */
    len--;
    while (len > 0)
    {
        if (L'\\' == buf[len])
        {
            /* ̎Ő؂ */
            buf[len + 1] = L'\0';
            break;
        }
        len--;
    }
    if (0 == len)
    {
        return FALSE;
    }

    /* 擪\\?\*/
    wcscpy_s(dir, _countof(dir), L"\\\\?\\");

    /* pX{ */
    wcscat_s(dir, _countof(dir), buf);

    /* logǉ */
    wcscat_s(dir, _countof(dir), L"log");

    /* t@C܂̓fBNg݂Ɖ肵āA𓾂 */
    attr = GetFileAttributes(dir);
    if (INVALID_FILE_ATTRIBUTES == attr)
    {
        /* t@C܂̓fBNg݂͑Ȃ */
        attr = 0;
    }
    else
    {
        /* fBNĝ݂}XN */
        attr &= FILE_ATTRIBUTE_DIRECTORY;
    }

    /* fBNg */
    if (0 == attr)
    {
        /* fBNgłȂ̂ŁA쐬݂ */
        result = CreateDirectory(dir, NULL);
        if (FALSE == result)
        {
            /* fBNg̍쐬Ɏs */
            return FALSE;
        }
    }

    /* [J擾 */
    memset(&st, 0, sizeof(st));
    GetLocalTime(&st);

    /* dirbuf֋tɃtH[}bg */
    wcscat_s(dir, _countof(dir), L"\\");
    swprintf_s(
        buf,
        _countof(buf),
        L"%s%04d%02d%02d_%02d%02d%02d.log",
        dir,
        st.wYear,
        st.wMonth,
        st.wDay,
        st.wHour,
        st.wMinute,
        st.wSecond);

    /* t@C쐬 */
    err = _wfopen_s(&g_logwin_file, buf, L"a+t");
    if ((0 != err) || (NULL == g_logwin_file))
    {
        return FALSE;
    }

    /*  */
    return TRUE;
}

/*
 * WindowsO
 * 
 */
BOOL logwin_init(HWND parent, int x, int y, int width, int height)
{
    BOOL result;

    /* t@Cnh */
    g_logwin_file = NULL;

    /* Oԍ */
    g_logwin_num = 0;

    /* t@CI[v */
    result = logwin_file_open();
    if (FALSE == result)
    {
        return FALSE;
    }

    /* XN[IuWFNg */
    memset(&g_logwin_screen, 0, sizeof(g_logwin_screen));

    /* p[^Zbg */
    g_logwin_screen.name = LOGWIN_WINDOW_NAME;
    g_logwin_screen.parent = parent;
    g_logwin_screen.x = x;
    g_logwin_screen.y = y;
    g_logwin_screen.width = width;
    g_logwin_screen.height = height;
    g_logwin_screen.fore_def = GetSysColor(COLOR_WINDOWTEXT);
    g_logwin_screen.back_def = GetSysColor(COLOR_WINDOW);
    g_logwin_screen.vscroll = TRUE;
    g_logwin_screen.on_ncdestroy = logwin_on_ncdestroy;

    /* XN[쐬 */
    return screen_create(&g_logwin_screen);
}

/*
 * WindowsO
 * TCY
 */
void logwin_resize(int x, int y, int width, int height)
{
    /* p[^Zbg */
    g_logwin_screen.x = x;
    g_logwin_screen.y = y;
    g_logwin_screen.width = width;
    g_logwin_screen.height = height;

    /* XN[TCY */
    screen_resize(&g_logwin_screen);
}

/*
 * WindowsO
 * L[
 */
void logwin_keydown(WPARAM wparam, LPARAM lparam)
{
    /* WM_KEYDOWN|Xg */
    PostMessage(g_logwin_screen.hwnd, WM_KEYDOWN, wparam, lparam);
}

/*
 * WindowsO
 * Oo(char)
 */
void logwin_out(const char *log)
{
    char buf[0x400];
    wchar_t wide[0x400];
    SYSTEMTIME st;
    UINT loop;

    assert(NULL != log);

    /* [J擾 */
    memset(&st, 0, sizeof(st));
    GetLocalTime(&st);

    /* bufփtH[}bg */
    sprintf_s(
        buf,
        _countof(buf),
        "%07d,%02d:%02d:%02d.%03d,%s",
        g_logwin_num,
        st.wHour,
        st.wMinute,
        st.wSecond,
        st.wMilliseconds,
        log
    );
    buf[_countof(buf) - 1] = L'\0';

    /* Oԍi߂ */
    g_logwin_num++;

    /* \nꂽAőł؂ */
    for (loop = 0; loop < _countof(buf); loop++)
    {
        if ('\0' == buf[loop])
        {
            break;
        }
        if ('\n' == buf[loop])
        {
            buf[loop] = '\0';
            break;
        }
    }

    /* t@C֒ǉ */
    assert(NULL != g_logwin_file);
    fprintf_s(g_logwin_file, "%s\n", buf);

    /* Ch֕ϊ */
    MultiByteToWideChar(
        CP_ACP,
        MB_PRECOMPOSED,
        buf,
        -1,
        wide,
        _countof(wide));
    wide[_countof(wide) - 1] = L'\0';

    /* \XN[֒ǉ */
    screen_add(&g_logwin_screen, wide);
}

/*
 * WindowsO
 * o(char)
 */
void logwin_printf(const char *format, ...)
{
    char multibyte[0x400];
    va_list ap;

    assert(NULL != format);

    /* tH[}bg */
    va_start(ap, format);
    vsprintf_s(multibyte, _countof(multibyte), format, ap);
    multibyte[_countof(multibyte) - 1] = '\0';
    va_end(ap);

    /* Oo */
    logwin_out(multibyte);
}

/*
 * WindowsO
 * o(wchar_t)
 */
void logwin_printfw(const wchar_t *format, ...)
{
    wchar_t wide[0x400];
    char multibyte[0x400];
    va_list ap;
    int result;

    assert(NULL != format);

    /* tH[}bg */
    va_start(ap, format);
    vswprintf_s(wide, _countof(wide), format, ap);
    wide[_countof(wide) - 1] = '\0';
    va_end(ap);

    /* }`oCg֕ϊ */
    result = WideCharToMultiByte(
        CP_ACP,
        0,
        wide,
        -1,
        multibyte,
        _countof(multibyte),
        NULL,
        NULL);
    if (0 == result)
    {
        return;
    }

    /* Oo */
    logwin_out(multibyte);
}
