/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ WinMain ]
 */

#include "header.h"
#include "screen.h"
#include "cons.h"
#include "monitor.h"
#include "logwin.h"
#include "comm.h"
#include "ymodem.h"
#include "app.h"
#include "winmain.h"

/*
 * 萔
 */

/* EBhENX */
#define WINDOW_CLASS_NAME               L"FrameWindow"

/* EBhELvV */
#define WINDOW_CAPTION                  L"Debug Monitor"

/* tHg̃tF[X */
#define WINDOW_FONT_FACENAME            L"lr SVbN"

/* tHg̃|Cg */
#define WINDOW_FONT_POINT               9

/* tHg̍ɉ}[W(%) */
#define WINDOW_FONT_HEIGHT_MERGIN       10

/* R\[EBhE̍䗦(%) */
#define CONS_HEIGHT_RATIO               60

/* R\[EBhE̕ */
#define CONS_WIDTH_CHRS                 80

/*
 * O[oϐ
 */

/* AvP[ṼCX^X */
HINSTANCE g_hAppInstance;

/* tHgnh */
HFONT g_hFont;

/* tHg̃eLXggbN */
TEXTMETRIC g_tm;

/* tHg̍(}[W܂) */
LONG g_tmAllHeight;

/* WM_USERbZ[W|Xg */
BOOL g_bUserPost;

/* WM_CLOSEbZ[W󂯂 */
BOOL g_bCloseReq;

/* [UAvP[VI */
BOOL g_bUserQuit;

/*
 * \̒`
 */
typedef struct _CHILD_RECTS {
    /* R\[̈ */
    RECT rcCons;

    /* j^̈ */
    RECT rcMonitor;

    /* O(Windows)̈ */
    RECT rcLogWin;
} CHILD_RECTS;

/*
 * staticϐ
 */

/* t[EBhẼEBhEnh */
static HWND g_hFrameWnd;

/* `ChEBhE̋` */
static CHILD_RECTS g_rcChilds;

/*
 * WinMain
 * `ChEBhẼTCY
 */
static void CalcChilldRects(HWND hWnd)
{
    RECT rect;
    LONG lWidth;
    LONG lHeight;
    LONG lScreenHeight;
    LONG lChars;
    BOOL bSuccess;

    assert(NULL != hWnd);
    assert(0 < g_tmAllHeight);

    /* mԂ𖢊mɏ */
    bSuccess = FALSE;

    /* NCAg̈擾 */
    GetClientRect(hWnd, &rect);

    /* ƍ擾 */
    lWidth = rect.right - rect.left;
    lHeight = rect.bottom - rect.top;

    /* ׂ0ɏ */
    memset(&g_rcChilds, 0, sizeof(g_rcChilds));
    lScreenHeight = 0;

    /* ƍ̂ǂ炩0ł΁Aׂ0 */
    if (FALSE == bSuccess)
    {
        if ((0 == lWidth) || (0 == lHeight))
        {
            /* m */
            bSuccess = TRUE;
        }
    }

    /* w荂䗦XN[AcOɊ蓖Ă */
    if (FALSE == bSuccess)
    {
        /* ̃XN[Zo */
        lScreenHeight = (LONG)(lHeight * CONS_HEIGHT_RATIO / 100);

        /* LN^𓾂 */
        lChars = (LONG)(lScreenHeight / g_tmAllHeight);

        /* LN^J艺ɂ */
        lScreenHeight = (LONG)(lChars * g_tmAllHeight);
    }

    /* R\[̋`ݒ */
    g_rcChilds.rcCons.left = 0;
    g_rcChilds.rcCons.top = 0;
    g_rcChilds.rcCons.right = (LONG)(CONS_WIDTH_CHRS * g_tm.tmAveCharWidth);
    g_rcChilds.rcCons.bottom = lScreenHeight;

    /* j^̋`ݒ */
    g_rcChilds.rcMonitor.left = g_rcChilds.rcCons.right;
    g_rcChilds.rcMonitor.top = 0;
    if (lWidth < g_rcChilds.rcMonitor.left)
    {
        /* Ȃ */
        g_rcChilds.rcMonitor.right = g_rcChilds.rcMonitor.left;
    }
    else
    {
        /* ͑Ă */
        g_rcChilds.rcMonitor.right = lWidth;
    }
    g_rcChilds.rcMonitor.bottom = lScreenHeight;

    /* O(Windows)̋`ݒ */
    g_rcChilds.rcLogWin.left = 0;
    g_rcChilds.rcLogWin.top = g_rcChilds.rcCons.bottom;
    g_rcChilds.rcLogWin.right = lWidth;
    if (lHeight < g_rcChilds.rcLogWin.top)
    {
        /* Ȃ */
        g_rcChilds.rcLogWin.bottom = g_rcChilds.rcLogWin.top;
    }
    else
    {
        /* ͑Ă */
        g_rcChilds.rcLogWin.bottom = lHeight;
    }
}

/*
 * WinMain
 * tHg쐬
 */
static BOOL OnCreateFont(HWND hWnd)
{
    HDC hDC;
    LOGFONT lf;
    HFONT hDefFont;
    BOOL bResult;

    assert(NULL != hWnd);

    /* GetDeviceCapsGetTextMetriĉ߃foCXReLXg쐬 */
    hDC = GetDC(hWnd);
    assert(NULL != hDC);
    if (NULL == hDC)
    {
        return FALSE;
    }

    /* [NA */
    memset(&lf, 0, sizeof(lf));

    /* tHg */
    lf.lfHeight = -MulDiv(WINDOW_FONT_POINT, GetDeviceCaps(hDC, LOGPIXELSY), 72);

    /* tHg */
    lf.lfWidth = 0;

    /* ̊px */
    lf.lfEscapement = 0;

    /* x[XCƂ̊px */
    lf.lfOrientation = 0;

    /* tHg̑ */
    lf.lfWeight = FW_DONTCARE;

    /* C^bN */
    lf.lfItalic = FALSE;

    /* A_[C */
    lf.lfUnderline = FALSE;

    /*  */
    lf.lfStrikeOut = FALSE;

    /* {ꕶZbg */
    lf.lfCharSet = SHIFTJIS_CHARSET;

    /* o͐x */
    lf.lfOutPrecision = OUT_DEFAULT_PRECIS;

    /* NbsOx */
    lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;

    /* o͕i */
    lf.lfQuality = DEFAULT_QUALITY;

    /* tHgsb`ƃt@~ */
    lf.lfPitchAndFamily = FIXED_PITCH | FF_DONTCARE;

    /* tHg */
    wcscpy_s(lf.lfFaceName, _countof(lf.lfFaceName), WINDOW_FONT_FACENAME);

    /* tHg쐬 */
    g_hFont = CreateFontIndirect(&lf);
    assert(NULL != g_hFont);
    if (NULL == g_hFont)
    {
        ReleaseDC(hWnd, hDC);
        return FALSE;
    }

    /* tHgI */
    hDefFont = SelectObject(hDC, g_hFont);
    assert(NULL != hDefFont);
    if (NULL == hDefFont)
    {
        ReleaseDC(hWnd, hDC);
        return FALSE;
    }

    /* eLXggbN擾 */
    bResult = GetTextMetrics(hDC, &g_tm);
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        SelectObject(hDC, hDefFont);
        ReleaseDC(hWnd, hDC);
        return FALSE;
    }

    /*tHg𕜌 */
    SelectObject(hDC, hDefFont);

    /* foCXReLXg */
    ReleaseDC(hWnd, hDC);

    /* eLXggbN */
    assert(0 < g_tm.tmAveCharWidth);
    assert(0 < g_tm.tmMaxCharWidth);
    assert(g_tm.tmAveCharWidth < g_tm.tmMaxCharWidth);
    assert(0 < g_tm.tmHeight);

    /* tHg̍vݒ */
    g_tmAllHeight = g_tm.tmHeight + g_tm.tmExternalLeading;
    g_tmAllHeight *= (100 + WINDOW_FONT_HEIGHT_MERGIN);
    g_tmAllHeight /= 100;

    /* I */
    return TRUE;
}

/*
 * WinMain
 * WM_CREATEbZ[Wnh
 */
static BOOL OnCreate(HWND hWnd, const CREATESTRUCT *lpcs)
{
    BOOL bResult;
    int x;
    int y;
    int width;
    int height;

    assert(NULL != hWnd);
    assert(NULL != lpcs);

    /* tHg쐬 */
    if (FALSE == OnCreateFont(hWnd))
    {
        return FALSE;
    }

    /* |[g */
    comm_init();

    /* `ChEBhẼTCY */
    CalcChilldRects(hWnd);

    /* XN[̏ */
    bResult = screen_init();
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        return FALSE;
    }

    /* R\[쐬 */
    x = g_rcChilds.rcCons.left;
    y = g_rcChilds.rcCons.top;
    width = g_rcChilds.rcCons.right - g_rcChilds.rcCons.left;
    assert(0 <= width);
    height = g_rcChilds.rcCons.bottom - g_rcChilds.rcCons.top;
    assert(0 <= height);
    bResult = cons_init(hWnd, x, y, width, height);
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        return FALSE;
    }

    /* j^쐬 */
    x = g_rcChilds.rcMonitor.left;
    y = g_rcChilds.rcMonitor.top;
    width = g_rcChilds.rcMonitor.right - g_rcChilds.rcMonitor.left;
    assert(0 <= width);
    height = g_rcChilds.rcMonitor.bottom - g_rcChilds.rcMonitor.top;
    assert(0 <= height);
    bResult = monitor_init(hWnd, x, y, width, height);
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        return FALSE;
    }

    /* WindowsO쐬 */
    x = g_rcChilds.rcLogWin.left;
    y = g_rcChilds.rcLogWin.top;
    width = g_rcChilds.rcLogWin.right - g_rcChilds.rcLogWin.left;
    assert(0 <= width);
    height = g_rcChilds.rcLogWin.bottom - g_rcChilds.rcLogWin.top;
    assert(0 <= height);
    bResult = logwin_init(hWnd, x, y, width, height);
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        return FALSE;
    }

    /* I */
    return TRUE;
}

/*
 * WinMain
 * WM_DESTROYbZ[Wnh
 */
static void OnDestroy(HWND hWnd)
{
    assert(NULL != hWnd);

    /* |[gI */
    comm_deinit();

    /* tHg΍폜 */
    if (NULL != g_hFont)
    {
        DeleteObject(g_hFont);
        g_hFont = NULL;
    }
}

/*
 * WinMain
 * WM_SIZEbZ[Wnh
 */
static void OnSize(HWND hWnd)
{
    int x;
    int y;
    int width;
    int height;

    assert(NULL != hWnd);

    /* `ChEBhẼTCY */
    CalcChilldRects(hWnd);

    /* R\[̃TCYv */
    x = g_rcChilds.rcCons.left;
    y = g_rcChilds.rcCons.top;
    width = g_rcChilds.rcCons.right - g_rcChilds.rcCons.left;
    assert(0 <= width);
    height = g_rcChilds.rcCons.bottom - g_rcChilds.rcCons.top;
    assert(0 <= height);
    cons_resize(x, y, width, height);

    /* j^̃TCYv */
    x = g_rcChilds.rcMonitor.left;
    y = g_rcChilds.rcMonitor.top;
    width = g_rcChilds.rcMonitor.right - g_rcChilds.rcMonitor.left;
    assert(0 <= width);
    height = g_rcChilds.rcMonitor.bottom - g_rcChilds.rcMonitor.top;
    assert(0 <= height);
    monitor_resize(x, y, width, height);

    /* WindowsÕTCYv */
    x = g_rcChilds.rcLogWin.left;
    y = g_rcChilds.rcLogWin.top;
    width = g_rcChilds.rcLogWin.right - g_rcChilds.rcLogWin.left;
    assert(0 <= width);
    height = g_rcChilds.rcLogWin.bottom - g_rcChilds.rcLogWin.top;
    assert(0 <= height);
    logwin_resize(x, y, width, height);
}

/*
 * WinMain
 * WM_ACTIVATEbZ[Wnh
 */
static void OnActivate(HWND hWnd)
{
    assert(NULL != hWnd);

    /* WM_USER|XgĂȂꍇ */
    if (FALSE == g_bUserPost)
    {
        /* WM_USER|Xgς݂Ƃ */
        g_bUserPost = TRUE;

        /* WM_USER|Xg */
        PostMessage(hWnd, WM_USER, 0, 0);
    }
}

/*
 * WinMain
 * WM_CLOSEbZ[Wnh
 */
static void OnClose(HWND hWnd)
{
    assert(NULL != hWnd);

    /* N[YvL */
    g_bCloseReq = TRUE;

    /* AvP[VIĂ΁ADestroyWindow𑦍ɔs */
    if (FALSE != g_bUserQuit)
    {
        DestroyWindow(hWnd);
    }
}

/*
 * WinMain
 * WM_USERbZ[Wnh
 */
static void OnUser(HWND hWnd)
{
    assert(NULL != hWnd);

    /* [UAv͏IĂȂ */
    g_bUserQuit = FALSE;

    /* AvP[VĂяo */
    app_run();

    /* [UAv͏I */
    logwin_printf("AvP[V͏I܂");
    g_bUserQuit = TRUE;

    /* IvoĂ΁ADestroyWindow𔭍s */
    if (FALSE != g_bCloseReq)
    {
        DestroyWindow(hWnd);
    }
}

/*
 * WinMain
 * WM_KEYDOWNbZ[Wnh
 */
static void OnKeyDown(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
    assert(NULL != hWnd);

    /* L[ʂɏ */
    switch (wParam)
    {
    case VK_HOME:
    case VK_END:
    case VK_PRIOR:
    case VK_NEXT:
    case VK_UP:
    case VK_DOWN:
        /* WindowsO֓] */
        logwin_keydown(wParam, lParam);
        break;
    }
}

/*
 * WinMain
 * t[EBhẼEBhEvV[W
 */
static LRESULT CALLBACK FrameWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    const CREATESTRUCT *lpcs;
    BOOL bResult;

    switch (uMsg)
    {
    /* EBhE쐬ꂽ */
    case WM_CREATE:
        /* nhĂяo */
        lpcs = (const CREATESTRUCT *)lParam;
        assert(NULL != lpcs);
        bResult = OnCreate(hWnd, lpcs);

        /* nȟʂɂāACreateWindows */
        if (FALSE == bResult)
        {
            /* OnCreateɎs */
            return -1;
        }

        /* I */
        return 0;

    /* EBhEjꂽ */
    case WM_DESTROY:
        /* nhĂяo */
        OnDestroy(hWnd);

        /* WM_QUIT𑗐M */
        PostQuitMessage(0);
        return 0;

    /* EBhETCYꂽ */
    case WM_SIZE:
        /* nhĂяo */
        OnSize(hWnd);
        return 0;

    /* EBhE\ꂽ */
    case WM_ACTIVATE:
        /* nhĂяo */
        OnActivate(hWnd);
        return 0;

    /* EBhEIvꂽ */
    case WM_CLOSE:
        /* nhĂяo */
        OnClose(hWnd);
        return 0;

    /* [UbZ[W */
    case WM_USER:
        /* nhĂяo */
        OnUser(hWnd);
        return 0;

    /* WM_KEYDOWN */
    case WM_KEYDOWN:
        /* nhĂяo */
        OnKeyDown(hWnd, wParam, lParam);
        return 0;

    /* ̑ */
    default:
        break;
    }

    /* ftHg̃EBhEvV[W */
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

/*
 * WinMain
 * EBhENX̓o^
 */
static BOOL RegisterWindowClass(void)
{
    WNDCLASSEX wcex;

    /* [NA */
    memset(&wcex, 0, sizeof(wcex));

    /* \̃TCY */
    wcex.cbSize = sizeof(wcex);

    /* EBhEX^C */
    wcex.style = CS_HREDRAW | CS_VREDRAW;

    /* EBhEvV[W */
    wcex.lpfnWndProc = FrameWindowProc;

    /* CX^X */
    wcex.hInstance = g_hAppInstance;

    /* ACR() */
    wcex.hIcon = (HICON)LoadImage(NULL, IDI_APPLICATION, IMAGE_ICON, 0, 0, LR_SHARED);

    /* J[\ */
    wcex.hCursor = (HCURSOR)LoadImage(NULL, IDC_ARROW, IMAGE_CURSOR, 0, 0, LR_SHARED);

    /* wiuV */
    wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);

    /* NX */
    wcex.lpszClassName = WINDOW_CLASS_NAME;

    /* ACR() */
    wcex.hIconSm = (HICON)LoadImage(NULL, IDI_APPLICATION, IMAGE_ICON, 0, 0, LR_SHARED);

    /* EBhENX̓o^ */
    if (0 == RegisterClassEx(&wcex))
    {
        /* o^s */
        return FALSE;
    }

    /* o^ */
    return TRUE;
}

/*
 * WinMain
 * CX^X̏
 */
static BOOL InitInstance(HINSTANCE hInstance)
{
    MMRESULT mmResult;
    BOOL bResult;

#ifdef _DEBUG
    /* CRTfobOtOݒ */
    _CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
#endif /* _DEBUG */

    /* CX^XL */
    g_hAppInstance = hInstance;

    /* O[oϐ */
    g_hFont = NULL;
    memset(&g_tm, 0, sizeof(g_tm));
    g_tmAllHeight = 0;

    /* staticϐ */
    g_hFrameWnd = NULL;
    memset(&g_rcChilds, 0, sizeof(g_rcChilds));
    g_bUserPost = FALSE;
    g_bCloseReq = FALSE;
    g_bUserQuit = FALSE;

    /* }`fBA^C}̍ŏ\ݒ */
    mmResult = timeBeginPeriod(1);
    assert(TIMERR_NOERROR == mmResult);
    if (TIMERR_NOERROR != mmResult)
    {
        return FALSE;
    }

    /* IME𖳌(gbvxEBhE̍쐬Oɍs) */
    ImmDisableIME((DWORD)-1);

    /* DPIΉł邱Ƃ𖾎(Windows VistaŒǉꂽAPI) */
    /* APIōsƂ͐ĂȂ(}jtFXgōŝ@) */
    bResult = SetProcessDPIAware();
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        return FALSE;
    }

    /* EBhENXo^ */
    bResult = RegisterWindowClass();
    assert(FALSE != bResult);
    if (FALSE == bResult)
    {
        return FALSE;
    }

    /* EBhE쐬 */
    g_hFrameWnd = CreateWindow(
        WINDOW_CLASS_NAME,
        WINDOW_CAPTION,
        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        g_hAppInstance,
        NULL);

    /* EBhE쐬ł`FbN */
    if (NULL == g_hFrameWnd)
    {
        return FALSE;
    }

    /* EBhE쐬 */
    return TRUE;
}

/*
 * WinMain
 * CX^X̏I
 */
static void ExitInstance(void)
{
    /* }`fBA^C}̍ŏ\𕜌 */
    timeEndPeriod(1);
}

/*
 * WinMain
 * ACh
 */
static void OnIdle(void)
{
    /* t[EBhE쐬O͉Ȃ */
    if (NULL == g_hFrameWnd)
    {
        return;
    }

    /* frameworkcomm̃ACh */
    screen_idle();
    cons_idle();
    monitor_idle();
    ymodem_idle();
}

/*
 * WinMain
 * bZ[W|v
 * AvP[VIׂꍇFALSEԂ
 */
BOOL do_events(DWORD dwTimeOut)
{
    MSG msg;
    DWORD dwTime;
    DWORD dwDiff;

    /* ݂̎ԂL */
    dwTime = timeGetTime();

    /* [v */
    for (;;)
    {
        /* ԍ𓾂 */
        dwDiff = (DWORD)(timeGetTime() - dwTime);

        /* ԍ𒴂甲 */
        if (dwDiff > dwTimeOut)
        {
            break;
        }

        /* bZ[WĂ邩 */
        if (FALSE != PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
        {
            /* bZ[WL[擾 */
            if (GetMessage(&msg, NULL, 0, 0) <= 0)
            {
                /* WM_QUITȂFALSEԂ */
                return FALSE;
            }

            /* bZ[WfBXpb` */
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }

        /* ACh */
        OnIdle();

        /* bZ[WĂȂ΃X[v */
        if (FALSE == PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
        {
            /* X[v */
            Sleep(10);
        }

        /* WM_CLOSEĂFALSEԂ */
        if (FALSE != g_bCloseReq)
        {
            return FALSE;
        }
    }

    /* AvP[Vpł̂ŁATRUEԂ */
    return TRUE;
}

/*
 * WinMain
 */
int WINAPI wWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PWSTR pCmdLine, int nCmdShow)
{
    MSG msg;

    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(pCmdLine);

    /* CX^X̏ */
    if (InitInstance(hInstance) == FALSE)
    {
        return 0;
    }

    /* EBhE̕\ƍXV */
    ShowWindow(g_hFrameWnd, nCmdShow);
    UpdateWindow(g_hFrameWnd);

    /* bZ[W[v */
    for (;;)
    {
        /* bZ[WĂ邩 */
        if (FALSE != PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
        {
            /* bZ[WL[擾 */
            if (GetMessage(&msg, NULL, 0, 0) <= 0)
            {
                /* WM_QUITȂI */
                break;
            }

            /* bZ[WfBXpb` */
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }

        /* [UAvIĂāAWM_CLOSEOȂ */
        if ((FALSE != g_bUserQuit) && (g_bCloseReq == FALSE))
        {
            /* ACh */
            OnIdle();

            /* X[v */
            Sleep(10);
        }
    }

    /* CX^X̏I */
    ExitInstance();

    /* vOI */
    return (int)msg.wParam;
}
