﻿#coding:utf-8

#
# CLRインポート
#
import clr
clr.AddReferenceByPartialName("System.Windows.Forms")
from System.Windows.Forms import *
clr.AddReferenceByPartialName("System.Drawing")
from System.Drawing import *

#
# ライブラリインポート
#
import os
import datetime

#
# スクリプト開始
#
common.OutputPanel("Pythonスクリプトを開始しました", MessageType.Information)
print "Pythonスクリプトを開始しました"

#
# プロジェクトオープンされているか確認
#
common.OutputPanel("プロジェクト確認中です", MessageType.Information)
print "プロジェクト確認中です"
if project.IsOpen != True:
    common.OutputPanel("プロジェクトがオープンされていません", MessageType.Error)
    print "プロジェクトがオープンされていません"
    sys.exit()
common.OutputPanel("プロジェクト確認しました", MessageType.Information)
print "プロジェクト確認しました"

#
# アクティブプロジェクト名からPythonベースパスを作成
# (プロジェクト名に日本語文字を含めないこと)
# basePath:プロジェクトパス/Python/
#
common.OutputPanel("Python作業パスを確認中です", MessageType.Information)
print "Python作業パスを確認中です"
basePath = project.Path.rpartition('\\')[0] + project.Path.rpartition('\\')[1]
basePath = basePath + "Python"
# パスが存在しなければ作成(作成できたかどうかのチェックは行わない)
if os.path.exists(basePath) != True:
    os.mkdir(basePath)
# パスの存在をチェック
if os.path.exists(basePath) != True:
    common.OutputPanel("フォルダ作成に失敗しました", MessageType.Error)
    print "フォルダ作成に失敗しました"
    sys.exit()
# パスがディレクトリか、またはファイルかチェック
if os.path.isdir(basePath) != True:
    common.OutputPanel("Pythonフォルダがファイルとして存在しています", MessageType.Error)
    print "Pythonフォルダがファイルとして存在しています"
    sys.exit()
# 末尾にパス区切り文字を追加
basePath = basePath + "\\"
common.OutputPanel("Pythonパスを確認しました " + basePath, MessageType.Information)
print "Python作業パスを確認しました " + basePath

#
# ログファイルを作成
# scriptName:スクリプトファイル名(.pyは含まない)
# logPath:プロジェクトパス/Python/スクリプトファイル名_日付_時刻.log
#
logDate = datetime.datetime.now()
scriptName = os.path.basename(__file__).rpartition(".")[0]
logPath = basePath + scriptName + logDate.strftime("_%Y%m%d_%H%M%S.log")
logFile = open(logPath, "a")
# オープンできたかチェック
if logFile.closed == True:
    common.OutputPanel("ログファイルを追加オープンできません", MessageType.Error)
    print "ログファイルを追加オープンできません"
    sys.exit()

#
# ログ番号を初期化
#
logNum = 0

#-[ 汎用関数 ]----------------------------------------------------------------

#
# 関数:ログ出力
#
def output_log(msg, err=False):
    # ログ番号をフォーマット
    global logNum
    numMsg = "[%06d] " % logNum

    # ログ番号を+1
    logNum = logNum + 1

    # 日付をフォーマット
    dtNow = datetime.datetime.now()
    dtMsg = dtNow.strftime("%Y-%m-%d %H:%M:%S ")

    # [ログ番号] 日付 時間 文字列
    numMsg = numMsg + dtMsg + msg

    # パネル
    if err == True:
        common.OutputPanel(numMsg, MessageType.Error)
    else:
        common.OutputPanel(numMsg, MessageType.Information)

    # Pythonコンソール
    print numMsg

    # ログ
    numMsg = numMsg + "\n"
    logFile.write(numMsg.encode('cp932'))

    # エラーなら、ここでスクリプト打ち切り
    if err == True:
        # 中断
        logFile.close()
        sys.exit()

#
# 関数:スクリーンキャプチャの取得とセーブ(マルチディスプレイ対応)
#
def save_screen(name):
    # スクリーン番号を表すインデックスを初期化
    index = 0

    # スクリーン毎にループ
    for scr in Screen.AllScreens:
        # 現在日付＋スクリーン番号＋パラメータからパス名を作成
        dtNow = datetime.datetime.now()
        dtMsg = dtNow.strftime("%Y%m%d_%H%M%S")
        scrMsg = "_%1d_" % index
        path = basePath + dtMsg + scrMsg + name + ".png"

        # スクリーン毎のサイズを表すRectangle型を取得
        rect = scr.Bounds

        # ビットマップとグラフィックを併用してスクリーンキャプチャ
        bmp = Bitmap(rect.Width, rect.Height)
        grp = Graphics.FromImage(bmp)
        grp.CopyFromScreen(Point(0, 0), Point(0, 0), Size(rect.Width, rect.Height))

        # PNG形式でファイルに保存
        bmp.Save(path, Imaging.ImageFormat.Png)

        # 後片付け
        grp.Dispose()
        bmp.Dispose()

        # ログ出力
        output_log("スクリーンキャプチャを保存しました " + path)

        # 次のスクリーンへ
        index = index + 1

#-[ ビルド ]------------------------------------------------------------------

#
# 関数:ビルド
#
def build_project(all):
    # ログ表示
    if all == True:
        output_log("リビルドしています")
    else:
        output_log("通常ビルドしています")

    # パラメータに応じて通常ビルドまたはリビルド
    ret = build.All(all, True)

    # 結果確認
    if ret == True:
        output_log("ビルド成功しました")
    else:
        output_log("ビルド失敗しました", True)

#
# 関数:メッセージボックスでビルドタイプを選択
#
def select_build():
    # メッセージボックスでビルドタイプを選択
    output_log("ビルドタイプ選択(はい:通常ビルド いいえ:リビルド)")
    ret = MessageBox.Show("通常ビルドしますか？", "ビルド選択", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question)

    # キャンセルされたら終了する
    if ret == DialogResult.Cancel:
        output_log("キャンセルされました", True)

    # 結果を判定
    if ret == DialogResult.Yes:
        rebuild = False
    else:
        rebuild = True
    return rebuild

#-[ デバッガ ]----------------------------------------------------------------

#
# 関数:デバッガをE1(Serial)へ変更
#
def change_debugger_e1s():
    # ログ表示
    output_log("デバッガをE1(Serial)へ変更しています")

    # デバッガ変更
    if e1 == True:
        ret = debugger.DebugTool.Change(DebugTool.E1Serial)
    else:
        ret = debugger.DebugTool.Change(DebugTool.Simulator)

    # 結果評価
    if ret == True:
        output_log("デバッガをE1(Serial)へ変更しました")
    else:
        output_log("デバッガのE1(Serial)への変更に失敗しました", True)

#
# 関数:デバッガをE1(LPD)へ変更
#
def change_debugger_e1l():
    # ログ表示
    output_log("デバッガをE1(LPD)へ変更しています")

    # デバッガ変更
    ret = debugger.DebugTool.Change(DebugTool.E1Lpd)

    # 結果評価
    if ret == True:
        output_log("デバッガをE1(LPD)へ変更しました")
    else:
        output_log("デバッガのE1(LPD)への変更に失敗しました", True)

#
# 関数:デバッガをIECUBEへ変更
#
def change_debugger_iecube():
    # ログ表示
    output_log("デバッガをIECUBEへ変更しています")

    # デバッガ変更
    ret = debugger.DebugTool.Change(DebugTool.Iecube)

    # 結果評価
    if ret == True:
        output_log("デバッガをIECUBEへ変更しました")
    else:
        output_log("デバッガのIECUBEへの変更に失敗しました", True)

#
# 関数:デバッガをSimへ変更
#
def change_debugger_sim():
    # ログ表示
    output_log("デバッガをSimへ変更しています")

    # デバッガ変更
    ret = debugger.DebugTool.Change(DebugTool.Simulator)

    # 結果評価
    if ret == True:
        output_log("デバッガをSimへ変更しました")
    else:
        output_log("デバッガのSimへの変更に失敗しました", True)

#
# 関数:デバッガへ接続
#
def connect_debugger():
    # ログ表示
    output_log("デバッガへ接続しています")

    # デバッガへ接続
    ret = debugger.Connect()

    # 結果評価
    if ret == True:
        output_log("デバッガへ接続成功しました")
    else:
        output_log("デバッガへ接続できませんでした", True)

#
# 関数:デバッガを切り離す
#
def disconnect_debugger():
    # ログ表示
    output_log("デバッガを切り離しています")

    # デバッガを切断
    ret = debugger.Disconnect()

    # 結果評価
    if ret == True:
        output_log("デバッガを切断しました")
    else:
        output_log("デバッガを切断できませんでした", True)

#
# 関数:メッセージボックスでデバッガタイプを選択(E1Serial)
#
def select_debugger_e1s():
    # メッセージボックスでデバッガタイプを選択
    output_log("デバッガ選択(はい:E1(Serial) いいえ:Sim)")
    ret = MessageBox.Show("E1(Serial)を使用しますか？", "デバッガ選択", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question)

    # キャンセルされたら終了する
    if ret == DialogResult.Cancel:
        output_log("キャンセルされました", True)

    # 結果を判定
    if ret == DialogResult.Yes:
        e1s = True
    else:
        e1s = False
    return e1s

#-[ 実行制御 ]----------------------------------------------------------------

#
# 関数:ロードモジュールをダウンロード
#
def download_module():
    # ログ表示
    output_log("ロードモジュールをダウンロードしています")

    # ダウンロード
    ret = debugger.Download.LoadModule()

    # 結果評価
    if ret == True:
        info = debugger.Download.Information()
        output_log("ロードモジュールをダウンロードしました " + info[0].Name)
    else:
        output_log("ロードモジュールをダウンロードできませんでした", True)

#
# 関数:プログラムをリセット後に実行
#
def reset_and_go(wait):
    # ログ表示
    if wait == True:
        output_log("リセット後スタートします(ブレークするまで待機)")
    else:
        output_log("リセット後スタートします(待機しない)")

    # リセット後に実行
    debugger.Run()

#
# 関数:強制ストップ
#
def force_stop():
    # ログ表示
    output_log("強制ストップします")

    # 強制ストップ
    debugger.Stop()

#-[ ブレークポイント ]--------------------------------------------------------


#
# 関数:ブレークポイントをすべて削除
#
def clear_breakpoint():
    # ログ表示
    output_log("ブレークポイントをすべて削除します")

    # すべて削除
    ret = debugger.Breakpoint.Delete()

    # 結果評価
    if ret != True:
        output_log("ブレークポイントを削除できませんでした", True)

#
# 関数:実行時ブレークポイントを追加
#
def add_execbreak(name, hardware=True):
    # ブレークポイントオブジェクトを作成
    executeBreak = BreakCondition()
    executeBreak.Address = name
    if hardware == True:
        executeBreak.BreakType = BreakType.Hardware
    else:
        executeBreak.BreakType = BreakType.Software

    # ブレークポイントを追加
    ret = debugger.Breakpoint.Set(executeBreak)

    # 結果評価
    if ret == True:
        if hardware == True:
            output_log("実行時ハードウェアブレークポイントを追加しました " + name)
        else:
            output_log("実行時ソフトウェアブレークポイントを追加しました " + name)
    else:
        output_log("ブレークポイントの追加に失敗しました" + name, True)

#
# 関数:ブレーク時にPCからジャンプ
#
def view_break():
   # PCを取得
   pc = debugger.GetPC()

   # ログ表示
   pcMsg = "%x" % pc
   output_log("ブレークしました PC=0x" + pcMsg)

   # ジャンプ
   debugger.Jump.Address(JumpType.Source, pc)

#
# メイン(ビルド)
#
rebuild = select_build()
build_project(rebuild)

#
# メイン(デバッグ開始)
#
if debugger.IsConnected() == True:
    if debugger.IsRunning == True:
       force_stop()
    disconnect_debugger()
e1s = select_debugger()
if e1s == True:
    change_debugger_e1s()
else:
    change_debugger_sim()
connect_debugger()
download_module()
clear_breakpoint()
add_execbreak("R_TAU0_Channel0_Start")
reset_and_go(True)

view_break()
save_screen("TAU0_Ch0_Start")

#
# メイン(デバッグ終了)
#
if debugger.IsConnected() == True:
    if debugger.IsRunning == True:
       force_stop()
    disconnect_debugger()

#
# 終了
#
output_log("正常終了しました")
save_screen("終了")
logFile.close()
