/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ LEDhCo ]
 */

#include "common.h"
#include "iodefine.h"
#include "cpu.h"
#include "led.h"

/*
 * SFRݒl(P6WX^)
 */
#define RL78F_P6_LED1			((u1)(0x80))
									/* P67(Lxœ_) */
#define RL78F_P6_LED2			((u1)(0x40))
									/* P66(LExœ_) */

/*
 * LED
 * O[oϐ
 */
static u1 led_sts;
									/* |[g6o̓b`(LED1,LED2̂) */

/*
 * LED
 * 
 */
void led_init(void)
{
	u1 dir;

	/* |[g6̕ݒ肷 */
	dir = (RL78F_P6_LED1 | RL78F_P6_LED2);
	PM6 &= (u1)(~dir);

	/* Ԃ͋ɓ_ */
	led_sts = (u1)(~(RL78F_P6_LED1 | RL78F_P6_LED2));
	P6 &= (u1)(~(RL78F_P6_LED1 | RL78F_P6_LED2));
}

/*
 * LED
 * _
 */
void led_on(u1 ledno)
{
	u1 psw;

	/* 荞݋֎~ */
	psw = cpu_di();

	/* LEDԍ */
	if (0 == ledno)
	{
		/* LED1 */
		led_sts &= (u1)(~RL78F_P6_LED1);
		P6 &= (u1)(~RL78F_P6_LED1);
	}
	else
	{
		/* LED2 */
		led_sts &= (u1)(~RL78F_P6_LED2);
		P6 &= (u1)(~RL78F_P6_LED2);
	}

	/* 荞ݕA */
	cpu_ei(psw);
}

/*
 * LED
 * 
 */
void led_off(u1 ledno)
{
	u1 psw;

	/* 荞݋֎~ */
	psw = cpu_di();

	/* LEDԍ */
	if (0 == ledno)
	{
		/* LED1 */
		led_sts |= RL78F_P6_LED1;
		P6 |= RL78F_P6_LED1;
	}
	else
	{
		/* LED2 */
		led_sts |= RL78F_P6_LED2;
		P6 |= RL78F_P6_LED2;
	}

	/* 荞ݕA */
	cpu_ei(psw);
}
