/*
 * CAN Target Simulator
 * for Windows(x86) + Visual Studio Express 2013 for Windows Desktop
 *
 * [ TvAv]
 */

#include "Helper.h"

/*
 * SFR`
 */
#define C0CTLR						(0xD7C0)
#define C0STR						(0xD7C2)
#define C0BCR						(0xD7C4)

/*
 * R}hs
 */
void Command(u4 cmd)
{
	u1 data8;
	u2 data16;

	switch (cmd)
	{
		/* R}h0:Xe[^XWX^ǂݏo */
		case 0:
			data16 = Read16bit(C0STR);
			Log16bit("C0STRWX^", data16);
			break;

		/* R}h1: X[v[h */
		case 1:
			/* ANDSLPMrbg𗎂Ƃ */
			data16 = Read16bit(C0CTLR);
			data16 &= ~0x0004;
			Write16bit(C0CTLR, data16);

			/* Xe[^XWX^SLPST0ɂȂ܂ő҂ */
			for (;;)
			{
				data8 = Read8bit(C0STR);
				if ((data8 & 0x04) == 0)
				{
					break;
				}
			}
			LogMsg("X[v[h");
			break;

		/* R}h2:NbNIуrbgRtBM[V */
		case 2:
			Write32bit(C0BCR, 0x0003A003);
			Log32bit("C0BCR+C0CLKR", Read32bit(C0BCR));
			break;
	}
}
