//
// CAN/LIN Checker for RL78/F14
//
// Target: Win32(Visual Studio Express 2013 for Windows Desktop)
// Author: Yasushi Tanaka
//
// [ COM|[gfoCX ]
//

#include "StdAfx.h"
#include "CommDevice.h"

//
// CommDevice()
// RXgN^(Ȃ)
//
CommDevice::CommDevice()
{
	// o
	m_pFriendlyName = NULL;
	m_pPortName = NULL;
	m_hPort = INVALID_HANDLE_VALUE;
}

//
// CommDevice()
// RXgN^()
//
CommDevice::CommDevice(_TCHAR* pFriendly, _TCHAR* pPort)
{
	size_t nLen;

	// o
	m_pFriendlyName = NULL;
	m_pPortName = NULL;
	m_hPort = INVALID_HANDLE_VALUE;

	// thl[
	if (pFriendly != NULL)
	{
		nLen = _tcslen(pFriendly);
		m_pFriendlyName = new _TCHAR[nLen + 1];
		_tcscpy_s(m_pFriendlyName, (size_t)(nLen + 1), pFriendly);
	}

	// |[gl[
	if (pPort != NULL)
	{
		nLen = _tcslen(pPort);
		m_pPortName = new _TCHAR[nLen + 1];
		_tcscpy_s(m_pPortName, (size_t)(nLen + 1), pPort);
	}
}

//
// CommDevice()
// Rs[RXgN^
//
CommDevice::CommDevice(const CommDevice& src)
{
	const _TCHAR *pName;
	size_t nLen;

	// o
	m_pFriendlyName = NULL;
	m_pPortName = NULL;
	m_hPort = INVALID_HANDLE_VALUE;

	// thl[
	pName = src.GetFriendlyName();
	if (pName != NULL)
	{
		nLen = _tcslen(pName);
		m_pFriendlyName = new _TCHAR[nLen + 1];
		_tcscpy_s(m_pFriendlyName, (size_t)(nLen + 1), pName);
	}

	// |[gl[
	pName = src.GetPortName();
	if (pName != NULL)
	{
		nLen = _tcslen(pName);
		m_pPortName = new _TCHAR[nLen + 1];
		_tcscpy_s(m_pPortName, (size_t)(nLen + 1), pName);
	}
}

//
// ~CommDevice()
// fXgN^
//
CommDevice::~CommDevice()
{
	// I
	DeInit();
}

//
// Init()
// 
//
BOOL CommDevice::Init()
{
	return TRUE;
}

//
// DeInit()
// I
//
void CommDevice::DeInit()
{
	// N[Y
	Close();

	// 
	if (m_pPortName != NULL)
	{
		delete[] m_pPortName;
		m_pPortName = NULL;
	}

	if (m_pFriendlyName != NULL)
	{
		delete[] m_pFriendlyName;
		m_pFriendlyName = NULL;
	}
}

//
// Open()
// I[v
//
BOOL CommDevice::Open()
{
	_TCHAR szPortName[32];
	DCB dcb;
	COMMTIMEOUTS cto;

	_stprintf_s(szPortName, _countof(szPortName), _T("\\\\.\\%s"), m_pPortName);

	// I[v݂
	m_hPort = CreateFile(
		szPortName,
		GENERIC_READ | GENERIC_WRITE,
		0,
		NULL,
		OPEN_EXISTING,
		0,
		NULL);

	// DCB̎擾
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		ZeroMemory(&dcb, sizeof(dcb));
		dcb.DCBlength = sizeof(dcb);
		if (GetCommState(m_hPort, &dcb) == FALSE)
		{
			// DCB̎擾Ɏs
			Close();
		}
	}

	// DCB̐ݒ
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		// {[[g500kbps, 8rbg, peBȂ, 1Xgbvrbg
		dcb.BaudRate = 500000;
		dcb.fBinary = TRUE;
		dcb.fParity = FALSE;
		dcb.fOutxCtsFlow = FALSE;
		dcb.fOutxDsrFlow = FALSE;
		dcb.fDtrControl = DTR_CONTROL_ENABLE;
		dcb.fDsrSensitivity = FALSE;
		dcb.fTXContinueOnXoff = TRUE;
		dcb.fOutX = FALSE;
		dcb.fInX = FALSE;
		dcb.fErrorChar = FALSE;
		dcb.fNull = FALSE;
		dcb.fRtsControl = RTS_CONTROL_ENABLE;
		dcb.fAbortOnError = FALSE;
		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;

		if (SetCommState(m_hPort, &dcb) == FALSE)
		{
			// DCB̐ݒɎs
			Close();
		}
	}

	// ^CAEg̐ݒ
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		// 1oCgԂ̃^CAEg50msAM\oCg~25ms҂
		cto.ReadIntervalTimeout = 50;
		cto.ReadTotalTimeoutConstant = 25;
		cto.ReadTotalTimeoutMultiplier = 1;

		// M\oCg~25ms҂
		cto.WriteTotalTimeoutConstant = 25;
		cto.WriteTotalTimeoutMultiplier = 1;

		if (SetCommTimeouts(m_hPort, &cto) == FALSE)
		{
			// ^CAEg̐ݒɎs
			Close();
		}
	}

	// o̓obt@TCY̐ݒ
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		// ̓obt@0x2000oCgAo̓obt@0x1000oCgɐݒ
		if (SetupComm(m_hPort, 0x2000, 0x1000) == 0)
		{
			// Cxg}XN̐ݒɎs
			Close();
		}
	}

	// Cxg}XN̐ݒ
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		if (SetCommMask(m_hPort, 0) == 0)
		{
			// Cxg}XN̐ݒɎs
			Close();
		}
	}

	// u[NԂ̉
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		if (ClearCommBreak(m_hPort) == FALSE)
		{
			// u[NԂ̉Ɏs
			Close();
		}
	}

	// Mobt@̃NA
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		if (PurgeComm(m_hPort, PURGE_RXCLEAR | PURGE_TXCLEAR) == FALSE)
		{
			// Mobt@̃NAɎs
			Close();
		}
	}

	// m_hPortINVALID_HANDLE_VALUEȊOł΃I[vłĂ
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

//
// Close()
// N[Y
//
void CommDevice::Close()
{
	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		CloseHandle(m_hPort);
		m_hPort = INVALID_HANDLE_VALUE;
	}
}

//
// Read()
// M
//
DWORD CommDevice::Read(LPBYTE pData, DWORD dwMaxBytes)
{
	COMSTAT stat;
	DWORD dwError;
	DWORD dwBytes;

	// dwBytes
	dwBytes = 0;

	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		// ݂̎Mobt@̃f[^𓾂
		dwError = 0;
		if (ClearCommError(m_hPort, &dwError, &stat) == TRUE)
		{
			// M0ȏłΎM
			if (stat.cbInQue > 0)
			{
				// dwMaxBytesstat.cbInQueAǂ炩Ȃ
				if (dwMaxBytes < stat.cbInQue)
				{
					stat.cbInQue = dwMaxBytes;
				}

				// M
				if (ReadFile(
					m_hPort,
					pData,
					stat.cbInQue,
					&dwBytes,
					NULL) == FALSE)
				{
					// Ms
					dwBytes = 0;
				}
			}

			// t[~OG[܂̓I[o[G[Ă0
			if ((dwError & (CE_FRAME | CE_OVERRUN | CE_RXOVER)) != 0)
			{
				// G[o
				dwBytes = 0;
			}
		}
	}

	return dwBytes;
}

//
// Write()
// M
//
BOOL CommDevice::Write(const LPBYTE pData, DWORD dwBytes)
{
	DWORD dwWritten;
	BOOL bResult;

	// bRseultFALSEŏ
	bResult = FALSE;

	if (m_hPort != INVALID_HANDLE_VALUE)
	{
		bResult = WriteFile(
					m_hPort,
					pData,
					dwBytes,
					&dwWritten,
					NULL);

		if (bResult == TRUE)
		{
			// dwBytesdwWrittenr
			if (dwBytes != dwWritten)
			{
				// \肵ĂoCg𑗐MłȂ
				bResult = FALSE;
			}
		}
	}

	return bResult;
}

//
// GetFriendlyName()
// thl[̃|C^擾
//
const _TCHAR* CommDevice::GetFriendlyName() const
{
	return m_pFriendlyName;
}

//
// GetPortName()
// |[gl[̃|C^擾
//
const _TCHAR* CommDevice::GetPortName() const
{
	return m_pPortName;
}
