;------------------------------------------------------------------------
;                                                                       |
;                                                                       |
;                                                                       |
;   DESCRIPTION :define the sfr register. (for Assembler language)      |
;                                                                       |
;                                                                       |
;   This file is generated by Renesas Project Generator.                |
;                                                                       |
;------------------------------------------------------------------------
;*******************************************************************************
;*
;* Device     : M16C/5M
;*
;* File Name  : sfr5m.inc
;*
;* Abstract   : Definition of I/O Register.
;*
;* History    : 0.12  (2009-03-18) [Hardware Manual Revision : 0.12]
;*            : 0.13  (2009-10-30) [Hardware Manual Revision : 0.13]
;*            : 0.20  (2010-03-08) [Hardware Manual Revision : 0.20]
;*            : 1.00  (2010-05-06) [Hardware Manual Revision : 1.00]
;*            : 1.01  (2010-06-01) [Hardware Manual Revision : 1.00]
;*            : 1.02  (2010-06-30) [Hardware Manual Revision : 1.01]
;*
;* NOTE       : THIS IS A TYPICAL EXAMPLE.
;*
;*  Copyright (C) 2009(2010) Renesas Electronics Corporation and
;*  Renesas Solutions Corp. All rights reserved.
;*
;*******************************************************************************/
;********************************************************************************
;*  Definition of SFR                                                           *
;********************************************************************************
;*------------------------------------------------------------------------------*
;*  Processor Mode Register 0                                                   *
;*------------------------------------------------------------------------------*
pm0			.equ	0004h
;
pm03			.btequ		3,pm0		; Software reset bit
;
;*------------------------------------------------------------------------------*
;*  Processor Mode Register 1                                                   *
;*------------------------------------------------------------------------------*
pm1			.equ	0005h
;
pm10			.btequ		0,pm1		; Data flash enable bit
pm12			.btequ		2,pm1		; Watchdog timer function select bit
pm17			.btequ		7,pm1		; Wait bit
;
;*------------------------------------------------------------------------------*
;*  System Clock Control Register 0                                             *
;*------------------------------------------------------------------------------*
cm0			.equ	0006h
;
cm00			.btequ		0,cm0		; Clock output function select bit
cm01			.btequ		1,cm0		; Clock output function select bit
cm02			.btequ		2,cm0		; Wait mode peripheral function clock stop bit
cm03			.btequ		3,cm0		; XCIN-XCOUT drive capacity select bit
cm04			.btequ		4,cm0		; Port XC select bit
cm05			.btequ		5,cm0		; Main clock stop bit
cm06			.btequ		6,cm0		; Main clock division select bit 0
cm07			.btequ		7,cm0		; System clock select bit
;
;*------------------------------------------------------------------------------*
;*  System Clock Control Register 1                                             *
;*------------------------------------------------------------------------------*
cm1			.equ	0007h
;
cm10			.btequ		0,cm1		; All clock stop control bit
cm11			.btequ		1,cm1		; System clock select bit 1
cm13			.btequ		3,cm1		; XIN-XOUT feedback register select bit
cm14			.btequ		4,cm1		; 125kHz on-chip oscillator stop bit
cm15			.btequ		5,cm1		; XIN-XOUT drive capacity select bit
cm16			.btequ		6,cm1		; Main clock division select bit 1
cm17			.btequ		7,cm1		; Main clock division select bit 1
;
;*------------------------------------------------------------------------------*
;*  Protect Register                                                            *
;*------------------------------------------------------------------------------*
prcr		.equ	000Ah
;
prc0			.btequ		0,prcr		; Protect bit 0
prc1			.btequ		1,prcr		; Protect bit 1
prc2			.btequ		2,prcr		; Protect bit 2
prc3			.btequ		3,prcr		; Protect bit 3
prc6			.btequ		6,prcr		; Protect bit 6
prc7			.btequ		7,prcr		; Protect bit 7
;
;*------------------------------------------------------------------------------*
;*  Oscillation Stop Detection Register                                         *
;*------------------------------------------------------------------------------*
cm2			.equ	000Ch
;
cm20			.btequ		0,cm2		; Oscillator stop/restart detect enable bit
cm21			.btequ		1,cm2		; System clock select bit 2
cm22			.btequ		2,cm2		; Oscillator stop/restart detect flag
cm23			.btequ		3,cm2		; XIN monitor flag
cm27			.btequ		7,cm2		; Operation select bit(when an oscillator stop/restart is detected)
;
;*------------------------------------------------------------------------------*
;*  Program 2 Area Control Register                                             *
;*------------------------------------------------------------------------------*
prg2c		.equ	0010h
;
prg2c0			.btequ		0,prg2c		; Program ROM 2 disable bit
;
;*------------------------------------------------------------------------------*
;*  Peripheral Clock Select Register                                            *
;*------------------------------------------------------------------------------*
pclkr		.equ	0012h
;
pclk0			.btequ		0,pclkr		; Timers A, B, S, multi-master I2C bus interface clock select bit(clock source for timers A , B, S,dead time timer, and multi-master I2C bus interface)
pclk1			.btequ		1,pclkr		; SI/O clock select bit(clock source for UART0 to UART4)
pclk5			.btequ		5,pclkr		; Clock output function extension bit
;
;*------------------------------------------------------------------------------*
;*  Clock Prescaler Reset Flag                                                  *
;*------------------------------------------------------------------------------*
cpsrf		.equ	0015h
;
cpsr			.btequ		7,cpsrf		; Clock prescaler reset flag
;
;*------------------------------------------------------------------------------*
;*  Reset Source Determine Register                                             *
;*------------------------------------------------------------------------------*
rstfr		.equ	0018h
;
hwr				.btequ		1,rstfr		; Hardware reset detection flag
swr				.btequ		2,rstfr		; Software reset detection flag
wdr				.btequ		3,rstfr		; Watchdog timer reset detection flag
lvd2r			.btequ		5,rstfr		; Voltage monitor 2 reset detection flag
osdr			.btequ		6,rstfr		; Oscillation stop detection reset detection flag
;
;*------------------------------------------------------------------------------*
;*  Voltage Detector 2 Flag Register                                            *
;*------------------------------------------------------------------------------*
vcr1		.equ	0019h
;
vc13			.btequ		3,vcr1		; Low-voltage monitor flag
;
;*------------------------------------------------------------------------------*
;*  Voltage Detector Operation Enable Register                                  *
;*------------------------------------------------------------------------------*
vcr2		.equ	001Ah
;
vc25			.btequ		5,vcr2		; Voltage detector 0 enable bit
vc27			.btequ		7,vcr2		; Voltage detector 2 enable bit
;
;*------------------------------------------------------------------------------*
;*  PLL Control Register 0                                                      *
;*------------------------------------------------------------------------------*
plc0		.equ	001Ch
;
plc00			.btequ		0,plc0		; PLL multiplying factor select bit
plc01			.btequ		1,plc0		; PLL multiplying factor select bit
plc02			.btequ		2,plc0		; PLL multiplying factor select bit
plc04			.btequ		4,plc0		; Reference frequency counter set bit
plc05			.btequ		5,plc0		; Reference frequency counter set bit
plc07			.btequ		7,plc0		; Operation enable bit
;
;*------------------------------------------------------------------------------*
;*  Processor Mode Register 2                                                   *
;*------------------------------------------------------------------------------*
pm2			.equ	001Eh
;
pm21			.btequ		1,pm2		; System clock protection bit
pm24			.btequ		4,pm2		; NMI~ interrupt enable bit
pm25			.btequ		5,pm2		; Peripheral clock fC provide bit
;
;*------------------------------------------------------------------------------*
;*  40 MHz On-Chip Oscillator Control Register 0                                *
;*------------------------------------------------------------------------------*
fra0		.equ	0022h
;
fra00			.btequ		0,fra0		; 40 MHz on-chip oscillator start bit
fra01			.btequ		1,fra0		; On-chip oscillator select bit
;
;*------------------------------------------------------------------------------*
;*  40 MHz On-Chip Oscillator Control Register 2                                *
;*------------------------------------------------------------------------------*
fra2		.equ	0024h
;
fra20			.btequ		0,fra2		; 40 MHz on-chip oscillator division select bit
fra21			.btequ		1,fra2		; 40 MHz on-chip oscillator division select bit
fra22			.btequ		2,fra2		; 40 MHz on-chip oscillator division select bit
;
;*------------------------------------------------------------------------------*
;*  Voltage Monitor Function Select Register                                    *
;*------------------------------------------------------------------------------*
vwce		.equ	0026h
;
vw12e			.btequ		0,vwce		; Voltage monitor 2 enable bit
;
;*------------------------------------------------------------------------------*
;*  Voltage Detector 2 Level Select Register                                    *
;*------------------------------------------------------------------------------*
vd2ls		.equ	0028h
;
vd2ls0			.btequ		0,vd2ls		; Vdet2 select bit
vd2ls1			.btequ		1,vd2ls		; Vdet2 select bit
vd2ls2			.btequ		2,vd2ls		; Vdet2 select bit
vd2ls3			.btequ		3,vd2ls		; Vdet2 select bit
;
;*------------------------------------------------------------------------------*
;*  Voltage Monitor 0 Control Register                                          *
;*------------------------------------------------------------------------------*
vw0c		.equ	002Ah
;
vw0c0			.btequ		0,vw0c		; Voltage monitor 0 reset enable bit
;
;*------------------------------------------------------------------------------*
;*  Voltage Monitor 2 Control Register                                          *
;*------------------------------------------------------------------------------*
vw2c		.equ	002Ch
;
vw2c0			.btequ		0,vw2c		; Voltage monitor 2 interrupt/reset enable bit
vw2c1			.btequ		1,vw2c		; Voltage monitor 2 digital filter disable mode select bit
vw2c2			.btequ		2,vw2c		; Voltage change detection flag
vw2c3			.btequ		3,vw2c		; Watchdog timer detection flag
vw2f0			.btequ		4,vw2c		; Sampling clock select bit
vw2f1			.btequ		5,vw2c		; Sampling clock select bit
vw2c6			.btequ		6,vw2c		; Voltage monitor 2 mode select bit
vw2c7			.btequ		7,vw2c		; Voltage monitor 2 interrupt/reset generation condition select bit
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Interrupt Control Register                                      *
;*------------------------------------------------------------------------------*
e2fic		.equ	0041h
;
ilvl0_e2fic		.btequ		0,e2fic		; Interrupt priority level select bit
ilvl1_e2fic		.btequ		1,e2fic		; Interrupt priority level select bit
ilvl2_e2fic		.btequ		2,e2fic		; Interrupt priority level select bit
ir_e2fic		.btequ		3,e2fic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  INT7 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int7ic		.equ	0042h
;
ilvl0_int7ic	.btequ		0,int7ic	; Interrupt priority level select bit
ilvl1_int7ic	.btequ		1,int7ic	; Interrupt priority level select bit
ilvl2_int7ic	.btequ		2,int7ic	; Interrupt priority level select bit
ir_int7ic		.btequ		3,int7ic	; Interrupt request bit
pol_int7ic		.btequ		4,int7ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  Serial Bus Interface 0 Interrupt Control Register                           *
;*------------------------------------------------------------------------------*
ss0ic		.equ	0042h
;
ilvl0_ss0ic		.btequ		0,ss0ic		; Interrupt priority level select bit
ilvl1_ss0ic		.btequ		1,ss0ic		; Interrupt priority level select bit
ilvl2_ss0ic		.btequ		2,ss0ic		; Interrupt priority level select bit
ir_ss0ic		.btequ		3,ss0ic		; Interrupt request bit
pol_ss0ic		.btequ		4,ss0ic		; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  INT6 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int6ic		.equ	0043h
;
ilvl0_int6ic	.btequ		0,int6ic	; Interrupt priority level select bit
ilvl1_int6ic	.btequ		1,int6ic	; Interrupt priority level select bit
ilvl2_int6ic	.btequ		2,int6ic	; Interrupt priority level select bit
ir_int6ic		.btequ		3,int6ic	; Interrupt request bit
pol_int6ic		.btequ		4,int6ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
lin0ic		.equ	0043h
;
ilvl0_lin0ic	.btequ		0,lin0ic	; Interrupt priority level select bit
ilvl1_lin0ic	.btequ		1,lin0ic	; Interrupt priority level select bit
ilvl2_lin0ic	.btequ		2,lin0ic	; Interrupt priority level select bit
ir_lin0ic		.btequ		3,lin0ic	; Interrupt request bit
pol_lin0ic		.btequ		4,lin0ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  INT3 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int3ic		.equ	0044h
;
ilvl0_int3ic	.btequ		0,int3ic	; Interrupt priority level select bit
ilvl1_int3ic	.btequ		1,int3ic	; Interrupt priority level select bit
ilvl2_int3ic	.btequ		2,int3ic	; Interrupt priority level select bit
ir_int3ic		.btequ		3,int3ic	; Interrupt request bit
pol_int3ic		.btequ		4,int3ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  Timer B5 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
tb5ic		.equ	0045h
;
ilvl0_tb5ic		.btequ		0,tb5ic		; Interrupt priority level select bit
ilvl1_tb5ic		.btequ		1,tb5ic		; Interrupt priority level select bit
ilvl2_tb5ic		.btequ		2,tb5ic		; Interrupt priority level select bit
ir_tb5ic		.btequ		3,tb5ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer B4 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
tb4ic		.equ	0046h
;
ilvl0_tb4ic		.btequ		0,tb4ic		; Interrupt priority level select bit
ilvl1_tb4ic		.btequ		1,tb4ic		; Interrupt priority level select bit
ilvl2_tb4ic		.btequ		2,tb4ic		; Interrupt priority level select bit
ir_tb4ic		.btequ		3,tb4ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer B3 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
tb3ic		.equ	0047h
;
ilvl0_tb3ic		.btequ		0,tb3ic		; Interrupt priority level select bit
ilvl1_tb3ic		.btequ		1,tb3ic		; Interrupt priority level select bit
ilvl2_tb3ic		.btequ		2,tb3ic		; Interrupt priority level select bit
ir_tb3ic		.btequ		3,tb3ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  INT5 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int5ic		.equ	0048h
;
ilvl0_int5ic	.btequ		0,int5ic	; Interrupt priority level select bit
ilvl1_int5ic	.btequ		1,int5ic	; Interrupt priority level select bit
ilvl2_int5ic	.btequ		2,int5ic	; Interrupt priority level select bit
ir_int5ic		.btequ		3,int5ic	; Interrupt request bit
pol_int5ic		.btequ		4,int5ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  INT4 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int4ic		.equ	0049h
;
ilvl0_int4ic	.btequ		0,int4ic	; Interrupt priority level select bit
ilvl1_int4ic	.btequ		1,int4ic	; Interrupt priority level select bit
ilvl2_int4ic	.btequ		2,int4ic	; Interrupt priority level select bit
ir_int4ic		.btequ		3,int4ic	; Interrupt request bit
pol_int4ic		.btequ		4,int4ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Bus Collision Detection Interrupt Control Register                    *
;*------------------------------------------------------------------------------*
bcnic		.equ	004Ah
;
ilvl0_bcnic		.btequ		0,bcnic		; Interrupt priority level select bit
ilvl1_bcnic		.btequ		1,bcnic		; Interrupt priority level select bit
ilvl2_bcnic		.btequ		2,bcnic		; Interrupt priority level select bit
ir_bcnic		.btequ		3,bcnic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Task Monitoring Timer Interrupt Control Register                            *
;*------------------------------------------------------------------------------*
tmosic		.equ	004Ah
;
ilvl0_tmosic	.btequ		0,tmosic	; Interrupt priority level select bit
ilvl1_tmosic	.btequ		1,tmosic	; Interrupt priority level select bit
ilvl2_tmosic	.btequ		2,tmosic	; Interrupt priority level select bit
ir_tmosic		.btequ		3,tmosic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  DMA0 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
dm0ic		.equ	004Bh
;
ilvl0_dm0ic		.btequ		0,dm0ic		; Interrupt priority level select bit
ilvl1_dm0ic		.btequ		1,dm0ic		; Interrupt priority level select bit
ilvl2_dm0ic		.btequ		2,dm0ic		; Interrupt priority level select bit
ir_dm0ic		.btequ		3,dm0ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  DMA1 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
dm1ic		.equ	004Ch
;
ilvl0_dm1ic		.btequ		0,dm1ic		; Interrupt priority level select bit
ilvl1_dm1ic		.btequ		1,dm1ic		; Interrupt priority level select bit
ilvl2_dm1ic		.btequ		2,dm1ic		; Interrupt priority level select bit
ir_dm1ic		.btequ		3,dm1ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Key Input Interrupt Control Register                                        *
;*------------------------------------------------------------------------------*
kupic		.equ	004Dh
;
ilvl0_kupic		.btequ		0,kupic		; Interrupt priority level select bit
ilvl1_kupic		.btequ		1,kupic		; Interrupt priority level select bit
ilvl2_kupic		.btequ		2,kupic		; Interrupt priority level select bit
ir_kupic		.btequ		3,kupic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  A/D Conversion Interrupt Control Register                                   *
;*------------------------------------------------------------------------------*
adic		.equ	004Eh
;
ilvl0_adic		.btequ		0,adic		; Interrupt priority level select bit
ilvl1_adic		.btequ		1,adic		; Interrupt priority level select bit
ilvl2_adic		.btequ		2,adic		; Interrupt priority level select bit
ir_adic			.btequ		3,adic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Transmit Interrupt Control Register                                   *
;*------------------------------------------------------------------------------*
s2tic		.equ	004Fh
;
ilvl0_s2tic		.btequ		0,s2tic		; Interrupt priority level select bit
ilvl1_s2tic		.btequ		1,s2tic		; Interrupt priority level select bit
ilvl2_s2tic		.btequ		2,s2tic		; Interrupt priority level select bit
ir_s2tic		.btequ		3,s2tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Receive Interrupt Control Register                                    *
;*------------------------------------------------------------------------------*
s2ric		.equ	0050h
;
ilvl0_s2ric		.btequ		0,s2ric		; Interrupt priority level select bit
ilvl1_s2ric		.btequ		1,s2ric		; Interrupt priority level select bit
ilvl2_s2ric		.btequ		2,s2ric		; Interrupt priority level select bit
ir_s2ric		.btequ		3,s2ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART0 Transmit Interrupt Control Register                                   *
;*------------------------------------------------------------------------------*
s0tic		.equ	0051h
;
ilvl0_s0tic		.btequ		0,s0tic		; Interrupt priority level select bit
ilvl1_s0tic		.btequ		1,s0tic		; Interrupt priority level select bit
ilvl2_s0tic		.btequ		2,s0tic		; Interrupt priority level select bit
ir_s0tic		.btequ		3,s0tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Low Detection Interrupt Control Register                               *
;*------------------------------------------------------------------------------*
l0wic		.equ	0051h
;
ilvl0_l0wic		.btequ		0,l0wic		; Interrupt priority level select bit
ilvl1_l0wic		.btequ		1,l0wic		; Interrupt priority level select bit
ilvl2_l0wic		.btequ		2,l0wic		; Interrupt priority level select bit
ir_l0wic		.btequ		3,l0wic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART0 Receive Interrupt Control Register                                    *
;*------------------------------------------------------------------------------*
s0ric		.equ	0052h
;
ilvl0_s0ric		.btequ		0,s0ric		; Interrupt priority level select bit
ilvl1_s0ric		.btequ		1,s0ric		; Interrupt priority level select bit
ilvl2_s0ric		.btequ		2,s0ric		; Interrupt priority level select bit
ir_s0ric		.btequ		3,s0ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART1 Transmit Interrupt Control Register                                   *
;*------------------------------------------------------------------------------*
s1tic		.equ	0053h
;
ilvl0_s1tic		.btequ		0,s1tic		; Interrupt priority level select bit
ilvl1_s1tic		.btequ		1,s1tic		; Interrupt priority level select bit
ilvl2_s1tic		.btequ		2,s1tic		; Interrupt priority level select bit
ir_s1tic		.btequ		3,s1tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART1 Receive Interrupt Control Register                                    *
;*------------------------------------------------------------------------------*
s1ric		.equ	0054h
;
ilvl0_s1ric		.btequ		0,s1ric		; Interrupt priority level select bit
ilvl1_s1ric		.btequ		1,s1ric		; Interrupt priority level select bit
ilvl2_s1ric		.btequ		2,s1ric		; Interrupt priority level select bit
ir_s1ric		.btequ		3,s1ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer A0 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
ta0ic		.equ	0055h
;
ilvl0_ta0ic		.btequ		0,ta0ic		; Interrupt priority level select bit
ilvl1_ta0ic		.btequ		1,ta0ic		; Interrupt priority level select bit
ilvl2_ta0ic		.btequ		2,ta0ic		; Interrupt priority level select bit
ir_ta0ic		.btequ		3,ta0ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer A1 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
ta1ic		.equ	0056h
;
ilvl0_ta1ic		.btequ		0,ta1ic		; Interrupt priority level select bit
ilvl1_ta1ic		.btequ		1,ta1ic		; Interrupt priority level select bit
ilvl2_ta1ic		.btequ		2,ta1ic		; Interrupt priority level select bit
ir_ta1ic		.btequ		3,ta1ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer A2 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
ta2ic		.equ	0057h
;
ilvl0_ta2ic		.btequ		0,ta2ic		; Interrupt priority level select bit
ilvl1_ta2ic		.btequ		1,ta2ic		; Interrupt priority level select bit
ilvl2_ta2ic		.btequ		2,ta2ic		; Interrupt priority level select bit
ir_ta2ic		.btequ		3,ta2ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer A3 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
ta3ic		.equ	0058h
;
ilvl0_ta3ic		.btequ		0,ta3ic		; Interrupt priority level select bit
ilvl1_ta3ic		.btequ		1,ta3ic		; Interrupt priority level select bit
ilvl2_ta3ic		.btequ		2,ta3ic		; Interrupt priority level select bit
ir_ta3ic		.btequ		3,ta3ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer A4 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
ta4ic		.equ	0059h
;
ilvl0_ta4ic		.btequ		0,ta4ic		; Interrupt priority level select bit
ilvl1_ta4ic		.btequ		1,ta4ic		; Interrupt priority level select bit
ilvl2_ta4ic		.btequ		2,ta4ic		; Interrupt priority level select bit
ir_ta4ic		.btequ		3,ta4ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer B0 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
tb0ic		.equ	005Ah
;
ilvl0_tb0ic		.btequ		0,tb0ic		; Interrupt priority level select bit
ilvl1_tb0ic		.btequ		1,tb0ic		; Interrupt priority level select bit
ilvl2_tb0ic		.btequ		2,tb0ic		; Interrupt priority level select bit
ir_tb0ic		.btequ		3,tb0ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer B1 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
tb1ic		.equ	005Bh
;
ilvl0_tb1ic		.btequ		0,tb1ic		; Interrupt priority level select bit
ilvl1_tb1ic		.btequ		1,tb1ic		; Interrupt priority level select bit
ilvl2_tb1ic		.btequ		2,tb1ic		; Interrupt priority level select bit
ir_tb1ic		.btequ		3,tb1ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Timer B2 Interrupt Control Register                                         *
;*------------------------------------------------------------------------------*
tb2ic		.equ	005Ch
;
ilvl0_tb2ic		.btequ		0,tb2ic		; Interrupt priority level select bit
ilvl1_tb2ic		.btequ		1,tb2ic		; Interrupt priority level select bit
ilvl2_tb2ic		.btequ		2,tb2ic		; Interrupt priority level select bit
ir_tb2ic		.btequ		3,tb2ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  INT0 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int0ic		.equ	005Dh
;
ilvl0_int0ic	.btequ		0,int0ic	; Interrupt priority level select bit
ilvl1_int0ic	.btequ		1,int0ic	; Interrupt priority level select bit
ilvl2_int0ic	.btequ		2,int0ic	; Interrupt priority level select bit
ir_int0ic		.btequ		3,int0ic	; Interrupt request bit
pol_int0ic		.btequ		4,int0ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  INT1 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int1ic		.equ	005Eh
;
ilvl0_int1ic	.btequ		0,int1ic	; Interrupt priority level select bit
ilvl1_int1ic	.btequ		1,int1ic	; Interrupt priority level select bit
ilvl2_int1ic	.btequ		2,int1ic	; Interrupt priority level select bit
ir_int1ic		.btequ		3,int1ic	; Interrupt request bit
pol_int1ic		.btequ		4,int1ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  INT2 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
int2ic		.equ	005Fh
;
ilvl0_int2ic	.btequ		0,int2ic	; Interrupt priority level select bit
ilvl1_int2ic	.btequ		1,int2ic	; Interrupt priority level select bit
ilvl2_int2ic	.btequ		2,int2ic	; Interrupt priority level select bit
ir_int2ic		.btequ		3,int2ic	; Interrupt request bit
pol_int2ic		.btequ		4,int2ic	; Polarity select bit
;
;*------------------------------------------------------------------------------*
;*  DMA2 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
dm2ic		.equ	0069h
;
ilvl0_dm2ic		.btequ		0,dm2ic		; Interrupt priority level select bit
ilvl1_dm2ic		.btequ		1,dm2ic		; Interrupt priority level select bit
ilvl2_dm2ic		.btequ		2,dm2ic		; Interrupt priority level select bit
ir_dm2ic		.btequ		3,dm2ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  DMA3 Interrupt Control Register                                             *
;*------------------------------------------------------------------------------*
dm3ic		.equ	006Ah
;
ilvl0_dm3ic		.btequ		0,dm3ic		; Interrupt priority level select bit
ilvl1_dm3ic		.btequ		1,dm3ic		; Interrupt priority level select bit
ilvl2_dm3ic		.btequ		2,dm3ic		; Interrupt priority level select bit
ir_dm3ic		.btequ		3,dm3ic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Receive Interrupt Control Register                                     *
;*------------------------------------------------------------------------------*
c1ric		.equ	006Bh
;
ilvl0_c1ric		.btequ		0,c1ric		; Interrupt priority level select bit
ilvl1_c1ric		.btequ		1,c1ric		; Interrupt priority level select bit
ilvl2_c1ric		.btequ		2,c1ric		; Interrupt priority level select bit
ir_c1ric		.btequ		3,c1ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Transmit Interrupt Control Register                                    *
;*------------------------------------------------------------------------------*
c1tic		.equ	006Ch
;
ilvl0_c1tic		.btequ		0,c1tic		; Interrupt priority level select bit
ilvl1_c1tic		.btequ		1,c1tic		; Interrupt priority level select bit
ilvl2_c1tic		.btequ		2,c1tic		; Interrupt priority level select bit
ir_c1tic		.btequ		3,c1tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Receive FIFO Interrupt Control Register                                *
;*------------------------------------------------------------------------------*
c1fric		.equ	006Dh
;
ilvl0_c1fric	.btequ		0,c1fric	; Interrupt priority level select bit
ilvl1_c1fric	.btequ		1,c1fric	; Interrupt priority level select bit
ilvl2_c1fric	.btequ		2,c1fric	; Interrupt priority level select bit
ir_c1fric		.btequ		3,c1fric	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Transmit FIFO Interrupt Control Register                               *
;*------------------------------------------------------------------------------*
c1ftic		.equ	006Eh
;
ilvl0_c1ftic	.btequ		0,c1ftic	; Interrupt priority level select bit
ilvl1_c1ftic	.btequ		1,c1ftic	; Interrupt priority level select bit
ilvl2_c1ftic	.btequ		2,c1ftic	; Interrupt priority level select bit
ir_c1ftic		.btequ		3,c1ftic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART4 Transmit Interrupt Control Register                                   *
;*------------------------------------------------------------------------------*
s4tic		.equ	006Fh
;
ilvl0_s4tic		.btequ		0,s4tic		; Interrupt priority level select bit
ilvl1_s4tic		.btequ		1,s4tic		; Interrupt priority level select bit
ilvl2_s4tic		.btequ		2,s4tic		; Interrupt priority level select bit
ir_s4tic		.btequ		3,s4tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Compare Interrupt Control Register                          *
;*------------------------------------------------------------------------------*
rtccic		.equ	006Fh
;
ilvl0_rtccic	.btequ		0,rtccic	; Interrupt priority level select bit
ilvl1_rtccic	.btequ		1,rtccic	; Interrupt priority level select bit
ilvl2_rtccic	.btequ		2,rtccic	; Interrupt priority level select bit
ir_rtccic		.btequ		3,rtccic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART4 Receive Interrupt Control Register                                    *
;*------------------------------------------------------------------------------*
s4ric		.equ	0070h
;
ilvl0_s4ric		.btequ		0,s4ric		; Interrupt priority level select bit
ilvl1_s4ric		.btequ		1,s4ric		; Interrupt priority level select bit
ilvl2_s4ric		.btequ		2,s4ric		; Interrupt priority level select bit
ir_s4ric		.btequ		3,s4ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Wakeup Interrupt Control Register                                      *
;*------------------------------------------------------------------------------*
c0wic		.equ	0071h
;
ilvl0_c0wic		.btequ		0,c0wic		; Interrupt priority level select bit
ilvl1_c0wic		.btequ		1,c0wic		; Interrupt priority level select bit
ilvl2_c0wic		.btequ		2,c0wic		; Interrupt priority level select bit
ir_c0wic		.btequ		3,c0wic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART3 Transmit Interrupt Control Register                                   *
;*------------------------------------------------------------------------------*
s3tic		.equ	0072h
;
ilvl0_s3tic		.btequ		0,s3tic		; Interrupt priority level select bit
ilvl1_s3tic		.btequ		1,s3tic		; Interrupt priority level select bit
ilvl2_s3tic		.btequ		2,s3tic		; Interrupt priority level select bit
ir_s3tic		.btequ		3,s3tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Error Interrupt Control Register                                       *
;*------------------------------------------------------------------------------*
c0eic		.equ	0072h
;
ilvl0_c0eic		.btequ		0,c0eic		; Interrupt priority level select bit
ilvl1_c0eic		.btequ		1,c0eic		; Interrupt priority level select bit
ilvl2_c0eic		.btequ		2,c0eic		; Interrupt priority level select bit
ir_c0eic		.btequ		3,c0eic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  UART3 Receive Interrupt Control Register                                    *
;*------------------------------------------------------------------------------*
s3ric		.equ	0073h
;
ilvl0_s3ric		.btequ		0,s3ric		; Interrupt priority level select bit
ilvl1_s3ric		.btequ		1,s3ric		; Interrupt priority level select bit
ilvl2_s3ric		.btequ		2,s3ric		; Interrupt priority level select bit
ir_s3ric		.btequ		3,s3ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Wakeup Interrupt Control Register                                      *
;*------------------------------------------------------------------------------*
c1wic		.equ	0073h
;
ilvl0_c1wic		.btequ		0,c1wic		; Interrupt priority level select bit
ilvl1_c1wic		.btequ		1,c1wic		; Interrupt priority level select bit
ilvl2_c1wic		.btequ		2,c1wic		; Interrupt priority level select bit
ir_c1wic		.btequ		3,c1wic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Cycle Interrupt Control Register                            *
;*------------------------------------------------------------------------------*
rtctic		.equ	0074h
;
ilvl0_rtctic	.btequ		0,rtctic	; Interrupt priority level select bit
ilvl1_rtctic	.btequ		1,rtctic	; Interrupt priority level select bit
ilvl2_rtctic	.btequ		2,rtctic	; Interrupt priority level select bit
ir_rtctic		.btequ		3,rtctic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Error Interrupt Control Register                                       *
;*------------------------------------------------------------------------------*
c1eic		.equ	0074h
;
ilvl0_c1eic		.btequ		0,c1eic		; Interrupt priority level select bit
ilvl1_c1eic		.btequ		1,c1eic		; Interrupt priority level select bit
ilvl2_c1eic		.btequ		2,c1eic		; Interrupt priority level select bit
ir_c1eic		.btequ		3,c1eic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Receive Completion Interrupt Control Register                          *
;*------------------------------------------------------------------------------*
c0ric		.equ	0075h
;
ilvl0_c0ric		.btequ		0,c0ric		; Interrupt priority level select bit
ilvl1_c0ric		.btequ		1,c0ric		; Interrupt priority level select bit
ilvl2_c0ric		.btequ		2,c0ric		; Interrupt priority level select bit
ir_c0ric		.btequ		3,c0ric		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Transmit Completion Interrupt Control Register                         *
;*------------------------------------------------------------------------------*
c0tic		.equ	0076h
;
ilvl0_c0tic		.btequ		0,c0tic		; Interrupt priority level select bit
ilvl1_c0tic		.btequ		1,c0tic		; Interrupt priority level select bit
ilvl2_c0tic		.btequ		2,c0tic		; Interrupt priority level select bit
ir_c0tic		.btequ		3,c0tic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Receive FIFO Interrupt Control Register                                *
;*------------------------------------------------------------------------------*
c0fric		.equ	0077h
;
ilvl0_c0fric	.btequ		0,c0fric	; Interrupt priority level select bit
ilvl1_c0fric	.btequ		1,c0fric	; Interrupt priority level select bit
ilvl2_c0fric	.btequ		2,c0fric	; Interrupt priority level select bit
ir_c0fric		.btequ		3,c0fric	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Transmit FIFO Interrupt Control Register                               *
;*------------------------------------------------------------------------------*
c0ftic		.equ	0078h
;
ilvl0_c0ftic	.btequ		0,c0ftic	; Interrupt priority level select bit
ilvl1_c0ftic	.btequ		1,c0ftic	; Interrupt priority level select bit
ilvl2_c0ftic	.btequ		2,c0ftic	; Interrupt priority level select bit
ir_c0ftic		.btequ		3,c0ftic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Interrupt 0 Control Register                                          *
;*------------------------------------------------------------------------------*
icoc0ic		.equ	0079h
;
ilvl0_icoc0ic	.btequ		0,icoc0ic	; Interrupt priority level select bit
ilvl1_icoc0ic	.btequ		1,icoc0ic	; Interrupt priority level select bit
ilvl2_icoc0ic	.btequ		2,icoc0ic	; Interrupt priority level select bit
ir_icoc0ic		.btequ		3,icoc0ic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Channel 0 Interrupt Control Register                                  *
;*------------------------------------------------------------------------------*
icoch0ic	.equ	007Ah
;
ilvl0_icoch0ic	.btequ		0,icoch0ic	; Interrupt priority level select bit
ilvl1_icoch0ic	.btequ		1,icoch0ic	; Interrupt priority level select bit
ilvl2_icoch0ic	.btequ		2,icoch0ic	; Interrupt priority level select bit
ir_icoch0ic		.btequ		3,icoch0ic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Interrupt 1 Control Register                                          *
;*------------------------------------------------------------------------------*
icoc1ic		.equ	007Bh
;
ilvl0_icoc1ic	.btequ		0,icoc1ic	; Interrupt priority level select bit
ilvl1_icoc1ic	.btequ		1,icoc1ic	; Interrupt priority level select bit
ilvl2_icoc1ic	.btequ		2,icoc1ic	; Interrupt priority level select bit
ir_icoc1ic		.btequ		3,icoc1ic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  I2C-bus Interface Interrupt Control Register                                *
;*------------------------------------------------------------------------------*
iicic		.equ	007Bh
;
ilvl0_iicic		.btequ		0,iicic		; Interrupt priority level select bit
ilvl1_iicic		.btequ		1,iicic		; Interrupt priority level select bit
ilvl2_iicic		.btequ		2,iicic		; Interrupt priority level select bit
ir_iicic		.btequ		3,iicic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Channel 1 Interrupt Control Register                                  *
;*------------------------------------------------------------------------------*
icoch1ic	.equ	007Ch
;
ilvl0_icoch1ic	.btequ		0,icoch1ic	; Interrupt priority level select bit
ilvl1_icoch1ic	.btequ		1,icoch1ic	; Interrupt priority level select bit
ilvl2_icoch1ic	.btequ		2,icoch1ic	; Interrupt priority level select bit
ir_icoch1ic		.btequ		3,icoch1ic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  SCL/SDA Interrupt Control Register                                          *
;*------------------------------------------------------------------------------*
scldaic		.equ	007Ch
;
ilvl0_scldaic	.btequ		0,scldaic	; Interrupt priority level select bit
ilvl1_scldaic	.btequ		1,scldaic	; Interrupt priority level select bit
ilvl2_scldaic	.btequ		2,scldaic	; Interrupt priority level select bit
ir_scldaic		.btequ		3,scldaic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Channel 2 Interrupt Control Register                                  *
;*------------------------------------------------------------------------------*
icoch2ic	.equ	007Dh
;
ilvl0_icoch2ic	.btequ		0,icoch2ic	; Interrupt priority level select bit
ilvl1_icoch2ic	.btequ		1,icoch2ic	; Interrupt priority level select bit
ilvl2_icoch2ic	.btequ		2,icoch2ic	; Interrupt priority level select bit
ir_icoch2ic		.btequ		3,icoch2ic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Channel 3 Interrupt Control Register                                  *
;*------------------------------------------------------------------------------*
icoch3ic	.equ	007Eh
;
ilvl0_icoch3ic	.btequ		0,icoch3ic	; Interrupt priority level select bit
ilvl1_icoch3ic	.btequ		1,icoch3ic	; Interrupt priority level select bit
ilvl2_icoch3ic	.btequ		2,icoch3ic	; Interrupt priority level select bit
ir_icoch3ic		.btequ		3,icoch3ic	; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  IC/OC Base Timer Interrupt Control Register                                 *
;*------------------------------------------------------------------------------*
btic		.equ	007Fh
;
ilvl0_btic		.btequ		0,btic		; Interrupt priority level select bit
ilvl1_btic		.btequ		1,btic		; Interrupt priority level select bit
ilvl2_btic		.btequ		2,btic		; Interrupt priority level select bit
ir_btic			.btequ		3,btic		; Interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Address Register                                                *
;*------------------------------------------------------------------------------*
e2fa		.equ	0080h
;
e2fal		.equ	e2fa				; E2dataFlash Address Register(low 16bit)
e2fah		.equ	e2fa+2				; E2dataFlash Address Register(high 16bit)
e2fall		.equ	e2fa				; E2dataFlash Address Register(lowlow 8bit)
e2falh		.equ	e2fa+1				; E2dataFlash Address Register(lowhigh 8bit)
e2fahl		.equ	e2fa+2				; E2dataFlash Address Register(highlow 8bit)
e2fahh		.equ	e2fa+3				; E2dataFlash Address Register(highhigh 8bit)
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Command Register                                                *
;*------------------------------------------------------------------------------*
e2fi		.equ	0088h
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Data Register                                                   *
;*------------------------------------------------------------------------------*
e2fd		.equ	008Ch
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Mode Register                                                   *
;*------------------------------------------------------------------------------*
e2fm		.equ	0090h
;
om_e2fm			.btequ		0,e2fm		; Operating mode select bit
rst_e2fm		.btequ		1,e2fm		; E2dataFlash reset bit
ewm_e2fm		.btequ		2,e2fm		; EW mode setting bit
ecc_e2fm		.btequ		7,e2fm		; ECC control bit
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Control Register                                                *
;*------------------------------------------------------------------------------*
e2fc		.equ	0092h
;
rie_e2fc		.btequ		0,e2fc		; Ready interrupt enable bit
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Status Register 1                                               *
;*------------------------------------------------------------------------------*
e2fs1		.equ	0094h
;
omm_e2fs1		.btequ		0,e2fs1		; Operating mode monitor flag
;
;*------------------------------------------------------------------------------*
;*  E2dataFlash Status Register 0                                               *
;*------------------------------------------------------------------------------*
e2fs0		.equ	00A1h
;
werr_e2fs0		.btequ		4,e2fs0		; Program error flag
eerr_e2fs0		.btequ		5,e2fs0		; Erase error flag
rdy_e2fs0		.btequ		7,e2fs0		; Ready flag
;
;*------------------------------------------------------------------------------*
;*  LIN Wake-Up Baud Rate Select Register                                       *
;*------------------------------------------------------------------------------*
lwbr		.equ	0161h
;
lwbr0_lwbr		.btequ		0,lwbr		; Wake-up Baud Rate Select Bit
;
;*------------------------------------------------------------------------------*
;*  LIN Baud Rate Prescaler 0 Register                                          *
;*------------------------------------------------------------------------------*
lbrp0		.equ	0162h
;
;*------------------------------------------------------------------------------*
;*  LIN Baud Rate Prescaler 1 Register                                          *
;*------------------------------------------------------------------------------*
lbrp1		.equ	0163h
;
;*------------------------------------------------------------------------------*
;*  LIN Self-test Control Register                                              *
;*------------------------------------------------------------------------------*
lstc		.equ	0164h
;
lstm_lstc		.btequ		0,lstc		; Self-test Mode Bit
;
;*------------------------------------------------------------------------------*
;*  LIN Port Clock Control Register                                             *
;*------------------------------------------------------------------------------*
lpc			.equ	0165h
;
pcks_lpc		.btequ		0,lpc		; LIN Clock Source Select Bit
lpe_lpc			.btequ		2,lpc		; LIN Port Enable Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Mode Register                                                          *
;*------------------------------------------------------------------------------*
l0md		.equ	0168h
;
lcks0_l0md		.btequ		2,l0md		; LIN System Clock Select Bit
lcks1_l0md		.btequ		3,l0md		; LIN System Clock Select Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Break Field Setting Register                                           *
;*------------------------------------------------------------------------------*
l0brk		.equ	0169h
;
blt0_l0brk		.btequ		0,l0brk		; Break Transmission Setting Bit
blt1_l0brk		.btequ		1,l0brk		; Break Transmission Setting Bit
blt2_l0brk		.btequ		2,l0brk		; Break Transmission Setting Bit
blt3_l0brk		.btequ		3,l0brk		; Break Transmission Setting Bit
bdt0_l0brk		.btequ		4,l0brk		; Break Delimiter Transmission Setting Bit
bdt1_l0brk		.btequ		5,l0brk		; Break Delimiter Transmission Setting Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Space Setting Register                                                 *
;*------------------------------------------------------------------------------*
l0spc		.equ	016Ah
;
ibsh0_l0spc		.btequ		0,l0spc		; Interbyte Space (Header)/Response Space Setting Bit
ibsh1_l0spc		.btequ		1,l0spc		; Interbyte Space (Header)/Response Space Setting Bit
ibsh2_l0spc		.btequ		2,l0spc		; Interbyte Space (Header)/Response Space Setting Bit
ibs0_l0spc		.btequ		4,l0spc		; Interbyte Space Setting Bit
ibs1_l0spc		.btequ		5,l0spc		; Interbyte Space Setting Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Wake-Up Setting Register                                               *
;*------------------------------------------------------------------------------*
l0wup		.equ	016Bh
;
wutl0_l0wup		.btequ		4,l0wup		; Wake-up Transmission Low Time Pulse Width Setting Bit
wutl1_l0wup		.btequ		5,l0wup		; Wake-up Transmission Low Time Pulse Width Setting Bit
wutl2_l0wup		.btequ		6,l0wup		; Wake-up Transmission Low Time Pulse Width Setting Bit
wutl3_l0wup		.btequ		7,l0wup		; Wake-up Transmission Low Time Pulse Width Setting Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Interrupt Enable Register                                              *
;*------------------------------------------------------------------------------*
l0ie		.equ	016Ch
;
ftcie_l0ie		.btequ		0,l0ie		; Frame/Wake-up Transmit Completion Interrupt Enable Bit
frcie_l0ie		.btequ		1,l0ie		; Frame/Wake-up Receive Completion Interrupt Enable Bit
errie_l0ie		.btequ		2,l0ie		; Error Detection Interrupt Enable Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Error Detection Enable Register                                        *
;*------------------------------------------------------------------------------*
l0ede		.equ	016Dh
;
bere_l0ede		.btequ		0,l0ede		; Bit Error Detection Enable Bit
pbere_l0ede		.btequ		1,l0ede		; Physical Bus Error Detection Enable Bit
ftere_l0ede		.btequ		2,l0ede		; Frame Timeout Error Detection Enable Bit
fere_l0ede		.btequ		3,l0ede		; Framing Error Detection Enable Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Control Register                                                       *
;*------------------------------------------------------------------------------*
l0c			.equ	016Eh
;
om0_l0c			.btequ		0,l0c		; LIN Reset Bit
om1_l0c			.btequ		1,l0c		; LIN Mode Select Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Transmission Control Register                                          *
;*------------------------------------------------------------------------------*
l0tc		.equ	0170h
;
fts_l0tc		.btequ		0,l0tc		; Frame Transmission/Wake-up Transmission and Reception Start Bit
rts_l0tc		.btequ		1,l0tc		; Response Transmission Start Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Mode Status Register                                                   *
;*------------------------------------------------------------------------------*
l0mst		.equ	0171h
;
omm0_l0mst		.btequ		0,l0mst		; LIN0 Reset Status Monitor
omm1_l0mst		.btequ		1,l0mst		; LIN0 Mode Status Monitor
;
;*------------------------------------------------------------------------------*
;*  LIN0 Status Register                                                        *
;*------------------------------------------------------------------------------*
l0st		.equ	0172h
;
ftc_l0st		.btequ		0,l0st		; Frame/Wake-up Transmit Completion Flag
frc_l0st		.btequ		1,l0st		; Frame/Wake-up Receive Completion Flag
err_l0st		.btequ		3,l0st		; Error Detection Flag
d1rc_l0st		.btequ		6,l0st		; Data 1 Receive Completion Flag
htrc_l0st		.btequ		7,l0st		; Header Transmit Completion Flag
;
;*------------------------------------------------------------------------------*
;*  LIN0 Error Status Register                                                  *
;*------------------------------------------------------------------------------*
l0est		.equ	0173h
;
ber_l0est		.btequ		0,l0est		; Bit Error Flag
pber_l0est		.btequ		1,l0est		; Physical Bus Error Flag
fter_l0est		.btequ		2,l0est		; Frame Timeout Error Flag
fer_l0est		.btequ		3,l0est		; Framing Error Flag
cser_l0est		.btequ		5,l0est		; Check Sum Error Flag
;
;*------------------------------------------------------------------------------*
;*  LIN0 Response Field Setting Register                                        *
;*------------------------------------------------------------------------------*
l0rfc		.equ	0174h
;
rfdl0_l0rfc		.btequ		0,l0rfc		; Response Field Data Length Setting Bit
rfdl1_l0rfc		.btequ		1,l0rfc		; Response Field Data Length Setting Bit
rfdl2_l0rfc		.btequ		2,l0rfc		; Response Field Data Length Setting Bit
rfdl3_l0rfc		.btequ		3,l0rfc		; Response Field Data Length Setting Bit
rft_l0rfc		.btequ		4,l0rfc		; Response Field Transmit/Receive Direction Setting Bit
csm_l0rfc		.btequ		5,l0rfc		; Check Sum Model Select Bit
fsm_l0rfc		.btequ		6,l0rfc		; Frame Separate Mode Select Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 ID Buffer Register                                                     *
;*------------------------------------------------------------------------------*
l0idb		.equ	0175h
;
id0_l0idb		.btequ		0,l0idb		; ID Setting Bit
id1_l0idb		.btequ		1,l0idb		; ID Setting Bit
id2_l0idb		.btequ		2,l0idb		; ID Setting Bit
id3_l0idb		.btequ		3,l0idb		; ID Setting Bit
id4_l0idb		.btequ		4,l0idb		; ID Setting Bit
id5_l0idb		.btequ		5,l0idb		; ID Setting Bit
idp0_l0idb		.btequ		6,l0idb		; Parity Setting Bit
idp1_l0idb		.btequ		7,l0idb		; Parity Setting Bit
;
;*------------------------------------------------------------------------------*
;*  LIN0 Check Sum Buffer Register                                              *
;*------------------------------------------------------------------------------*
l0cb		.equ	0176h
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data1 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db1		.equ	0178h
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data2 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db2		.equ	0179h
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data3 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db3		.equ	017Ah
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data4 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db4		.equ	017Bh
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data5 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db5		.equ	017Ch
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data6 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db6		.equ	017Dh
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data7 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db7		.equ	017Eh
;
;*------------------------------------------------------------------------------*
;*  LIN0 Data8 Buffer Register                                                  *
;*------------------------------------------------------------------------------*
l0db8		.equ	017Fh
;
;*------------------------------------------------------------------------------*
;*  DMA0 Source Pointer                                                         *
;*------------------------------------------------------------------------------*
sar0		.equ	0180h
;
sar0l		.equ	sar0				; DMA0 source address(low 8bit)
sar0m		.equ	sar0+1				; DMA0 source address(mid 8bit)
sar0h		.equ	sar0+2				; DMA0 source address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA0 Destination Pointer                                                    *
;*------------------------------------------------------------------------------*
dar0		.equ	0184h
;
dar0l		.equ	dar0				; DMA0 destination address(low 8bit)
dar0m		.equ	dar0+1				; DMA0 destination address(mid 8bit)
dar0h		.equ	dar0+2				; DMA0 destination address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA0 Transfer Counter                                                       *
;*------------------------------------------------------------------------------*
tcr0		.equ	0188h
;
tcr0l		.equ	tcr0				; DMA0 transfer count(low 8bit)
tcr0h		.equ	tcr0+1				; DMA0 transfer count(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA0 Control Register                                                       *
;*------------------------------------------------------------------------------*
dm0con		.equ	018Ch
;
dmbit_dm0con	.btequ		0,dm0con	; Transfer unit bit select bit
dmasl_dm0con	.btequ		1,dm0con	; Repeat transfer mode select bit
dmas_dm0con		.btequ		2,dm0con	; DMA request bit
dmae_dm0con		.btequ		3,dm0con	; DMA enable bit
dsd_dm0con		.btequ		4,dm0con	; Source address direction select bit
dad_dm0con		.btequ		5,dm0con	; Destination address direction select bit
;
;*------------------------------------------------------------------------------*
;*  DMA1 Source Pointer                                                         *
;*------------------------------------------------------------------------------*
sar1		.equ	0190h
;
sar1l		.equ	sar1				; DMA1 source address(low 8bit)
sar1m		.equ	sar1+1				; DMA1 source address(mid 8bit)
sar1h		.equ	sar1+2				; DMA1 source address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA1 Destination Pointer                                                    *
;*------------------------------------------------------------------------------*
dar1		.equ	0194h
;
dar1l		.equ	dar1				; DMA1 destination address(low 8bit)
dar1m		.equ	dar1+1				; DMA1 destination address(mid 8bit)
dar1h		.equ	dar1+2				; DMA1 destination address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA1 Transfer Counter                                                       *
;*------------------------------------------------------------------------------*
tcr1		.equ	0198h
;
tcr1l		.equ	tcr1				; DMA1 transfer count(low 8bit)
tcr1h		.equ	tcr1+1				; DMA1 transfer count(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA1 Control Register                                                       *
;*------------------------------------------------------------------------------*
dm1con		.equ	019Ch
;
dmbit_dm1con	.btequ		0,dm1con	; Transfer unit bit select bit
dmasl_dm1con	.btequ		1,dm1con	; Repeat transfer mode select bit
dmas_dm1con		.btequ		2,dm1con	; DMA request bit
dmae_dm1con		.btequ		3,dm1con	; DMA enable bit
dsd_dm1con		.btequ		4,dm1con	; Source address direction select bit
dad_dm1con		.btequ		5,dm1con	; Destination address direction select bit
;
;*------------------------------------------------------------------------------*
;*  DMA2 Source Pointer                                                         *
;*------------------------------------------------------------------------------*
sar2		.equ	01A0h
;
sar2l		.equ	sar2				; DMA2 source address(low 8bit)
sar2m		.equ	sar2+1				; DMA2 source address(mid 8bit)
sar2h		.equ	sar2+2				; DMA2 source address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA2 Destination Pointer                                                    *
;*------------------------------------------------------------------------------*
dar2		.equ	01A4h
;
dar2l		.equ	dar2				; DMA2 destination address(low 8bit)
dar2m		.equ	dar2+1				; DMA2 destination address(mid 8bit)
dar2h		.equ	dar2+2				; DMA2 destination address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA2 Transfer Counter                                                       *
;*------------------------------------------------------------------------------*
tcr2		.equ	01A8h
;
tcr2l		.equ	tcr2				; DMA2 transfer count(low 8bit)
tcr2h		.equ	tcr2+1				; DMA2 transfer count(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA2 Control Register                                                       *
;*------------------------------------------------------------------------------*
dm2con		.equ	01ACh
;
dmbit_dm2con	.btequ		0,dm2con	; Transfer unit bit select bit
dmasl_dm2con	.btequ		1,dm2con	; Repeat transfer mode select bit
dmas_dm2con		.btequ		2,dm2con	; DMA request bit
dmae_dm2con		.btequ		3,dm2con	; DMA enable bit
dsd_dm2con		.btequ		4,dm2con	; Source address direction select bit
dad_dm2con		.btequ		5,dm2con	; Destination address direction select bit
;
;*------------------------------------------------------------------------------*
;*  DMA3 Source Pointer                                                         *
;*------------------------------------------------------------------------------*
sar3		.equ	01B0h
;
sar3l		.equ	sar3				; DMA3 source address(low 8bit)
sar3m		.equ	sar3+1				; DMA3 source address(mid 8bit)
sar3h		.equ	sar3+2				; DMA3 source address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA3 Destination Pointer                                                    *
;*------------------------------------------------------------------------------*
dar3		.equ	01B4h
;
dar3l		.equ	dar3				; DMA3 destination address(low 8bit)
dar3m		.equ	dar3+1				; DMA3 destination address(mid 8bit)
dar3h		.equ	dar3+2				; DMA3 destination address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA3 Transfer Counter                                                       *
;*------------------------------------------------------------------------------*
tcr3		.equ	01B8h
;
tcr3l		.equ	tcr3				; DMA3 transfer count(low 8bit)
tcr3h		.equ	tcr3+1				; DMA3 transfer count(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  DMA3 Control Register                                                       *
;*------------------------------------------------------------------------------*
dm3con		.equ	01BCh
;
dmbit_dm3con	.btequ		0,dm3con	; Transfer unit bit select bit
dmasl_dm3con	.btequ		1,dm3con	; Repeat transfer mode select bit
dmas_dm3con		.btequ		2,dm3con	; DMA request bit
dmae_dm3con		.btequ		3,dm3con	; DMA enable bit
dsd_dm3con		.btequ		4,dm3con	; Source address direction select bit
dad_dm3con		.btequ		5,dm3con	; Destination address direction select bit
;
;*------------------------------------------------------------------------------*
;*  Timer B0-1 Register                                                         *
;*------------------------------------------------------------------------------*
tb01		.equ	01C0h
;
;*------------------------------------------------------------------------------*
;*  Timer B1-1 Register                                                         *
;*------------------------------------------------------------------------------*
tb11		.equ	01C2h
;
;*------------------------------------------------------------------------------*
;*  Timer B2-1 Register                                                         *
;*------------------------------------------------------------------------------*
tb21		.equ	01C4h
;
;*------------------------------------------------------------------------------*
;*  Pulse Period/Pulse Width Measurement Mode Function Select Register 1        *
;*------------------------------------------------------------------------------*
ppwfs1		.equ	01C6h
;
ppwfs10			.btequ		0,ppwfs1	; Timer B0 pulse period/pulse width measurement mode function select bit
ppwfs11			.btequ		1,ppwfs1	; Timer B1 pulse period/pulse width measurement mode function select bit
ppwfs12			.btequ		2,ppwfs1	; Timer B2 pulse period/pulse width measurement mode function select bit
;
;*------------------------------------------------------------------------------*
;*  Timer B Count Source Select Register 0                                      *
;*------------------------------------------------------------------------------*
tbcs0		.equ	01C8h
;
tcs0_tbcs0		.btequ		0,tbcs0		; TB0 count source select bit
tcs1_tbcs0		.btequ		1,tbcs0		; TB0 count source select bit
tcs2_tbcs0		.btequ		2,tbcs0		; TB0 count source select bit
tcs3_tbcs0		.btequ		3,tbcs0		; TB0 count source option specified bit
tcs4_tbcs0		.btequ		4,tbcs0		; TB1 count source select bit
tcs5_tbcs0		.btequ		5,tbcs0		; TB1 count source select bit
tcs6_tbcs0		.btequ		6,tbcs0		; TB1 count source select bit
tcs7_tbcs0		.btequ		7,tbcs0		; TB1 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  Timer B Count Source Select Register 1                                      *
;*------------------------------------------------------------------------------*
tbcs1		.equ	01C9h
;
tcs0_tbcs1		.btequ		0,tbcs1		; TB2 count source select bit
tcs1_tbcs1		.btequ		1,tbcs1		; TB2 count source select bit
tcs2_tbcs1		.btequ		2,tbcs1		; TB2 count source select bit
tcs3_tbcs1		.btequ		3,tbcs1		; TB2 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  Timer AB Division Control Register 0                                        *
;*------------------------------------------------------------------------------*
tckdivc0	.equ	01CBh
;
tcdiv00			.btequ		0,tckdivc0	; Clock select prior to timer AB division bit
;
;*------------------------------------------------------------------------------*
;*  Timer A Count Source Select Register 0                                      *
;*------------------------------------------------------------------------------*
tacs0		.equ	01D0h
;
tcs0_tacs0		.btequ		0,tacs0		; TA0 count source select bit
tcs1_tacs0		.btequ		1,tacs0		; TA0 count source select bit
tcs2_tacs0		.btequ		2,tacs0		; TA0 count source select bit
tcs3_tacs0		.btequ		3,tacs0		; TA0 count source option specified bit
tcs4_tacs0		.btequ		4,tacs0		; TA1 count source select bit
tcs5_tacs0		.btequ		5,tacs0		; TA1 count source select bit
tcs6_tacs0		.btequ		6,tacs0		; TA1 count source select bit
tcs7_tacs0		.btequ		7,tacs0		; TA1 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  Timer A Count Source Select Register 1                                      *
;*------------------------------------------------------------------------------*
tacs1		.equ	01D1h
;
tcs0_tacs1		.btequ		0,tacs1		; TA2 count source select bit
tcs1_tacs1		.btequ		1,tacs1		; TA2 count source select bit
tcs2_tacs1		.btequ		2,tacs1		; TA2 count source select bit
tcs3_tacs1		.btequ		3,tacs1		; TA2 count source option specified bit
tcs4_tacs1		.btequ		4,tacs1		; TA3 count source select bit
tcs5_tacs1		.btequ		5,tacs1		; TA3 count source select bit
tcs6_tacs1		.btequ		6,tacs1		; TA3 count source select bit
tcs7_tacs1		.btequ		7,tacs1		; TA3 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  Timer A Count Source Select Register 2                                      *
;*------------------------------------------------------------------------------*
tacs2		.equ	01D2h
;
tcs0_tacs2		.btequ		0,tacs2		; TA4 count source select bit
tcs1_tacs2		.btequ		1,tacs2		; TA4 count source select bit
tcs2_tacs2		.btequ		2,tacs2		; TA4 count source select bit
tcs3_tacs2		.btequ		3,tacs2		; TA4 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  16-bit Pulse Width Modulation Mode Function Select Register                 *
;*------------------------------------------------------------------------------*
pwmfs		.equ	01D4h
;
pwmfs1			.btequ		1,pwmfs		; Timer A1 programmable output mode select bit
pwmfs2			.btequ		2,pwmfs		; Timer A2 programmable output mode select bit
pwmfs4			.btequ		4,pwmfs		; Timer A4 programmable output mode select bit
;
;*------------------------------------------------------------------------------*
;*  Timer A Waveform Output Function Select Register                            *
;*------------------------------------------------------------------------------*
tapofs		.equ	01D5h
;
pofs0			.btequ		0,tapofs	; TA0OUT output polar control bit
pofs1			.btequ		1,tapofs	; TA1OUT output polar control bit
pofs2			.btequ		2,tapofs	; TA2OUT output polar control bit
pofs3			.btequ		3,tapofs	; TA3OUT output polar control bit
pofs4			.btequ		4,tapofs	; TA4OUT output polar control bit
;
;*------------------------------------------------------------------------------*
;*  Timer A Output Waveform Change Enable Register                              *
;*------------------------------------------------------------------------------*
taow		.equ	01D8h
;
ta1ow			.btequ		1,taow		; Timer A1 output waveform change enable bit
ta2ow			.btequ		2,taow		; Timer A2 output waveform change enable bit
ta4ow			.btequ		4,taow		; Timer A4 output waveform change enable bit
;
;*------------------------------------------------------------------------------*
;*  Three-phase Protect Control Register                                        *
;*------------------------------------------------------------------------------*
tprc		.equ	01DAh
;
tprc0			.btequ		0,tprc		; Three-phase protect control bit
;
;*------------------------------------------------------------------------------*
;*  Timer B3-1 Register                                                         *
;*------------------------------------------------------------------------------*
tb31		.equ	01E0h
;
;*------------------------------------------------------------------------------*
;*  Timer B4-1 Register                                                         *
;*------------------------------------------------------------------------------*
tb41		.equ	01E2h
;
;*------------------------------------------------------------------------------*
;*  Timer B5-1 Register                                                         *
;*------------------------------------------------------------------------------*
tb51		.equ	01E4h
;
;*------------------------------------------------------------------------------*
;*  Pulse Period/Pulse Width Measurement Mode Function Select Register 2        *
;*------------------------------------------------------------------------------*
ppwfs2		.equ	01E6h
;
ppwfs20			.btequ		0,ppwfs2	; Timer B3 pulse period/pulse width measurement mode function select bit
ppwfs21			.btequ		1,ppwfs2	; Timer B4 pulse period/pulse width measurement mode function select bit
ppwfs22			.btequ		2,ppwfs2	; Timer B5 pulse period/pulse width measurement mode function select bit
;
;*------------------------------------------------------------------------------*
;*  Timer B Count Source Select Register 2                                      *
;*------------------------------------------------------------------------------*
tbcs2		.equ	01E8h
;
tcs0_tbcs2		.btequ		0,tbcs2		; TB3 count source select bit
tcs1_tbcs2		.btequ		1,tbcs2		; TB3 count source select bit
tcs2_tbcs2		.btequ		2,tbcs2		; TB3 count source select bit
tcs3_tbcs2		.btequ		3,tbcs2		; TB3 count source option specified bit
tcs4_tbcs2		.btequ		4,tbcs2		; TB4 count source select bit
tcs5_tbcs2		.btequ		5,tbcs2		; TB4 count source select bit
tcs6_tbcs2		.btequ		6,tbcs2		; TB4 count source select bit
tcs7_tbcs2		.btequ		7,tbcs2		; TB4 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  Timer B Count Source Select Register 3                                      *
;*------------------------------------------------------------------------------*
tbcs3		.equ	01E9h
;
tcs0_tbcs3		.btequ		0,tbcs3		; TB5 count source select bit
tcs1_tbcs3		.btequ		1,tbcs3		; TB5 count source select bit
tcs2_tbcs3		.btequ		2,tbcs3		; TB5 count source select bit
tcs3_tbcs3		.btequ		3,tbcs3		; TB5 count source option specified bit
;
;*------------------------------------------------------------------------------*
;*  Task Monitor Timer Register                                                 *
;*------------------------------------------------------------------------------*
tmos		.equ	01F0h
;
;*------------------------------------------------------------------------------*
;*  Task Monitor Timer Count Start Flag                                         *
;*------------------------------------------------------------------------------*
tmossr		.equ	01F2h
;
tmos0s			.btequ		0,tmossr	; Task monitor timer count start flag
;
;*------------------------------------------------------------------------------*
;*  Task Monitor Timer Count Source Select Register                             *
;*------------------------------------------------------------------------------*
tmoscs		.equ	01F3h
;
tmos0cs			.btequ		0,tmoscs	; Task monitor timer count source select bit
tmos1cs			.btequ		1,tmoscs	; Task monitor timer count source select bit
tmos2cs			.btequ		2,tmoscs	; Task monitor timer count source select bit
;
;*------------------------------------------------------------------------------*
;*  Task Monitor Timer Protect Register                                         *
;*------------------------------------------------------------------------------*
tmospr		.equ	01F4h
;
;*------------------------------------------------------------------------------*
;*  Interrupt Source Select Register 4                                          *
;*------------------------------------------------------------------------------*
ifsr4a		.equ	0204h
;
ifsr43			.btequ		3,ifsr4a	; Interrupt Request Source Select bit
ifsr44			.btequ		4,ifsr4a	; Interrupt Request Source Select bit
ifsr45			.btequ		5,ifsr4a	; Interrupt Request Source Select bit
ifsr46			.btequ		6,ifsr4a	; Interrupt Request Source Select bit
ifsr47			.btequ		7,ifsr4a	; Interrupt Request Source Select bit
;
;*------------------------------------------------------------------------------*
;*  Interrupt Source Select Register 3                                          *
;*------------------------------------------------------------------------------*
ifsr3a		.equ	0205h
;
ifsr30			.btequ		0,ifsr3a	; INT6~ interrupt priority select bit
ifsr31			.btequ		1,ifsr3a	; INT7~ interrupt priority select bit
ifsr32			.btequ		2,ifsr3a	; Interrupt Request Source Select bit
ifsr33			.btequ		3,ifsr3a	; Interrupt Request Source Select bit
ifsr34			.btequ		4,ifsr3a	; Interrupt Request Source Select bit
ifsr35			.btequ		5,ifsr3a	; Interrupt Request Source Select bit
ifsr36			.btequ		6,ifsr3a	; Interrupt Request Source Select bit
;
;*------------------------------------------------------------------------------*
;*  Interrupt Source Select Register 2                                          *
;*------------------------------------------------------------------------------*
ifsr2a		.equ	0206h
;
ifsr20			.btequ		0,ifsr2a	; Interrupt request source select bit
ifsr22			.btequ		2,ifsr2a	; Interrupt request source select bit
ifsr23			.btequ		3,ifsr2a	; Interrupt request source select bit
ifsr24			.btequ		4,ifsr2a	; Interrupt request source select bit
ifsr25			.btequ		5,ifsr2a	; Interrupt request source select bit
;
;*------------------------------------------------------------------------------*
;*  Interrupt Source Select Register                                            *
;*------------------------------------------------------------------------------*
ifsr		.equ	0207h
;
ifsr0			.btequ		0,ifsr		; INT0~ interrupt polarity switch bit
ifsr1			.btequ		1,ifsr		; INT1~ interrupt polarity switch bit
ifsr2			.btequ		2,ifsr		; INT2~ interrupt polarity switch bit
ifsr3			.btequ		3,ifsr		; INT3~ interrupt polarity switch bit
ifsr4			.btequ		4,ifsr		; INT4~ interrupt polarity switch bit
ifsr5			.btequ		5,ifsr		; INT5~ interrupt polarity switch bit
ifsr6			.btequ		6,ifsr		; Interrupt request source select bit
ifsr7			.btequ		7,ifsr		; Interrupt request source select bit
;
;*------------------------------------------------------------------------------*
;*  Address Match Interrupt Enable Register                                     *
;*------------------------------------------------------------------------------*
aier		.equ	020Eh
;
aier0			.btequ		0,aier		; Address match interrupt 0 enable bit
aier1			.btequ		1,aier		; Address match interrupt 1 enable bit
;
;*------------------------------------------------------------------------------*
;*  Address Match Interrupt Enable Register 2                                   *
;*------------------------------------------------------------------------------*
aier2		.equ	020Fh
;
aier20			.btequ		0,aier2		; Address match interrupt 2 enable bit
aier21			.btequ		1,aier2		; Address match interrupt 3 enable bit
;
;*------------------------------------------------------------------------------*
;*  Address Match Interrupt Register 0                                          *
;*------------------------------------------------------------------------------*
rmad0		.equ	0210h
;
rmad0l		.equ	rmad0				; RMAD0 address(low 8bit)
rmad0m		.equ	rmad0+1				; RMAD0 address(mid 8bit)
rmad0h		.equ	rmad0+2				; RMAD0 address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  Address Match Interrupt Register 1                                          *
;*------------------------------------------------------------------------------*
rmad1		.equ	0214h
;
rmad1l		.equ	rmad1				; RMAD1 address(low 8bit)
rmad1m		.equ	rmad1+1				; RMAD1 address(mid 8bit)
rmad1h		.equ	rmad1+2				; RMAD1 address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  Address Match Interrupt Register 2                                          *
;*------------------------------------------------------------------------------*
rmad2		.equ	0218h
;
rmad2l		.equ	rmad2				; RMAD2 address(low 8bit)
rmad2m		.equ	rmad2+1				; RMAD2 address(mid 8bit)
rmad2h		.equ	rmad2+2				; RMAD2 address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  Address Match Interrupt Register 3                                          *
;*------------------------------------------------------------------------------*
rmad3		.equ	021Ch
;
rmad3l		.equ	rmad3				; RMAD3 address(low 8bit)
rmad3m		.equ	rmad3+1				; RMAD3 address(mid 8bit)
rmad3h		.equ	rmad3+2				; RMAD3 address(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  Flash Memory Control Register 0                                             *
;*------------------------------------------------------------------------------*
fmr0		.equ	0220h
;
fmr00			.btequ		0,fmr0		; RY / BY~ status flag
fmr01			.btequ		1,fmr0		; CPU rewrite mode select bit
fmr02			.btequ		2,fmr0		; Lock bit disable select bit
fmstp			.btequ		3,fmr0		; Flash memory stop bit
fmr06			.btequ		6,fmr0		; Program status flag
fmr07			.btequ		7,fmr0		; Erase Status Flag
;
;*------------------------------------------------------------------------------*
;*  Flash Memory Control Register 1                                             *
;*------------------------------------------------------------------------------*
fmr1		.equ	0221h
;
fmr11			.btequ		1,fmr1		; Write to FMR6 register enable bit
fmr16			.btequ		6,fmr1		; Lock bit status flag
fmr17			.btequ		7,fmr1		; Data flash wait bit
;
;*------------------------------------------------------------------------------*
;*  Flash Memory Control Register 2                                             *
;*------------------------------------------------------------------------------*
fmr2		.equ	0222h
;
fmr22			.btequ		2,fmr2		; Slow read mode enable bit
fmr23			.btequ		3,fmr2		; Low current consumption read mode enable bit
;
;*------------------------------------------------------------------------------*
;*  Flash Memory Control Register 3                                             *
;*------------------------------------------------------------------------------*
fmr3		.equ	0223h
;
fmr30			.btequ		0,fmr3		; Suspend function enable bit
fmr31			.btequ		1,fmr3		; Suspend request bit
fmr32			.btequ		2,fmr3		; Erase suspend status flag
fmr33			.btequ		3,fmr3		; Program suspend status flag
;
;*------------------------------------------------------------------------------*
;*  Flash Memory Control Register 6                                             *
;*------------------------------------------------------------------------------*
fmr6		.equ	0230h
;
fmr60			.btequ		0,fmr6		; EW1 mode select bit
fmr61			.btequ		1,fmr6		; Reserved bit
;
;*------------------------------------------------------------------------------*
;*  UART0 Transmit/Receive Mode Register                                        *
;*------------------------------------------------------------------------------*
u0mr		.equ	0248h
;
smd0_u0mr		.btequ		0,u0mr		; Serial I/O mode select bit
smd1_u0mr		.btequ		1,u0mr		; Serial I/O mode select bit
smd2_u0mr		.btequ		2,u0mr		; Serial I/O mode select bit
ckdir_u0mr		.btequ		3,u0mr		; Internal/external clock select bit
stps_u0mr		.btequ		4,u0mr		; Stop bit length select bit
pry_u0mr		.btequ		5,u0mr		; Odd/even parity select bit
prye_u0mr		.btequ		6,u0mr		; Parity enable bit
iopol_u0mr		.btequ		7,u0mr		; TXD, RXD I/O polarity inverse bit
;
;*------------------------------------------------------------------------------*
;*  UART0 Bit Rate Register                                                     *
;*------------------------------------------------------------------------------*
u0brg		.equ	0249h
;
;*------------------------------------------------------------------------------*
;*  UART0 Transmit Buffer Register                                              *
;*------------------------------------------------------------------------------*
u0tb		.equ	024Ah
;
u0tbl		.equ	u0tb				; UART0 Transmit buffer register(low 8bit)
u0tbh		.equ	u0tb+1				; UART0 Transmit buffer register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  UART0 Transmit/Receive Control Register 0                                   *
;*------------------------------------------------------------------------------*
u0c0		.equ	024Ch
;
clk0_u0c0		.btequ		0,u0c0		; U0BRG count source select bit
clk1_u0c0		.btequ		1,u0c0		; U0BRG count source select bit
crs_u0c0		.btequ		2,u0c0		; CTS~/RTS~ function select bit
txept_u0c0		.btequ		3,u0c0		; Transmit register empty flag
crd_u0c0		.btequ		4,u0c0		; CTS~/RTS~ disable bit
nch_u0c0		.btequ		5,u0c0		; Data output select bit
ckpol_u0c0		.btequ		6,u0c0		; CLK polarity select bit
uform_u0c0		.btequ		7,u0c0		; Bit order select bit
;
;*------------------------------------------------------------------------------*
;*  UART0 Transmit/Receive Control Register 1                                   *
;*------------------------------------------------------------------------------*
u0c1		.equ	024Dh
;
te_u0c1			.btequ		0,u0c1		; Transmit enable bit
ti_u0c1			.btequ		1,u0c1		; Transmit buffer empty flag
re_u0c1			.btequ		2,u0c1		; Receive enable bit
ri_u0c1			.btequ		3,u0c1		; Receive complete flag
u0irs			.btequ		4,u0c1		; UART0 transmit interrupt source select bit
u0rrm			.btequ		5,u0c1		; UART0 continuous receive mode enable bit
u0lch			.btequ		6,u0c1		; Data logic select bit
u0ere			.btequ		7,u0c1		; Error signal output enable bit
;
;*------------------------------------------------------------------------------*
;*  UART0 Receive Buffer Register                                               *
;*------------------------------------------------------------------------------*
u0rb		.equ	024Eh
;
u0rbl		.equ	u0rb				; UART0 receive buffer register(low 8bit)
u0rbh		.equ	u0rb+1				; UART0 receive buffer register(high 8bit)
;
abt_u0rb		.btequ		11,u0rb		; Arbitration lost detect flag
oer_u0rb		.btequ		12,u0rb		; Overrun error flag
fer_u0rb		.btequ		13,u0rb		; Framing error flag
per_u0rb		.btequ		14,u0rb		; Parity error flag
sum_u0rb		.btequ		15,u0rb		; Error sum flag
;
;*------------------------------------------------------------------------------*
;*  UART Clock Select Register                                                  *
;*------------------------------------------------------------------------------*
uclksel0	.equ	0252h
;
ocosel0			.btequ		2,uclksel0	; UART0 to UART2 clock prior to division select bit
ocosel1			.btequ		3,uclksel0	; UART3 to UART4 clock prior to division select bit
;
;*------------------------------------------------------------------------------*
;*  UART1 Transmit/Receive Mode Register                                        *
;*------------------------------------------------------------------------------*
u1mr		.equ	0258h
;
smd0_u1mr		.btequ		0,u1mr		; Serial I/O mode select bit
smd1_u1mr		.btequ		1,u1mr		; Serial I/O mode select bit
smd2_u1mr		.btequ		2,u1mr		; Serial I/O mode select bit
ckdir_u1mr		.btequ		3,u1mr		; Internal/external clock select bit
stps_u1mr		.btequ		4,u1mr		; Stop bit length select bit
pry_u1mr		.btequ		5,u1mr		; Odd/even parity select bit
prye_u1mr		.btequ		6,u1mr		; Parity enable bit
iopol_u1mr		.btequ		7,u1mr		; TXD, RXD I/O polarity inverse bit
;
;*------------------------------------------------------------------------------*
;*  UART1 Bit Rate Register                                                     *
;*------------------------------------------------------------------------------*
u1brg		.equ	0259h
;
;*------------------------------------------------------------------------------*
;*  UART1 Transmit Buffer Register                                              *
;*------------------------------------------------------------------------------*
u1tb		.equ	025Ah
;
u1tbl		.equ	u1tb				; UART1 Transmit buffer register(low 8bit)
u1tbh		.equ	u1tb+1				; UART1 Transmit buffer register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  UART1 Transmit/Receive Control Register 0                                   *
;*------------------------------------------------------------------------------*
u1c0		.equ	025Ch
;
clk0_u1c0		.btequ		0,u1c0		; U1BRG count source select bit
clk1_u1c0		.btequ		1,u1c0		; U1BRG count source select bit
crs_u1c0		.btequ		2,u1c0		; CTS~/RTS~ function select bit
txept_u1c0		.btequ		3,u1c0		; Transmit register empty flag
crd_u1c0		.btequ		4,u1c0		; CTS~/RTS~ disable bit
nch_u1c0		.btequ		5,u1c0		; Data output select bit
ckpol_u1c0		.btequ		6,u1c0		; CLK polarity select bit
uform_u1c0		.btequ		7,u1c0		; Bit order select bit
;
;*------------------------------------------------------------------------------*
;*  UART1 Transmit/Receive Control Register 1                                   *
;*------------------------------------------------------------------------------*
u1c1		.equ	025Dh
;
te_u1c1			.btequ		0,u1c1		; Transmit enable bit
ti_u1c1			.btequ		1,u1c1		; Transmit buffer empty flag
re_u1c1			.btequ		2,u1c1		; Receive enable bit
ri_u1c1			.btequ		3,u1c1		; Receive complete flag
u1irs			.btequ		4,u1c1		; UART1 transmit interrupt source select bit
u1rrm			.btequ		5,u1c1		; UART1 continuous receive mode enable bit
u1lch			.btequ		6,u1c1		; Data logic select bit
u1ere			.btequ		7,u1c1		; Error signal output enable bit
;
;*------------------------------------------------------------------------------*
;*  UART1 Receive Buffer Register                                               *
;*------------------------------------------------------------------------------*
u1rb		.equ	025Eh
;
u1rbl		.equ	u1rb				; UART1 receive buffer register(low 8bit)
u1rbh		.equ	u1rb+1				; UART1 receive buffer register(high 8bit)
;
abt_u1rb		.btequ		11,u1rb		; Arbitration lost detect flag
oer_u1rb		.btequ		12,u1rb		; Overrun error flag
fer_u1rb		.btequ		13,u1rb		; Framing error flag
per_u1rb		.btequ		14,u1rb		; Parity error flag
sum_u1rb		.btequ		15,u1rb		; Error sum flag
;
;*------------------------------------------------------------------------------*
;*  UART2 Special Mode Register 4                                               *
;*------------------------------------------------------------------------------*
u2smr4		.equ	0264h
;
stareq_u2smr4	.btequ		0,u2smr4	; Start condition generate bit
rstareq_u2smr4	.btequ		1,u2smr4	; Restart condition generate bit
stpreq_u2smr4	.btequ		2,u2smr4	; Stop condition generate bit
stspsel_u2smr4	.btequ		3,u2smr4	; SCL, SDA output select bit
ackd_u2smr4		.btequ		4,u2smr4	; ACK data bit
ackc_u2smr4		.btequ		5,u2smr4	; ACK data output enable bit
sclhi_u2smr4	.btequ		6,u2smr4	; SCL output stop enable bit
swc9_u2smr4		.btequ		7,u2smr4	; SCL wait bit 3
;
;*------------------------------------------------------------------------------*
;*  UART2 Special Mode Register 3                                               *
;*------------------------------------------------------------------------------*
u2smr3		.equ	0265h
;
ckph_u2smr3		.btequ		1,u2smr3	; Clock phase set bit
nodc_u2smr3		.btequ		3,u2smr3	; Clock output select bit
dl0_u2smr3		.btequ		5,u2smr3	; SDA2 digital delay setup bit
dl1_u2smr3		.btequ		6,u2smr3	; SDA2 digital delay setup bit
dl2_u2smr3		.btequ		7,u2smr3	; SDA2 digital delay setup bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Special Mode Register 2                                               *
;*------------------------------------------------------------------------------*
u2smr2		.equ	0266h
;
iicm2_u2smr2	.btequ		0,u2smr2	; I2C mode select bit 2
csc_u2smr2		.btequ		1,u2smr2	; Clock synchronization bit
swc_u2smr2		.btequ		2,u2smr2	; SCL wait output bit
als_u2smr2		.btequ		3,u2smr2	; SDA output stop bit
stac_u2smr2		.btequ		4,u2smr2	; UART2 initialization bit
swc2_u2smr2		.btequ		5,u2smr2	; SCL wait output bit 2
sdhi_u2smr2		.btequ		6,u2smr2	; SDA output disable bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Special Mode Register                                                 *
;*------------------------------------------------------------------------------*
u2smr		.equ	0267h
;
iicm_u2smr		.btequ		0,u2smr		; I2C mode select bit
abc_u2smr		.btequ		1,u2smr		; Arbitration lost detect flag control bit
bbs_u2smr		.btequ		2,u2smr		; Bus busy flag
abscs_u2smr		.btequ		4,u2smr		; Bus collision detect sampling clock select bit
acse_u2smr		.btequ		5,u2smr		; Auto clear function select bit of transmit enable bit
sss_u2smr		.btequ		6,u2smr		; Transmit start condition select bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Transmit/Receive Mode Register                                        *
;*------------------------------------------------------------------------------*
u2mr		.equ	0268h
;
smd0_u2mr		.btequ		0,u2mr		; Serial I/O mode select bit
smd1_u2mr		.btequ		1,u2mr		; Serial I/O mode select bit
smd2_u2mr		.btequ		2,u2mr		; Serial I/O mode select bit
ckdir_u2mr		.btequ		3,u2mr		; Internal/external clock select bit
stps_u2mr		.btequ		4,u2mr		; Stop bit length select bit
pry_u2mr		.btequ		5,u2mr		; Odd/even parity select bit
prye_u2mr		.btequ		6,u2mr		; Parity enable bit
iopol_u2mr		.btequ		7,u2mr		; TXD, RXD I/O polarity inverse bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Bit Rate Register                                                     *
;*------------------------------------------------------------------------------*
u2brg		.equ	0269h
;
;*------------------------------------------------------------------------------*
;*  UART2 Transmit Buffer Register                                              *
;*------------------------------------------------------------------------------*
u2tb		.equ	026Ah
;
u2tbl		.equ	u2tb				; UART2 Transmit buffer register(low 8bit)
u2tbh		.equ	u2tb+1				; UART2 Transmit buffer register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  UART2 Transmit/Receive Control Register 0                                   *
;*------------------------------------------------------------------------------*
u2c0		.equ	026Ch
;
clk0_u2c0		.btequ		0,u2c0		; U2BRG count source select bit
clk1_u2c0		.btequ		1,u2c0		; U2BRG count source select bit
crs_u2c0		.btequ		2,u2c0		; CTS~/RTS~ function select bit
txept_u2c0		.btequ		3,u2c0		; Transmit register empty flag
crd_u2c0		.btequ		4,u2c0		; CTS~/RTS~ disable bit
nch_u2c0		.btequ		5,u2c0		; Data output select bit
ckpol_u2c0		.btequ		6,u2c0		; CLK polarity select bit
uform_u2c0		.btequ		7,u2c0		; Bit order select bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Transmit/Receive Control Register 1                                   *
;*------------------------------------------------------------------------------*
u2c1		.equ	026Dh
;
te_u2c1			.btequ		0,u2c1		; Transmit enable bit
ti_u2c1			.btequ		1,u2c1		; Transmit buffer empty flag
re_u2c1			.btequ		2,u2c1		; Receive enable bit
ri_u2c1			.btequ		3,u2c1		; Receive complete flag
u2irs			.btequ		4,u2c1		; UART2 transmit interrupt source select bit
u2rrm			.btequ		5,u2c1		; UART2 continuous receive mode enable bit
u2lch			.btequ		6,u2c1		; Data logic select bit
u2ere			.btequ		7,u2c1		; Error signal output enable bit
;
;*------------------------------------------------------------------------------*
;*  UART2 Receive Buffer Register                                               *
;*------------------------------------------------------------------------------*
u2rb		.equ	026Eh
;
u2rbl		.equ	u2rb				; UART2 receive buffer register(low 8bit)
u2rbh		.equ	u2rb+1				; UART2 receive buffer register(high 8bit)
;
abt_u2rb		.btequ		11,u2rb		; Arbitration lost detect flag
oer_u2rb		.btequ		12,u2rb		; Overrun error flag
fer_u2rb		.btequ		13,u2rb		; Framing error flag
per_u2rb		.btequ		14,u2rb		; Parity error flag
sum_u2rb		.btequ		15,u2rb		; Error sum flag
;
;*------------------------------------------------------------------------------*
;*  UART4 Transmit/Receive Mode Register                                        *
;*------------------------------------------------------------------------------*
u4mr		.equ	0298h
;
smd0_u4mr		.btequ		0,u4mr		; Serial I/O mode select bit
smd1_u4mr		.btequ		1,u4mr		; Serial I/O mode select bit
smd2_u4mr		.btequ		2,u4mr		; Serial I/O mode select bit
ckdir_u4mr		.btequ		3,u4mr		; Internal/external clock select bit
stps_u4mr		.btequ		4,u4mr		; Stop bit length select bit
pry_u4mr		.btequ		5,u4mr		; Odd/even parity select bit
prye_u4mr		.btequ		6,u4mr		; Parity enable bit
iopol_u4mr		.btequ		7,u4mr		; TXD, RXD I/O polarity inverse bit
;
;*------------------------------------------------------------------------------*
;*  UART4 Bit Rate Register                                                     *
;*------------------------------------------------------------------------------*
u4brg		.equ	0299h
;
;*------------------------------------------------------------------------------*
;*  UART4 Transmit Buffer Register                                              *
;*------------------------------------------------------------------------------*
u4tb		.equ	029Ah
;
u4tbl		.equ	u4tb				; UART4 Transmit buffer register(low 8bit)
u4tbh		.equ	u4tb+1				; UART4 Transmit buffer register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  UART4 Transmit/Receive Control Register 0                                   *
;*------------------------------------------------------------------------------*
u4c0		.equ	029Ch
;
clk0_u4c0		.btequ		0,u4c0		; U4BRG count source select bit
clk1_u4c0		.btequ		1,u4c0		; U4BRG count source select bit
crs_u4c0		.btequ		2,u4c0		; CTS~/RTS~ function select bit
txept_u4c0		.btequ		3,u4c0		; Transmit register empty flag
crd_u4c0		.btequ		4,u4c0		; CTS~/RTS~ disable bit
nch_u4c0		.btequ		5,u4c0		; Data output select bit
ckpol_u4c0		.btequ		6,u4c0		; CLK polarity select bit
uform_u4c0		.btequ		7,u4c0		; Bit order select bit
;
;*------------------------------------------------------------------------------*
;*  UART4 Transmit/Receive Control Register 1                                   *
;*------------------------------------------------------------------------------*
u4c1		.equ	029Dh
;
te_u4c1			.btequ		0,u4c1		; Transmit enable bit
ti_u4c1			.btequ		1,u4c1		; Transmit buffer empty flag
re_u4c1			.btequ		2,u4c1		; Receive enable bit
ri_u4c1			.btequ		3,u4c1		; Receive complete flag
u4irs			.btequ		4,u4c1		; UART4 transmit interrupt source select bit
u4rrm			.btequ		5,u4c1		; UART4 continuous receive mode enable bit
u4lch			.btequ		6,u4c1		; Data logic select bit
u4ere			.btequ		7,u4c1		; Error signal output enable bit
;
;*------------------------------------------------------------------------------*
;*  UART4 Receive Buffer Register                                               *
;*------------------------------------------------------------------------------*
u4rb		.equ	029Eh
;
u4rbl		.equ	u4rb				; UART4 receive buffer register(low 8bit)
u4rbh		.equ	u4rb+1				; UART4 receive buffer register(high 8bit)
;
abt_u4rb		.btequ		11,u4rb		; Arbitration lost detect flag
oer_u4rb		.btequ		12,u4rb		; Overrun error flag
fer_u4rb		.btequ		13,u4rb		; Framing error flag
per_u4rb		.btequ		14,u4rb		; Parity error flag
sum_u4rb		.btequ		15,u4rb		; Error sum flag
;
;*------------------------------------------------------------------------------*
;*  UART3 Transmit/Receive Mode Register                                        *
;*------------------------------------------------------------------------------*
u3mr		.equ	02A8h
;
smd0_u3mr		.btequ		0,u3mr		; Serial I/O mode select bit
smd1_u3mr		.btequ		1,u3mr		; Serial I/O mode select bit
smd2_u3mr		.btequ		2,u3mr		; Serial I/O mode select bit
ckdir_u3mr		.btequ		3,u3mr		; Internal/external clock select bit
stps_u3mr		.btequ		4,u3mr		; Stop bit length select bit
pry_u3mr		.btequ		5,u3mr		; Odd/even parity select bit
prye_u3mr		.btequ		6,u3mr		; Parity enable bit
iopol_u3mr		.btequ		7,u3mr		; TXD, RXD I/O polarity inverse bit
;
;*------------------------------------------------------------------------------*
;*  UART3 Bit Rate Register                                                     *
;*------------------------------------------------------------------------------*
u3brg		.equ	02A9h
;
;*------------------------------------------------------------------------------*
;*  UART3 Transmit Buffer Register                                              *
;*------------------------------------------------------------------------------*
u3tb		.equ	02AAh
;
u3tbl		.equ	u3tb				; UART3 Transmit buffer register(low 8bit)
u3tbh		.equ	u3tb+1				; UART3 Transmit buffer register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  UART3 Transmit/Receive Control Register 0                                   *
;*------------------------------------------------------------------------------*
u3c0		.equ	02ACh
;
clk0_u3c0		.btequ		0,u3c0		; U3BRG count source select bit
clk1_u3c0		.btequ		1,u3c0		; U3BRG count source select bit
crs_u3c0		.btequ		2,u3c0		; CTS~/RTS~ function select bit
txept_u3c0		.btequ		3,u3c0		; Transmit register empty flag
crd_u3c0		.btequ		4,u3c0		; CTS~/RTS~ disable bit
nch_u3c0		.btequ		5,u3c0		; Data output select bit
ckpol_u3c0		.btequ		6,u3c0		; CLK polarity select bit
uform_u3c0		.btequ		7,u3c0		; Bit order select bit
;
;*------------------------------------------------------------------------------*
;*  UART3 Transmit/Receive Control Register 1                                   *
;*------------------------------------------------------------------------------*
u3c1		.equ	02ADh
;
te_u3c1			.btequ		0,u3c1		; Transmit enable bit
ti_u3c1			.btequ		1,u3c1		; Transmit buffer empty flag
re_u3c1			.btequ		2,u3c1		; Receive enable bit
ri_u3c1			.btequ		3,u3c1		; Receive complete flag
u3irs			.btequ		4,u3c1		; UART3 transmit interrupt source select bit
u3rrm			.btequ		5,u3c1		; UART3 continuous receive mode enable bit
u3lch			.btequ		6,u3c1		; Data logic select bit
u3ere			.btequ		7,u3c1		; Error signal output enable bit
;
;*------------------------------------------------------------------------------*
;*  UART3 Receive Buffer Register                                               *
;*------------------------------------------------------------------------------*
u3rb		.equ	02AEh
;
u3rbl		.equ	u3rb				; UART3 receive buffer register(low 8bit)
u3rbh		.equ	u3rb+1				; UART3 receive buffer register(high 8bit)
;
abt_u3rb		.btequ		11,u3rb		; Arbitration lost detect flag
oer_u3rb		.btequ		12,u3rb		; Overrun error flag
fer_u3rb		.btequ		13,u3rb		; Framing error flag
per_u3rb		.btequ		14,u3rb		; Parity error flag
sum_u3rb		.btequ		15,u3rb		; Error sum flag
;
;*------------------------------------------------------------------------------*
;*  I2C0 Data Shift Register                                                    *
;*------------------------------------------------------------------------------*
s00			.equ	02B0h
;
;*------------------------------------------------------------------------------*
;*  I2C0 Address Register 0                                                     *
;*------------------------------------------------------------------------------*
s0d0		.equ	02B2h
;
sad0_s0d0		.btequ		1,s0d0		; Slave address
sad1_s0d0		.btequ		2,s0d0		; Slave address
sad2_s0d0		.btequ		3,s0d0		; Slave address
sad3_s0d0		.btequ		4,s0d0		; Slave address
sad4_s0d0		.btequ		5,s0d0		; Slave address
sad5_s0d0		.btequ		6,s0d0		; Slave address
sad6_s0d0		.btequ		7,s0d0		; Slave address
;
;*------------------------------------------------------------------------------*
;*  I2C0 Control Register 0                                                     *
;*------------------------------------------------------------------------------*
s1d0		.equ	02B3h
;
bc0				.btequ		0,s1d0		; Bit counter(number of transmitted/received bits)
bc1				.btequ		1,s1d0		; Bit counter(number of transmitted/received bits)
bc2				.btequ		2,s1d0		; Bit counter(number of transmitted/received bits)
es0				.btequ		3,s1d0		; I2C-bus interface enable bit
als				.btequ		4,s1d0		; Data format selection bit
ihr				.btequ		6,s1d0		; I2C-bus interface reset bit
tiss			.btequ		7,s1d0		; I2C-bus interface pin input level select bit
;
;*------------------------------------------------------------------------------*
;*  I2C0 Clock Control Register                                                 *
;*------------------------------------------------------------------------------*
s20			.equ	02B4h
;
ccr0			.btequ		0,s20		; Bit rate control bit
ccr1			.btequ		1,s20		; Bit rate control bit
ccr2			.btequ		2,s20		; Bit rate control bit
ccr3			.btequ		3,s20		; Bit rate control bit
ccr4			.btequ		4,s20		; Bit rate control bit
fastmode		.btequ		5,s20		; SCL mode select bit
ackbit			.btequ		6,s20		; ACK bit
ackclk			.btequ		7,s20		; ACK clock bit
;
;*------------------------------------------------------------------------------*
;*  I2C0 Start/Stop Condition Control Register                                  *
;*------------------------------------------------------------------------------*
s2d0		.equ	02B5h
;
ssc0			.btequ		0,s2d0		; Start/stop condition setting bit
ssc1			.btequ		1,s2d0		; Start/stop condition setting bit
ssc2			.btequ		2,s2d0		; Start/stop condition setting bit
ssc3			.btequ		3,s2d0		; Start/stop condition setting bit
ssc4			.btequ		4,s2d0		; Start/stop condition setting bit
sip				.btequ		5,s2d0		; SCL/SDA interrupt pin polarity select bit
sis				.btequ		6,s2d0		; SCL/SDA interrupt pin select bit
stspsel			.btequ		7,s2d0		; Start/stop condition generation select bit
;
;*------------------------------------------------------------------------------*
;*  I2C0 Control Register 1                                                     *
;*------------------------------------------------------------------------------*
s3d0		.equ	02B6h
;
sim				.btequ		0,s3d0		; Stop condition detect interrupt enable bit
wit				.btequ		1,s3d0		; Data receive interrupt enable bit
sdam			.btequ		4,s3d0		; Internal SDA output monitor bit
sclm			.btequ		5,s3d0		; Internal SCL output monitor bit
ick0			.btequ		6,s3d0		; I2C-bus system clock select bit(Enabled when bits ICK4 to ICK2 in the S4D0 register are 000b)
ick1			.btequ		7,s3d0		; I2C-bus system clock select bit(Enabled when bits ICK4 to ICK2 in the S4D0 register are 000b)
;
;*------------------------------------------------------------------------------*
;*  I2C0 Control Register 2                                                     *
;*------------------------------------------------------------------------------*
s4d0		.equ	02B7h
;
toe				.btequ		0,s4d0		; Timeout detect function enable bit
tof				.btequ		1,s4d0		; Timeout detect flag
tosel			.btequ		2,s4d0		; Timeout detect time select bit
ick2			.btequ		3,s4d0		; I2C-bus system clock select bit
ick3			.btequ		4,s4d0		; I2C-bus system clock select bit
ick4			.btequ		5,s4d0		; I2C-bus system clock select bit
mslad			.btequ		6,s4d0		; Slave address control bit
scpin			.btequ		7,s4d0		; Stop condition detect interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  I2C0 Status Register 0                                                      *
;*------------------------------------------------------------------------------*
s10			.equ	02B8h
;
lrb				.btequ		0,s10		; Last receive bit
adr0			.btequ		1,s10		; General call detect flag
aas				.btequ		2,s10		; Slave address compare flag
al				.btequ		3,s10		; Arbitration lost detect flag
pin				.btequ		4,s10		; I2C-Bus interface interrupt request bit
bb				.btequ		5,s10		; Bus busy flag
trx				.btequ		6,s10		; Communication mode select bit 0
mst				.btequ		7,s10		; Communication mode select bit 1
;
;*------------------------------------------------------------------------------*
;*  I2C0 Status Register 1                                                      *
;*------------------------------------------------------------------------------*
s11			.equ	02B9h
;
aas0			.btequ		0,s11		; Slave address 0 compare flag
aas1			.btequ		1,s11		; Slave address 1 compare flag
aas2			.btequ		2,s11		; Slave address 2 compare flag
;
;*------------------------------------------------------------------------------*
;*  I2C0 Address Register 1                                                     *
;*------------------------------------------------------------------------------*
s0d1		.equ	02BAh
;
sad0_s0d1		.btequ		1,s0d1		; Slave address
sad1_s0d1		.btequ		2,s0d1		; Slave address
sad2_s0d1		.btequ		3,s0d1		; Slave address
sad3_s0d1		.btequ		4,s0d1		; Slave address
sad4_s0d1		.btequ		5,s0d1		; Slave address
sad5_s0d1		.btequ		6,s0d1		; Slave address
sad6_s0d1		.btequ		7,s0d1		; Slave address
;
;*------------------------------------------------------------------------------*
;*  I2C0 Address Register 2                                                     *
;*------------------------------------------------------------------------------*
s0d2		.equ	02BBh
;
sad0_s0d2		.btequ		1,s0d2		; Slave address
sad1_s0d2		.btequ		2,s0d2		; Slave address
sad2_s0d2		.btequ		3,s0d2		; Slave address
sad3_s0d2		.btequ		4,s0d2		; Slave address
sad4_s0d2		.btequ		5,s0d2		; Slave address
sad5_s0d2		.btequ		6,s0d2		; Slave address
sad6_s0d2		.btequ		7,s0d2		; Slave address
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 0                                                 *
;*------------------------------------------------------------------------------*
g1tm0		.equ	02C0h
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 0                                                 *
;*------------------------------------------------------------------------------*
g1po0		.equ	02C0h
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 1                                                 *
;*------------------------------------------------------------------------------*
g1tm1		.equ	02C2h
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 1                                                 *
;*------------------------------------------------------------------------------*
g1po1		.equ	02C2h
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 2                                                 *
;*------------------------------------------------------------------------------*
g1tm2		.equ	02C4h
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 2                                                 *
;*------------------------------------------------------------------------------*
g1po2		.equ	02C4h
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 3                                                 *
;*------------------------------------------------------------------------------*
g1tm3		.equ	02C6h
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 3                                                 *
;*------------------------------------------------------------------------------*
g1po3		.equ	02C6h
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 4                                                 *
;*------------------------------------------------------------------------------*
g1tm4		.equ	02C8h
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 4                                                 *
;*------------------------------------------------------------------------------*
g1po4		.equ	02C8h
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 5                                                 *
;*------------------------------------------------------------------------------*
g1tm5		.equ	02CAh
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 5                                                 *
;*------------------------------------------------------------------------------*
g1po5		.equ	02CAh
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 6                                                 *
;*------------------------------------------------------------------------------*
g1tm6		.equ	02CCh
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 6                                                 *
;*------------------------------------------------------------------------------*
g1po6		.equ	02CCh
;
;*------------------------------------------------------------------------------*
;*  Time measurement Register 7                                                 *
;*------------------------------------------------------------------------------*
g1tm7		.equ	02CEh
;
;*------------------------------------------------------------------------------*
;*  Pulse generation register 7                                                 *
;*------------------------------------------------------------------------------*
g1po7		.equ	02CEh
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 0                                      *
;*------------------------------------------------------------------------------*
g1pocr0		.equ	02D0h
;
mod0_g1pocr0	.btequ		0,g1pocr0	; Operating mode select bit
mod1_g1pocr0	.btequ		1,g1pocr0	; Operating mode select bit
ivl_g1pocr0		.btequ		4,g1pocr0	; Default output value select bit
rld_g1pocr0		.btequ		5,g1pocr0	; G1PO0 register value reload timing select bit
inv_g1pocr0		.btequ		7,g1pocr0	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 1                                      *
;*------------------------------------------------------------------------------*
g1pocr1		.equ	02D1h
;
mod0_g1pocr1	.btequ		0,g1pocr1	; Operating mode select bit
mod1_g1pocr1	.btequ		1,g1pocr1	; Operating mode select bit
ivl_g1pocr1		.btequ		4,g1pocr1	; Default output value select bit
rld_g1pocr1		.btequ		5,g1pocr1	; G1PO0 register value reload timing select bit
inv_g1pocr1		.btequ		7,g1pocr1	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 2                                      *
;*------------------------------------------------------------------------------*
g1pocr2		.equ	02D2h
;
mod0_g1pocr2	.btequ		0,g1pocr2	; Operating mode select bit
mod1_g1pocr2	.btequ		1,g1pocr2	; Operating mode select bit
ivl_g1pocr2		.btequ		4,g1pocr2	; Default output value select bit
rld_g1pocr2		.btequ		5,g1pocr2	; G1PO0 register value reload timing select bit
inv_g1pocr2		.btequ		7,g1pocr2	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 3                                      *
;*------------------------------------------------------------------------------*
g1pocr3		.equ	02D3h
;
mod0_g1pocr3	.btequ		0,g1pocr3	; Operating mode select bit
mod1_g1pocr3	.btequ		1,g1pocr3	; Operating mode select bit
ivl_g1pocr3		.btequ		4,g1pocr3	; Default output value select bit
rld_g1pocr3		.btequ		5,g1pocr3	; G1PO0 register value reload timing select bit
inv_g1pocr3		.btequ		7,g1pocr3	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 4                                      *
;*------------------------------------------------------------------------------*
g1pocr4		.equ	02D4h
;
mod0_g1pocr4	.btequ		0,g1pocr4	; Operating mode select bit
mod1_g1pocr4	.btequ		1,g1pocr4	; Operating mode select bit
ivl_g1pocr4		.btequ		4,g1pocr4	; Default output value select bit
rld_g1pocr4		.btequ		5,g1pocr4	; G1PO0 register value reload timing select bit
inv_g1pocr4		.btequ		7,g1pocr4	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 5                                      *
;*------------------------------------------------------------------------------*
g1pocr5		.equ	02D5h
;
mod0_g1pocr5	.btequ		0,g1pocr5	; Operating mode select bit
mod1_g1pocr5	.btequ		1,g1pocr5	; Operating mode select bit
ivl_g1pocr5		.btequ		4,g1pocr5	; Default output value select bit
rld_g1pocr5		.btequ		5,g1pocr5	; G1PO0 register value reload timing select bit
inv_g1pocr5		.btequ		7,g1pocr5	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 6                                      *
;*------------------------------------------------------------------------------*
g1pocr6		.equ	02D6h
;
mod0_g1pocr6	.btequ		0,g1pocr6	; Operating mode select bit
mod1_g1pocr6	.btequ		1,g1pocr6	; Operating mode select bit
ivl_g1pocr6		.btequ		4,g1pocr6	; Default output value select bit
rld_g1pocr6		.btequ		5,g1pocr6	; G1PO0 register value reload timing select bit
inv_g1pocr6		.btequ		7,g1pocr6	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Waveform Generation Control Register 7                                      *
;*------------------------------------------------------------------------------*
g1pocr7		.equ	02D7h
;
mod0_g1pocr7	.btequ		0,g1pocr7	; Operating mode select bit
mod1_g1pocr7	.btequ		1,g1pocr7	; Operating mode select bit
ivl_g1pocr7		.btequ		4,g1pocr7	; Default output value select bit
rld_g1pocr7		.btequ		5,g1pocr7	; G1PO0 register value reload timing select bit
inv_g1pocr7		.btequ		7,g1pocr7	; Output level inversion select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 0                                         *
;*------------------------------------------------------------------------------*
g1tmcr0		.equ	02D8h
;
cts0_g1tmcr0	.btequ		0,g1tmcr0	; Time measurement trigger select bit
cts1_g1tmcr0	.btequ		1,g1tmcr0	; Time measurement trigger select bit
df0_g1tmcr0		.btequ		2,g1tmcr0	; Digital filter function select bit
df1_g1tmcr0		.btequ		3,g1tmcr0	; Digital filter function select bit
gt_g1tmcr0		.btequ		4,g1tmcr0	; Gate function select bit
goc_g1tmcr0		.btequ		5,g1tmcr0	; Gate function release select bit
gsc_g1tmcr0		.btequ		6,g1tmcr0	; Gate function release bit
pr_g1tmcr0		.btequ		7,g1tmcr0	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 1                                         *
;*------------------------------------------------------------------------------*
g1tmcr1		.equ	02D9h
;
cts0_g1tmcr1	.btequ		0,g1tmcr1	; Time measurement trigger select bit
cts1_g1tmcr1	.btequ		1,g1tmcr1	; Time measurement trigger select bit
df0_g1tmcr1		.btequ		2,g1tmcr1	; Digital filter function select bit
df1_g1tmcr1		.btequ		3,g1tmcr1	; Digital filter function select bit
gt_g1tmcr1		.btequ		4,g1tmcr1	; Gate function select bit
goc_g1tmcr1		.btequ		5,g1tmcr1	; Gate function release select bit
gsc_g1tmcr1		.btequ		6,g1tmcr1	; Gate function release bit
pr_g1tmcr1		.btequ		7,g1tmcr1	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 2                                         *
;*------------------------------------------------------------------------------*
g1tmcr2		.equ	02DAh
;
cts0_g1tmcr2	.btequ		0,g1tmcr2	; Time measurement trigger select bit
cts1_g1tmcr2	.btequ		1,g1tmcr2	; Time measurement trigger select bit
df0_g1tmcr2		.btequ		2,g1tmcr2	; Digital filter function select bit
df1_g1tmcr2		.btequ		3,g1tmcr2	; Digital filter function select bit
gt_g1tmcr2		.btequ		4,g1tmcr2	; Gate function select bit
goc_g1tmcr2		.btequ		5,g1tmcr2	; Gate function release select bit
gsc_g1tmcr2		.btequ		6,g1tmcr2	; Gate function release bit
pr_g1tmcr2		.btequ		7,g1tmcr2	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 3                                         *
;*------------------------------------------------------------------------------*
g1tmcr3		.equ	02DBh
;
cts0_g1tmcr3	.btequ		0,g1tmcr3	; Time measurement trigger select bit
cts1_g1tmcr3	.btequ		1,g1tmcr3	; Time measurement trigger select bit
df0_g1tmcr3		.btequ		2,g1tmcr3	; Digital filter function select bit
df1_g1tmcr3		.btequ		3,g1tmcr3	; Digital filter function select bit
gt_g1tmcr3		.btequ		4,g1tmcr3	; Gate function select bit
goc_g1tmcr3		.btequ		5,g1tmcr3	; Gate function release select bit
gsc_g1tmcr3		.btequ		6,g1tmcr3	; Gate function release bit
pr_g1tmcr3		.btequ		7,g1tmcr3	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 4                                         *
;*------------------------------------------------------------------------------*
g1tmcr4		.equ	02DCh
;
cts0_g1tmcr4	.btequ		0,g1tmcr4	; Time measurement trigger select bit
cts1_g1tmcr4	.btequ		1,g1tmcr4	; Time measurement trigger select bit
df0_g1tmcr4		.btequ		2,g1tmcr4	; Digital filter function select bit
df1_g1tmcr4		.btequ		3,g1tmcr4	; Digital filter function select bit
gt_g1tmcr4		.btequ		4,g1tmcr4	; Gate function select bit
goc_g1tmcr4		.btequ		5,g1tmcr4	; Gate function release select bit
gsc_g1tmcr4		.btequ		6,g1tmcr4	; Gate function release bit
pr_g1tmcr4		.btequ		7,g1tmcr4	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 5                                         *
;*------------------------------------------------------------------------------*
g1tmcr5		.equ	02DDh
;
cts0_g1tmcr5	.btequ		0,g1tmcr5	; Time measurement trigger select bit
cts1_g1tmcr5	.btequ		1,g1tmcr5	; Time measurement trigger select bit
df0_g1tmcr5		.btequ		2,g1tmcr5	; Digital filter function select bit
df1_g1tmcr5		.btequ		3,g1tmcr5	; Digital filter function select bit
gt_g1tmcr5		.btequ		4,g1tmcr5	; Gate function select bit
goc_g1tmcr5		.btequ		5,g1tmcr5	; Gate function release select bit
gsc_g1tmcr5		.btequ		6,g1tmcr5	; Gate function release bit
pr_g1tmcr5		.btequ		7,g1tmcr5	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 6                                         *
;*------------------------------------------------------------------------------*
g1tmcr6		.equ	02DEh
;
cts0_g1tmcr6	.btequ		0,g1tmcr6	; Time measurement trigger select bit
cts1_g1tmcr6	.btequ		1,g1tmcr6	; Time measurement trigger select bit
df0_g1tmcr6		.btequ		2,g1tmcr6	; Digital filter function select bit
df1_g1tmcr6		.btequ		3,g1tmcr6	; Digital filter function select bit
gt_g1tmcr6		.btequ		4,g1tmcr6	; Gate function select bit
goc_g1tmcr6		.btequ		5,g1tmcr6	; Gate function release select bit
gsc_g1tmcr6		.btequ		6,g1tmcr6	; Gate function release bit
pr_g1tmcr6		.btequ		7,g1tmcr6	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Control Register 7                                         *
;*------------------------------------------------------------------------------*
g1tmcr7		.equ	02DFh
;
cts0_g1tmcr7	.btequ		0,g1tmcr7	; Time measurement trigger select bit
cts1_g1tmcr7	.btequ		1,g1tmcr7	; Time measurement trigger select bit
df0_g1tmcr7		.btequ		2,g1tmcr7	; Digital filter function select bit
df1_g1tmcr7		.btequ		3,g1tmcr7	; Digital filter function select bit
gt_g1tmcr7		.btequ		4,g1tmcr7	; Gate function select bit
goc_g1tmcr7		.btequ		5,g1tmcr7	; Gate function release select bit
gsc_g1tmcr7		.btequ		6,g1tmcr7	; Gate function release bit
pr_g1tmcr7		.btequ		7,g1tmcr7	; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  Base Timer Register                                                         *
;*------------------------------------------------------------------------------*
g1bt		.equ	02E0h
;
;*------------------------------------------------------------------------------*
;*  Base Timer Control Register 0                                               *
;*------------------------------------------------------------------------------*
g1bcr0		.equ	02E2h
;
bck0_g1bcr0		.btequ		0,g1bcr0	; Count source select bit
bck1_g1bcr0		.btequ		1,g1bcr0	; Count source select bit
rst4_g1bcr0		.btequ		2,g1bcr0	; Base timer reset source select bit4
ch7insel_g1bcr0	.btequ		6,g1bcr0	; Channel 7 input select bit
it_g1bcr0		.btequ		7,g1bcr0	; Base timer interrupt select bit
;
;*------------------------------------------------------------------------------*
;*  Base Timer Control Register 1                                               *
;*------------------------------------------------------------------------------*
g1bcr1		.equ	02E3h
;
rst1_g1bcr1		.btequ		1,g1bcr1	; Base timer reset source select bit1
rst2_g1bcr1		.btequ		2,g1bcr1	; Base timer reset source select bit2
bts_g1bcr1		.btequ		4,g1bcr1	; Base timer start bit
ud0_g1bcr1		.btequ		5,g1bcr1	; Increment/decrement control bit
ud1_g1bcr1		.btequ		6,g1bcr1	; Increment/decrement control bit
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Prescale Register 6                                        *
;*------------------------------------------------------------------------------*
g1tpr6		.equ	02E4h
;
;*------------------------------------------------------------------------------*
;*  Time Measurement Prescale Register 7                                        *
;*------------------------------------------------------------------------------*
g1tpr7		.equ	02E5h
;
;*------------------------------------------------------------------------------*
;*  Function Enable Register                                                    *
;*------------------------------------------------------------------------------*
g1fe		.equ	02E6h
;
ife0_g1fe		.btequ		0,g1fe		; Channel 0 function enable bit
ife1_g1fe		.btequ		1,g1fe		; Channel 1 function enable bit
ife2_g1fe		.btequ		2,g1fe		; Channel 2 function enable bit
ife3_g1fe		.btequ		3,g1fe		; Channel 3 function enable bit
ife4_g1fe		.btequ		4,g1fe		; Channel 4 function enable bit
ife5_g1fe		.btequ		5,g1fe		; Channel 5 function enable bit
ife6_g1fe		.btequ		6,g1fe		; Channel 6 function enable bit
ife7_g1fe		.btequ		7,g1fe		; Channel 7 function enable bit
;
;*------------------------------------------------------------------------------*
;*  Function Select Register                                                    *
;*------------------------------------------------------------------------------*
g1fs		.equ	02E7h
;
fsc0_g1fs		.btequ		0,g1fs		; Channel 0 time measurement/waveform generation function select bit
fsc1_g1fs		.btequ		1,g1fs		; Channel 1 time measurement/waveform generation function select bit
fsc2_g1fs		.btequ		2,g1fs		; Channel 2 time measurement/waveform generation function select bit
fsc3_g1fs		.btequ		3,g1fs		; Channel 3 time measurement/waveform generation function select bit
fsc4_g1fs		.btequ		4,g1fs		; Channel 4 time measurement/waveform generation function select bit
fsc5_g1fs		.btequ		5,g1fs		; Channel 5 time measurement/waveform generation function select bit
fsc6_g1fs		.btequ		6,g1fs		; Channel 6 time measurement/waveform generation function select bit
fsc7_g1fs		.btequ		7,g1fs		; Channel 7 time measurement/waveform generation function select bit
;
;*------------------------------------------------------------------------------*
;*  Base Timer Reset Register                                                   *
;*------------------------------------------------------------------------------*
g1btrr		.equ	02E8h
;
;*------------------------------------------------------------------------------*
;*  Count Source Divide Register                                                *
;*------------------------------------------------------------------------------*
g1dv		.equ	02EAh
;
;*------------------------------------------------------------------------------*
;*  Waveform Output Master Enable Register                                      *
;*------------------------------------------------------------------------------*
g1oer		.equ	02ECh
;
eoc0			.btequ		0,g1oer		; OUTC1_0 output disable bit
eoc1			.btequ		1,g1oer		; OUTC1_1 output disable bit
eoc2			.btequ		2,g1oer		; OUTC1_2 output disable bit
eoc3			.btequ		3,g1oer		; OUTC1_3 output disable bit
eoc4			.btequ		4,g1oer		; OUTC1_4 output disable bit
eoc5			.btequ		5,g1oer		; OUTC1_5 output disable bit
eoc6			.btequ		6,g1oer		; OUTC1_6 output disable bit
eoc7			.btequ		7,g1oer		; OUTC1_7 output disable bit
;
;*------------------------------------------------------------------------------*
;*  Timer S I/O Control Register 0                                              *
;*------------------------------------------------------------------------------*
g1ior0		.equ	02EEh
;
io00			.btequ		0,g1ior0	; OUTC1_0 output control bit
io01			.btequ		1,g1ior0	; OUTC1_0 output control bit
io10			.btequ		2,g1ior0	; OUTC1_1 output control bit
io11			.btequ		3,g1ior0	; OUTC1_1 output control bit
io20			.btequ		4,g1ior0	; OUTC1_2 output control bit
io21			.btequ		5,g1ior0	; OUTC1_2 output control bit
io30			.btequ		6,g1ior0	; OUTC1_3 output control bit
io31			.btequ		7,g1ior0	; OUTC1_3 output control bit
;
;*------------------------------------------------------------------------------*
;*  Timer S I/O Control Register 1                                              *
;*------------------------------------------------------------------------------*
g1ior1		.equ	02EFh
;
io40			.btequ		0,g1ior1	; OUTC1_4 output control bit
io41			.btequ		1,g1ior1	; OUTC1_4 output control bit
io50			.btequ		2,g1ior1	; OUTC1_5 output control bit
io51			.btequ		3,g1ior1	; OUTC1_5 output control bit
io60			.btequ		4,g1ior1	; OUTC1_6 output control bit
io61			.btequ		5,g1ior1	; OUTC1_6 output control bit
io70			.btequ		6,g1ior1	; OUTC1_7 output control bit
io71			.btequ		7,g1ior1	; OUTC1_7 output control bit
;
;*------------------------------------------------------------------------------*
;*  Interrupt Request Register                                                  *
;*------------------------------------------------------------------------------*
g1ir		.equ	02F0h
;
g1ir0			.btequ		0,g1ir		; Channel 0 interrupt request bit
g1ir1			.btequ		1,g1ir		; Channel 1 interrupt request bit
g1ir2			.btequ		2,g1ir		; Channel 2 interrupt request bit
g1ir3			.btequ		3,g1ir		; Channel 3 interrupt request bit
g1ir4			.btequ		4,g1ir		; Channel 4 interrupt request bit
g1ir5			.btequ		5,g1ir		; Channel 5 interrupt request bit
g1ir6			.btequ		6,g1ir		; Channel 6 interrupt request bit
g1ir7			.btequ		7,g1ir		; Channel 7 interrupt request bit
;
;*------------------------------------------------------------------------------*
;*  Interrupt Enable Register 0                                                 *
;*------------------------------------------------------------------------------*
g1ie0		.equ	02F1h
;
g1ie00			.btequ		0,g1ie0		; Channel 0 interrupt enable 0 bit
g1ie01			.btequ		1,g1ie0		; Channel 1 interrupt enable 0 bit
g1ie02			.btequ		2,g1ie0		; Channel 2 interrupt enable 0 bit
g1ie03			.btequ		3,g1ie0		; Channel 3 interrupt enable 0 bit
g1ie04			.btequ		4,g1ie0		; Channel 4 interrupt enable 0 bit
g1ie05			.btequ		5,g1ie0		; Channel 5 interrupt enable 0 bit
g1ie06			.btequ		6,g1ie0		; Channel 6 interrupt enable 0 bit
g1ie07			.btequ		7,g1ie0		; Channel 7 interrupt enable 0 bit
;
;*------------------------------------------------------------------------------*
;*  Interrupt Enable Register 1                                                 *
;*------------------------------------------------------------------------------*
g1ie1		.equ	02F2h
;
g1ie10			.btequ		0,g1ie1		; Channel 0 interrupt enable 1 bit
g1ie11			.btequ		1,g1ie1		; Channel 1 interrupt enable 1 bit
g1ie12			.btequ		2,g1ie1		; Channel 2 interrupt enable 1 bit
g1ie13			.btequ		3,g1ie1		; Channel 3 interrupt enable 1 bit
g1ie14			.btequ		4,g1ie1		; Channel 4 interrupt enable 1 bit
g1ie15			.btequ		5,g1ie1		; Channel 5 interrupt enable 1 bit
g1ie16			.btequ		6,g1ie1		; Channel 6 interrupt enable 1 bit
g1ie17			.btequ		7,g1ie1		; Channel 7 interrupt enable 1 bit
;
;*------------------------------------------------------------------------------*
;*  NMI Digital Debounce Register                                               *
;*------------------------------------------------------------------------------*
nddr		.equ	02FEh
;
;*------------------------------------------------------------------------------*
;*  P17 Digital Debounce Register                                               *
;*------------------------------------------------------------------------------*
p17ddr		.equ	02FFh
;
;*------------------------------------------------------------------------------*
;*  Timer B3/B4/B5 Count Start Flag                                             *
;*------------------------------------------------------------------------------*
tbsr		.equ	0300h
;
tb3s			.btequ		5,tbsr		; Timer B3 count start flag
tb4s			.btequ		6,tbsr		; Timer B4 count start flag
tb5s			.btequ		7,tbsr		; Timer B5 count start flag
;
;*------------------------------------------------------------------------------*
;*  Timer A1-1 Register                                                         *
;*------------------------------------------------------------------------------*
ta11		.equ	0302h
;
;*------------------------------------------------------------------------------*
;*  Timer A2-1 Register                                                         *
;*------------------------------------------------------------------------------*
ta21		.equ	0304h
;
;*------------------------------------------------------------------------------*
;*  Timer A4-1 Register                                                         *
;*------------------------------------------------------------------------------*
ta41		.equ	0306h
;
;*------------------------------------------------------------------------------*
;*  Three-Phase PWM Control Register 0                                          *
;*------------------------------------------------------------------------------*
invc0		.equ	0308h
;
inv00			.btequ		0,invc0		; ICTB2 count condition select bit
inv01			.btequ		1,invc0		; ICTB2 count condition select bit
inv02			.btequ		2,invc0		; Three-phase motor control timer function enable bit
inv03			.btequ		3,invc0		; Three-phase motor control timer output control bit
inv04			.btequ		4,invc0		; High- and low-side simultaneous turn-on disable
inv05			.btequ		5,invc0		; High- and low-side simultaneous turn-on detect flag
inv06			.btequ		6,invc0		; Modulation mode select bit
inv07			.btequ		7,invc0		; Software trigger select bit
;
;*------------------------------------------------------------------------------*
;*  Three-Phase PWM Control Register 1                                          *
;*------------------------------------------------------------------------------*
invc1		.equ	0309h
;
inv10			.btequ		0,invc1		; Timer A1, A2 and A4 start trigger select bit
inv11			.btequ		1,invc1		; Timer A1-1, A2-1 and A4-1 control bit
inv12			.btequ		2,invc1		; Dead time timer count source select bit
inv13			.btequ		3,invc1		; Carrier wave rise/fall detect flag
inv14			.btequ		4,invc1		; Active level control bit
inv15			.btequ		5,invc1		; Dead time disable bit
inv16			.btequ		6,invc1		; Dead time timer trigger select bit
;
;*------------------------------------------------------------------------------*
;*  Three-Phase Output Buffer Register 0                                        *
;*------------------------------------------------------------------------------*
idb0		.equ	030Ah
;
du0				.btequ		0,idb0		; U-phase output buffer 0
dub0			.btequ		1,idb0		; U~-phase output buffer 0
dv0				.btequ		2,idb0		; V-phase output buffer 0
dvb0			.btequ		3,idb0		; V~-phase output buffer 0
dw0				.btequ		4,idb0		; W-phase output buffer 0
dwb0			.btequ		5,idb0		; W~-phase output buffer 0
;
;*------------------------------------------------------------------------------*
;*  Three-Phase Output Buffer Register 1                                        *
;*------------------------------------------------------------------------------*
idb1		.equ	030Bh
;
du1				.btequ		0,idb1		; U-phase output buffer 1
dub1			.btequ		1,idb1		; U~-phase output buffer 1
dv1				.btequ		2,idb1		; V-phase output buffer 1
dvb1			.btequ		3,idb1		; V~-phase output buffer 1
dw1				.btequ		4,idb1		; W-phase output buffer 1
dwb1			.btequ		5,idb1		; W~-phase output buffer 1
;
;*------------------------------------------------------------------------------*
;*  Dead Time Timer                                                             *
;*------------------------------------------------------------------------------*
dtt			.equ	030Ch
;
;*------------------------------------------------------------------------------*
;*  Timer B2 Interrupt Generation Frequency Set Counter                         *
;*------------------------------------------------------------------------------*
ictb2		.equ	030Dh
;
;*------------------------------------------------------------------------------*
;*  Position-Data-Retain Function Control Register                              *
;*------------------------------------------------------------------------------*
pdrf		.equ	030Eh
;
pdrw			.btequ		0,pdrf		; W-phase position data retain bit
pdrv			.btequ		1,pdrf		; V-phase position data retain bit
pdru			.btequ		2,pdrf		; U-phase position data retain bit
pdrt			.btequ		3,pdrf		; Retain-trigger polarity select bit
;
;*------------------------------------------------------------------------------*
;*  Timer B3 Register                                                           *
;*------------------------------------------------------------------------------*
tb3			.equ	0310h
;
;*------------------------------------------------------------------------------*
;*  Timer B4 Register                                                           *
;*------------------------------------------------------------------------------*
tb4			.equ	0312h
;
;*------------------------------------------------------------------------------*
;*  Timer B5 Register                                                           *
;*------------------------------------------------------------------------------*
tb5			.equ	0314h
;
;*------------------------------------------------------------------------------*
;*  Port Function Control Register                                              *
;*------------------------------------------------------------------------------*
pfcr		.equ	0318h
;
pfc0			.btequ		0,pfcr		; Port P8_0 output function select bit
pfc1			.btequ		1,pfcr		; Port P8_1 output function select bit
pfc2			.btequ		2,pfcr		; Port P7_2 output function select bit
pfc3			.btequ		3,pfcr		; Port P7_3 output function select bit
pfc4			.btequ		4,pfcr		; Port P7_4 output function select bit
pfc5			.btequ		5,pfcr		; Port P7_5 output function select bit
;
;*------------------------------------------------------------------------------*
;*  Timer B3 Mode Register                                                      *
;*------------------------------------------------------------------------------*
tb3mr		.equ	031Bh
;
tmod0_tb3mr		.btequ		0,tb3mr		; Operation mode select bit
tmod1_tb3mr		.btequ		1,tb3mr		; Operation mode select bit
mr0_tb3mr		.btequ		2,tb3mr		; Function varies with each operation mode
mr1_tb3mr		.btequ		3,tb3mr		; Function varies with each operation mode
mr3_tb3mr		.btequ		5,tb3mr		; Function varies with each operation mode
tck0_tb3mr		.btequ		6,tb3mr		; Count source select bit(Function varies with each operation mode)
tck1_tb3mr		.btequ		7,tb3mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer B4 Mode Register                                                      *
;*------------------------------------------------------------------------------*
tb4mr		.equ	031Ch
;
tmod0_tb4mr		.btequ		0,tb4mr		; Operation mode select bit
tmod1_tb4mr		.btequ		1,tb4mr		; Operation mode select bit
mr0_tb4mr		.btequ		2,tb4mr		; Function varies with each operation mode
mr1_tb4mr		.btequ		3,tb4mr		; Function varies with each operation mode
mr3_tb4mr		.btequ		5,tb4mr		; Function varies with each operation mode
tck0_tb4mr		.btequ		6,tb4mr		; Count source select bit(Function varies with each operation mode)
tck1_tb4mr		.btequ		7,tb4mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer B5 Mode Register                                                      *
;*------------------------------------------------------------------------------*
tb5mr		.equ	031Dh
;
tmod0_tb5mr		.btequ		0,tb5mr		; Operation mode select bit
tmod1_tb5mr		.btequ		1,tb5mr		; Operation mode select bit
mr0_tb5mr		.btequ		2,tb5mr		; Function varies with each operation mode
mr1_tb5mr		.btequ		3,tb5mr		; Function varies with each operation mode
mr3_tb5mr		.btequ		5,tb5mr		; Function varies with each operation mode
tck0_tb5mr		.btequ		6,tb5mr		; Count source select bit(Function varies with each operation mode)
tck1_tb5mr		.btequ		7,tb5mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Count Start Flag                                                            *
;*------------------------------------------------------------------------------*
tabsr		.equ	0320h
;
ta0s			.btequ		0,tabsr		; Timer A0 count start flag
ta1s			.btequ		1,tabsr		; Timer A1 count start flag
ta2s			.btequ		2,tabsr		; Timer A2 count start flag
ta3s			.btequ		3,tabsr		; Timer A3 count start flag
ta4s			.btequ		4,tabsr		; Timer A4 count start flag
tb0s			.btequ		5,tabsr		; Timer B0 count start flag
tb1s			.btequ		6,tabsr		; Timer B1 count start flag
tb2s			.btequ		7,tabsr		; Timer B2 count start flag
;
;*------------------------------------------------------------------------------*
;*  One-Shot Start Flag                                                         *
;*------------------------------------------------------------------------------*
onsf		.equ	0322h
;
ta0os			.btequ		0,onsf		; Timer A0 one-shot start flag
ta1os			.btequ		1,onsf		; Timer A1 one-shot start flag
ta2os			.btequ		2,onsf		; Timer A2 one-shot start flag
ta3os			.btequ		3,onsf		; Timer A3 one-shot start flag
ta4os			.btequ		4,onsf		; Timer A4 one-shot start flag
tazie			.btequ		5,onsf		; Z-phase input enable bit
ta0tgl			.btequ		6,onsf		; Timer A0 event/trigger select bit
ta0tgh			.btequ		7,onsf		; Timer A0 event/trigger select bit
;
;*------------------------------------------------------------------------------*
;*  Trigger Select Register                                                     *
;*------------------------------------------------------------------------------*
trgsr		.equ	0323h
;
ta1tgl			.btequ		0,trgsr		; Timer A1 event/trigger select bit
ta1tgh			.btequ		1,trgsr		; Timer A1 event/trigger select bit
ta2tgl			.btequ		2,trgsr		; Timer A2 event/trigger select bit
ta2tgh			.btequ		3,trgsr		; Timer A2 event/trigger select bit
ta3tgl			.btequ		4,trgsr		; Timer A3 event/trigger select bit
ta3tgh			.btequ		5,trgsr		; Timer A3 event/trigger select bit
ta4tgl			.btequ		6,trgsr		; Timer A4 event/trigger select bit
ta4tgh			.btequ		7,trgsr		; Timer A4 event/trigger select bit
;
;*------------------------------------------------------------------------------*
;*  Increment/Decrement Flag                                                    *
;*------------------------------------------------------------------------------*
udf			.equ	0324h
;
ta0ud			.btequ		0,udf		; Timer A0 increment/decrement flag
ta1ud			.btequ		1,udf		; Timer A1 increment/decrement flag
ta2ud			.btequ		2,udf		; Timer A2 increment/decrement flag
ta3ud			.btequ		3,udf		; Timer A3 increment/decrement flag
ta4ud			.btequ		4,udf		; Timer A4 increment/decrement flag
ta2p			.btequ		5,udf		; Timer A2 two-phase pulse signal processing select bit
ta3p			.btequ		6,udf		; Timer A3 two-phase pulse signal processing select bit
ta4p			.btequ		7,udf		; Timer A4 two-phase pulse signal processing select bit
;
;*------------------------------------------------------------------------------*
;*  Timer A0 Register                                                           *
;*------------------------------------------------------------------------------*
ta0			.equ	0326h
;
;*------------------------------------------------------------------------------*
;*  Timer A1 Register                                                           *
;*------------------------------------------------------------------------------*
ta1			.equ	0328h
;
;*------------------------------------------------------------------------------*
;*  Timer A2 Register                                                           *
;*------------------------------------------------------------------------------*
ta2			.equ	032Ah
;
;*------------------------------------------------------------------------------*
;*  Timer A3 Register                                                           *
;*------------------------------------------------------------------------------*
ta3			.equ	032Ch
;
;*------------------------------------------------------------------------------*
;*  Timer A4 Register                                                           *
;*------------------------------------------------------------------------------*
ta4			.equ	032Eh
;
;*------------------------------------------------------------------------------*
;*  Timer B0 Register                                                           *
;*------------------------------------------------------------------------------*
tb0			.equ	0330h
;
;*------------------------------------------------------------------------------*
;*  Timer B1 Register                                                           *
;*------------------------------------------------------------------------------*
tb1			.equ	0332h
;
;*------------------------------------------------------------------------------*
;*  Timer B2 Register                                                           *
;*------------------------------------------------------------------------------*
tb2			.equ	0334h
;
;*------------------------------------------------------------------------------*
;*  Timer A0 Mode Register                                                      *
;*------------------------------------------------------------------------------*
ta0mr		.equ	0336h
;
tmod0_ta0mr		.btequ		0,ta0mr		; Operation mode select bit
tmod1_ta0mr		.btequ		1,ta0mr		; Operation mode select bit
mr0_ta0mr		.btequ		2,ta0mr		; Function varies with each operation mode
mr1_ta0mr		.btequ		3,ta0mr		; Function varies with each operation mode
mr2_ta0mr		.btequ		4,ta0mr		; Function varies with each operation mode
mr3_ta0mr		.btequ		5,ta0mr		; Function varies with each operation mode
tck0_ta0mr		.btequ		6,ta0mr		; Count source select bit(Function varies with each operation mode)
tck1_ta0mr		.btequ		7,ta0mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer A1 Mode Register                                                      *
;*------------------------------------------------------------------------------*
ta1mr		.equ	0337h
;
tmod0_ta1mr		.btequ		0,ta1mr		; Operation mode select bit
tmod1_ta1mr		.btequ		1,ta1mr		; Operation mode select bit
mr0_ta1mr		.btequ		2,ta1mr		; Function varies with each operation mode
mr1_ta1mr		.btequ		3,ta1mr		; Function varies with each operation mode
mr2_ta1mr		.btequ		4,ta1mr		; Function varies with each operation mode
mr3_ta1mr		.btequ		5,ta1mr		; Function varies with each operation mode
tck0_ta1mr		.btequ		6,ta1mr		; Count source select bit(Function varies with each operation mode)
tck1_ta1mr		.btequ		7,ta1mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer A2 Mode Register                                                      *
;*------------------------------------------------------------------------------*
ta2mr		.equ	0338h
;
tmod0_ta2mr		.btequ		0,ta2mr		; Operation mode select bit
tmod1_ta2mr		.btequ		1,ta2mr		; Operation mode select bit
mr0_ta2mr		.btequ		2,ta2mr		; Function varies with each operation mode
mr1_ta2mr		.btequ		3,ta2mr		; Function varies with each operation mode
mr2_ta2mr		.btequ		4,ta2mr		; Function varies with each operation mode
mr3_ta2mr		.btequ		5,ta2mr		; Function varies with each operation mode
tck0_ta2mr		.btequ		6,ta2mr		; Count source select bit(Function varies with each operation mode)
tck1_ta2mr		.btequ		7,ta2mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer A3 Mode Register                                                      *
;*------------------------------------------------------------------------------*
ta3mr		.equ	0339h
;
tmod0_ta3mr		.btequ		0,ta3mr		; Operation mode select bit
tmod1_ta3mr		.btequ		1,ta3mr		; Operation mode select bit
mr0_ta3mr		.btequ		2,ta3mr		; Function varies with each operation mode
mr1_ta3mr		.btequ		3,ta3mr		; Function varies with each operation mode
mr2_ta3mr		.btequ		4,ta3mr		; Function varies with each operation mode
mr3_ta3mr		.btequ		5,ta3mr		; Function varies with each operation mode
tck0_ta3mr		.btequ		6,ta3mr		; Count source select bit(Function varies with each operation mode)
tck1_ta3mr		.btequ		7,ta3mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer A4 Mode Register                                                      *
;*------------------------------------------------------------------------------*
ta4mr		.equ	033Ah
;
tmod0_ta4mr		.btequ		0,ta4mr		; Operation mode select bit
tmod1_ta4mr		.btequ		1,ta4mr		; Operation mode select bit
mr0_ta4mr		.btequ		2,ta4mr		; Function varies with each operation mode
mr1_ta4mr		.btequ		3,ta4mr		; Function varies with each operation mode
mr2_ta4mr		.btequ		4,ta4mr		; Function varies with each operation mode
mr3_ta4mr		.btequ		5,ta4mr		; Function varies with each operation mode
tck0_ta4mr		.btequ		6,ta4mr		; Count source select bit(Function varies with each operation mode)
tck1_ta4mr		.btequ		7,ta4mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer B0 Mode Register                                                      *
;*------------------------------------------------------------------------------*
tb0mr		.equ	033Bh
;
tmod0_tb0mr		.btequ		0,tb0mr		; Operation mode select bit
tmod1_tb0mr		.btequ		1,tb0mr		; Operation mode select bit
mr0_tb0mr		.btequ		2,tb0mr		; Function varies with each operation mode
mr1_tb0mr		.btequ		3,tb0mr		; Function varies with each operation mode
mr3_tb0mr		.btequ		5,tb0mr		; Function varies with each operation mode
tck0_tb0mr		.btequ		6,tb0mr		; Count source select bit(Function varies with each operation mode)
tck1_tb0mr		.btequ		7,tb0mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer B1 Mode Register                                                      *
;*------------------------------------------------------------------------------*
tb1mr		.equ	033Ch
;
tmod0_tb1mr		.btequ		0,tb1mr		; Operation mode select bit
tmod1_tb1mr		.btequ		1,tb1mr		; Operation mode select bit
mr0_tb1mr		.btequ		2,tb1mr		; Function varies with each operation mode
mr1_tb1mr		.btequ		3,tb1mr		; Function varies with each operation mode
mr3_tb1mr		.btequ		5,tb1mr		; Function varies with each operation mode
tck0_tb1mr		.btequ		6,tb1mr		; Count source select bit(Function varies with each operation mode)
tck1_tb1mr		.btequ		7,tb1mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer B2 Mode Register                                                      *
;*------------------------------------------------------------------------------*
tb2mr		.equ	033Dh
;
tmod0_tb2mr		.btequ		0,tb2mr		; Operation mode select bit
tmod1_tb2mr		.btequ		1,tb2mr		; Operation mode select bit
mr0_tb2mr		.btequ		2,tb2mr		; Function varies with each operation mode
mr1_tb2mr		.btequ		3,tb2mr		; Function varies with each operation mode
mr3_tb2mr		.btequ		5,tb2mr		; Function varies with each operation mode
tck0_tb2mr		.btequ		6,tb2mr		; Count source select bit(Function varies with each operation mode)
tck1_tb2mr		.btequ		7,tb2mr		; Count source select bit(Function varies with each operation mode)
;
;*------------------------------------------------------------------------------*
;*  Timer B2 Special Mode Register                                              *
;*------------------------------------------------------------------------------*
tb2sc		.equ	033Eh
;
pwcon			.btequ		0,tb2sc		; Timer B2 reload timing switch bit
ivpcr1			.btequ		1,tb2sc		; Three-phase output port SD~ control bit 1
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Second Data Register                                        *
;*------------------------------------------------------------------------------*
rtcsec		.equ	0340h
;
sc00			.btequ		0,rtcsec	; First digit of second count bit
sc01			.btequ		1,rtcsec	; First digit of second count bit
sc02			.btequ		2,rtcsec	; First digit of second count bit
sc03			.btequ		3,rtcsec	; First digit of second count bit
sc10			.btequ		4,rtcsec	; Second digit of second count bit
sc11			.btequ		5,rtcsec	; Second digit of second count bit
sc12			.btequ		6,rtcsec	; Second digit of second count bit
bsy				.btequ		7,rtcsec	; Real-time clock busy flag
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Minute Data Register                                        *
;*------------------------------------------------------------------------------*
rtcmin		.equ	0341h
;
mn00			.btequ		0,rtcmin	; First digit of minute count bit
mn01			.btequ		1,rtcmin	; First digit of minute count bit
mn02			.btequ		2,rtcmin	; First digit of minute count bit
mn03			.btequ		3,rtcmin	; First digit of minute count bit
mn10			.btequ		4,rtcmin	; Second digit of minute count bit
mn11			.btequ		5,rtcmin	; Second digit of minute count bit
mn12			.btequ		6,rtcmin	; Second digit of minute count bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Hour Data Register                                          *
;*------------------------------------------------------------------------------*
rtchr		.equ	0342h
;
hr00			.btequ		0,rtchr		; First digit of hour count bit
hr01			.btequ		1,rtchr		; First digit of hour count bit
hr02			.btequ		2,rtchr		; First digit of hour count bit
hr03			.btequ		3,rtchr		; First digit of hour count bit
hr10			.btequ		4,rtchr		; Second digit of hour count bit
hr11			.btequ		5,rtchr		; Second digit of hour count bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Day Data Register                                           *
;*------------------------------------------------------------------------------*
rtcwk		.equ	0343h
;
wk0				.btequ		0,rtcwk		; Day count bit
wk1				.btequ		1,rtcwk		; Day count bit
wk2				.btequ		2,rtcwk		; Day count bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Control Register 1                                          *
;*------------------------------------------------------------------------------*
rtccr1		.equ	0344h
;
tcstf			.btequ		1,rtccr1	; Real-time clock count status flag
toena			.btequ		2,rtccr1	; RTCOUT pin output bit
rtcrst			.btequ		4,rtccr1	; Real-time clock reset bit
rtcpm			.btequ		5,rtccr1	; a.m./p.m. bit
h12h24			.btequ		6,rtccr1	; Operating mode select bit
tstart			.btequ		7,rtccr1	; Real-time clock count start bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Control Register 2                                          *
;*------------------------------------------------------------------------------*
rtccr2		.equ	0345h
;
seie			.btequ		0,rtccr2	; Periodic interrupt triggered every second enable bit
mnie			.btequ		1,rtccr2	; Periodic interrupt triggered every minute enable bit
hrie			.btequ		2,rtccr2	; Periodic interrupt triggered every hour enable bit
dyie			.btequ		3,rtccr2	; Periodic interrupt triggered every day enable bit
wkie			.btequ		4,rtccr2	; Periodic interrupt triggered every week enable bit
rtccmp0			.btequ		5,rtccr2	; Compare mode select bit
rtccmp1			.btequ		6,rtccr2	; Compare mode select bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Count Source Select Register                                *
;*------------------------------------------------------------------------------*
rtccsr		.equ	0346h
;
rcs0			.btequ		0,rtccsr	; Count source select bit
rcs1			.btequ		1,rtccsr	; Count source select bit
rcs2			.btequ		2,rtccsr	; Count source frequency select bit
rcs3			.btequ		3,rtccsr	; Count source frequency select bit
rcs4			.btequ		4,rtccsr	; Count source frequency select bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Second Compare Data Register                                *
;*------------------------------------------------------------------------------*
rtccsec		.equ	0348h
;
scmp00			.btequ		0,rtccsec	; First digit of second compare data bit
scmp01			.btequ		1,rtccsec	; First digit of second compare data bit
scmp02			.btequ		2,rtccsec	; First digit of second compare data bit
scmp03			.btequ		3,rtccsec	; First digit of second compare data bit
scmp10			.btequ		4,rtccsec	; Second digit of second compare data bit
scmp11			.btequ		5,rtccsec	; Second digit of second compare data bit
scmp12			.btequ		6,rtccsec	; Second digit of second compare data bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Minute Compare Data Register                                *
;*------------------------------------------------------------------------------*
rtccmin		.equ	0349h
;
mcmp00			.btequ		0,rtccmin	; First digit of minute compare data bit
mcmp01			.btequ		1,rtccmin	; First digit of minute compare data bit
mcmp02			.btequ		2,rtccmin	; First digit of minute compare data bit
mcmp03			.btequ		3,rtccmin	; First digit of minute compare data bit
mcmp10			.btequ		4,rtccmin	; Second digit of minute compare data bit
mcmp11			.btequ		5,rtccmin	; Second digit of minute compare data bit
mcmp12			.btequ		6,rtccmin	; Second digit of minute compare data bit
;
;*------------------------------------------------------------------------------*
;*  Real-Time Clock Hour Compare Data Register                                  *
;*------------------------------------------------------------------------------*
rtcchr		.equ	034Ah
;
hcmp00			.btequ		0,rtcchr	; First digit of hour compare data bit
hcmp01			.btequ		1,rtcchr	; First digit of hour compare data bit
hcmp02			.btequ		2,rtcchr	; First digit of hour compare data bit
hcmp03			.btequ		3,rtcchr	; First digit of hour compare data bit
hcmp10			.btequ		4,rtcchr	; Second digit of hour compare data bit
hcmp11			.btequ		5,rtcchr	; Second digit of hour compare data bit
pmcmp			.btequ		6,rtcchr	; a.m./p.m. compare bit
;
;*------------------------------------------------------------------------------*
;*  SS0 Bit Counter Register                                                    *
;*------------------------------------------------------------------------------*
ss0br		.equ	0353h
;
bs0_ss0br		.btequ		0,ss0br		; Serial bus interface data transfer length bit
bs1_ss0br		.btequ		1,ss0br		; Serial bus interface data transfer length bit
bs2_ss0br		.btequ		2,ss0br		; Serial bus interface data transfer length bit
bs3_ss0br		.btequ		3,ss0br		; Serial bus interface data transfer length bit
;
;*------------------------------------------------------------------------------*
;*  SS0 Transmit Data Register                                                  *
;*------------------------------------------------------------------------------*
ss0tdr		.equ	0354h
;
ss0tdrl		.equ	ss0tdr				; SS0 transmit data register(low 8bit)
ss0tdrh		.equ	ss0tdr+1			; SS0 transmit data register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  SS0 Receive Data Register                                                   *
;*------------------------------------------------------------------------------*
ss0rdr		.equ	0356h
;
ss0rdrl		.equ	ss0rdr				; SS0 receive data register(low 8bit)
ss0rdrh		.equ	ss0rdr+1			; SS0 receive data register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  SS0 Control Register H                                                      *
;*------------------------------------------------------------------------------*
ss0crh		.equ	0358h
;
cks0_ss0crh		.btequ		0,ss0crh	; Transmit/Receive Clock Rate Select Bit
cks1_ss0crh		.btequ		1,ss0crh	; Transmit/Receive Clock Rate Select Bit
cks2_ss0crh		.btequ		2,ss0crh	; Transmit/Receive Clock Rate Select Bit
mss_ss0crh		.btequ		5,ss0crh	; Master/Slave Mode Select Bit
rsstp_ss0crh	.btequ		6,ss0crh	; Receive Single Stop bit
;
;*------------------------------------------------------------------------------*
;*  SS0L Control Register L                                                     *
;*------------------------------------------------------------------------------*
ss0crl		.equ	0359h
;
sres_ss0crl		.btequ		1,ss0crl	; Synchronous Serial Interface Controller Reset Bit
solp_ss0crl		.btequ		4,ss0crl	; SOL Write Protect Bit
sol_ss0crl		.btequ		5,ss0crl	; Serial Data Output Setting Bit
;
;*------------------------------------------------------------------------------*
;*  SS0 Mode Register                                                           *
;*------------------------------------------------------------------------------*
ss0mr		.equ	035Ah
;
bc0_ss0mr		.btequ		0,ss0mr		; Bit counter
bc1_ss0mr		.btequ		1,ss0mr		; Bit counter
bc2_ss0mr		.btequ		2,ss0mr		; Bit counter
bc3_ss0mr		.btequ		3,ss0mr		; Bit counter
cphs_ss0mr		.btequ		5,ss0mr		; SSCK0 Clock Phase Select Bit
cpos_ss0mr		.btequ		6,ss0mr		; SSCK0 Clock Polarity Select Bit
mls_ss0mr		.btequ		7,ss0mr		; Bit Order Select Bit
;
;*------------------------------------------------------------------------------*
;*  SS0 Enable Register                                                         *
;*------------------------------------------------------------------------------*
ss0er		.equ	035Bh
;
ceie_ss0er		.btequ		0,ss0er		; Conflict Error Interrupt Enable Bit
re_ss0er		.btequ		3,ss0er		; Receive Enable Bit
te_ss0er		.btequ		4,ss0er		; Transmit Enable Bit
rie_ss0er		.btequ		5,ss0er		; Receive Interrupt Enable Bit
teie_ss0er		.btequ		6,ss0er		; Transmit End Interrupt Enable Bit
tie_ss0er		.btequ		7,ss0er		; Transmit Interrupt Enable Bit
;
;*------------------------------------------------------------------------------*
;*  SS0 Status Register                                                         *
;*------------------------------------------------------------------------------*
ss0sr		.equ	035Ch
;
ce_ss0sr		.btequ		0,ss0sr		; Conflict Error Flag
orer_ss0sr		.btequ		2,ss0sr		; Overrun Error Flag
rdrf_ss0sr		.btequ		5,ss0sr		; Receive Data Register Full Flag
tend_ss0sr		.btequ		6,ss0sr		; Transmit End Flag
tdre_ss0sr		.btequ		7,ss0sr		; Transmit Data Register Empty Flag
;
;*------------------------------------------------------------------------------*
;*  SS0 Mode Register 2                                                         *
;*------------------------------------------------------------------------------*
ss0mr2		.equ	035Dh
;
ssums_ss0mr2	.btequ		0,ss0mr2	; Mode select bit
csos_ss0mr2		.btequ		1,ss0mr2	; SCS0~ Pin Open Drain Output Select Bit
soos_ss0mr2		.btequ		2,ss0mr2	; Serial Data Open Drain output Select Bit
sckos_ss0mr2	.btequ		3,ss0mr2	; SSCK0 Pin Open Drain Output Select Bit
css0_ss0mr2		.btequ		4,ss0mr2	; SCS0~ Pin Function Select Bit
css1_ss0mr2		.btequ		5,ss0mr2	; SCS0~ Pin Function Select Bit
scks_ss0mr2		.btequ		6,ss0mr2	; SSCK0 Pin Function Select Bit
bide_ss0mr2		.btequ		7,ss0mr2	; Bidirectional mode Enable Bit
;
;*------------------------------------------------------------------------------*
;*  Pull-Up Control Register 0                                                  *
;*------------------------------------------------------------------------------*
pur0		.equ	0360h
;
pu00			.btequ		0,pur0		; P0_0 to P0_3 pull-up
pu01			.btequ		1,pur0		; P0_4 to P0_7 pull-up
pu02			.btequ		2,pur0		; P1_0 to P1_3 pull-up
pu03			.btequ		3,pur0		; P1_4 to P1_7 pull-up
pu04			.btequ		4,pur0		; P2_0 to P2_3 pull-up
pu05			.btequ		5,pur0		; P2_4 to P2_7 pull-up
pu06			.btequ		6,pur0		; P3_0 to P3_3 pull-up
pu07			.btequ		7,pur0		; P3_4 to P3_7 pull-up
;
;*------------------------------------------------------------------------------*
;*  Pull-Up Control Register 1                                                  *
;*------------------------------------------------------------------------------*
pur1		.equ	0361h
;
pu10			.btequ		0,pur1		; P4_0 to P4_3 pull-up
pu11			.btequ		1,pur1		; P4_4 to P4_7 pull-up
pu12			.btequ		2,pur1		; P5_0 to P5_3 pull-up
pu13			.btequ		3,pur1		; P5_4 to P5_7 pull-up
pu14			.btequ		4,pur1		; P6_0 to P6_3 pull-up
pu15			.btequ		5,pur1		; P6_4 to P6_7 pull-up
pu16			.btequ		6,pur1		; P7_2 to P7_3 pull-up
pu17			.btequ		7,pur1		; P7_4 to P7_7 pull-up
;
;*------------------------------------------------------------------------------*
;*  Pull-Up Control Register 2                                                  *
;*------------------------------------------------------------------------------*
pur2		.equ	0362h
;
pu20			.btequ		0,pur2		; P8_0 to P8_3 pull-up
pu21			.btequ		1,pur2		; P8_4 to P8_7 pull-up
pu22			.btequ		2,pur2		; P9_0 to P9_3 pull-up
pu23			.btequ		3,pur2		; P9_4 to P9_7 pull-up
pu24			.btequ		4,pur2		; P10_0 to P10_3 pull-up
pu25			.btequ		5,pur2		; P10_4 to P10_7 pull-up
;
;*------------------------------------------------------------------------------*
;*  Port Control Register                                                       *
;*------------------------------------------------------------------------------*
pcr			.equ	0366h
;
pcr0			.btequ		0,pcr		; Port P1 control bit
;
;*------------------------------------------------------------------------------*
;*  Input Threshold Select Register 0                                           *
;*------------------------------------------------------------------------------*
vlt0		.equ	036Ch
;
vlt00			.btequ		0,vlt0		; P0 input level select bit
vlt01			.btequ		1,vlt0		; P0 input level select bit
vlt02			.btequ		2,vlt0		; P1 input level select bit
vlt03			.btequ		3,vlt0		; P1 input level select bit
vlt04			.btequ		4,vlt0		; P2 input level select bit
vlt05			.btequ		5,vlt0		; P2 input level select bit
vlt06			.btequ		6,vlt0		; P3 input level select bit
vlt07			.btequ		7,vlt0		; P3 input level select bit
;
;*------------------------------------------------------------------------------*
;*  Input Threshold Select Register 1                                           *
;*------------------------------------------------------------------------------*
vlt1		.equ	036Dh
;
vlt10			.btequ		0,vlt1		; P4 input level select bit
vlt11			.btequ		1,vlt1		; P4 input level select bit
vlt12			.btequ		2,vlt1		; P5 input level select bit
vlt13			.btequ		3,vlt1		; P5 input level select bit
vlt14			.btequ		4,vlt1		; P6 input level select bit
vlt15			.btequ		5,vlt1		; P6 input level select bit
vlt16			.btequ		6,vlt1		; P7 input level select bit
vlt17			.btequ		7,vlt1		; P7 input level select bit
;
;*------------------------------------------------------------------------------*
;*  Input Threshold Select Register 2                                           *
;*------------------------------------------------------------------------------*
vlt2		.equ	036Eh
;
vlt20			.btequ		0,vlt2		; P8 input level select bit
vlt21			.btequ		1,vlt2		; P8 input level select bit
vlt22			.btequ		2,vlt2		; P9 input level select bit
vlt23			.btequ		3,vlt2		; P9 input level select bit
vlt24			.btequ		4,vlt2		; P10 input level select bit
vlt25			.btequ		5,vlt2		; P10 input level select bit
;
;*------------------------------------------------------------------------------*
;*  Pin Assignment Control Register                                             *
;*------------------------------------------------------------------------------*
pacr		.equ	0370h
;
pacr0			.btequ		0,pacr		; Pin enabling bit
pacr1			.btequ		1,pacr		; Pin enabling bit
pacr2			.btequ		2,pacr		; Pin enabling bit
u1map			.btequ		7,pacr		; UART1 pin remapping bit
;
;*------------------------------------------------------------------------------*
;*  Count Source Protection Mode Register                                       *
;*------------------------------------------------------------------------------*
cspr		.equ	037Ch
;
cspro			.btequ		7,cspr		; Count source protection mode select bit
;
;*------------------------------------------------------------------------------*
;*  Watchdog Timer Refresh Register                                             *
;*------------------------------------------------------------------------------*
wdtr		.equ	037Dh
;
;*------------------------------------------------------------------------------*
;*  Watchdog Timer Start Register                                               *
;*------------------------------------------------------------------------------*
wdts		.equ	037Eh
;
;*------------------------------------------------------------------------------*
;*  Watchdog Timer Control Register                                             *
;*------------------------------------------------------------------------------*
wdc			.equ	037Fh
;
wdc0			.btequ		0,wdc		; The contents of the watchdog timer counter, b10 to b5, can be read.
wdc1			.btequ		1,wdc		; The contents of the watchdog timer counter, b10 to b5, can be read.
wdc2			.btequ		2,wdc		; The contents of the watchdog timer counter, b10 to b5, can be read.
wdc3			.btequ		3,wdc		; The contents of the watchdog timer counter, b10 to b5, can be read.
wdc4			.btequ		4,wdc		; The contents of the watchdog timer counter, b10 to b5, can be read.
wdc5			.btequ		5,wdc		; The contents of the watchdog timer counter, b10 to b5, can be read.
wdc7			.btequ		7,wdc		; Prescaler select bit
;
;*------------------------------------------------------------------------------*
;*  DMA2 Source Select Register                                                 *
;*------------------------------------------------------------------------------*
dm2sl		.equ	0390h
;
dsel0_dm2sl		.btequ		0,dm2sl		; DMA request source select bit
dsel1_dm2sl		.btequ		1,dm2sl		; DMA request source select bit
dsel2_dm2sl		.btequ		2,dm2sl		; DMA request source select bit
dsel3_dm2sl		.btequ		3,dm2sl		; DMA request source select bit
dsel4_dm2sl		.btequ		4,dm2sl		; DMA request source select bit
dms_dm2sl		.btequ		6,dm2sl		; DMA request source expansion select bit
dsr_dm2sl		.btequ		7,dm2sl		; Software DMA request bit
;
;*------------------------------------------------------------------------------*
;*  DMA3 Source Select Register                                                 *
;*------------------------------------------------------------------------------*
dm3sl		.equ	0392h
;
dsel0_dm3sl		.btequ		0,dm3sl		; DMA request source select bit
dsel1_dm3sl		.btequ		1,dm3sl		; DMA request source select bit
dsel2_dm3sl		.btequ		2,dm3sl		; DMA request source select bit
dsel3_dm3sl		.btequ		3,dm3sl		; DMA request source select bit
dsel4_dm3sl		.btequ		4,dm3sl		; DMA request source select bit
dms_dm3sl		.btequ		6,dm3sl		; DMA request source expansion select bit
dsr_dm3sl		.btequ		7,dm3sl		; Software DMA request bit
;
;*------------------------------------------------------------------------------*
;*  DMA0 Source Select Register                                                 *
;*------------------------------------------------------------------------------*
dm0sl		.equ	0398h
;
dsel0_dm0sl		.btequ		0,dm0sl		; DMA request source select bit
dsel1_dm0sl		.btequ		1,dm0sl		; DMA request source select bit
dsel2_dm0sl		.btequ		2,dm0sl		; DMA request source select bit
dsel3_dm0sl		.btequ		3,dm0sl		; DMA request source select bit
dsel4_dm0sl		.btequ		4,dm0sl		; DMA request source select bit
dms_dm0sl		.btequ		6,dm0sl		; DMA request source expansion select bit
dsr_dm0sl		.btequ		7,dm0sl		; Software DMA request bit
;
;*------------------------------------------------------------------------------*
;*  DMA1 Source Select Register                                                 *
;*------------------------------------------------------------------------------*
dm1sl		.equ	039Ah
;
dsel0_dm1sl		.btequ		0,dm1sl		; DMA request source select bit
dsel1_dm1sl		.btequ		1,dm1sl		; DMA request source select bit
dsel2_dm1sl		.btequ		2,dm1sl		; DMA request source select bit
dsel3_dm1sl		.btequ		3,dm1sl		; DMA request source select bit
dsel4_dm1sl		.btequ		4,dm1sl		; DMA request source select bit
dms_dm1sl		.btequ		6,dm1sl		; DMA request source expansion select bit
dsr_dm1sl		.btequ		7,dm1sl		; Software DMA request bit
;
;*------------------------------------------------------------------------------*
;*  Open-Circuit Detection Assist Function Register                             *
;*------------------------------------------------------------------------------*
ainrst		.equ	03A2h
;
ainrst0			.btequ		4,ainrst	; Open-circuit detection assist function enable bit
ainrst1			.btequ		5,ainrst	; Open-circuit detection assist function enable bit
;
;*------------------------------------------------------------------------------*
;*  SFR Snoop Address Register                                                  *
;*------------------------------------------------------------------------------*
crcsar		.equ	03B4h
;
crcsarl		.equ	crcsar				; SFR Snoop Address Register(low 8bit)
crcsarh		.equ	crcsar+1			; SFR Snoop Address Register(high 8bit)
;
crcsar0			.btequ		0,crcsar	; SFR snoop address bit
crcsar1			.btequ		1,crcsar	; SFR snoop address bit
crcsar2			.btequ		2,crcsar	; SFR snoop address bit
crcsar3			.btequ		3,crcsar	; SFR snoop address bit
crcsar4			.btequ		4,crcsar	; SFR snoop address bit
crcsar5			.btequ		5,crcsar	; SFR snoop address bit
crcsar6			.btequ		6,crcsar	; SFR snoop address bit
crcsar7			.btequ		7,crcsar	; SFR snoop address bit
crcsar8			.btequ		8,crcsar	; SFR snoop address bit
crcsar9			.btequ		9,crcsar	; SFR snoop address bit
crcsr			.btequ		14,crcsar	; Snoop-on-read enable bit
crcsw			.btequ		15,crcsar	; Snoop-on-write enable bit
;
;*------------------------------------------------------------------------------*
;*  CRC Mode Register                                                           *
;*------------------------------------------------------------------------------*
crcmr		.equ	03B6h
;
crcps			.btequ		0,crcmr		; CRC polynomial select bit
crcms			.btequ		7,crcmr		; CRC mode select bit
;
;*------------------------------------------------------------------------------*
;*  CRC Data Register                                                           *
;*------------------------------------------------------------------------------*
crcd		.equ	03BCh
;
crcdl		.equ	crcd				; CRC Data Register(low 8bit)
crcdh		.equ	crcd+1				; CRC Data Register(high 8bit)
;
;*------------------------------------------------------------------------------*
;*  CRC Input Register                                                          *
;*------------------------------------------------------------------------------*
crcin		.equ	03BEh
;
;*------------------------------------------------------------------------------*
;*  A/D Register 0                                                              *
;*------------------------------------------------------------------------------*
ad0			.equ	03C0h
;
;*------------------------------------------------------------------------------*
;*  A/D Register 1                                                              *
;*------------------------------------------------------------------------------*
ad1			.equ	03C2h
;
;*------------------------------------------------------------------------------*
;*  A/D Register 2                                                              *
;*------------------------------------------------------------------------------*
ad2			.equ	03C4h
;
;*------------------------------------------------------------------------------*
;*  A/D Register 3                                                              *
;*------------------------------------------------------------------------------*
ad3			.equ	03C6h
;
;*------------------------------------------------------------------------------*
;*  A/D Register 4                                                              *
;*------------------------------------------------------------------------------*
ad4			.equ	03C8h
;
;*------------------------------------------------------------------------------*
;*  A/D Register 5                                                              *
;*------------------------------------------------------------------------------*
ad5			.equ	03CAh
;
;*------------------------------------------------------------------------------*
;*  A/D Register 6                                                              *
;*------------------------------------------------------------------------------*
ad6			.equ	03CCh
;
;*------------------------------------------------------------------------------*
;*  A/D Register 7                                                              *
;*------------------------------------------------------------------------------*
ad7			.equ	03CEh
;
;*------------------------------------------------------------------------------*
;*  A/D Control Register 2                                                      *
;*------------------------------------------------------------------------------*
adcon2		.equ	03D4h
;
adgsel0			.btequ		1,adcon2	; A/D input group select bit
adgsel1			.btequ		2,adcon2	; A/D input group select bit
cks2			.btequ		4,adcon2	; Frequency select bit 2
cks3			.btequ		7,adcon2	; fAD select bit
;
;*------------------------------------------------------------------------------*
;*  A/D Control Register 0                                                      *
;*------------------------------------------------------------------------------*
adcon0		.equ	03D6h
;
ch0				.btequ		0,adcon0	; Analog input pin select bit
ch1				.btequ		1,adcon0	; Analog input pin select bit
ch2				.btequ		2,adcon0	; Analog input pin select bit
md0				.btequ		3,adcon0	; A/D operation mode select bit 0
md1				.btequ		4,adcon0	; A/D operation mode select bit 0
trg				.btequ		5,adcon0	; Trigger select bit
adst			.btequ		6,adcon0	; A/D conversion start flag
cks0			.btequ		7,adcon0	; Frequency select bit 0
;
;*------------------------------------------------------------------------------*
;*  A/D Control Register 1                                                      *
;*------------------------------------------------------------------------------*
adcon1		.equ	03D7h
;
scan0			.btequ		0,adcon1	; A/D sweep pin select bit
scan1			.btequ		1,adcon1	; A/D sweep pin select bit
cks1			.btequ		4,adcon1	; Frequency select bit 1
adstby			.btequ		5,adcon1	; A/D standby bit
;
;*------------------------------------------------------------------------------*
;*  D/A0 register                                                               *
;*------------------------------------------------------------------------------*
da0			.equ	03D8h
;
;*------------------------------------------------------------------------------*
;*  D/A control register                                                        *
;*------------------------------------------------------------------------------*
dacon		.equ	03DCh
;
da0e			.btequ		0,dacon		; D/A0 output enable bit
;
;*------------------------------------------------------------------------------*
;*  Port P0 Register                                                            *
;*------------------------------------------------------------------------------*
p0			.equ	03E0h
;
p0_0			.btequ		0,p0		; Port P0_0 bit
p0_1			.btequ		1,p0		; Port P0_1 bit
p0_2			.btequ		2,p0		; Port P0_2 bit
p0_3			.btequ		3,p0		; Port P0_3 bit
p0_4			.btequ		4,p0		; Port P0_4 bit
p0_5			.btequ		5,p0		; Port P0_5 bit
p0_6			.btequ		6,p0		; Port P0_6 bit
p0_7			.btequ		7,p0		; Port P0_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P1 Register                                                            *
;*------------------------------------------------------------------------------*
p1			.equ	03E1h
;
p1_0			.btequ		0,p1		; Port P1_0 bit
p1_1			.btequ		1,p1		; Port P1_1 bit
p1_2			.btequ		2,p1		; Port P1_2 bit
p1_3			.btequ		3,p1		; Port P1_3 bit
p1_4			.btequ		4,p1		; Port P1_4 bit
p1_5			.btequ		5,p1		; Port P1_5 bit
p1_6			.btequ		6,p1		; Port P1_6 bit
p1_7			.btequ		7,p1		; Port P1_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P0 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd0			.equ	03E2h
;
pd0_0			.btequ		0,pd0		; Port P0_0 direction bit
pd0_1			.btequ		1,pd0		; Port P0_1 direction bit
pd0_2			.btequ		2,pd0		; Port P0_2 direction bit
pd0_3			.btequ		3,pd0		; Port P0_3 direction bit
pd0_4			.btequ		4,pd0		; Port P0_4 direction bit
pd0_5			.btequ		5,pd0		; Port P0_5 direction bit
pd0_6			.btequ		6,pd0		; Port P0_6 direction bit
pd0_7			.btequ		7,pd0		; Port P0_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P1 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd1			.equ	03E3h
;
pd1_0			.btequ		0,pd1		; Port P1_0 direction bit
pd1_1			.btequ		1,pd1		; Port P1_1 direction bit
pd1_2			.btequ		2,pd1		; Port P1_2 direction bit
pd1_3			.btequ		3,pd1		; Port P1_3 direction bit
pd1_4			.btequ		4,pd1		; Port P1_4 direction bit
pd1_5			.btequ		5,pd1		; Port P1_5 direction bit
pd1_6			.btequ		6,pd1		; Port P1_6 direction bit
pd1_7			.btequ		7,pd1		; Port P1_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P2 Register                                                            *
;*------------------------------------------------------------------------------*
p2			.equ	03E4h
;
p2_0			.btequ		0,p2		; Port P2_0 bit
p2_1			.btequ		1,p2		; Port P2_1 bit
p2_2			.btequ		2,p2		; Port P2_2 bit
p2_3			.btequ		3,p2		; Port P2_3 bit
p2_4			.btequ		4,p2		; Port P2_4 bit
p2_5			.btequ		5,p2		; Port P2_5 bit
p2_6			.btequ		6,p2		; Port P2_6 bit
p2_7			.btequ		7,p2		; Port P2_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P3 Register                                                            *
;*------------------------------------------------------------------------------*
p3			.equ	03E5h
;
p3_0			.btequ		0,p3		; Port P3_0 bit
p3_1			.btequ		1,p3		; Port P3_1 bit
p3_2			.btequ		2,p3		; Port P3_2 bit
p3_3			.btequ		3,p3		; Port P3_3 bit
p3_4			.btequ		4,p3		; Port P3_4 bit
p3_5			.btequ		5,p3		; Port P3_5 bit
p3_6			.btequ		6,p3		; Port P3_6 bit
p3_7			.btequ		7,p3		; Port P3_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P2 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd2			.equ	03E6h
;
pd2_0			.btequ		0,pd2		; Port P2_0 direction bit
pd2_1			.btequ		1,pd2		; Port P2_1 direction bit
pd2_2			.btequ		2,pd2		; Port P2_2 direction bit
pd2_3			.btequ		3,pd2		; Port P2_3 direction bit
pd2_4			.btequ		4,pd2		; Port P2_4 direction bit
pd2_5			.btequ		5,pd2		; Port P2_5 direction bit
pd2_6			.btequ		6,pd2		; Port P2_6 direction bit
pd2_7			.btequ		7,pd2		; Port P2_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P3 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd3			.equ	03E7h
;
pd3_0			.btequ		0,pd3		; Port P3_0 direction bit
pd3_1			.btequ		1,pd3		; Port P3_1 direction bit
pd3_2			.btequ		2,pd3		; Port P3_2 direction bit
pd3_3			.btequ		3,pd3		; Port P3_3 direction bit
pd3_4			.btequ		4,pd3		; Port P3_4 direction bit
pd3_5			.btequ		5,pd3		; Port P3_5 direction bit
pd3_6			.btequ		6,pd3		; Port P3_6 direction bit
pd3_7			.btequ		7,pd3		; Port P3_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P4 Register                                                            *
;*------------------------------------------------------------------------------*
p4			.equ	03E8h
;
p4_0			.btequ		0,p4		; Port P4_0 bit
p4_1			.btequ		1,p4		; Port P4_1 bit
p4_2			.btequ		2,p4		; Port P4_2 bit
p4_3			.btequ		3,p4		; Port P4_3 bit
p4_4			.btequ		4,p4		; Port P4_4 bit
p4_5			.btequ		5,p4		; Port P4_5 bit
p4_6			.btequ		6,p4		; Port P4_6 bit
p4_7			.btequ		7,p4		; Port P4_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P5 Register                                                            *
;*------------------------------------------------------------------------------*
p5			.equ	03E9h
;
p5_0			.btequ		0,p5		; Port P5_0 bit
p5_1			.btequ		1,p5		; Port P5_1 bit
p5_2			.btequ		2,p5		; Port P5_2 bit
p5_3			.btequ		3,p5		; Port P5_3 bit
p5_4			.btequ		4,p5		; Port P5_4 bit
p5_5			.btequ		5,p5		; Port P5_5 bit
p5_6			.btequ		6,p5		; Port P5_6 bit
p5_7			.btequ		7,p5		; Port P5_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P4 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd4			.equ	03EAh
;
pd4_0			.btequ		0,pd4		; Port P4_0 direction bit
pd4_1			.btequ		1,pd4		; Port P4_1 direction bit
pd4_2			.btequ		2,pd4		; Port P4_2 direction bit
pd4_3			.btequ		3,pd4		; Port P4_3 direction bit
pd4_4			.btequ		4,pd4		; Port P4_4 direction bit
pd4_5			.btequ		5,pd4		; Port P4_5 direction bit
pd4_6			.btequ		6,pd4		; Port P4_6 direction bit
pd4_7			.btequ		7,pd4		; Port P4_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P5 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd5			.equ	03EBh
;
pd5_0			.btequ		0,pd5		; Port P5_0 direction bit
pd5_1			.btequ		1,pd5		; Port P5_1 direction bit
pd5_2			.btequ		2,pd5		; Port P5_2 direction bit
pd5_3			.btequ		3,pd5		; Port P5_3 direction bit
pd5_4			.btequ		4,pd5		; Port P5_4 direction bit
pd5_5			.btequ		5,pd5		; Port P5_5 direction bit
pd5_6			.btequ		6,pd5		; Port P5_6 direction bit
pd5_7			.btequ		7,pd5		; Port P5_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P6 Register                                                            *
;*------------------------------------------------------------------------------*
p6			.equ	03ECh
;
p6_0			.btequ		0,p6		; Port P6_0 bit
p6_1			.btequ		1,p6		; Port P6_1 bit
p6_2			.btequ		2,p6		; Port P6_2 bit
p6_3			.btequ		3,p6		; Port P6_3 bit
p6_4			.btequ		4,p6		; Port P6_4 bit
p6_5			.btequ		5,p6		; Port P6_5 bit
p6_6			.btequ		6,p6		; Port P6_6 bit
p6_7			.btequ		7,p6		; Port P6_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P7 Register                                                            *
;*------------------------------------------------------------------------------*
p7			.equ	03EDh
;
p7_0			.btequ		0,p7		; Port P7_0 bit
p7_1			.btequ		1,p7		; Port P7_1 bit
p7_2			.btequ		2,p7		; Port P7_2 bit
p7_3			.btequ		3,p7		; Port P7_3 bit
p7_4			.btequ		4,p7		; Port P7_4 bit
p7_5			.btequ		5,p7		; Port P7_5 bit
p7_6			.btequ		6,p7		; Port P7_6 bit
p7_7			.btequ		7,p7		; Port P7_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P6 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd6			.equ	03EEh
;
pd6_0			.btequ		0,pd6		; Port P6_0 direction bit
pd6_1			.btequ		1,pd6		; Port P6_1 direction bit
pd6_2			.btequ		2,pd6		; Port P6_2 direction bit
pd6_3			.btequ		3,pd6		; Port P6_3 direction bit
pd6_4			.btequ		4,pd6		; Port P6_4 direction bit
pd6_5			.btequ		5,pd6		; Port P6_5 direction bit
pd6_6			.btequ		6,pd6		; Port P6_6 direction bit
pd6_7			.btequ		7,pd6		; Port P6_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P7 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd7			.equ	03EFh
;
pd7_0			.btequ		0,pd7		; Port P7_0 direction bit
pd7_1			.btequ		1,pd7		; Port P7_1 direction bit
pd7_2			.btequ		2,pd7		; Port P7_2 direction bit
pd7_3			.btequ		3,pd7		; Port P7_3 direction bit
pd7_4			.btequ		4,pd7		; Port P7_4 direction bit
pd7_5			.btequ		5,pd7		; Port P7_5 direction bit
pd7_6			.btequ		6,pd7		; Port P7_6 direction bit
pd7_7			.btequ		7,pd7		; Port P7_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P8 Register                                                            *
;*------------------------------------------------------------------------------*
p8			.equ	03F0h
;
p8_0			.btequ		0,p8		; Port P8_0 bit
p8_1			.btequ		1,p8		; Port P8_1 bit
p8_2			.btequ		2,p8		; Port P8_2 bit
p8_3			.btequ		3,p8		; Port P8_3 bit
p8_4			.btequ		4,p8		; Port P8_4 bit
p8_5			.btequ		5,p8		; Port P8_5 bit
p8_6			.btequ		6,p8		; Port P8_6 bit
p8_7			.btequ		7,p8		; Port P8_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P9 Register                                                            *
;*------------------------------------------------------------------------------*
p9			.equ	03F1h
;
p9_0			.btequ		0,p9		; Port P9_0 bit
p9_1			.btequ		1,p9		; Port P9_1 bit
p9_2			.btequ		2,p9		; Port P9_2 bit
p9_3			.btequ		3,p9		; Port P9_3 bit
p9_4			.btequ		4,p9		; Port P9_4 bit
p9_5			.btequ		5,p9		; Port P9_5 bit
p9_6			.btequ		6,p9		; Port P9_6 bit
p9_7			.btequ		7,p9		; Port P9_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P8 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd8			.equ	03F2h
;
pd8_0			.btequ		0,pd8		; Port P8_0 direction bit
pd8_1			.btequ		1,pd8		; Port P8_1 direction bit
pd8_2			.btequ		2,pd8		; Port P8_2 direction bit
pd8_3			.btequ		3,pd8		; Port P8_3 direction bit
pd8_4			.btequ		4,pd8		; Port P8_4 direction bit
pd8_5			.btequ		5,pd8		; Port P8_5 direction bit
pd8_6			.btequ		6,pd8		; Port P8_6 direction bit
pd8_7			.btequ		7,pd8		; Port P8_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P9 Direction Register                                                  *
;*------------------------------------------------------------------------------*
pd9			.equ	03F3h
;
pd9_0			.btequ		0,pd9		; Port P9_0 direction bit
pd9_1			.btequ		1,pd9		; Port P9_1 direction bit
pd9_2			.btequ		2,pd9		; Port P9_2 direction bit
pd9_3			.btequ		3,pd9		; Port P9_3 direction bit
pd9_4			.btequ		4,pd9		; Port P9_4 direction bit
pd9_5			.btequ		5,pd9		; Port P9_5 direction bit
pd9_6			.btequ		6,pd9		; Port P9_6 direction bit
pd9_7			.btequ		7,pd9		; Port P9_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  Port P10 Register                                                           *
;*------------------------------------------------------------------------------*
p10			.equ	03F4h
;
p10_0			.btequ		0,p10		; Port P10_0 bit
p10_1			.btequ		1,p10		; Port P10_1 bit
p10_2			.btequ		2,p10		; Port P10_2 bit
p10_3			.btequ		3,p10		; Port P10_3 bit
p10_4			.btequ		4,p10		; Port P10_4 bit
p10_5			.btequ		5,p10		; Port P10_5 bit
p10_6			.btequ		6,p10		; Port P10_6 bit
p10_7			.btequ		7,p10		; Port P10_7 bit
;
;*------------------------------------------------------------------------------*
;*  Port P10 Direction Register                                                 *
;*------------------------------------------------------------------------------*
pd10		.equ	03F6h
;
pd10_0			.btequ		0,pd10		; Port P10_0 direction bit
pd10_1			.btequ		1,pd10		; Port P10_1 direction bit
pd10_2			.btequ		2,pd10		; Port P10_2 direction bit
pd10_3			.btequ		3,pd10		; Port P10_3 direction bit
pd10_4			.btequ		4,pd10		; Port P10_4 direction bit
pd10_5			.btequ		5,pd10		; Port P10_5 direction bit
pd10_6			.btequ		6,pd10		; Port P10_6 direction bit
pd10_7			.btequ		7,pd10		; Port P10_7 direction bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 0                                                     *
;*------------------------------------------------------------------------------*
c1mb0		.equ	0D200h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 1                                                     *
;*------------------------------------------------------------------------------*
c1mb1		.equ	0D210h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 2                                                     *
;*------------------------------------------------------------------------------*
c1mb2		.equ	0D220h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 3                                                     *
;*------------------------------------------------------------------------------*
c1mb3		.equ	0D230h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 4                                                     *
;*------------------------------------------------------------------------------*
c1mb4		.equ	0D240h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 5                                                     *
;*------------------------------------------------------------------------------*
c1mb5		.equ	0D250h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 6                                                     *
;*------------------------------------------------------------------------------*
c1mb6		.equ	0D260h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 7                                                     *
;*------------------------------------------------------------------------------*
c1mb7		.equ	0D270h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 8                                                     *
;*------------------------------------------------------------------------------*
c1mb8		.equ	0D280h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 9                                                     *
;*------------------------------------------------------------------------------*
c1mb9		.equ	0D290h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 10                                                    *
;*------------------------------------------------------------------------------*
c1mb10		.equ	0D2A0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 11                                                    *
;*------------------------------------------------------------------------------*
c1mb11		.equ	0D2B0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 12                                                    *
;*------------------------------------------------------------------------------*
c1mb12		.equ	0D2C1h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 13                                                    *
;*------------------------------------------------------------------------------*
c1mb13		.equ	0D2D0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 14                                                    *
;*------------------------------------------------------------------------------*
c1mb14		.equ	0D2E0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 15                                                    *
;*------------------------------------------------------------------------------*
c1mb15		.equ	0D2F0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 16                                                    *
;*------------------------------------------------------------------------------*
c1mb16		.equ	0D300h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 17                                                    *
;*------------------------------------------------------------------------------*
c1mb17		.equ	0D310h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 18                                                    *
;*------------------------------------------------------------------------------*
c1mb18		.equ	0D320h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 19                                                    *
;*------------------------------------------------------------------------------*
c1mb19		.equ	0D330h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 20                                                    *
;*------------------------------------------------------------------------------*
c1mb20		.equ	0D340h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 21                                                    *
;*------------------------------------------------------------------------------*
c1mb21		.equ	0D350h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 22                                                    *
;*------------------------------------------------------------------------------*
c1mb22		.equ	0D360h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 23                                                    *
;*------------------------------------------------------------------------------*
c1mb23		.equ	0D370h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 24                                                    *
;*------------------------------------------------------------------------------*
c1mb24		.equ	0D380h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 25                                                    *
;*------------------------------------------------------------------------------*
c1mb25		.equ	0D390h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 26                                                    *
;*------------------------------------------------------------------------------*
c1mb26		.equ	0D3A0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 27                                                    *
;*------------------------------------------------------------------------------*
c1mb27		.equ	0D3B0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 28                                                    *
;*------------------------------------------------------------------------------*
c1mb28		.equ	0D3C1h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 29                                                    *
;*------------------------------------------------------------------------------*
c1mb29		.equ	0D3D0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 30                                                    *
;*------------------------------------------------------------------------------*
c1mb30		.equ	0D3E0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Register 31                                                    *
;*------------------------------------------------------------------------------*
c1mb31		.equ	0D3F0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Register 0                                                        *
;*------------------------------------------------------------------------------*
c1mkr0		.equ	0D400h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Register 1                                                        *
;*------------------------------------------------------------------------------*
c1mkr1		.equ	0D404h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Register 2                                                        *
;*------------------------------------------------------------------------------*
c1mkr2		.equ	0D408h
;
;*------------------------------------------------------------------------------*
;*  CAN1 mask register 3                                                        *
;*------------------------------------------------------------------------------*
c1mkr3		.equ	0D40Ch
;
;*------------------------------------------------------------------------------*
;*  CAN1 mask register 4                                                        *
;*------------------------------------------------------------------------------*
c1mkr4		.equ	0D410h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Register 5                                                        *
;*------------------------------------------------------------------------------*
c1mkr5		.equ	0D414h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Register 6                                                        *
;*------------------------------------------------------------------------------*
c1mkr6		.equ	0D418h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Register 7                                                        *
;*------------------------------------------------------------------------------*
c1mkr7		.equ	0D41Ch
;
;*------------------------------------------------------------------------------*
;*  CAN1 FIFO Receive ID Compare Register 0                                     *
;*------------------------------------------------------------------------------*
c1fidcr0	.equ	0D420h
;
;*------------------------------------------------------------------------------*
;*  CAN1 FIFO Receive ID Compare Register 1                                     *
;*------------------------------------------------------------------------------*
c1fidcr1	.equ	0D424h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mask Invalid Register                                                  *
;*------------------------------------------------------------------------------*
c1mkivlr	.equ	0D428h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Interrupt Enable Register                                      *
;*------------------------------------------------------------------------------*
c1mier		.equ	0D42Ch
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 0                                             *
;*------------------------------------------------------------------------------*
c1mctl0		.equ	0D4A0h
;
newdata_c1mctl0	.btequ		0,c1mctl0	; Reception Complete Flag
sentdata_c1mctl0	.btequ		0,c1mctl0	; Transmission Complete Flag
invaldata_c1mctl0	.btequ		1,c1mctl0	; Reception-in-Progress Status Flag
trmactive_c1mctl0	.btequ		1,c1mctl0	; Transmission-in-Progress Status Flag
msglost_c1mctl0	.btequ		2,c1mctl0	; Message Lost Flag
trmabt_c1mctl0	.btequ		2,c1mctl0	; Transmission Abort Complete Flag
oneshot_c1mctl0	.btequ		4,c1mctl0	; One-shot Enable Bit
recreq_c1mctl0	.btequ		6,c1mctl0	; Receive Mailbox Set Bit
trmreq_c1mctl0	.btequ		7,c1mctl0	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 1                                             *
;*------------------------------------------------------------------------------*
c1mctl1		.equ	0D4A1h
;
newdata_c1mctl1	.btequ		0,c1mctl1	; Reception Complete Flag
sentdata_c1mctl1	.btequ		0,c1mctl1	; Transmission Complete Flag
invaldata_c1mctl1	.btequ		1,c1mctl1	; Reception-in-Progress Status Flag
trmactive_c1mctl1	.btequ		1,c1mctl1	; Transmission-in-Progress Status Flag
msglost_c1mctl1	.btequ		2,c1mctl1	; Message Lost Flag
trmabt_c1mctl1	.btequ		2,c1mctl1	; Transmission Abort Complete Flag
oneshot_c1mctl1	.btequ		4,c1mctl1	; One-shot Enable Bit
recreq_c1mctl1	.btequ		6,c1mctl1	; Receive Mailbox Set Bit
trmreq_c1mctl1	.btequ		7,c1mctl1	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 2                                             *
;*------------------------------------------------------------------------------*
c1mctl2		.equ	0D4A2h
;
newdata_c1mctl2	.btequ		0,c1mctl2	; Reception Complete Flag
sentdata_c1mctl2	.btequ		0,c1mctl2	; Transmission Complete Flag
invaldata_c1mctl2	.btequ		1,c1mctl2	; Reception-in-Progress Status Flag
trmactive_c1mctl2	.btequ		1,c1mctl2	; Transmission-in-Progress Status Flag
msglost_c1mctl2	.btequ		2,c1mctl2	; Message Lost Flag
trmabt_c1mctl2	.btequ		2,c1mctl2	; Transmission Abort Complete Flag
oneshot_c1mctl2	.btequ		4,c1mctl2	; One-shot Enable Bit
recreq_c1mctl2	.btequ		6,c1mctl2	; Receive Mailbox Set Bit
trmreq_c1mctl2	.btequ		7,c1mctl2	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 3                                             *
;*------------------------------------------------------------------------------*
c1mctl3		.equ	0D4A3h
;
newdata_c1mctl3	.btequ		0,c1mctl3	; Reception Complete Flag
sentdata_c1mctl3	.btequ		0,c1mctl3	; Transmission Complete Flag
invaldata_c1mctl3	.btequ		1,c1mctl3	; Reception-in-Progress Status Flag
trmactive_c1mctl3	.btequ		1,c1mctl3	; Transmission-in-Progress Status Flag
msglost_c1mctl3	.btequ		2,c1mctl3	; Message Lost Flag
trmabt_c1mctl3	.btequ		2,c1mctl3	; Transmission Abort Complete Flag
oneshot_c1mctl3	.btequ		4,c1mctl3	; One-shot Enable Bit
recreq_c1mctl3	.btequ		6,c1mctl3	; Receive Mailbox Set Bit
trmreq_c1mctl3	.btequ		7,c1mctl3	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 4                                             *
;*------------------------------------------------------------------------------*
c1mctl4		.equ	0D4A4h
;
newdata_c1mctl4	.btequ		0,c1mctl4	; Reception Complete Flag
sentdata_c1mctl4	.btequ		0,c1mctl4	; Transmission Complete Flag
invaldata_c1mctl4	.btequ		1,c1mctl4	; Reception-in-Progress Status Flag
trmactive_c1mctl4	.btequ		1,c1mctl4	; Transmission-in-Progress Status Flag
msglost_c1mctl4	.btequ		2,c1mctl4	; Message Lost Flag
trmabt_c1mctl4	.btequ		2,c1mctl4	; Transmission Abort Complete Flag
oneshot_c1mctl4	.btequ		4,c1mctl4	; One-shot Enable Bit
recreq_c1mctl4	.btequ		6,c1mctl4	; Receive Mailbox Set Bit
trmreq_c1mctl4	.btequ		7,c1mctl4	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 5                                             *
;*------------------------------------------------------------------------------*
c1mctl5		.equ	0D4A5h
;
newdata_c1mctl5	.btequ		0,c1mctl5	; Reception Complete Flag
sentdata_c1mctl5	.btequ		0,c1mctl5	; Transmission Complete Flag
invaldata_c1mctl5	.btequ		1,c1mctl5	; Reception-in-Progress Status Flag
trmactive_c1mctl5	.btequ		1,c1mctl5	; Transmission-in-Progress Status Flag
msglost_c1mctl5	.btequ		2,c1mctl5	; Message Lost Flag
trmabt_c1mctl5	.btequ		2,c1mctl5	; Transmission Abort Complete Flag
oneshot_c1mctl5	.btequ		4,c1mctl5	; One-shot Enable Bit
recreq_c1mctl5	.btequ		6,c1mctl5	; Receive Mailbox Set Bit
trmreq_c1mctl5	.btequ		7,c1mctl5	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 6                                             *
;*------------------------------------------------------------------------------*
c1mctl6		.equ	0D4A6h
;
newdata_c1mctl6	.btequ		0,c1mctl6	; Reception Complete Flag
sentdata_c1mctl6	.btequ		0,c1mctl6	; Transmission Complete Flag
invaldata_c1mctl6	.btequ		1,c1mctl6	; Reception-in-Progress Status Flag
trmactive_c1mctl6	.btequ		1,c1mctl6	; Transmission-in-Progress Status Flag
msglost_c1mctl6	.btequ		2,c1mctl6	; Message Lost Flag
trmabt_c1mctl6	.btequ		2,c1mctl6	; Transmission Abort Complete Flag
oneshot_c1mctl6	.btequ		4,c1mctl6	; One-shot Enable Bit
recreq_c1mctl6	.btequ		6,c1mctl6	; Receive Mailbox Set Bit
trmreq_c1mctl6	.btequ		7,c1mctl6	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 7                                             *
;*------------------------------------------------------------------------------*
c1mctl7		.equ	0D4A7h
;
newdata_c1mctl7	.btequ		0,c1mctl7	; Reception Complete Flag
sentdata_c1mctl7	.btequ		0,c1mctl7	; Transmission Complete Flag
invaldata_c1mctl7	.btequ		1,c1mctl7	; Reception-in-Progress Status Flag
trmactive_c1mctl7	.btequ		1,c1mctl7	; Transmission-in-Progress Status Flag
msglost_c1mctl7	.btequ		2,c1mctl7	; Message Lost Flag
trmabt_c1mctl7	.btequ		2,c1mctl7	; Transmission Abort Complete Flag
oneshot_c1mctl7	.btequ		4,c1mctl7	; One-shot Enable Bit
recreq_c1mctl7	.btequ		6,c1mctl7	; Receive Mailbox Set Bit
trmreq_c1mctl7	.btequ		7,c1mctl7	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 8                                             *
;*------------------------------------------------------------------------------*
c1mctl8		.equ	0D4A8h
;
newdata_c1mctl8	.btequ		0,c1mctl8	; Reception Complete Flag
sentdata_c1mctl8	.btequ		0,c1mctl8	; Transmission Complete Flag
invaldata_c1mctl8	.btequ		1,c1mctl8	; Reception-in-Progress Status Flag
trmactive_c1mctl8	.btequ		1,c1mctl8	; Transmission-in-Progress Status Flag
msglost_c1mctl8	.btequ		2,c1mctl8	; Message Lost Flag
trmabt_c1mctl8	.btequ		2,c1mctl8	; Transmission Abort Complete Flag
oneshot_c1mctl8	.btequ		4,c1mctl8	; One-shot Enable Bit
recreq_c1mctl8	.btequ		6,c1mctl8	; Receive Mailbox Set Bit
trmreq_c1mctl8	.btequ		7,c1mctl8	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 9                                             *
;*------------------------------------------------------------------------------*
c1mctl9		.equ	0D4A9h
;
newdata_c1mctl9	.btequ		0,c1mctl9	; Reception Complete Flag
sentdata_c1mctl9	.btequ		0,c1mctl9	; Transmission Complete Flag
invaldata_c1mctl9	.btequ		1,c1mctl9	; Reception-in-Progress Status Flag
trmactive_c1mctl9	.btequ		1,c1mctl9	; Transmission-in-Progress Status Flag
msglost_c1mctl9	.btequ		2,c1mctl9	; Message Lost Flag
trmabt_c1mctl9	.btequ		2,c1mctl9	; Transmission Abort Complete Flag
oneshot_c1mctl9	.btequ		4,c1mctl9	; One-shot Enable Bit
recreq_c1mctl9	.btequ		6,c1mctl9	; Receive Mailbox Set Bit
trmreq_c1mctl9	.btequ		7,c1mctl9	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 10                                            *
;*------------------------------------------------------------------------------*
c1mctl10	.equ	0D4AAh
;
newdata_c1mctl10	.btequ		0,c1mctl10	; Reception Complete Flag
sentdata_c1mctl10	.btequ		0,c1mctl10	; Transmission Complete Flag
invaldata_c1mctl10	.btequ		1,c1mctl10	; Reception-in-Progress Status Flag
trmactive_c1mctl10	.btequ		1,c1mctl10	; Transmission-in-Progress Status Flag
msglost_c1mctl10	.btequ		2,c1mctl10	; Message Lost Flag
trmabt_c1mctl10	.btequ		2,c1mctl10	; Transmission Abort Complete Flag
oneshot_c1mctl10	.btequ		4,c1mctl10	; One-shot Enable Bit
recreq_c1mctl10	.btequ		6,c1mctl10	; Receive Mailbox Set Bit
trmreq_c1mctl10	.btequ		7,c1mctl10	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 11                                            *
;*------------------------------------------------------------------------------*
c1mctl11	.equ	0D4ABh
;
newdata_c1mctl11	.btequ		0,c1mctl11	; Reception Complete Flag
sentdata_c1mctl11	.btequ		0,c1mctl11	; Transmission Complete Flag
invaldata_c1mctl11	.btequ		1,c1mctl11	; Reception-in-Progress Status Flag
trmactive_c1mctl11	.btequ		1,c1mctl11	; Transmission-in-Progress Status Flag
msglost_c1mctl11	.btequ		2,c1mctl11	; Message Lost Flag
trmabt_c1mctl11	.btequ		2,c1mctl11	; Transmission Abort Complete Flag
oneshot_c1mctl11	.btequ		4,c1mctl11	; One-shot Enable Bit
recreq_c1mctl11	.btequ		6,c1mctl11	; Receive Mailbox Set Bit
trmreq_c1mctl11	.btequ		7,c1mctl11	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 12                                            *
;*------------------------------------------------------------------------------*
c1mctl12	.equ	0D4ACh
;
newdata_c1mctl12	.btequ		0,c1mctl12	; Reception Complete Flag
sentdata_c1mctl12	.btequ		0,c1mctl12	; Transmission Complete Flag
invaldata_c1mctl12	.btequ		1,c1mctl12	; Reception-in-Progress Status Flag
trmactive_c1mctl12	.btequ		1,c1mctl12	; Transmission-in-Progress Status Flag
msglost_c1mctl12	.btequ		2,c1mctl12	; Message Lost Flag
trmabt_c1mctl12	.btequ		2,c1mctl12	; Transmission Abort Complete Flag
oneshot_c1mctl12	.btequ		4,c1mctl12	; One-shot Enable Bit
recreq_c1mctl12	.btequ		6,c1mctl12	; Receive Mailbox Set Bit
trmreq_c1mctl12	.btequ		7,c1mctl12	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 13                                            *
;*------------------------------------------------------------------------------*
c1mctl13	.equ	0D4ADh
;
newdata_c1mctl13	.btequ		0,c1mctl13	; Reception Complete Flag
sentdata_c1mctl13	.btequ		0,c1mctl13	; Transmission Complete Flag
invaldata_c1mctl13	.btequ		1,c1mctl13	; Reception-in-Progress Status Flag
trmactive_c1mctl13	.btequ		1,c1mctl13	; Transmission-in-Progress Status Flag
msglost_c1mctl13	.btequ		2,c1mctl13	; Message Lost Flag
trmabt_c1mctl13	.btequ		2,c1mctl13	; Transmission Abort Complete Flag
oneshot_c1mctl13	.btequ		4,c1mctl13	; One-shot Enable Bit
recreq_c1mctl13	.btequ		6,c1mctl13	; Receive Mailbox Set Bit
trmreq_c1mctl13	.btequ		7,c1mctl13	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 14                                            *
;*------------------------------------------------------------------------------*
c1mctl14	.equ	0D4AEh
;
newdata_c1mctl14	.btequ		0,c1mctl14	; Reception Complete Flag
sentdata_c1mctl14	.btequ		0,c1mctl14	; Transmission Complete Flag
invaldata_c1mctl14	.btequ		1,c1mctl14	; Reception-in-Progress Status Flag
trmactive_c1mctl14	.btequ		1,c1mctl14	; Transmission-in-Progress Status Flag
msglost_c1mctl14	.btequ		2,c1mctl14	; Message Lost Flag
trmabt_c1mctl14	.btequ		2,c1mctl14	; Transmission Abort Complete Flag
oneshot_c1mctl14	.btequ		4,c1mctl14	; One-shot Enable Bit
recreq_c1mctl14	.btequ		6,c1mctl14	; Receive Mailbox Set Bit
trmreq_c1mctl14	.btequ		7,c1mctl14	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 15                                            *
;*------------------------------------------------------------------------------*
c1mctl15	.equ	0D4AFh
;
newdata_c1mctl15	.btequ		0,c1mctl15	; Reception Complete Flag
sentdata_c1mctl15	.btequ		0,c1mctl15	; Transmission Complete Flag
invaldata_c1mctl15	.btequ		1,c1mctl15	; Reception-in-Progress Status Flag
trmactive_c1mctl15	.btequ		1,c1mctl15	; Transmission-in-Progress Status Flag
msglost_c1mctl15	.btequ		2,c1mctl15	; Message Lost Flag
trmabt_c1mctl15	.btequ		2,c1mctl15	; Transmission Abort Complete Flag
oneshot_c1mctl15	.btequ		4,c1mctl15	; One-shot Enable Bit
recreq_c1mctl15	.btequ		6,c1mctl15	; Receive Mailbox Set Bit
trmreq_c1mctl15	.btequ		7,c1mctl15	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 16                                            *
;*------------------------------------------------------------------------------*
c1mctl16	.equ	0D4B0h
;
newdata_c1mctl16	.btequ		0,c1mctl16	; Reception Complete Flag
sentdata_c1mctl16	.btequ		0,c1mctl16	; Transmission Complete Flag
invaldata_c1mctl16	.btequ		1,c1mctl16	; Reception-in-Progress Status Flag
trmactive_c1mctl16	.btequ		1,c1mctl16	; Transmission-in-Progress Status Flag
msglost_c1mctl16	.btequ		2,c1mctl16	; Message Lost Flag
trmabt_c1mctl16	.btequ		2,c1mctl16	; Transmission Abort Complete Flag
oneshot_c1mctl16	.btequ		4,c1mctl16	; One-shot Enable Bit
recreq_c1mctl16	.btequ		6,c1mctl16	; Receive Mailbox Set Bit
trmreq_c1mctl16	.btequ		7,c1mctl16	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 17                                            *
;*------------------------------------------------------------------------------*
c1mctl17	.equ	0D4B1h
;
newdata_c1mctl17	.btequ		0,c1mctl17	; Reception Complete Flag
sentdata_c1mctl17	.btequ		0,c1mctl17	; Transmission Complete Flag
invaldata_c1mctl17	.btequ		1,c1mctl17	; Reception-in-Progress Status Flag
trmactive_c1mctl17	.btequ		1,c1mctl17	; Transmission-in-Progress Status Flag
msglost_c1mctl17	.btequ		2,c1mctl17	; Message Lost Flag
trmabt_c1mctl17	.btequ		2,c1mctl17	; Transmission Abort Complete Flag
oneshot_c1mctl17	.btequ		4,c1mctl17	; One-shot Enable Bit
recreq_c1mctl17	.btequ		6,c1mctl17	; Receive Mailbox Set Bit
trmreq_c1mctl17	.btequ		7,c1mctl17	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 18                                            *
;*------------------------------------------------------------------------------*
c1mctl18	.equ	0D4B2h
;
newdata_c1mctl18	.btequ		0,c1mctl18	; Reception Complete Flag
sentdata_c1mctl18	.btequ		0,c1mctl18	; Transmission Complete Flag
invaldata_c1mctl18	.btequ		1,c1mctl18	; Reception-in-Progress Status Flag
trmactive_c1mctl18	.btequ		1,c1mctl18	; Transmission-in-Progress Status Flag
msglost_c1mctl18	.btequ		2,c1mctl18	; Message Lost Flag
trmabt_c1mctl18	.btequ		2,c1mctl18	; Transmission Abort Complete Flag
oneshot_c1mctl18	.btequ		4,c1mctl18	; One-shot Enable Bit
recreq_c1mctl18	.btequ		6,c1mctl18	; Receive Mailbox Set Bit
trmreq_c1mctl18	.btequ		7,c1mctl18	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 19                                            *
;*------------------------------------------------------------------------------*
c1mctl19	.equ	0D4B3h
;
newdata_c1mctl19	.btequ		0,c1mctl19	; Reception Complete Flag
sentdata_c1mctl19	.btequ		0,c1mctl19	; Transmission Complete Flag
invaldata_c1mctl19	.btequ		1,c1mctl19	; Reception-in-Progress Status Flag
trmactive_c1mctl19	.btequ		1,c1mctl19	; Transmission-in-Progress Status Flag
msglost_c1mctl19	.btequ		2,c1mctl19	; Message Lost Flag
trmabt_c1mctl19	.btequ		2,c1mctl19	; Transmission Abort Complete Flag
oneshot_c1mctl19	.btequ		4,c1mctl19	; One-shot Enable Bit
recreq_c1mctl19	.btequ		6,c1mctl19	; Receive Mailbox Set Bit
trmreq_c1mctl19	.btequ		7,c1mctl19	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 20                                            *
;*------------------------------------------------------------------------------*
c1mctl20	.equ	0D4B4h
;
newdata_c1mctl20	.btequ		0,c1mctl20	; Reception Complete Flag
sentdata_c1mctl20	.btequ		0,c1mctl20	; Transmission Complete Flag
invaldata_c1mctl20	.btequ		1,c1mctl20	; Reception-in-Progress Status Flag
trmactive_c1mctl20	.btequ		1,c1mctl20	; Transmission-in-Progress Status Flag
msglost_c1mctl20	.btequ		2,c1mctl20	; Message Lost Flag
trmabt_c1mctl20	.btequ		2,c1mctl20	; Transmission Abort Complete Flag
oneshot_c1mctl20	.btequ		4,c1mctl20	; One-shot Enable Bit
recreq_c1mctl20	.btequ		6,c1mctl20	; Receive Mailbox Set Bit
trmreq_c1mctl20	.btequ		7,c1mctl20	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 21                                            *
;*------------------------------------------------------------------------------*
c1mctl21	.equ	0D4B5h
;
newdata_c1mctl21	.btequ		0,c1mctl21	; Reception Complete Flag
sentdata_c1mctl21	.btequ		0,c1mctl21	; Transmission Complete Flag
invaldata_c1mctl21	.btequ		1,c1mctl21	; Reception-in-Progress Status Flag
trmactive_c1mctl21	.btequ		1,c1mctl21	; Transmission-in-Progress Status Flag
msglost_c1mctl21	.btequ		2,c1mctl21	; Message Lost Flag
trmabt_c1mctl21	.btequ		2,c1mctl21	; Transmission Abort Complete Flag
oneshot_c1mctl21	.btequ		4,c1mctl21	; One-shot Enable Bit
recreq_c1mctl21	.btequ		6,c1mctl21	; Receive Mailbox Set Bit
trmreq_c1mctl21	.btequ		7,c1mctl21	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 22                                            *
;*------------------------------------------------------------------------------*
c1mctl22	.equ	0D4B6h
;
newdata_c1mctl22	.btequ		0,c1mctl22	; Reception Complete Flag
sentdata_c1mctl22	.btequ		0,c1mctl22	; Transmission Complete Flag
invaldata_c1mctl22	.btequ		1,c1mctl22	; Reception-in-Progress Status Flag
trmactive_c1mctl22	.btequ		1,c1mctl22	; Transmission-in-Progress Status Flag
msglost_c1mctl22	.btequ		2,c1mctl22	; Message Lost Flag
trmabt_c1mctl22	.btequ		2,c1mctl22	; Transmission Abort Complete Flag
oneshot_c1mctl22	.btequ		4,c1mctl22	; One-shot Enable Bit
recreq_c1mctl22	.btequ		6,c1mctl22	; Receive Mailbox Set Bit
trmreq_c1mctl22	.btequ		7,c1mctl22	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 23                                            *
;*------------------------------------------------------------------------------*
c1mctl23	.equ	0D4B7h
;
newdata_c1mctl23	.btequ		0,c1mctl23	; Reception Complete Flag
sentdata_c1mctl23	.btequ		0,c1mctl23	; Transmission Complete Flag
invaldata_c1mctl23	.btequ		1,c1mctl23	; Reception-in-Progress Status Flag
trmactive_c1mctl23	.btequ		1,c1mctl23	; Transmission-in-Progress Status Flag
msglost_c1mctl23	.btequ		2,c1mctl23	; Message Lost Flag
trmabt_c1mctl23	.btequ		2,c1mctl23	; Transmission Abort Complete Flag
oneshot_c1mctl23	.btequ		4,c1mctl23	; One-shot Enable Bit
recreq_c1mctl23	.btequ		6,c1mctl23	; Receive Mailbox Set Bit
trmreq_c1mctl23	.btequ		7,c1mctl23	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 24                                            *
;*------------------------------------------------------------------------------*
c1mctl24	.equ	0D4B8h
;
newdata_c1mctl24	.btequ		0,c1mctl24	; Reception Complete Flag
sentdata_c1mctl24	.btequ		0,c1mctl24	; Transmission Complete Flag
invaldata_c1mctl24	.btequ		1,c1mctl24	; Reception-in-Progress Status Flag
trmactive_c1mctl24	.btequ		1,c1mctl24	; Transmission-in-Progress Status Flag
msglost_c1mctl24	.btequ		2,c1mctl24	; Message Lost Flag
trmabt_c1mctl24	.btequ		2,c1mctl24	; Transmission Abort Complete Flag
oneshot_c1mctl24	.btequ		4,c1mctl24	; One-shot Enable Bit
recreq_c1mctl24	.btequ		6,c1mctl24	; Receive Mailbox Set Bit
trmreq_c1mctl24	.btequ		7,c1mctl24	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 25                                            *
;*------------------------------------------------------------------------------*
c1mctl25	.equ	0D4B9h
;
newdata_c1mctl25	.btequ		0,c1mctl25	; Reception Complete Flag
sentdata_c1mctl25	.btequ		0,c1mctl25	; Transmission Complete Flag
invaldata_c1mctl25	.btequ		1,c1mctl25	; Reception-in-Progress Status Flag
trmactive_c1mctl25	.btequ		1,c1mctl25	; Transmission-in-Progress Status Flag
msglost_c1mctl25	.btequ		2,c1mctl25	; Message Lost Flag
trmabt_c1mctl25	.btequ		2,c1mctl25	; Transmission Abort Complete Flag
oneshot_c1mctl25	.btequ		4,c1mctl25	; One-shot Enable Bit
recreq_c1mctl25	.btequ		6,c1mctl25	; Receive Mailbox Set Bit
trmreq_c1mctl25	.btequ		7,c1mctl25	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 26                                            *
;*------------------------------------------------------------------------------*
c1mctl26	.equ	0D4BAh
;
newdata_c1mctl26	.btequ		0,c1mctl26	; Reception Complete Flag
sentdata_c1mctl26	.btequ		0,c1mctl26	; Transmission Complete Flag
invaldata_c1mctl26	.btequ		1,c1mctl26	; Reception-in-Progress Status Flag
trmactive_c1mctl26	.btequ		1,c1mctl26	; Transmission-in-Progress Status Flag
msglost_c1mctl26	.btequ		2,c1mctl26	; Message Lost Flag
trmabt_c1mctl26	.btequ		2,c1mctl26	; Transmission Abort Complete Flag
oneshot_c1mctl26	.btequ		4,c1mctl26	; One-shot Enable Bit
recreq_c1mctl26	.btequ		6,c1mctl26	; Receive Mailbox Set Bit
trmreq_c1mctl26	.btequ		7,c1mctl26	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 27                                            *
;*------------------------------------------------------------------------------*
c1mctl27	.equ	0D4BBh
;
newdata_c1mctl27	.btequ		0,c1mctl27	; Reception Complete Flag
sentdata_c1mctl27	.btequ		0,c1mctl27	; Transmission Complete Flag
invaldata_c1mctl27	.btequ		1,c1mctl27	; Reception-in-Progress Status Flag
trmactive_c1mctl27	.btequ		1,c1mctl27	; Transmission-in-Progress Status Flag
msglost_c1mctl27	.btequ		2,c1mctl27	; Message Lost Flag
trmabt_c1mctl27	.btequ		2,c1mctl27	; Transmission Abort Complete Flag
oneshot_c1mctl27	.btequ		4,c1mctl27	; One-shot Enable Bit
recreq_c1mctl27	.btequ		6,c1mctl27	; Receive Mailbox Set Bit
trmreq_c1mctl27	.btequ		7,c1mctl27	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 28                                            *
;*------------------------------------------------------------------------------*
c1mctl28	.equ	0D4BCh
;
newdata_c1mctl28	.btequ		0,c1mctl28	; Reception Complete Flag
sentdata_c1mctl28	.btequ		0,c1mctl28	; Transmission Complete Flag
invaldata_c1mctl28	.btequ		1,c1mctl28	; Reception-in-Progress Status Flag
trmactive_c1mctl28	.btequ		1,c1mctl28	; Transmission-in-Progress Status Flag
msglost_c1mctl28	.btequ		2,c1mctl28	; Message Lost Flag
trmabt_c1mctl28	.btequ		2,c1mctl28	; Transmission Abort Complete Flag
oneshot_c1mctl28	.btequ		4,c1mctl28	; One-shot Enable Bit
recreq_c1mctl28	.btequ		6,c1mctl28	; Receive Mailbox Set Bit
trmreq_c1mctl28	.btequ		7,c1mctl28	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 29                                            *
;*------------------------------------------------------------------------------*
c1mctl29	.equ	0D4BDh
;
newdata_c1mctl29	.btequ		0,c1mctl29	; Reception Complete Flag
sentdata_c1mctl29	.btequ		0,c1mctl29	; Transmission Complete Flag
invaldata_c1mctl29	.btequ		1,c1mctl29	; Reception-in-Progress Status Flag
trmactive_c1mctl29	.btequ		1,c1mctl29	; Transmission-in-Progress Status Flag
msglost_c1mctl29	.btequ		2,c1mctl29	; Message Lost Flag
trmabt_c1mctl29	.btequ		2,c1mctl29	; Transmission Abort Complete Flag
oneshot_c1mctl29	.btequ		4,c1mctl29	; One-shot Enable Bit
recreq_c1mctl29	.btequ		6,c1mctl29	; Receive Mailbox Set Bit
trmreq_c1mctl29	.btequ		7,c1mctl29	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 30                                            *
;*------------------------------------------------------------------------------*
c1mctl30	.equ	0D4BEh
;
newdata_c1mctl30	.btequ		0,c1mctl30	; Reception Complete Flag
sentdata_c1mctl30	.btequ		0,c1mctl30	; Transmission Complete Flag
invaldata_c1mctl30	.btequ		1,c1mctl30	; Reception-in-Progress Status Flag
trmactive_c1mctl30	.btequ		1,c1mctl30	; Transmission-in-Progress Status Flag
msglost_c1mctl30	.btequ		2,c1mctl30	; Message Lost Flag
trmabt_c1mctl30	.btequ		2,c1mctl30	; Transmission Abort Complete Flag
oneshot_c1mctl30	.btequ		4,c1mctl30	; One-shot Enable Bit
recreq_c1mctl30	.btequ		6,c1mctl30	; Receive Mailbox Set Bit
trmreq_c1mctl30	.btequ		7,c1mctl30	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Message Control Register 31                                            *
;*------------------------------------------------------------------------------*
c1mctl31	.equ	0D4BFh
;
newdata_c1mctl31	.btequ		0,c1mctl31	; Reception Complete Flag
sentdata_c1mctl31	.btequ		0,c1mctl31	; Transmission Complete Flag
invaldata_c1mctl31	.btequ		1,c1mctl31	; Reception-in-Progress Status Flag
trmactive_c1mctl31	.btequ		1,c1mctl31	; Transmission-in-Progress Status Flag
msglost_c1mctl31	.btequ		2,c1mctl31	; Message Lost Flag
trmabt_c1mctl31	.btequ		2,c1mctl31	; Transmission Abort Complete Flag
oneshot_c1mctl31	.btequ		4,c1mctl31	; One-shot Enable Bit
recreq_c1mctl31	.btequ		6,c1mctl31	; Receive Mailbox Set Bit
trmreq_c1mctl31	.btequ		7,c1mctl31	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Control Register                                                       *
;*------------------------------------------------------------------------------*
c1ctlr		.equ	0D4C0h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Status Register                                                        *
;*------------------------------------------------------------------------------*
c1str		.equ	0D4C2h
;
c1strl		.equ	c1str				; CAN1 Status Register(low-order byte)
c1strh		.equ	c1str+1				; CAN1 Status Register(high-order byte)
;
rstst_c1str		.btequ		0,c1str		; CAN Reset Status Flag
hltst_c1str		.btequ		1,c1str		; CAN Halt Status Flag
slpst_c1str		.btequ		2,c1str		; CAN Sleep Status Flag
epst_c1str		.btequ		3,c1str		; Error-Passive Status Flag
bost_c1str		.btequ		4,c1str		; Bus-Off Status Flag
trmst_c1str		.btequ		5,c1str		; Transmit Status Flag(transmitter)
recst_c1str		.btequ		6,c1str		; Receive Status Flag(receiver)
ndst_c1str		.btequ		8,c1str		; NEWDATA Status Flag
sdst_c1str		.btequ		9,c1str		; SENTDATA Status Flag
rfst_c1str		.btequ		10,c1str	; Receive FIFO Status Flag
tfst_c1str		.btequ		11,c1str	; Transmit FIFO Status Flag
nmlst_c1str		.btequ		12,c1str	; Normal Mailbox Message Lost Status Flag
fmlst_c1str		.btequ		13,c1str	; FIFO Mailbox Message Lost Status Flag
tabst_c1str		.btequ		14,c1str	; Transmission Abort Status Flag
est_c1str		.btequ		15,c1str	; Error Status Flag
;
;*------------------------------------------------------------------------------*
;*  CAN1 Bit Configuration Register                                             *
;*------------------------------------------------------------------------------*
c1bcr		.equ	0D4C4h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Clock Select Register                                                  *
;*------------------------------------------------------------------------------*
c1clkr		.equ	0D4C7h
;
cclks_c1clkr	.btequ		0,c1clkr	; CAN Clock Source Select Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Receive FIFO Control Register                                          *
;*------------------------------------------------------------------------------*
c1rfcr		.equ	0D4C8h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Receive FIFO Pointer Control Register                                  *
;*------------------------------------------------------------------------------*
c1rfpcr		.equ	0D4C9h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Transmit FIFO Control Register                                         *
;*------------------------------------------------------------------------------*
c1tfcr		.equ	0D4CAh
;
;*------------------------------------------------------------------------------*
;*  CAN1 Transmit FIFO Pointer Control Register                                 *
;*------------------------------------------------------------------------------*
c1tfpcr		.equ	0D4CBh
;
;*------------------------------------------------------------------------------*
;*  CAN1 Error Interrupt Enable Register                                        *
;*------------------------------------------------------------------------------*
c1eier		.equ	0D4CCh
;
beie_c1eier		.btequ		0,c1eier	; Bus Error Interrupt Enable Bit
ewie_c1eier		.btequ		1,c1eier	; Error Warning Interrupt Enable Bit
epie_c1eier		.btequ		2,c1eier	; Error Passive Interrupt Enable Bit
boeie_c1eier	.btequ		3,c1eier	; Bus-Off Entry Interrupt Enable Bit
borie_c1eier	.btequ		4,c1eier	; Bus-Off Recovery Interrupt Enable Bit
orie_c1eier		.btequ		5,c1eier	; Receive Overrun Interrupt Enable Bit
olie_c1eier		.btequ		6,c1eier	; Overload Frame Transmit Interrupt Enable Bit
blie_c1eier		.btequ		7,c1eier	; Bus Lock Interrupt Enable Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Error Interrupt Factor Judge Register                                  *
;*------------------------------------------------------------------------------*
c1eifr		.equ	0D4CDh
;
beif_c1eifr		.btequ		0,c1eifr	; Bus Error Detect Flag
ewif_c1eifr		.btequ		1,c1eifr	; Error Warning Detect Flag
epif_c1eifr		.btequ		2,c1eifr	; Error Passive Detect Flag
boeif_c1eifr	.btequ		3,c1eifr	; Bus-Off Entry Detect Flag
borif_c1eifr	.btequ		4,c1eifr	; Bus-Off Recovery Detect Flag
orif_c1eifr		.btequ		5,c1eifr	; Receive Overrun Detect Flag
olif_c1eifr		.btequ		6,c1eifr	; Overload Frame Transmission Detect Flag
blif_c1eifr		.btequ		7,c1eifr	; Bus Lock Detect Flag
;
;*------------------------------------------------------------------------------*
;*  CAN1 Receive Error Count Register                                           *
;*------------------------------------------------------------------------------*
c1recr		.equ	0D4CEh
;
;*------------------------------------------------------------------------------*
;*  CAN1 Transmit Error Count Register                                          *
;*------------------------------------------------------------------------------*
c1tecr		.equ	0D4CFh
;
;*------------------------------------------------------------------------------*
;*  CAN1 Error Code Store Register                                              *
;*------------------------------------------------------------------------------*
c1ecsr		.equ	0D4D0h
;
sef_c1ecsr		.btequ		0,c1ecsr	; Stuff Error Flag
fef_c1ecsr		.btequ		1,c1ecsr	; Form Error Flag
aef_c1ecsr		.btequ		2,c1ecsr	; ACK Error Flag
cef_c1ecsr		.btequ		3,c1ecsr	; CRC Error Flag
be1f_c1ecsr		.btequ		4,c1ecsr	; Bit Error(recessive) Flag
be0f_c1ecsr		.btequ		5,c1ecsr	; Bit Error(dominant) Flag
adef_c1ecsr		.btequ		6,c1ecsr	; ACK Delimiter Error Bit
edpm_c1ecsr		.btequ		7,c1ecsr	; Error Display Mode Select Bit
;
;*------------------------------------------------------------------------------*
;*  CAN1 Channel Search Support Register                                        *
;*------------------------------------------------------------------------------*
c1cssr		.equ	0D4D1h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Search Status Register                                         *
;*------------------------------------------------------------------------------*
c1mssr		.equ	0D4D2h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Mailbox Search Mode Register                                           *
;*------------------------------------------------------------------------------*
c1msmr		.equ	0D4D3h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Time Stamp Register                                                    *
;*------------------------------------------------------------------------------*
c1tsr		.equ	0D4D4h
;
;*------------------------------------------------------------------------------*
;*  CAN1 Acceptance Filter Support Register                                     *
;*------------------------------------------------------------------------------*
c1afsr		.equ	0D4D6h
;
c1afsrl		.equ	c1afsr				; CAN1 acceptance filter support register(low-order byte)
c1afsrh		.equ	c1afsr+1			; CAN1 acceptance filter support register(high-order byte)
;
;*------------------------------------------------------------------------------*
;*  CAN1 Test Control Register                                                  *
;*------------------------------------------------------------------------------*
c1tcr		.equ	0D4D8h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 0                                                     *
;*------------------------------------------------------------------------------*
c0mb0		.equ	0D500h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 1                                                     *
;*------------------------------------------------------------------------------*
c0mb1		.equ	0D510h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 2                                                     *
;*------------------------------------------------------------------------------*
c0mb2		.equ	0D520h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 3                                                     *
;*------------------------------------------------------------------------------*
c0mb3		.equ	0D530h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 4                                                     *
;*------------------------------------------------------------------------------*
c0mb4		.equ	0D540h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 5                                                     *
;*------------------------------------------------------------------------------*
c0mb5		.equ	0D550h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 6                                                     *
;*------------------------------------------------------------------------------*
c0mb6		.equ	0D560h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 7                                                     *
;*------------------------------------------------------------------------------*
c0mb7		.equ	0D570h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 8                                                     *
;*------------------------------------------------------------------------------*
c0mb8		.equ	0D580h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 9                                                     *
;*------------------------------------------------------------------------------*
c0mb9		.equ	0D590h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 10                                                    *
;*------------------------------------------------------------------------------*
c0mb10		.equ	0D5A0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 11                                                    *
;*------------------------------------------------------------------------------*
c0mb11		.equ	0D5B0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 12                                                    *
;*------------------------------------------------------------------------------*
c0mb12		.equ	0D5C0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 13                                                    *
;*------------------------------------------------------------------------------*
c0mb13		.equ	0D5D0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 14                                                    *
;*------------------------------------------------------------------------------*
c0mb14		.equ	0D5E0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 15                                                    *
;*------------------------------------------------------------------------------*
c0mb15		.equ	0D5F0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 16                                                    *
;*------------------------------------------------------------------------------*
c0mb16		.equ	0D600h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 17                                                    *
;*------------------------------------------------------------------------------*
c0mb17		.equ	0D610h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 18                                                    *
;*------------------------------------------------------------------------------*
c0mb18		.equ	0D620h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 19                                                    *
;*------------------------------------------------------------------------------*
c0mb19		.equ	0D630h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 20                                                    *
;*------------------------------------------------------------------------------*
c0mb20		.equ	0D640h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 21                                                    *
;*------------------------------------------------------------------------------*
c0mb21		.equ	0D650h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 22                                                    *
;*------------------------------------------------------------------------------*
c0mb22		.equ	0D660h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 23                                                    *
;*------------------------------------------------------------------------------*
c0mb23		.equ	0D670h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 24                                                    *
;*------------------------------------------------------------------------------*
c0mb24		.equ	0D680h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 25                                                    *
;*------------------------------------------------------------------------------*
c0mb25		.equ	0D690h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 26                                                    *
;*------------------------------------------------------------------------------*
c0mb26		.equ	0D6A0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 27                                                    *
;*------------------------------------------------------------------------------*
c0mb27		.equ	0D6B0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 28                                                    *
;*------------------------------------------------------------------------------*
c0mb28		.equ	0D6C0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 29                                                    *
;*------------------------------------------------------------------------------*
c0mb29		.equ	0D6D0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 30                                                    *
;*------------------------------------------------------------------------------*
c0mb30		.equ	0D6E0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Register 31                                                    *
;*------------------------------------------------------------------------------*
c0mb31		.equ	0D6F0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 0                                                        *
;*------------------------------------------------------------------------------*
c0mkr0		.equ	0D700h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 1                                                        *
;*------------------------------------------------------------------------------*
c0mkr1		.equ	0D704h
;
;*------------------------------------------------------------------------------*
;*  CAN0 mask register 2                                                        *
;*------------------------------------------------------------------------------*
c0mkr2		.equ	0D708h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 3                                                        *
;*------------------------------------------------------------------------------*
c0mkr3		.equ	0D70Ch
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 4                                                        *
;*------------------------------------------------------------------------------*
c0mkr4		.equ	0D710h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 5                                                        *
;*------------------------------------------------------------------------------*
c0mkr5		.equ	0D714h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 6                                                        *
;*------------------------------------------------------------------------------*
c0mkr6		.equ	0D718h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Register 7                                                        *
;*------------------------------------------------------------------------------*
c0mkr7		.equ	0D71Ch
;
;*------------------------------------------------------------------------------*
;*  CAN0 FIFO Receive ID Compare Register 0                                     *
;*------------------------------------------------------------------------------*
c0fidcr0	.equ	0D720h
;
;*------------------------------------------------------------------------------*
;*  CAN0 FIFO Receive ID Compare Register 1                                     *
;*------------------------------------------------------------------------------*
c0fidcr1	.equ	0D724h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mask Invalid Register                                                  *
;*------------------------------------------------------------------------------*
c0mkivlr	.equ	0D728h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Interrupt Enable Register                                      *
;*------------------------------------------------------------------------------*
c0mier		.equ	0D72Ch
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 0                                             *
;*------------------------------------------------------------------------------*
c0mctl0		.equ	0D7A0h
;
newdata_c0mctl0	.btequ		0,c0mctl0	; Reception Complete Flag
sentdata_c0mctl0	.btequ		0,c0mctl0	; Transmission Complete Flag
invaldata_c0mctl0	.btequ		1,c0mctl0	; Reception-in-Progress Status Flag
trmactive_c0mctl0	.btequ		1,c0mctl0	; Transmission-in-Progress Status Flag
msglost_c0mctl0	.btequ		2,c0mctl0	; Message Lost Flag
trmabt_c0mctl0	.btequ		2,c0mctl0	; Transmission Abort Complete Flag
oneshot_c0mctl0	.btequ		4,c0mctl0	; One-shot Enable Bit
recreq_c0mctl0	.btequ		6,c0mctl0	; Receive Mailbox Set Bit
trmreq_c0mctl0	.btequ		7,c0mctl0	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 1                                             *
;*------------------------------------------------------------------------------*
c0mctl1		.equ	0D7A1h
;
newdata_c0mctl1	.btequ		0,c0mctl1	; Reception Complete Flag
sentdata_c0mctl1	.btequ		0,c0mctl1	; Transmission Complete Flag
invaldata_c0mctl1	.btequ		1,c0mctl1	; Reception-in-Progress Status Flag
trmactive_c0mctl1	.btequ		1,c0mctl1	; Transmission-in-Progress Status Flag
msglost_c0mctl1	.btequ		2,c0mctl1	; Message Lost Flag
trmabt_c0mctl1	.btequ		2,c0mctl1	; Transmission Abort Complete Flag
oneshot_c0mctl1	.btequ		4,c0mctl1	; One-shot Enable Bit
recreq_c0mctl1	.btequ		6,c0mctl1	; Receive Mailbox Set Bit
trmreq_c0mctl1	.btequ		7,c0mctl1	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 2                                             *
;*------------------------------------------------------------------------------*
c0mctl2		.equ	0D7A2h
;
newdata_c0mctl2	.btequ		0,c0mctl2	; Reception Complete Flag
sentdata_c0mctl2	.btequ		0,c0mctl2	; Transmission Complete Flag
invaldata_c0mctl2	.btequ		1,c0mctl2	; Reception-in-Progress Status Flag
trmactive_c0mctl2	.btequ		1,c0mctl2	; Transmission-in-Progress Status Flag
msglost_c0mctl2	.btequ		2,c0mctl2	; Message Lost Flag
trmabt_c0mctl2	.btequ		2,c0mctl2	; Transmission Abort Complete Flag
oneshot_c0mctl2	.btequ		4,c0mctl2	; One-shot Enable Bit
recreq_c0mctl2	.btequ		6,c0mctl2	; Receive Mailbox Set Bit
trmreq_c0mctl2	.btequ		7,c0mctl2	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 3                                             *
;*------------------------------------------------------------------------------*
c0mctl3		.equ	0D7A3h
;
newdata_c0mctl3	.btequ		0,c0mctl3	; Reception Complete Flag
sentdata_c0mctl3	.btequ		0,c0mctl3	; Transmission Complete Flag
invaldata_c0mctl3	.btequ		1,c0mctl3	; Reception-in-Progress Status Flag
trmactive_c0mctl3	.btequ		1,c0mctl3	; Transmission-in-Progress Status Flag
msglost_c0mctl3	.btequ		2,c0mctl3	; Message Lost Flag
trmabt_c0mctl3	.btequ		2,c0mctl3	; Transmission Abort Complete Flag
oneshot_c0mctl3	.btequ		4,c0mctl3	; One-shot Enable Bit
recreq_c0mctl3	.btequ		6,c0mctl3	; Receive Mailbox Set Bit
trmreq_c0mctl3	.btequ		7,c0mctl3	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 4                                             *
;*------------------------------------------------------------------------------*
c0mctl4		.equ	0D7A4h
;
newdata_c0mctl4	.btequ		0,c0mctl4	; Reception Complete Flag
sentdata_c0mctl4	.btequ		0,c0mctl4	; Transmission Complete Flag
invaldata_c0mctl4	.btequ		1,c0mctl4	; Reception-in-Progress Status Flag
trmactive_c0mctl4	.btequ		1,c0mctl4	; Transmission-in-Progress Status Flag
msglost_c0mctl4	.btequ		2,c0mctl4	; Message Lost Flag
trmabt_c0mctl4	.btequ		2,c0mctl4	; Transmission Abort Complete Flag
oneshot_c0mctl4	.btequ		4,c0mctl4	; One-shot Enable Bit
recreq_c0mctl4	.btequ		6,c0mctl4	; Receive Mailbox Set Bit
trmreq_c0mctl4	.btequ		7,c0mctl4	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 5                                             *
;*------------------------------------------------------------------------------*
c0mctl5		.equ	0D7A5h
;
newdata_c0mctl5	.btequ		0,c0mctl5	; Reception Complete Flag
sentdata_c0mctl5	.btequ		0,c0mctl5	; Transmission Complete Flag
invaldata_c0mctl5	.btequ		1,c0mctl5	; Reception-in-Progress Status Flag
trmactive_c0mctl5	.btequ		1,c0mctl5	; Transmission-in-Progress Status Flag
msglost_c0mctl5	.btequ		2,c0mctl5	; Message Lost Flag
trmabt_c0mctl5	.btequ		2,c0mctl5	; Transmission Abort Complete Flag
oneshot_c0mctl5	.btequ		4,c0mctl5	; One-shot Enable Bit
recreq_c0mctl5	.btequ		6,c0mctl5	; Receive Mailbox Set Bit
trmreq_c0mctl5	.btequ		7,c0mctl5	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 6                                             *
;*------------------------------------------------------------------------------*
c0mctl6		.equ	0D7A6h
;
newdata_c0mctl6	.btequ		0,c0mctl6	; Reception Complete Flag
sentdata_c0mctl6	.btequ		0,c0mctl6	; Transmission Complete Flag
invaldata_c0mctl6	.btequ		1,c0mctl6	; Reception-in-Progress Status Flag
trmactive_c0mctl6	.btequ		1,c0mctl6	; Transmission-in-Progress Status Flag
msglost_c0mctl6	.btequ		2,c0mctl6	; Message Lost Flag
trmabt_c0mctl6	.btequ		2,c0mctl6	; Transmission Abort Complete Flag
oneshot_c0mctl6	.btequ		4,c0mctl6	; One-shot Enable Bit
recreq_c0mctl6	.btequ		6,c0mctl6	; Receive Mailbox Set Bit
trmreq_c0mctl6	.btequ		7,c0mctl6	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 7                                             *
;*------------------------------------------------------------------------------*
c0mctl7		.equ	0D7A7h
;
newdata_c0mctl7	.btequ		0,c0mctl7	; Reception Complete Flag
sentdata_c0mctl7	.btequ		0,c0mctl7	; Transmission Complete Flag
invaldata_c0mctl7	.btequ		1,c0mctl7	; Reception-in-Progress Status Flag
trmactive_c0mctl7	.btequ		1,c0mctl7	; Transmission-in-Progress Status Flag
msglost_c0mctl7	.btequ		2,c0mctl7	; Message Lost Flag
trmabt_c0mctl7	.btequ		2,c0mctl7	; Transmission Abort Complete Flag
oneshot_c0mctl7	.btequ		4,c0mctl7	; One-shot Enable Bit
recreq_c0mctl7	.btequ		6,c0mctl7	; Receive Mailbox Set Bit
trmreq_c0mctl7	.btequ		7,c0mctl7	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 8                                             *
;*------------------------------------------------------------------------------*
c0mctl8		.equ	0D7A8h
;
newdata_c0mctl8	.btequ		0,c0mctl8	; Reception Complete Flag
sentdata_c0mctl8	.btequ		0,c0mctl8	; Transmission Complete Flag
invaldata_c0mctl8	.btequ		1,c0mctl8	; Reception-in-Progress Status Flag
trmactive_c0mctl8	.btequ		1,c0mctl8	; Transmission-in-Progress Status Flag
msglost_c0mctl8	.btequ		2,c0mctl8	; Message Lost Flag
trmabt_c0mctl8	.btequ		2,c0mctl8	; Transmission Abort Complete Flag
oneshot_c0mctl8	.btequ		4,c0mctl8	; One-shot Enable Bit
recreq_c0mctl8	.btequ		6,c0mctl8	; Receive Mailbox Set Bit
trmreq_c0mctl8	.btequ		7,c0mctl8	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 9                                             *
;*------------------------------------------------------------------------------*
c0mctl9		.equ	0D7A9h
;
newdata_c0mctl9	.btequ		0,c0mctl9	; Reception Complete Flag
sentdata_c0mctl9	.btequ		0,c0mctl9	; Transmission Complete Flag
invaldata_c0mctl9	.btequ		1,c0mctl9	; Reception-in-Progress Status Flag
trmactive_c0mctl9	.btequ		1,c0mctl9	; Transmission-in-Progress Status Flag
msglost_c0mctl9	.btequ		2,c0mctl9	; Message Lost Flag
trmabt_c0mctl9	.btequ		2,c0mctl9	; Transmission Abort Complete Flag
oneshot_c0mctl9	.btequ		4,c0mctl9	; One-shot Enable Bit
recreq_c0mctl9	.btequ		6,c0mctl9	; Receive Mailbox Set Bit
trmreq_c0mctl9	.btequ		7,c0mctl9	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 10                                            *
;*------------------------------------------------------------------------------*
c0mctl10	.equ	0D7AAh
;
newdata_c0mctl10	.btequ		0,c0mctl10	; Reception Complete Flag
sentdata_c0mctl10	.btequ		0,c0mctl10	; Transmission Complete Flag
invaldata_c0mctl10	.btequ		1,c0mctl10	; Reception-in-Progress Status Flag
trmactive_c0mctl10	.btequ		1,c0mctl10	; Transmission-in-Progress Status Flag
msglost_c0mctl10	.btequ		2,c0mctl10	; Message Lost Flag
trmabt_c0mctl10	.btequ		2,c0mctl10	; Transmission Abort Complete Flag
oneshot_c0mctl10	.btequ		4,c0mctl10	; One-shot Enable Bit
recreq_c0mctl10	.btequ		6,c0mctl10	; Receive Mailbox Set Bit
trmreq_c0mctl10	.btequ		7,c0mctl10	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 11                                            *
;*------------------------------------------------------------------------------*
c0mctl11	.equ	0D7ABh
;
newdata_c0mctl11	.btequ		0,c0mctl11	; Reception Complete Flag
sentdata_c0mctl11	.btequ		0,c0mctl11	; Transmission Complete Flag
invaldata_c0mctl11	.btequ		1,c0mctl11	; Reception-in-Progress Status Flag
trmactive_c0mctl11	.btequ		1,c0mctl11	; Transmission-in-Progress Status Flag
msglost_c0mctl11	.btequ		2,c0mctl11	; Message Lost Flag
trmabt_c0mctl11	.btequ		2,c0mctl11	; Transmission Abort Complete Flag
oneshot_c0mctl11	.btequ		4,c0mctl11	; One-shot Enable Bit
recreq_c0mctl11	.btequ		6,c0mctl11	; Receive Mailbox Set Bit
trmreq_c0mctl11	.btequ		7,c0mctl11	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 12                                            *
;*------------------------------------------------------------------------------*
c0mctl12	.equ	0D7ACh
;
newdata_c0mctl12	.btequ		0,c0mctl12	; Reception Complete Flag
sentdata_c0mctl12	.btequ		0,c0mctl12	; Transmission Complete Flag
invaldata_c0mctl12	.btequ		1,c0mctl12	; Reception-in-Progress Status Flag
trmactive_c0mctl12	.btequ		1,c0mctl12	; Transmission-in-Progress Status Flag
msglost_c0mctl12	.btequ		2,c0mctl12	; Message Lost Flag
trmabt_c0mctl12	.btequ		2,c0mctl12	; Transmission Abort Complete Flag
oneshot_c0mctl12	.btequ		4,c0mctl12	; One-shot Enable Bit
recreq_c0mctl12	.btequ		6,c0mctl12	; Receive Mailbox Set Bit
trmreq_c0mctl12	.btequ		7,c0mctl12	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 13                                            *
;*------------------------------------------------------------------------------*
c0mctl13	.equ	0D7ADh
;
newdata_c0mctl13	.btequ		0,c0mctl13	; Reception Complete Flag
sentdata_c0mctl13	.btequ		0,c0mctl13	; Transmission Complete Flag
invaldata_c0mctl13	.btequ		1,c0mctl13	; Reception-in-Progress Status Flag
trmactive_c0mctl13	.btequ		1,c0mctl13	; Transmission-in-Progress Status Flag
msglost_c0mctl13	.btequ		2,c0mctl13	; Message Lost Flag
trmabt_c0mctl13	.btequ		2,c0mctl13	; Transmission Abort Complete Flag
oneshot_c0mctl13	.btequ		4,c0mctl13	; One-shot Enable Bit
recreq_c0mctl13	.btequ		6,c0mctl13	; Receive Mailbox Set Bit
trmreq_c0mctl13	.btequ		7,c0mctl13	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 14                                            *
;*------------------------------------------------------------------------------*
c0mctl14	.equ	0D7AEh
;
newdata_c0mctl14	.btequ		0,c0mctl14	; Reception Complete Flag
sentdata_c0mctl14	.btequ		0,c0mctl14	; Transmission Complete Flag
invaldata_c0mctl14	.btequ		1,c0mctl14	; Reception-in-Progress Status Flag
trmactive_c0mctl14	.btequ		1,c0mctl14	; Transmission-in-Progress Status Flag
msglost_c0mctl14	.btequ		2,c0mctl14	; Message Lost Flag
trmabt_c0mctl14	.btequ		2,c0mctl14	; Transmission Abort Complete Flag
oneshot_c0mctl14	.btequ		4,c0mctl14	; One-shot Enable Bit
recreq_c0mctl14	.btequ		6,c0mctl14	; Receive Mailbox Set Bit
trmreq_c0mctl14	.btequ		7,c0mctl14	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 15                                            *
;*------------------------------------------------------------------------------*
c0mctl15	.equ	0D7AFh
;
newdata_c0mctl15	.btequ		0,c0mctl15	; Reception Complete Flag
sentdata_c0mctl15	.btequ		0,c0mctl15	; Transmission Complete Flag
invaldata_c0mctl15	.btequ		1,c0mctl15	; Reception-in-Progress Status Flag
trmactive_c0mctl15	.btequ		1,c0mctl15	; Transmission-in-Progress Status Flag
msglost_c0mctl15	.btequ		2,c0mctl15	; Message Lost Flag
trmabt_c0mctl15	.btequ		2,c0mctl15	; Transmission Abort Complete Flag
oneshot_c0mctl15	.btequ		4,c0mctl15	; One-shot Enable Bit
recreq_c0mctl15	.btequ		6,c0mctl15	; Receive Mailbox Set Bit
trmreq_c0mctl15	.btequ		7,c0mctl15	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 16                                            *
;*------------------------------------------------------------------------------*
c0mctl16	.equ	0D7B0h
;
newdata_c0mctl16	.btequ		0,c0mctl16	; Reception Complete Flag
sentdata_c0mctl16	.btequ		0,c0mctl16	; Transmission Complete Flag
invaldata_c0mctl16	.btequ		1,c0mctl16	; Reception-in-Progress Status Flag
trmactive_c0mctl16	.btequ		1,c0mctl16	; Transmission-in-Progress Status Flag
msglost_c0mctl16	.btequ		2,c0mctl16	; Message Lost Flag
trmabt_c0mctl16	.btequ		2,c0mctl16	; Transmission Abort Complete Flag
oneshot_c0mctl16	.btequ		4,c0mctl16	; One-shot Enable Bit
recreq_c0mctl16	.btequ		6,c0mctl16	; Receive Mailbox Set Bit
trmreq_c0mctl16	.btequ		7,c0mctl16	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 17                                            *
;*------------------------------------------------------------------------------*
c0mctl17	.equ	0D7B1h
;
newdata_c0mctl17	.btequ		0,c0mctl17	; Reception Complete Flag
sentdata_c0mctl17	.btequ		0,c0mctl17	; Transmission Complete Flag
invaldata_c0mctl17	.btequ		1,c0mctl17	; Reception-in-Progress Status Flag
trmactive_c0mctl17	.btequ		1,c0mctl17	; Transmission-in-Progress Status Flag
msglost_c0mctl17	.btequ		2,c0mctl17	; Message Lost Flag
trmabt_c0mctl17	.btequ		2,c0mctl17	; Transmission Abort Complete Flag
oneshot_c0mctl17	.btequ		4,c0mctl17	; One-shot Enable Bit
recreq_c0mctl17	.btequ		6,c0mctl17	; Receive Mailbox Set Bit
trmreq_c0mctl17	.btequ		7,c0mctl17	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 18                                            *
;*------------------------------------------------------------------------------*
c0mctl18	.equ	0D7B2h
;
newdata_c0mctl18	.btequ		0,c0mctl18	; Reception Complete Flag
sentdata_c0mctl18	.btequ		0,c0mctl18	; Transmission Complete Flag
invaldata_c0mctl18	.btequ		1,c0mctl18	; Reception-in-Progress Status Flag
trmactive_c0mctl18	.btequ		1,c0mctl18	; Transmission-in-Progress Status Flag
msglost_c0mctl18	.btequ		2,c0mctl18	; Message Lost Flag
trmabt_c0mctl18	.btequ		2,c0mctl18	; Transmission Abort Complete Flag
oneshot_c0mctl18	.btequ		4,c0mctl18	; One-shot Enable Bit
recreq_c0mctl18	.btequ		6,c0mctl18	; Receive Mailbox Set Bit
trmreq_c0mctl18	.btequ		7,c0mctl18	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 19                                            *
;*------------------------------------------------------------------------------*
c0mctl19	.equ	0D7B3h
;
newdata_c0mctl19	.btequ		0,c0mctl19	; Reception Complete Flag
sentdata_c0mctl19	.btequ		0,c0mctl19	; Transmission Complete Flag
invaldata_c0mctl19	.btequ		1,c0mctl19	; Reception-in-Progress Status Flag
trmactive_c0mctl19	.btequ		1,c0mctl19	; Transmission-in-Progress Status Flag
msglost_c0mctl19	.btequ		2,c0mctl19	; Message Lost Flag
trmabt_c0mctl19	.btequ		2,c0mctl19	; Transmission Abort Complete Flag
oneshot_c0mctl19	.btequ		4,c0mctl19	; One-shot Enable Bit
recreq_c0mctl19	.btequ		6,c0mctl19	; Receive Mailbox Set Bit
trmreq_c0mctl19	.btequ		7,c0mctl19	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 20                                            *
;*------------------------------------------------------------------------------*
c0mctl20	.equ	0D7B4h
;
newdata_c0mctl20	.btequ		0,c0mctl20	; Reception Complete Flag
sentdata_c0mctl20	.btequ		0,c0mctl20	; Transmission Complete Flag
invaldata_c0mctl20	.btequ		1,c0mctl20	; Reception-in-Progress Status Flag
trmactive_c0mctl20	.btequ		1,c0mctl20	; Transmission-in-Progress Status Flag
msglost_c0mctl20	.btequ		2,c0mctl20	; Message Lost Flag
trmabt_c0mctl20	.btequ		2,c0mctl20	; Transmission Abort Complete Flag
oneshot_c0mctl20	.btequ		4,c0mctl20	; One-shot Enable Bit
recreq_c0mctl20	.btequ		6,c0mctl20	; Receive Mailbox Set Bit
trmreq_c0mctl20	.btequ		7,c0mctl20	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 21                                            *
;*------------------------------------------------------------------------------*
c0mctl21	.equ	0D7B5h
;
newdata_c0mctl21	.btequ		0,c0mctl21	; Reception Complete Flag
sentdata_c0mctl21	.btequ		0,c0mctl21	; Transmission Complete Flag
invaldata_c0mctl21	.btequ		1,c0mctl21	; Reception-in-Progress Status Flag
trmactive_c0mctl21	.btequ		1,c0mctl21	; Transmission-in-Progress Status Flag
msglost_c0mctl21	.btequ		2,c0mctl21	; Message Lost Flag
trmabt_c0mctl21	.btequ		2,c0mctl21	; Transmission Abort Complete Flag
oneshot_c0mctl21	.btequ		4,c0mctl21	; One-shot Enable Bit
recreq_c0mctl21	.btequ		6,c0mctl21	; Receive Mailbox Set Bit
trmreq_c0mctl21	.btequ		7,c0mctl21	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 22                                            *
;*------------------------------------------------------------------------------*
c0mctl22	.equ	0D7B6h
;
newdata_c0mctl22	.btequ		0,c0mctl22	; Reception Complete Flag
sentdata_c0mctl22	.btequ		0,c0mctl22	; Transmission Complete Flag
invaldata_c0mctl22	.btequ		1,c0mctl22	; Reception-in-Progress Status Flag
trmactive_c0mctl22	.btequ		1,c0mctl22	; Transmission-in-Progress Status Flag
msglost_c0mctl22	.btequ		2,c0mctl22	; Message Lost Flag
trmabt_c0mctl22	.btequ		2,c0mctl22	; Transmission Abort Complete Flag
oneshot_c0mctl22	.btequ		4,c0mctl22	; One-shot Enable Bit
recreq_c0mctl22	.btequ		6,c0mctl22	; Receive Mailbox Set Bit
trmreq_c0mctl22	.btequ		7,c0mctl22	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 23                                            *
;*------------------------------------------------------------------------------*
c0mctl23	.equ	0D7B7h
;
newdata_c0mctl23	.btequ		0,c0mctl23	; Reception Complete Flag
sentdata_c0mctl23	.btequ		0,c0mctl23	; Transmission Complete Flag
invaldata_c0mctl23	.btequ		1,c0mctl23	; Reception-in-Progress Status Flag
trmactive_c0mctl23	.btequ		1,c0mctl23	; Transmission-in-Progress Status Flag
msglost_c0mctl23	.btequ		2,c0mctl23	; Message Lost Flag
trmabt_c0mctl23	.btequ		2,c0mctl23	; Transmission Abort Complete Flag
oneshot_c0mctl23	.btequ		4,c0mctl23	; One-shot Enable Bit
recreq_c0mctl23	.btequ		6,c0mctl23	; Receive Mailbox Set Bit
trmreq_c0mctl23	.btequ		7,c0mctl23	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 24                                            *
;*------------------------------------------------------------------------------*
c0mctl24	.equ	0D7B8h
;
newdata_c0mctl24	.btequ		0,c0mctl24	; Reception Complete Flag
sentdata_c0mctl24	.btequ		0,c0mctl24	; Transmission Complete Flag
invaldata_c0mctl24	.btequ		1,c0mctl24	; Reception-in-Progress Status Flag
trmactive_c0mctl24	.btequ		1,c0mctl24	; Transmission-in-Progress Status Flag
msglost_c0mctl24	.btequ		2,c0mctl24	; Message Lost Flag
trmabt_c0mctl24	.btequ		2,c0mctl24	; Transmission Abort Complete Flag
oneshot_c0mctl24	.btequ		4,c0mctl24	; One-shot Enable Bit
recreq_c0mctl24	.btequ		6,c0mctl24	; Receive Mailbox Set Bit
trmreq_c0mctl24	.btequ		7,c0mctl24	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 25                                            *
;*------------------------------------------------------------------------------*
c0mctl25	.equ	0D7B9h
;
newdata_c0mctl25	.btequ		0,c0mctl25	; Reception Complete Flag
sentdata_c0mctl25	.btequ		0,c0mctl25	; Transmission Complete Flag
invaldata_c0mctl25	.btequ		1,c0mctl25	; Reception-in-Progress Status Flag
trmactive_c0mctl25	.btequ		1,c0mctl25	; Transmission-in-Progress Status Flag
msglost_c0mctl25	.btequ		2,c0mctl25	; Message Lost Flag
trmabt_c0mctl25	.btequ		2,c0mctl25	; Transmission Abort Complete Flag
oneshot_c0mctl25	.btequ		4,c0mctl25	; One-shot Enable Bit
recreq_c0mctl25	.btequ		6,c0mctl25	; Receive Mailbox Set Bit
trmreq_c0mctl25	.btequ		7,c0mctl25	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 26                                            *
;*------------------------------------------------------------------------------*
c0mctl26	.equ	0D7BAh
;
newdata_c0mctl26	.btequ		0,c0mctl26	; Reception Complete Flag
sentdata_c0mctl26	.btequ		0,c0mctl26	; Transmission Complete Flag
invaldata_c0mctl26	.btequ		1,c0mctl26	; Reception-in-Progress Status Flag
trmactive_c0mctl26	.btequ		1,c0mctl26	; Transmission-in-Progress Status Flag
msglost_c0mctl26	.btequ		2,c0mctl26	; Message Lost Flag
trmabt_c0mctl26	.btequ		2,c0mctl26	; Transmission Abort Complete Flag
oneshot_c0mctl26	.btequ		4,c0mctl26	; One-shot Enable Bit
recreq_c0mctl26	.btequ		6,c0mctl26	; Receive Mailbox Set Bit
trmreq_c0mctl26	.btequ		7,c0mctl26	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 27                                            *
;*------------------------------------------------------------------------------*
c0mctl27	.equ	0D7BBh
;
newdata_c0mctl27	.btequ		0,c0mctl27	; Reception Complete Flag
sentdata_c0mctl27	.btequ		0,c0mctl27	; Transmission Complete Flag
invaldata_c0mctl27	.btequ		1,c0mctl27	; Reception-in-Progress Status Flag
trmactive_c0mctl27	.btequ		1,c0mctl27	; Transmission-in-Progress Status Flag
msglost_c0mctl27	.btequ		2,c0mctl27	; Message Lost Flag
trmabt_c0mctl27	.btequ		2,c0mctl27	; Transmission Abort Complete Flag
oneshot_c0mctl27	.btequ		4,c0mctl27	; One-shot Enable Bit
recreq_c0mctl27	.btequ		6,c0mctl27	; Receive Mailbox Set Bit
trmreq_c0mctl27	.btequ		7,c0mctl27	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 28                                            *
;*------------------------------------------------------------------------------*
c0mctl28	.equ	0D7BCh
;
newdata_c0mctl28	.btequ		0,c0mctl28	; Reception Complete Flag
sentdata_c0mctl28	.btequ		0,c0mctl28	; Transmission Complete Flag
invaldata_c0mctl28	.btequ		1,c0mctl28	; Reception-in-Progress Status Flag
trmactive_c0mctl28	.btequ		1,c0mctl28	; Transmission-in-Progress Status Flag
msglost_c0mctl28	.btequ		2,c0mctl28	; Message Lost Flag
trmabt_c0mctl28	.btequ		2,c0mctl28	; Transmission Abort Complete Flag
oneshot_c0mctl28	.btequ		4,c0mctl28	; One-shot Enable Bit
recreq_c0mctl28	.btequ		6,c0mctl28	; Receive Mailbox Set Bit
trmreq_c0mctl28	.btequ		7,c0mctl28	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 29                                            *
;*------------------------------------------------------------------------------*
c0mctl29	.equ	0D7BDh
;
newdata_c0mctl29	.btequ		0,c0mctl29	; Reception Complete Flag
sentdata_c0mctl29	.btequ		0,c0mctl29	; Transmission Complete Flag
invaldata_c0mctl29	.btequ		1,c0mctl29	; Reception-in-Progress Status Flag
trmactive_c0mctl29	.btequ		1,c0mctl29	; Transmission-in-Progress Status Flag
msglost_c0mctl29	.btequ		2,c0mctl29	; Message Lost Flag
trmabt_c0mctl29	.btequ		2,c0mctl29	; Transmission Abort Complete Flag
oneshot_c0mctl29	.btequ		4,c0mctl29	; One-shot Enable Bit
recreq_c0mctl29	.btequ		6,c0mctl29	; Receive Mailbox Set Bit
trmreq_c0mctl29	.btequ		7,c0mctl29	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 30                                            *
;*------------------------------------------------------------------------------*
c0mctl30	.equ	0D7BEh
;
newdata_c0mctl30	.btequ		0,c0mctl30	; Reception Complete Flag
sentdata_c0mctl30	.btequ		0,c0mctl30	; Transmission Complete Flag
invaldata_c0mctl30	.btequ		1,c0mctl30	; Reception-in-Progress Status Flag
trmactive_c0mctl30	.btequ		1,c0mctl30	; Transmission-in-Progress Status Flag
msglost_c0mctl30	.btequ		2,c0mctl30	; Message Lost Flag
trmabt_c0mctl30	.btequ		2,c0mctl30	; Transmission Abort Complete Flag
oneshot_c0mctl30	.btequ		4,c0mctl30	; One-shot Enable Bit
recreq_c0mctl30	.btequ		6,c0mctl30	; Receive Mailbox Set Bit
trmreq_c0mctl30	.btequ		7,c0mctl30	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Message Control Register 31                                            *
;*------------------------------------------------------------------------------*
c0mctl31	.equ	0D7BFh
;
newdata_c0mctl31	.btequ		0,c0mctl31	; Reception Complete Flag
sentdata_c0mctl31	.btequ		0,c0mctl31	; Transmission Complete Flag
invaldata_c0mctl31	.btequ		1,c0mctl31	; Reception-in-Progress Status Flag
trmactive_c0mctl31	.btequ		1,c0mctl31	; Transmission-in-Progress Status Flag
msglost_c0mctl31	.btequ		2,c0mctl31	; Message Lost Flag
trmabt_c0mctl31	.btequ		2,c0mctl31	; Transmission Abort Complete Flag
oneshot_c0mctl31	.btequ		4,c0mctl31	; One-shot Enable Bit
recreq_c0mctl31	.btequ		6,c0mctl31	; Receive Mailbox Set Bit
trmreq_c0mctl31	.btequ		7,c0mctl31	; Transmit Mailbox Set Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Control Register                                                       *
;*------------------------------------------------------------------------------*
c0ctlr		.equ	0D7C0h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Status Register                                                        *
;*------------------------------------------------------------------------------*
c0str		.equ	0D7C2h
;
c0strl		.equ	c0str				; CAN0 Status Register(low-order byte)
c0strh		.equ	c0str+1				; CAN0 Status Register(high-order byte)
;
rstst_c0str		.btequ		0,c0str		; CAN Reset Status Flag
hltst_c0str		.btequ		1,c0str		; CAN Halt Status Flag
slpst_c0str		.btequ		2,c0str		; CAN Sleep Status Flag
epst_c0str		.btequ		3,c0str		; Error-Passive Status Flag
bost_c0str		.btequ		4,c0str		; Bus-Off Status Flag
trmst_c0str		.btequ		5,c0str		; Transmit Status Flag(transmitter)
recst_c0str		.btequ		6,c0str		; Receive Status Flag(receiver)
ndst_c0str		.btequ		8,c0str		; NEWDATA Status Flag
sdst_c0str		.btequ		9,c0str		; SENTDATA Status Flag
rfst_c0str		.btequ		10,c0str	; Receive FIFO Status Flag
tfst_c0str		.btequ		11,c0str	; Transmit FIFO Status Flag
nmlst_c0str		.btequ		12,c0str	; Normal Mailbox Message Lost Status Flag
fmlst_c0str		.btequ		13,c0str	; FIFO Mailbox Message Lost Status Flag
tabst_c0str		.btequ		14,c0str	; Transmission Abort Status Flag
est_c0str		.btequ		15,c0str	; Error Status Flag
;
;*------------------------------------------------------------------------------*
;*  CAN0 Bit Configuration Register                                             *
;*------------------------------------------------------------------------------*
c0bcr		.equ	0D7C4h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Clock Select Register                                                  *
;*------------------------------------------------------------------------------*
c0clkr		.equ	0D7C7h
;
cclks_c0clkr	.btequ		0,c0clkr	; CAN Clock Source Select Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Receive FIFO Control Register                                          *
;*------------------------------------------------------------------------------*
c0rfcr		.equ	0D7C8h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Receive FIFO Pointer Control Register                                  *
;*------------------------------------------------------------------------------*
c0rfpcr		.equ	0D7C9h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Transmit FIFO Control Register                                         *
;*------------------------------------------------------------------------------*
c0tfcr		.equ	0D7CAh
;
;*------------------------------------------------------------------------------*
;*  CAN0 Transmit FIFO Pointer Control Register                                 *
;*------------------------------------------------------------------------------*
c0tfpcr		.equ	0D7CBh
;
;*------------------------------------------------------------------------------*
;*  CAN0 Error Interrupt Enable Register                                        *
;*------------------------------------------------------------------------------*
c0eier		.equ	0D7CCh
;
beie_c0eier		.btequ		0,c0eier	; Bus Error Interrupt Enable Bit
ewie_c0eier		.btequ		1,c0eier	; Error Warning Interrupt Enable Bit
epie_c0eier		.btequ		2,c0eier	; Error Passive Interrupt Enable Bit
boeie_c0eier	.btequ		3,c0eier	; Bus-Off Entry Interrupt Enable Bit
borie_c0eier	.btequ		4,c0eier	; Bus-Off Recovery Interrupt Enable Bit
orie_c0eier		.btequ		5,c0eier	; Receive Overrun Interrupt Enable Bit
olie_c0eier		.btequ		6,c0eier	; Overload Frame Transmit Interrupt Enable Bit
blie_c0eier		.btequ		7,c0eier	; Bus Lock Interrupt Enable Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Error Interrupt Factor Judge Register                                  *
;*------------------------------------------------------------------------------*
c0eifr		.equ	0D7CDh
;
beif_c0eifr		.btequ		0,c0eifr	; Bus Error Detect Flag
ewif_c0eifr		.btequ		1,c0eifr	; Error Warning Detect Flag
epif_c0eifr		.btequ		2,c0eifr	; Error Passive Detect Flag
boeif_c0eifr	.btequ		3,c0eifr	; Bus-Off Entry Detect Flag
borif_c0eifr	.btequ		4,c0eifr	; Bus-Off Recovery Detect Flag
orif_c0eifr		.btequ		5,c0eifr	; Receive Overrun Detect Flag
olif_c0eifr		.btequ		6,c0eifr	; Overload Frame Transmission Detect Flag
blif_c0eifr		.btequ		7,c0eifr	; Bus Lock Detect Flag
;
;*------------------------------------------------------------------------------*
;*  CAN0 Receive Error Count Register                                           *
;*------------------------------------------------------------------------------*
c0recr		.equ	0D7CEh
;
;*------------------------------------------------------------------------------*
;*  CAN0 Transmit Error Count Register                                          *
;*------------------------------------------------------------------------------*
c0tecr		.equ	0D7CFh
;
;*------------------------------------------------------------------------------*
;*  CAN0 Error Code Store Register                                              *
;*------------------------------------------------------------------------------*
c0ecsr		.equ	0D7D0h
;
sef_c0ecsr		.btequ		0,c0ecsr	; Stuff Error Flag
fef_c0ecsr		.btequ		1,c0ecsr	; Form Error Flag
aef_c0ecsr		.btequ		2,c0ecsr	; ACK Error Flag
cef_c0ecsr		.btequ		3,c0ecsr	; CRC Error Flag
be1f_c0ecsr		.btequ		4,c0ecsr	; Bit Error(recessive) Flag
be0f_c0ecsr		.btequ		5,c0ecsr	; Bit Error(dominant) Flag
adef_c0ecsr		.btequ		6,c0ecsr	; ACK Delimiter Error Bit
edpm_c0ecsr		.btequ		7,c0ecsr	; Error Display Mode Select Bit
;
;*------------------------------------------------------------------------------*
;*  CAN0 Channel Search Support Register                                        *
;*------------------------------------------------------------------------------*
c0cssr		.equ	0D7D1h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Search Status Register                                         *
;*------------------------------------------------------------------------------*
c0mssr		.equ	0D7D2h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Mailbox Search Mode Register                                           *
;*------------------------------------------------------------------------------*
c0msmr		.equ	0D7D3h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Time Stamp Register                                                    *
;*------------------------------------------------------------------------------*
c0tsr		.equ	0D7D4h
;
;*------------------------------------------------------------------------------*
;*  CAN0 Acceptance Filter Support Register                                     *
;*------------------------------------------------------------------------------*
c0afsr		.equ	0D7D6h
;
c0afsrl		.equ	c0afsr				; CAN0 acceptance filter support register(low-order byte)
c0afsrh		.equ	c0afsr+1			; CAN0 acceptance filter support register(high-order byte)
;
;*------------------------------------------------------------------------------*
;*  CAN0 Test Control Register                                                  *
;*------------------------------------------------------------------------------*
c0tcr		.equ	0D7D8h
;
;*** EOF ************************************************************************
