/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ j^ ]
 */

#include "common.h"
#include "target.h"
#include "debug.h"
#include "timer.h"
#include "uart.h"
#include "led.h"
#include "log.h"

/*
 * j^
 * 萔
 */
#define MEMMON_UART_CH				(0)
										/* UART`l */
#define MEMMON_VERSION				(0x0001)
										/* vgRo[W */
#define MEMMON_STX0					(0x5A)
										/* STXf[^0 */
#define MEMMON_STX1					(0xA5)
										/* STXf[^1 */
#define MEMMON_NAK					(0xF0)
										/* NAK(R}h0x0F) */
#define MEMMON_OFFSET_STX0			(0)
										/* ItZbg(STXf[^0) */
#define MEMMON_OFFSET_STX1			(1)
										/* ItZbg(STXf[^1) */
#define MEMMON_OFFSET_CMD_LEN		(2)
										/* ItZbg(4bit:R}h 4bit:ǉf[^TCY) */
#define MEMMON_OFFSET_DATA0			(3)
										/* ItZbg(ǉf[^0) */
#define MEMMON_OFFSET_DATA1			(4)
										/* ItZbg(ǉf[^1) */
#define MEMMON_OFFSET_DATA2			(5)
										/* ItZbg(ǉf[^2) */
#define MEMMON_OFFSET_DATA3			(6)
										/* ItZbg(ǉf[^3) */
#define MEMMON_OFFSET_DATA4			(7)
										/* ItZbg(ǉf[^4) */
#define MEMMON_OFFSET_DATA5			(8)
										/* ItZbg(ǉf[^5) */

/*
 * j^
 * Mobt@
 */
static uint8 memmon_rx_buf[16 + 4];
										/* Mobt@ */

/*
 * j^
 * Mobt@
 */
static uint8 memmon_tx_buf[16 + 4];
										/* Mobt@ */

/*
 * j^
 * 
 */
void memmon_init(void)
{
}

/*
 * j^
 * ԐM
 * MEMMON_OFFSET_CMD_LENѕtf[^Zbgς݂ł邱
 */
static void memmon_send(void)
{
	uint8 len;
	uint8 loop;
	uint8 sum;

	/* STXf[^ */
	memmon_tx_buf[MEMMON_OFFSET_STX0] = MEMMON_STX0;
	memmon_tx_buf[MEMMON_OFFSET_STX1] = MEMMON_STX1;

	/* ǉf[^OX擾 */
	len = (uint8)(memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] & 0x0f);

	/* vf[^TCY擾 */
	len += 3;

	/* `FbNTZo */
	sum = 0;
	for (loop=0; loop<len; loop++)
	{
		sum += memmon_tx_buf[loop];
	}

	/* `FbNTݒ */
	memmon_tx_buf[len] = sum;

	/* UARTM */
	uart_tx(MEMMON_UART_CH, memmon_tx_buf, (uint16)(len + 1));
}

/*
 * j^
 * NAKԐM
 */
static void memmon_send_nak(void)
{
	/* R}hf[^(0xF0=NAK) */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = MEMMON_NAK;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h0:o[W擾
 */
static void memmon_getver(uint8 cmd)
{
	/* OX2ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x02);

	/* vgRo[W */
	memmon_tx_buf[MEMMON_OFFSET_DATA0] = (uint8)(MEMMON_VERSION >> 8);
	memmon_tx_buf[MEMMON_OFFSET_DATA1] = (uint8)MEMMON_VERSION;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h1:8bitǂݍ
 */
static void memmon_read8bit(uint8 cmd)
{
	uint16 addr;
	uint8 data;

	/* OX1ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x01);

	/* AhX擾 */
	addr = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA0];
	addr <<= 8;
	addr |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA1];

	/* ǂݍ */
	data = *((uint8 NEAR *)addr);

	/* f[^ݒ */
	memmon_tx_buf[MEMMON_OFFSET_DATA0] = data;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h2:8bit
 */
static void memmon_write8bit(uint8 cmd)
{
	uint16 addr;
	uint8 data;

	/* OX0ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x00);

	/* AhX擾 */
	addr = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA0];
	addr <<= 8;
	addr |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA1];

	/* f[^擾 */
	data = memmon_rx_buf[MEMMON_OFFSET_DATA2];

	/*  */
	*((uint8 NEAR *)addr) = data;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h3:16bitǂݍ
 */
static void memmon_read16bit(uint8 cmd)
{
	uint16 addr;
	uint16 data;

	/* OX1ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x02);

	/* AhX擾 */
	addr = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA0];
	addr <<= 8;
	addr |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA1];

	/* ǂݍ */
	data = *((uint16 NEAR *)addr);

	/* f[^ݒ */
	memmon_tx_buf[MEMMON_OFFSET_DATA0] = (uint8)(data >> 8);
	memmon_tx_buf[MEMMON_OFFSET_DATA1] = (uint8)data;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h4:16bit
 */
static void memmon_write16bit(uint8 cmd)
{
	uint16 addr;
	uint16 data;

	/* OX0ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x00);

	/* AhX擾 */
	addr = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA0];
	addr <<= 8;
	addr |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA1];

	/* f[^擾 */
	data = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA2];
	data <<= 8;
	data |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA3];

	/*  */
	*((uint16 NEAR *)addr) = data;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h32:8bitǂݍ
 */
static void memmon_read32bit(uint8 cmd)
{
	uint16 addr;
	uint32 data;

	/* OX4ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x04);

	/* AhX擾 */
	addr = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA0];
	addr <<= 8;
	addr |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA1];

	/* ǂݍ */
	data = *((uint32 NEAR *)addr);

	/* f[^ݒ */
	memmon_tx_buf[MEMMON_OFFSET_DATA0] = (uint8)(data >> 24);
	memmon_tx_buf[MEMMON_OFFSET_DATA1] = (uint8)(data >> 16);
	memmon_tx_buf[MEMMON_OFFSET_DATA2] = (uint8)(data >> 8);
	memmon_tx_buf[MEMMON_OFFSET_DATA3] = (uint8)data;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * R}h6:32bit
 */
static void memmon_write32bit(uint8 cmd)
{
	uint16 addr;
	uint32 data;

	/* OX0ŕԐM */
	memmon_tx_buf[MEMMON_OFFSET_CMD_LEN] = (uint8)((cmd << 4) | 0x00);

	/* AhX擾 */
	addr = (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA0];
	addr <<= 8;
	addr |= (uint16)memmon_rx_buf[MEMMON_OFFSET_DATA1];

	/* f[^擾 */
	data = (uint32)memmon_rx_buf[MEMMON_OFFSET_DATA2];
	data <<= 8;
	data |= (uint32)memmon_rx_buf[MEMMON_OFFSET_DATA3];
	data <<= 8;
	data |= (uint32)memmon_rx_buf[MEMMON_OFFSET_DATA4];
	data <<= 8;
	data |= (uint32)memmon_rx_buf[MEMMON_OFFSET_DATA5];

	/*  */
	*((uint32 NEAR *)addr) = data;

	/* ԐM */
	memmon_send();
}

/*
 * j^
 * fBXpb`
 */
static void memmon_dispatch(void)
{
	uint8 cmd;
	BOOL supported;

	/* R}hT|[g */
	supported = TRUE;

	/* LED_ */
	led_oneshot(LED_UART_CMD, LED_ONESHOT_MS);

	/* R}h擾 */
	cmd = memmon_rx_buf[MEMMON_OFFSET_CMD_LEN];
	cmd >>= 4;

	/* R}h */
	switch (cmd)
	{
		/* R}h0:o[W擾 */
		case 0:
			memmon_getver(cmd);
			break;

		/* R}h1:8bitǂݍ */
		case 1:
			memmon_read8bit(cmd);
			break;

		/* R}h2:8bit */
		case 2:
			memmon_write8bit(cmd);
			break;

		/* R}h3:16bitǂݍ */
		case 3:
			memmon_read16bit(cmd);
			break;

		/* R}h4:16bit */
		case 4:
			memmon_write16bit(cmd);
			break;

		/* R}h5:32bitǂݍ */
		case 5:
			memmon_read32bit(cmd);
			break;

		/* R}h6:32bit */
		case 6:
			memmon_write32bit(cmd);
			break;

		/* ̑̓T|[gĂȂ */
		default:
			supported = FALSE;
			break;
	}

	/* R}hT|[gȂ̏ꍇANAKԂ */
	if (supported == FALSE)
	{
		memmon_send_nak();
	}
}

/*
 * j^
 * `FbNT
 */
static BOOL memmon_chk_sum(void)
{
	uint8 len;
	uint8 loop;
	uint8 sum;

	/* ǉf[^OX擾 */
	len = (uint8)(memmon_rx_buf[MEMMON_OFFSET_CMD_LEN] & 0x0f);

	/* vf[^TCY擾 */
	len += 3;

	/* `FbNTZo */
	sum = 0;
	for (loop=0; loop<len; loop++)
	{
		sum += memmon_rx_buf[loop];
	}

	/* `FbNTvTRUEԂ */
	if (memmon_rx_buf[len] == sum)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

/*
 * j^
 * ^XN
 */
void memmon_task(void)
{
	uint16 bytes;
	BOOL equal;
	uint16 required;

	/* STXvtO=FALSEɏ */
	equal = FALSE;
	bytes = 0;

	/* STXvtO=TRUEɂȂ܂Ń[v */
	while (equal == FALSE)
	{
		/* STX0 + STX1 + (4bitR}h | 4bitf[^)3oCg͕KKv */
		bytes = uart_get(MEMMON_UART_CH, memmon_rx_buf, sizeof(memmon_rx_buf));

		/* bytes3łΏI */
		if (bytes < 3)
		{
			/* f[^s */
			return;
		}

		/* STX0STX1`FbN */
		if ((memmon_rx_buf[MEMMON_OFFSET_STX0] == MEMMON_STX0) && (memmon_rx_buf[MEMMON_OFFSET_STX1] == MEMMON_STX1))
		{
			/* STXƂv */
			equal = TRUE;
		}
		else
		{
			/* STXsvȂ̂ŁA1oCgp */
			uart_discard(MEMMON_UART_CH, 1);
		}
	}

	/* STX͈vB`FbNT܂߂KvoCgZo */
	required = (uint16)memmon_rx_buf[MEMMON_OFFSET_CMD_LEN];
	required &= 0x000f;
	required += 4;

	if (bytes >= required)
	{
		/* `FbNT */
		if (memmon_chk_sum() == TRUE)
		{
			/* `FbNT͈vBfBXpb` */
			memmon_dispatch();
		}
		else
		{
			/* `FbNTsvBNAK */
			memmon_send_nak();
		}

		/* requiredp */
		uart_discard(MEMMON_UART_CH, required);
	}
}
