package jp.gr.java_conf.wutse.purewiki.syntax.line;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.syntax.LineSyntax;

public class TableSyntax implements LineSyntax {
	@Override
	public boolean condition(PureWikiContext context) {
		String line = context.getLine();
		return line.startsWith("|");
	}

	@Override
	public String begin(PureWikiContext context) {
		return "<TABLE>\n";
	}

	@Override
	public String line(PureWikiContext context) {
		if (!condition(context)) {
			return context.getLine() + "<BR>\n";
		}
		String line = context.getLine();
		StringBuffer sb = new StringBuffer();
		sb.append("<TR>\n");
//		String[] colTexts = line.substring(1).split("\\|");
		String[] colTexts = line.substring(1).split("(?<!\\\\)\\|");  // \を前に付けたときはエスケープ
		for (String colText: colTexts) {
			if (colText.startsWith("^")) {
				sb.append("<TH>");
				sb.append(colText.substring(1).replaceAll("\\\\\\|", "|"));
				sb.append("</TH>\n");
			}
			else if (colText.startsWith(" ")) {
				sb.append("<TD style=\"text-align:right;\">");
				sb.append(colText.substring(1).replaceAll("\\\\\\|", "|"));
				sb.append("</TD>\n");
			}
			else {
				sb.append("<TD>");
				sb.append(colText.replaceAll("\\\\\\|", "|"));
				sb.append("</TD>\n");
			}
		}
		sb.append("</TR>");
		return sb.toString();
	}

	@Override
	public String end(PureWikiContext context) {
		return "</TABLE>\n";
	}
}
