$(document).ready(function() {

    var selected_index = -1;
    var linnutArray = [];
    var valinta;
    
// ------ Save bird observation to the list. ------
    $("#tallenna").click(function(){
        if ($("#lintuLaji").val() != "") {
            var lintuOlio = {
                lintuLaji : $("#lintuLaji").val(),
                havaintoPv : $("#havaintoPv").val(),
                havaintoAika : $("#havaintoAika").val(),
                havaintoPaikka : $("#havaintoPaikka").val(),
                lintuLkm : $("#lintuLkm").val()
            }
            linnutArray.push(lintuOlio);
            localStorage.setItem("linnut",JSON.stringify(linnutArray));
        }
        var modal2 = document.getElementById("tallennettu");
        modal2.style.display = "block"; // the confirmation
        var form = document.getElementById("kentat");
        form.reset(); // Clear the text fields.
    });

// ------ Print the whole list. ------
    $("#tulosta").click(function() {
        var modal1 = document.getElementById("modaali1");
        modal1.style.display = "block";
        var linnutJSON = localStorage.getItem("linnut");
        linnutArray = JSON.parse(linnutJSON);
        valinta = null;
        taulukonTulostus();
    });

// ------ Print a selected bird species. ------
    $("#hae").click(function() { 
        var modal1 = document.getElementById("modaali1");
        modal1.style.display = "block";
        var linnutJSON = localStorage.getItem("linnut");
        linnutArray = JSON.parse(linnutJSON);
        valinta = $("#lintuHaku").val().toLowerCase();
        taulukonTulostus();
    });

// ------ Close modal 1. ------
    $("#suljemodal1").click(function() {
        var modal1 = document.getElementById("modaali1");
        modal1.style.display = "none";
    });

// ------ Close modal 2. ------
    $("#suljemodal2").click(function() {
        var modal2 = document.getElementById("tallennettu");
        modal2.style.display = "none";
    });

// ------ Download a CSV file. ------
    $("#lataa_CSV").click(function() {
        var linnutJSON = localStorage.getItem("linnut");
        luoCSV(konvertoiCSV(linnutJSON));
        
        function konvertoiCSV(lintuArray) {
            var array = JSON.parse(lintuArray);
            var csv = 'Lintulaji,Havaintopvm,Havaintoaika,Havaintopaikka,Lintulkm\n';
            for (var i = 0; i < array.length; i++) {
                var rivi = '';
                rivi += [array[i].lintuLaji.replace(/,/g, "."), array[i].havaintoPv.replace(/,/g, "."), array[i].havaintoAika.replace(/,/g, "."), array[i].havaintoPaikka.replace(/,/g, "."), array[i].lintuLkm.replace(/,/g, ".")].join(',');
                csv += rivi + '\r\n';
                }
            return csv;
            }
            
        function luoCSV(csvString) {
            var piiloElementti = document.createElement('a');
            piiloElementti.href = 'data:text/csv;charset=utf-8,' + encodeURI(csvString);
            piiloElementti.target = '_blank';
            piiloElementti.download = 'lintuluettelo.csv';
            piiloElementti.click();
        }
    });

// ------ Print the table. ------
    function taulukonTulostus() {
        if(linnutArray == null) {
            linnutArray = [];
        }
        $("#taulukko").html = "";
        $("#taulukko").html("<thead><tr><th>lintulaji</th><th>havaintopvm</th><th>havaintoaika</th><th>havaintopaikka</th><th>lintulukumäärä</th><th></th></tr></thead><tbody></tbody>");
        if (valinta != null) {
            for (var i in linnutArray) { // Käydään alkiot läpi yksi kerrallaan.
                if (linnutArray[i].lintuLaji.toLowerCase().includes(valinta)) {
                    $("#taulukko tbody").append("<tr><td>" + linnutArray[i].lintuLaji + "</td><td>" + linnutArray[i].havaintoPv + "</td><td>" + linnutArray[i].havaintoAika + "</td><td>" + linnutArray[i].havaintoPaikka + "</td><td>" + linnutArray[i].lintuLkm + "</td><td><img src='recyclebin-icon.png' alt='Delete" + i + "' class='btnDelete'/></td></tr>");
                }
            }
        } else {
            for (var i in linnutArray) { // Käydään alkiot läpi yksi kerrallaan.
                $("#taulukko tbody").append("<tr><td>" + linnutArray[i].lintuLaji + "</td><td>" + linnutArray[i].havaintoPv + "</td><td>" + linnutArray[i].havaintoAika + "</td><td>" + linnutArray[i].havaintoPaikka + "</td><td>" + linnutArray[i].lintuLkm + "</td><td><img src='recyclebin-icon.png' alt='Delete" + i + "' class='btnDelete'/></td></tr>");
            }
        }
    }

// ------ Delete item from list. ------
    $("#taulukko").on("click",".btnDelete",function() {
        var selected_index = parseInt($(this).attr("alt").replace("Delete",""));
        linnutArray.splice(selected_index, 1);
        selected_index = -1;
        localStorage.setItem("linnut", JSON.stringify(linnutArray));
        var linnutJSON = localStorage.getItem("linnut");
        linnutArray = JSON.parse(linnutJSON);
        $("#suljemodal1").trigger("click");
        if (valinta == null) {
            $("#tulosta").trigger("click");
        } else {
            $("#hae").trigger("click");
        }
    });

});