// This module is used to get a user profile from the database. The function takes
// a username-string and a fragments-string as parameters. Then it performs a
// graphql-query with node-fetch-module. The function returns a user profile
// object with the fields specified in the fragments-parameter.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeKayttaja": async (username, frags, cb) => {
        
        if (username) {

            const data = JSON.stringify({
                query: `{
                    haeKayttaja(Kayttajatunnus: "${username}") {
                        ${frags}
                    }
                }`,
                    variables: null
                });
                const vastaus = await fetch(
                    url,
                    {
                        method: 'post',
                        body: data,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                    }
                );

            const json = await vastaus.json();
            cb(json.data.haeKayttaja);

        } else {

            cb(null);

        }
            
    }

};