// This module is used to get all the applications from the database, that the
// user has created. The function takes a username-string and a fragments-string
// as parameters. Then it performs a graphql-query with node-fetch-module. The
// function returns the applications as a json-object with the fields specified
// in the fragments-parameter.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeKayttajanHakemukset": async (username, frags, cb) => {

        const data = JSON.stringify({
            query: `{
                hakemuksetKayttajan(Kayttajatunnus: "${username}") {
                        ${frags}
                    }
            }`,
                variables: null
            });

        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        cb(json.data.hakemuksetKayttajan);
		
    }

};