// This module is used for getting a specific application document from the database.
// The function takes the application id-integer and a fragments-string as parameters.
// It then performs a graphql-query with node-fetch-module and returns the application object.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeHakemus": async (hakemusid, frags, cb) => {
        const data = JSON.stringify({
            query: `{
                hakemusId(Id: ${hakemusid}) {
                    ${frags}
                }
            }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        cb(json.data.hakemusId);
    }

};