// This module is used for updating a user profile in the database
// with the values specified in the request body-object. The function
// takes request body- and user data-objects as parameters. It then
// checks which of the fields is modified and then performs a
// graphql-mutation with node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "vahvistaProfiili": async (rqstbody, userdata, cb) => {

        var etunimi, sukunimi, osoite, puhelinnro, kuvausteksti;
        switch (rqstbody.field) {
            case ("fname") :
                etunimi = rqstbody.enim;
                sukunimi = userdata.SukuNimi;
                osoite = userdata.HomeAddress;
                puhelinnro = userdata.PhoneNumber;
                kuvausteksti = userdata.Description;
                break;
            case ("sname") :
                etunimi = userdata.EtuNimi;
                sukunimi = rqstbody.snim;
                osoite = userdata.HomeAddress;
                puhelinnro = userdata.PhoneNumber;
                kuvausteksti = userdata.Description;
                break;
            case ("address") :
                etunimi = userdata.EtuNimi;
                sukunimi = userdata.SukuNimi;
                osoite = rqstbody.addr;
                puhelinnro = userdata.PhoneNumber;
                kuvausteksti = userdata.Description;
                break;
            case ("puhnro") :
                etunimi = userdata.EtuNimi;
                sukunimi = userdata.SukuNimi;
                osoite = userdata.HomeAddress;
                puhelinnro = rqstbody.telephone;
                kuvausteksti = userdata.Description;
                break;
                case ("desc") :
                etunimi = userdata.EtuNimi;
                sukunimi = userdata.SukuNimi;
                osoite = userdata.HomeAddress;
                puhelinnro = userdata.PhoneNumber;
                kuvausteksti = rqstbody.kuvaus.replace(/(<|>)/gm, "").replace(/(\r\n|\n|\r)/gm,"<br>");
                break;
            }

            const data = JSON.stringify({
                query: `mutation {
                    profiilinMuokkaus(Kayttajatunnus: "${userdata.KayttajaTunnus}", Etunimi: "${etunimi}", Sukunimi: "${sukunimi}", Osoite: "${osoite}", Puhelinnro: "${puhelinnro}", Kuvaus: "${kuvausteksti}")
                }`,
                    variables: null
                });
                const vastaus = await fetch(
                    url,
                    {
                        method: 'post',
                        body: data,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                    }
                );

            const json = await vastaus.json();
            cb();
			
	}

};