// This module is used for adding a profile-image file to a user document in the database.
// The function takes a request file-object and a username-string as parameters. It first
// checks whether the file attachment exists and that it's in a valid format. Then two
// temporary file paths are created for a full sized image and a compressed version of it.
// The image-file is first copied to the first file path. Then a sharp module is used to
// copy a resized version to the second file path. The compressed file is then copied to
// a "file"-variable by readFileSync-operation. The image file is then converted to a string
// and saved to "buffer" variable, which is then inserted to the graphql-mutation. Finally
// the temporary file paths are unlinked (deleted). If a notification is returned in the
// callback, the "tiedosto"-field 0 indicates the image-file (not cv which is 1).
// "lause"-field is the notification, which is printed on the screen.

const fetch = require('node-fetch');
const fs = require('fs');
var path = require('path');
const sharp = require('sharp');
const { url } = require('../main');

module.exports = {

    "lisaaKuva": async (rqstfiles, username, cb) => {

        if (rqstfiles == null || !rqstfiles.pctr || Object.keys(rqstfiles.pctr).length === 0) {

            cb({ tiedosto: 0, lause: "Valitse ensin tiedosto!" });

        } else {

            let parts = rqstfiles.pctr.name.split(".");
			let extension = parts[parts.length - 1].toLowerCase();
			
			if (extension == 'jpg' || extension == 'png' || extension == 'gif' || extension == 'bmp') {
				
				let filepath = await path.join(__dirname, '../', rqstfiles.pctr.name);
				let filepath2 = await path.join(__dirname, '../', 'compressed_' + rqstfiles.pctr.name);
				await rqstfiles.pctr.mv(filepath);
				await sharp(filepath).resize(200).toFile(filepath2);
				let file = fs.readFileSync(filepath2);
				let buffer = new Buffer.from(file).toString('base64');
				
				const data = JSON.stringify({
					query: `mutation {
						kuvanLisays(Kayttajatunnus: "${username}", Kuva: "${buffer}")
					}`,
					variables: null
				});

				const vastaus = await fetch(
					url,
					{
						method: 'post',
						body: data,
						headers: {
							'Content-Type': 'application/json'
						},
					}
				);

				const json = await vastaus.json();
				fs.unlinkSync(filepath);
				fs.unlinkSync(filepath2);
				cb(false);
				
			} else {
				
				cb({ tiedosto: 0, lause: "Väärä tiedostomuoto! Tuetut tiedostomuodot ovat jpg, png, gif ja bmp." });
				
			}

        }

    }
	
};