// This module is used for updating a user document's "Documents"-field in the database by
// adding an advertisement id to it. The function takes an access-token-string, a user
// data-object and an advertisement-object as parameters. Then it performs the graphql-mutation
// with node-fetch-module. And finally it creates a notification and prints it to the screen.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "tallennaIlmoitus": async (token, userdata, ilmoitus, cb) => {

            const data = JSON.stringify({
				query: `mutation {
					ilmoituksenTallennus(ilmoitusid: ${ilmoitus.IlmoitusId}, kayttajaTunnus: "${userdata.KayttajaTunnus}")
				}`,
				variables: null
			});

			const vastaus = await fetch(
				url,
				{
					method: 'post',
					body: data,
					headers: {
						'Content-Type': 'application/json'
					},
				}
			);

			const json = await vastaus.json();
			let notification = "<h3>Ilmoitus lisätty:</h3><p>" + ilmoitus.title + "</p>";

			cb({
				"logsign": false,
				"user": userdata,
				"token": token,
				"ruutu": "lisays",
				"modal": false,
                "ilmoitus": ilmoitus,
                "huomautus": notification
			});

	}

};