// This module is used in adding a new advertisement to the database. The function takes
// a request body-object and a username-string as parameters. The advertisement description
// that the user has filled and submitted in the web page is first modified by escaping
// angle-brackets and replacing all line brakes with '<br>'. Then a new datetime is created
// for the advertisement document before the mutation.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "lisaaIlmoitus": async (rqstbody, username, cb) => {

        let kuvaus = rqstbody.desc.replace(/(<|>)/gm, "").replace(/(\r\n|\n|\r)/gm,"<br>");
        const date = new Date();
        const datestring = date.toString();

        const data = JSON.stringify({
            query: `mutation {
                ilmoituksenLisays(aika: "${datestring}",
                                    otsikko: "${rqstbody.title}",
                                    kuvaus: "${kuvaus}",
                                    kayttajaTunnus: "${username}",
                                    toimiala: ${rqstbody.ala},
                                    alue: ${rqstbody.maakunta}) {
                    IlmoitusId
                    title
                    desc
                }
            }`,
            variables: null
        });

        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        cb(json.data.ilmoituksenLisays);

    }

};